/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.bigtable.spark;

import com.google.cloud.bigtable.hbase.BigtableExtendedScan;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.io.Text;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.geotools.data.Query;
import org.locationtech.geomesa.bigtable.data.BigtableDataStoreFactory$;
import org.locationtech.geomesa.bigtable.spark.BigtableInputFormat$;
import org.locationtech.geomesa.bigtable.spark.BigtableInputFormatBase;
import org.locationtech.geomesa.bigtable.spark.GeoMesaBigtableInputFormat;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.data.HBaseQueryPlan;
import org.locationtech.geomesa.hbase.jobs.HBaseJobUtils$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator$;
import org.locationtech.geomesa.spark.SpatialRDD;
import org.locationtech.geomesa.spark.SpatialRDD$;
import org.locationtech.geomesa.spark.hbase.HBaseSpatialRDDProvider;
import org.locationtech.geomesa.utils.io.WithStore$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

@ScalaSignature(bytes="\u0006\u000194A\u0001B\u0003\u0001!!)\u0001\u0004\u0001C\u00013!)A\u0004\u0001C!;!)\u0001\n\u0001C!\u0013\nA\")[4uC\ndWm\u00159be.\u0014F\t\u0012)s_ZLG-\u001a:\u000b\u0005\u00199\u0011!B:qCJ\\'B\u0001\u0005\n\u0003!\u0011\u0017n\u001a;bE2,'B\u0001\u0006\f\u0003\u001d9Wm\\7fg\u0006T!\u0001D\u0007\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u00039\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\t\u0011\u0005I1R\"A\n\u000b\u0005Q)\u0012!\u00025cCN,'B\u0001\u0004\n\u0013\t92CA\fI\u0005\u0006\u001cXm\u00159bi&\fGN\u0015#E!J|g/\u001b3fe\u00061A(\u001b8jiz\"\u0012A\u0007\t\u00037\u0001i\u0011!B\u0001\u000bG\u0006t\u0007K]8dKN\u001cHC\u0001\u0010%!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u001d\u0011un\u001c7fC:DQ!\n\u0002A\u0002\u0019\na\u0001]1sC6\u001c\bGA\u0014=!\u0011ASf\f\u001e\u000e\u0003%R!AK\u0016\u0002\tU$\u0018\u000e\u001c\u0006\u0002Y\u0005!!.\u0019<b\u0013\tq\u0013FA\u0002NCB\u0004\"\u0001M\u001c\u000f\u0005E*\u0004C\u0001\u001a!\u001b\u0005\u0019$B\u0001\u001b\u0010\u0003\u0019a$o\\8u}%\u0011a\u0007I\u0001\u0007!J,G-\u001a4\n\u0005aJ$AB*ue&twM\u0003\u00027AA\u00111\b\u0010\u0007\u0001\t%iD%!A\u0001\u0002\u000b\u0005aHA\u0002`IE\n\"a\u0010\"\u0011\u0005}\u0001\u0015BA!!\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"a\u0011$\u000e\u0003\u0011S!!R\u0016\u0002\u0005%|\u0017BA$E\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\r\u0011H\r\u001a\u000b\u0006\u0015:K\u0006\r\u001a\t\u0003\u00172k\u0011!F\u0005\u0003\u001bV\u0011!b\u00159bi&\fGN\u0015#E\u0011\u0015y5\u00011\u0001Q\u0003\u0011\u0019wN\u001c4\u0011\u0005E;V\"\u0001*\u000b\u0005=\u001b&B\u0001+V\u0003\u0019A\u0017\rZ8pa*\u0011a+D\u0001\u0007CB\f7\r[3\n\u0005a\u0013&!D\"p]\u001aLw-\u001e:bi&|g\u000eC\u0003[\u0007\u0001\u00071,\u0001\u0002tGB\u0011ALX\u0007\u0002;*\u0011a!V\u0005\u0003?v\u0013Ab\u00159be.\u001cuN\u001c;fqRDQ!Y\u0002A\u0002\t\f\u0001\u0002Z:QCJ\fWn\u001d\t\u0005a\r|s&\u0003\u0002/s!)Qm\u0001a\u0001M\u0006IqN]5h#V,'/\u001f\t\u0003O2l\u0011\u0001\u001b\u0006\u0003S*\fA\u0001Z1uC*\u00111.D\u0001\tO\u0016|Go\\8mg&\u0011Q\u000e\u001b\u0002\u0006#V,'/\u001f")
public class BigtableSparkRDDProvider
extends HBaseSpatialRDDProvider {
    public boolean canProcess(java.util.Map<String, ? extends Serializable> params) {
        return BigtableDataStoreFactory$.MODULE$.canProcess(params);
    }

    public SpatialRDD rdd(Configuration conf, SparkContext sc, Map<String, String> dsParams, Query origQuery) {
        return (SpatialRDD)WithStore$.MODULE$.apply(dsParams).apply((Function1 & Serializable & scala.Serializable)ds -> {
            SpatialRDD spatialRDD;
            LazyRef sft$lzy = new LazyRef();
            LazyRef qps$lzy = new LazyRef();
            LazyRef rddSft$lzy = new LazyRef();
            if (ds == null || BigtableSparkRDDProvider.sft$1(sft$lzy, ds, origQuery) == null || BigtableSparkRDDProvider.qps$1(qps$lzy, origQuery, ds).isEmpty()) {
                spatialRDD = SpatialRDD$.MODULE$.apply(sc.emptyRDD(ClassTag$.MODULE$.apply(SimpleFeature.class)), BigtableSparkRDDProvider.rddSft$1(rddSft$lzy, origQuery, sft$lzy, ds));
            } else {
                RDD head;
                Seq seq = (Seq)BigtableSparkRDDProvider.qps$1(qps$lzy, origQuery, ds).map((Function1 & Serializable & scala.Serializable)qp -> BigtableSparkRDDProvider.queryPlanToRdd$1(qp, conf, sc), Seq$.MODULE$.canBuildFrom());
                Some some = Seq$.MODULE$.unapplySeq(seq);
                RDD rDD = !some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 ? (head = (RDD)((SeqLike)some.get()).apply(0)) : sc.union(seq, ClassTag$.MODULE$.apply(SimpleFeature.class));
                RDD rdd = rDD;
                spatialRDD = SpatialRDD$.MODULE$.apply(rdd, BigtableSparkRDDProvider.rddSft$1(rddSft$lzy, origQuery, sft$lzy, ds));
            }
            return spatialRDD;
        });
    }

    private static final /* synthetic */ SimpleFeatureType sft$lzycompute$1(LazyRef sft$lzy$1, HBaseDataStore ds$1, Query origQuery$1) {
        SimpleFeatureType simpleFeatureType;
        LazyRef lazyRef = sft$lzy$1;
        synchronized (lazyRef) {
            simpleFeatureType = sft$lzy$1.initialized() ? (SimpleFeatureType)sft$lzy$1.value() : (SimpleFeatureType)sft$lzy$1.initialize((Object)ds$1.getSchema(origQuery$1.getTypeName()));
        }
        return simpleFeatureType;
    }

    private static final SimpleFeatureType sft$1(LazyRef sft$lzy$1, HBaseDataStore ds$1, Query origQuery$1) {
        return sft$lzy$1.initialized() ? (SimpleFeatureType)sft$lzy$1.value() : BigtableSparkRDDProvider.sft$lzycompute$1(sft$lzy$1, ds$1, origQuery$1);
    }

    private static final /* synthetic */ Seq qps$lzycompute$1(LazyRef qps$lzy$1, Query origQuery$1, HBaseDataStore ds$1) {
        Seq seq;
        LazyRef lazyRef = qps$lzy$1;
        synchronized (lazyRef) {
            Seq seq2;
            if (qps$lzy$1.initialized()) {
                seq2 = (Seq)qps$lzy$1.value();
            } else {
                origQuery$1.getHints().put((Object)QueryHints$.MODULE$.LOOSE_BBOX(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                seq2 = (Seq)qps$lzy$1.initialize((Object)HBaseJobUtils$.MODULE$.getMultiScanPlans(ds$1, origQuery$1));
            }
            seq = seq2;
        }
        return seq;
    }

    private static final Seq qps$1(LazyRef qps$lzy$1, Query origQuery$1, HBaseDataStore ds$1) {
        return qps$lzy$1.initialized() ? (Seq)qps$lzy$1.value() : BigtableSparkRDDProvider.qps$lzycompute$1(qps$lzy$1, origQuery$1, ds$1);
    }

    private static final /* synthetic */ SimpleFeatureType rddSft$lzycompute$1(LazyRef rddSft$lzy$1, Query origQuery$1, LazyRef sft$lzy$1, HBaseDataStore ds$1) {
        SimpleFeatureType simpleFeatureType;
        LazyRef lazyRef = rddSft$lzy$1;
        synchronized (lazyRef) {
            simpleFeatureType = rddSft$lzy$1.initialized() ? (SimpleFeatureType)rddSft$lzy$1.value() : (SimpleFeatureType)rddSft$lzy$1.initialize(QueryHints$.MODULE$.RichHints(origQuery$1.getHints()).getTransformSchema().getOrElse((Function0 & Serializable & scala.Serializable)() -> BigtableSparkRDDProvider.sft$1(sft$lzy$1, ds$1, origQuery$1)));
        }
        return simpleFeatureType;
    }

    private static final SimpleFeatureType rddSft$1(LazyRef rddSft$lzy$1, Query origQuery$1, LazyRef sft$lzy$1, HBaseDataStore ds$1) {
        return rddSft$lzy$1.initialized() ? (SimpleFeatureType)rddSft$lzy$1.value() : BigtableSparkRDDProvider.rddSft$lzycompute$1(rddSft$lzy$1, origQuery$1, sft$lzy$1, ds$1);
    }

    private static final RDD queryPlanToRdd$1(HBaseQueryPlan.ScanPlan qp, Configuration conf$1, SparkContext sc$1) {
        Configuration config = new Configuration(conf$1);
        config.set("hbase.mapreduce.inputtable", ((HBaseQueryPlan.TableScan)qp.scans().head()).table().getNameAsString());
        Seq scans = (Seq)((HBaseQueryPlan.TableScan)qp.scans().head()).scans().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string;
            Scan scan = x0$1;
            if (scan instanceof BigtableExtendedScan) {
                BigtableExtendedScan bigtableExtendedScan = (BigtableExtendedScan)scan;
                bigtableExtendedScan.setAttribute("scan.attributes.table.name", ((HBaseQueryPlan.TableScan)qp.scans().head()).table().getName());
                string = BigtableInputFormatBase.scanToString(bigtableExtendedScan);
            } else if (scan != null) {
                Scan scan2 = scan;
                BigtableExtendedScan bes = new BigtableExtendedScan();
                bes.addRange(scan2.getStartRow(), scan2.getStopRow());
                bes.setAttribute("scan.attributes.table.name", ((HBaseQueryPlan.TableScan)qp.scans().head()).table().getName());
                string = BigtableInputFormatBase.scanToString(bes);
            } else {
                throw new MatchError((Object)scan);
            }
            return string;
        }, Seq$.MODULE$.canBuildFrom());
        config.setStrings(BigtableInputFormat$.MODULE$.SCANS(), (String[])scans.toArray(ClassTag$.MODULE$.apply(String.class)));
        GeoMesaConfigurator$.MODULE$.setResultsToFeatures(config, qp.resultsToFeatures());
        qp.reducer().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            GeoMesaConfigurator$.MODULE$.setReducer(config, x$1);
            return BoxedUnit.UNIT;
        });
        qp.sort().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            GeoMesaConfigurator$.MODULE$.setSorting(config, x$2);
            return BoxedUnit.UNIT;
        });
        qp.projection().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            GeoMesaConfigurator$.MODULE$.setProjection(config, x$3);
            return BoxedUnit.UNIT;
        });
        return sc$1.newAPIHadoopRDD(config, GeoMesaBigtableInputFormat.class, Text.class, SimpleFeature.class).map((Function1 & Serializable & scala.Serializable)x$4 -> (SimpleFeature)x$4._2(), ClassTag$.MODULE$.apply(SimpleFeature.class));
    }
}

