/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.blob.handlers.gdal;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.File;
import java.util.Date;
import java.util.Map;
import java.util.Vector;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.Transformer;
import org.gdal.gdal.gdal;
import org.gdal.gdalconst.gdalconstConstants;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.locationtech.geomesa.blob.api.handlers.AbstractFileHandler;
import org.locationtech.geomesa.blob.api.handlers.BlobStoreFileName;
import org.locationtech.geomesa.blob.api.handlers.BlobStoreSimpleFeatureBuilder;
import org.locationtech.geomesa.blob.handlers.gdal.GDALFileHandler$;
import org.locationtech.geomesa.utils.uuid.Z3FeatureIdGenerator;
import org.opengis.feature.simple.SimpleFeature;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001B\u0001\u0003\u0001=\u0011qb\u0012#B\u0019\u001aKG.\u001a%b]\u0012dWM\u001d\u0006\u0003\u0007\u0011\tAa\u001a3bY*\u0011QAB\u0001\tQ\u0006tG\r\\3sg*\u0011q\u0001C\u0001\u0005E2|'M\u0003\u0002\n\u0015\u00059q-Z8nKN\f'BA\u0006\r\u00031awnY1uS>tG/Z2i\u0015\u0005i\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u0011-u\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007CA\f\u001c\u001b\u0005A\"BA\u0003\u001a\u0015\tQb!A\u0002ba&L!\u0001\b\r\u0003'\u0005\u00137\u000f\u001e:bGR4\u0015\u000e\\3IC:$G.\u001a:\u0011\u0005y)S\"A\u0010\u000b\u0005\u0001\n\u0013\u0001D:dC2\fGn\\4hS:<'B\u0001\u0012$\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u0013\u0002\u0007\r|W.\u0003\u0002'?\tYA*\u0019>z\u0019><w-\u001b8h\u0011\u0015A\u0003\u0001\"\u0001*\u0003\u0019a\u0014N\\5u}Q\t!\u0006\u0005\u0002,\u00015\t!\u0001C\u0004.\u0001\t\u0007I\u0011\u0001\u0018\u0002\u0017\u001d,w.\u001c$bGR|'/_\u000b\u0002_A\u0011\u0001gN\u0007\u0002c)\u0011!gM\u0001\u0005O\u0016|WN\u0003\u00025k\u0005\u0019!\u000e^:\u000b\u0005Y\u001a\u0013A\u0004<jm&$7o\u001c7vi&|gn]\u0005\u0003qE\u0012qbR3p[\u0016$(/\u001f$bGR|'/\u001f\u0005\u0007u\u0001\u0001\u000b\u0011B\u0018\u0002\u0019\u001d,w.\u001c$bGR|'/\u001f\u0011\t\u000fq\u0002!\u0019!C\u0001{\u0005Y\u0011N\\5uS\u0006d\u0017N_3e+\u0005q\u0004CA\t@\u0013\t\u0001%CA\u0004C_>dW-\u00198\t\r\t\u0003\u0001\u0015!\u0003?\u00031Ig.\u001b;jC2L'0\u001a3!\u0011\u0015!\u0005\u0001\"\u0011F\u0003M9W\r^$f_6,GO]=Ge>lg)\u001b7f)\t1E\nE\u0002\u0012\u000f&K!\u0001\u0013\n\u0003\r=\u0003H/[8o!\t\u0001$*\u0003\u0002Lc\tAq)Z8nKR\u0014\u0018\u0010C\u0003N\u0007\u0002\u0007a*\u0001\u0003gS2,\u0007CA(U\u001b\u0005\u0001&BA)S\u0003\tIwNC\u0001T\u0003\u0011Q\u0017M^1\n\u0005U\u0003&\u0001\u0002$jY\u0016DQa\u0016\u0001\u0005Ba\u000b!bY1o!J|7-Z:t)\rIfl\u0018\t\u00035vk\u0011a\u0017\u0006\u00039J\u000bA\u0001\\1oO&\u0011\u0001i\u0017\u0005\u0006\u001bZ\u0003\rA\u0014\u0005\u0006AZ\u0003\r!Y\u0001\u0004[\u0006\u0004\b\u0003\u00022fO\u001el\u0011a\u0019\u0006\u0003IJ\u000bA!\u001e;jY&\u0011am\u0019\u0002\u0004\u001b\u0006\u0004\bC\u00015l\u001d\t\t\u0012.\u0003\u0002k%\u00051\u0001K]3eK\u001aL!\u0001\\7\u0003\rM#(/\u001b8h\u0015\tQ'\u0003C\u0003p\u0001\u0011\u0005\u0003/A\bhKR$\u0015\r^3Ge>lg)\u001b7f)\t\tX\u000fE\u0002\u0012\u000fJ\u0004\"AY:\n\u0005Q\u001c'\u0001\u0002#bi\u0016DQ!\u00148A\u00029CQa\u001e\u0001\u0005\na\facZ3u\u00136\fw-\u001a\"pk:$7oR3p[\u0016$(/\u001f\u000b\u0003\rfDQ!\u0014<A\u0002i\u0004\"a\u001f@\u000e\u0003qT!aA?\u000b\u0005\ra\u0011BA@}\u0005\u001d!\u0015\r^1tKRDq!a\u0001\u0001\t\u0013\t)!\u0001\tbaBd\u0017\u0010\u0016:b]N4wN]7feRA\u0011qAA\b\u00033\ti\u0002\u0005\u0003\u0012\u000f\u0006%\u0001c\u0001\u0019\u0002\f%\u0019\u0011QB\u0019\u0003\u0015\r{wN\u001d3j]\u0006$X\r\u0003\u0005\u0002\u0012\u0005\u0005\u0001\u0019AA\n\u0003\u0005A\bcA\t\u0002\u0016%\u0019\u0011q\u0003\n\u0003\r\u0011{WO\u00197f\u0011!\tY\"!\u0001A\u0002\u0005M\u0011!A=\t\u0011\u0005}\u0011\u0011\u0001a\u0001\u0003C\tA\u0001\u001e:b]B\u001910a\t\n\u0007\u0005\u0015BPA\u0006Ue\u0006t7OZ8s[\u0016\u0014xaBA\u0015\u0005!\u0005\u00111F\u0001\u0010\u000f\u0012\u000bEJR5mK\"\u000bg\u000e\u001a7feB\u00191&!\f\u0007\r\u0005\u0011\u0001\u0012AA\u0018'\r\ti\u0003\u0005\u0005\bQ\u00055B\u0011AA\u001a)\t\tY\u0003\u0003\u0006\u00028\u00055\"\u0019!C\u0001\u0003s\tq\u0001Z:u?N\u00148/F\u0001h\u0011!\ti$!\f!\u0002\u00139\u0017\u0001\u00033ti~\u001b(o\u001d\u0011\t\u0015\u0005\u0005\u0013Q\u0006b\u0001\n\u0003\t\u0019%\u0001\u0003paR\u001cXCAA#!\u0011\u0011\u0017qI4\n\u0007\u0005%3M\u0001\u0004WK\u000e$xN\u001d\u0005\n\u0003\u001b\ni\u0003)A\u0005\u0003\u000b\nQa\u001c9ug\u0002B!\"!\u0015\u0002.\t\u0007I\u0011AA*\u0003\u0015i\u0017N\u001c-Z+\t\t\u0019\u0002C\u0005\u0002X\u00055\u0002\u0015!\u0003\u0002\u0014\u00051Q.\u001b8Y3\u0002\u0002")
public class GDALFileHandler
implements AbstractFileHandler,
LazyLogging {
    private final GeometryFactory geomFactory;
    private final boolean initialized;
    private final Logger logger;
    private final ThreadLocal<SimpleFeatureBuilder> builderLocal;
    private final Z3FeatureIdGenerator featureIdGenerator;
    private volatile boolean bitmap$0;

    public static double minXY() {
        return GDALFileHandler$.MODULE$.minXY();
    }

    public static Vector<String> opts() {
        return GDALFileHandler$.MODULE$.opts();
    }

    public static String dst_srs() {
        return GDALFileHandler$.MODULE$.dst_srs();
    }

    private Logger logger$lzycompute() {
        GDALFileHandler gDALFileHandler = this;
        synchronized (gDALFileHandler) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public SimpleFeature buildSimpleFeature(File file, Map<String, String> params) {
        return AbstractFileHandler.class.buildSimpleFeature((AbstractFileHandler)this, (File)file, params);
    }

    public Date getDate(File file, Map<String, String> params) {
        return AbstractFileHandler.class.getDate((AbstractFileHandler)this, (File)file, params);
    }

    public Option<Date> getDateFromParams(Map<String, String> params) {
        return AbstractFileHandler.class.getDateFromParams((AbstractFileHandler)this, params);
    }

    public Geometry getGeometry(File file, Map<String, String> params) {
        return AbstractFileHandler.class.getGeometry((AbstractFileHandler)this, (File)file, params);
    }

    public Option<Geometry> getGeometryFromParams(Map<String, String> params) {
        return AbstractFileHandler.class.getGeometryFromParams((AbstractFileHandler)this, params);
    }

    public Option<String> getFileNameFromParams(Map<String, String> params) {
        return BlobStoreFileName.class.getFileNameFromParams((BlobStoreFileName)this, params);
    }

    public String getFileName(File file, Map<String, String> params) {
        return BlobStoreFileName.class.getFileName((BlobStoreFileName)this, (File)file, params);
    }

    public ThreadLocal<SimpleFeatureBuilder> builderLocal() {
        return this.builderLocal;
    }

    public Z3FeatureIdGenerator featureIdGenerator() {
        return this.featureIdGenerator;
    }

    public void org$locationtech$geomesa$blob$api$handlers$BlobStoreSimpleFeatureBuilder$_setter_$builderLocal_$eq(ThreadLocal x$1) {
        this.builderLocal = x$1;
    }

    public void org$locationtech$geomesa$blob$api$handlers$BlobStoreSimpleFeatureBuilder$_setter_$featureIdGenerator_$eq(Z3FeatureIdGenerator x$1) {
        this.featureIdGenerator = x$1;
    }

    public SimpleFeature buildBlobSimpleFeature(String fileName, Geometry geom, Date dtg) {
        return BlobStoreSimpleFeatureBuilder.class.buildBlobSimpleFeature((BlobStoreSimpleFeatureBuilder)this, (String)fileName, (Geometry)geom, (Date)dtg);
    }

    public GeometryFactory geomFactory() {
        return this.geomFactory;
    }

    public boolean initialized() {
        return this.initialized;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Geometry> getGeometryFromFile(File file) {
        BoxedUnit boxedUnit;
        Option<Geometry> option;
        Dataset gdalFile;
        if (this.initialized()) {
            gdalFile = gdal.Open((String)file.getAbsolutePath(), (int)gdalconstConstants.GA_ReadOnly);
            if (gdalFile == null) {
                option = None$.MODULE$;
                return option;
            }
            option = this.getImageBoundsGeometry(gdalFile);
            return option;
        }
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to proceed - ", " was not properly initialized"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass()})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        option = None$.MODULE$;
        return option;
        finally {
            gdalFile.delete();
        }
    }

    public Boolean canProcess(File file, Map<String, String> map) {
        Boolean bl;
        if (this.initialized()) {
            Dataset potentialGdalDataSet = gdal.Open((String)file.getAbsolutePath(), (int)gdalconstConstants.GA_ReadOnly);
            if (potentialGdalDataSet == null) {
                bl = Predef$.MODULE$.boolean2Boolean(false);
            } else {
                potentialGdalDataSet.delete();
                bl = Predef$.MODULE$.boolean2Boolean(true);
            }
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to proceed - ", " was not properly initialized"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass()})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = Predef$.MODULE$.boolean2Boolean(false);
        }
        return bl;
    }

    public Option<Date> getDateFromFile(File file) {
        return AbstractFileHandler.class.getDateFromFile((AbstractFileHandler)this, (File)file);
    }

    private Option<Geometry> getImageBoundsGeometry(Dataset file) {
        double maxX = (double)file.getRasterXSize() - GDALFileHandler$.MODULE$.minXY();
        double maxY = (double)file.getRasterYSize() - GDALFileHandler$.MODULE$.minXY();
        Tuple2[] coordinates = (Tuple2[])((Object[])new Tuple2[]{new Tuple2.mcDD.sp(GDALFileHandler$.MODULE$.minXY(), GDALFileHandler$.MODULE$.minXY()), new Tuple2.mcDD.sp(maxX, GDALFileHandler$.MODULE$.minXY()), new Tuple2.mcDD.sp(maxX, maxY), new Tuple2.mcDD.sp(GDALFileHandler$.MODULE$.minXY(), maxY), new Tuple2.mcDD.sp(GDALFileHandler$.MODULE$.minXY(), GDALFileHandler$.MODULE$.minXY())});
        Transformer transformer = new Transformer(file, null, GDALFileHandler$.MODULE$.opts());
        return new Some((Object)this.geomFactory().createPolygon((Coordinate[])Predef$.MODULE$.refArrayOps((Object[])coordinates).flatMap((Function1)new Serializable(this, transformer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GDALFileHandler $outer;
            private final Transformer transformer$1;

            public final Iterable<Coordinate> apply(Tuple2<Object, Object> p) {
                return Option$.MODULE$.option2Iterable(this.$outer.org$locationtech$geomesa$blob$handlers$gdal$GDALFileHandler$$applyTransformer(p._1$mcD$sp(), p._2$mcD$sp(), this.transformer$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.transformer$1 = transformer$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Coordinate.class)))));
    }

    public Option<Coordinate> org$locationtech$geomesa$blob$handlers$gdal$GDALFileHandler$$applyTransformer(double x, double y, Transformer tran) {
        Try try_;
        block7: {
            Option option;
            block6: {
                Option p;
                block5: {
                    BoxedUnit boxedUnit;
                    try_ = Try$.MODULE$.apply((Function0)new Serializable(this, x, y, tran){
                        public static final long serialVersionUID = 0L;
                        private final double x$1;
                        private final double y$1;
                        private final Transformer tran$1;

                        public final Option<Coordinate> apply() {
                            double[] point = (double[])Array$.MODULE$.ofDim(3, ClassTag$.MODULE$.Double());
                            int ret = this.tran$1.TransformPoint(point, 0, this.x$1, this.y$1);
                            return ret == 0 ? None$.MODULE$ : new Some((Object)new Coordinate(point[0], point[1]));
                        }
                        {
                            this.x$1 = x$1;
                            this.y$1 = y$1;
                            this.tran$1 = tran$1;
                        }
                    });
                    if (!(try_ instanceof Failure)) break block5;
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Failed to apply GDAL Transformer in GDALFileHandler", e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    option = None$.MODULE$;
                    break block6;
                }
                if (!(try_ instanceof Success)) break block7;
                Success success = (Success)try_;
                option = p = (Option)success.value();
            }
            return option;
        }
        throw new MatchError((Object)try_);
    }

    public GDALFileHandler() {
        Try try_;
        block9: {
            boolean bl;
            block8: {
                BoxedUnit boxedUnit;
                block7: {
                    BoxedUnit boxedUnit2;
                    BlobStoreSimpleFeatureBuilder.class.$init$((BlobStoreSimpleFeatureBuilder)this);
                    BlobStoreFileName.class.$init$((BlobStoreFileName)this);
                    AbstractFileHandler.class.$init$((AbstractFileHandler)this);
                    LazyLogging.class.$init$((LazyLogging)this);
                    this.geomFactory = new GeometryFactory();
                    try_ = Try$.MODULE$.apply((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            gdal.AllRegister();
                        }
                    });
                    if (!(try_ instanceof Success)) break block7;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Successfully loaded GDAL native interface bindings");
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    bl = true;
                    break block8;
                }
                if (!(try_ instanceof Failure)) break block9;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Failed to load GDAL native libraries in GeoMesa GDAL FileHandler, ensure that the path of the native GDAL libraries and JNI libraries are in the LD_LIBRARY_PATH environment variable", e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                bl = false;
            }
            this.initialized = bl;
            return;
        }
        throw new MatchError((Object)try_);
    }
}

