/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.blob.handlers.gdal;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.util.Date;
import java.util.Map;
import java.util.Vector;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.Transformer;
import org.gdal.gdal.gdal;
import org.gdal.gdalconst.gdalconstConstants;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.locationtech.geomesa.blob.api.handlers.AbstractFileHandler;
import org.locationtech.geomesa.blob.api.handlers.BlobStoreFileName;
import org.locationtech.geomesa.blob.api.handlers.BlobStoreSimpleFeatureBuilder;
import org.locationtech.geomesa.blob.handlers.gdal.GDALFileHandler$;
import org.locationtech.geomesa.utils.uuid.Z3FeatureIdGenerator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.simple.SimpleFeature;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\u0001\u0003\u0001=\u0011qb\u0012#B\u0019\u001aKG.\u001a%b]\u0012dWM\u001d\u0006\u0003\u0007\u0011\tAa\u001a3bY*\u0011QAB\u0001\tQ\u0006tG\r\\3sg*\u0011q\u0001C\u0001\u0005E2|'M\u0003\u0002\n\u0015\u00059q-Z8nKN\f'BA\u0006\r\u00031awnY1uS>tG/Z2i\u0015\u0005i\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u0011-u\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007CA\f\u001c\u001b\u0005A\"BA\u0003\u001a\u0015\tQb!A\u0002ba&L!\u0001\b\r\u0003'\u0005\u00137\u000f\u001e:bGR4\u0015\u000e\\3IC:$G.\u001a:\u0011\u0005y)S\"A\u0010\u000b\u0005\u0001\n\u0013\u0001D:dC2\fGn\\4hS:<'B\u0001\u0012$\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u0013\u0002\u0007\r|W.\u0003\u0002'?\tYA*\u0019>z\u0019><w-\u001b8h\u0011\u0015A\u0003\u0001\"\u0001*\u0003\u0019a\u0014N\\5u}Q\t!\u0006\u0005\u0002,\u00015\t!\u0001C\u0004.\u0001\t\u0007I\u0011\u0001\u0018\u0002\u0017\u001d,w.\u001c$bGR|'/_\u000b\u0002_A\u0011\u0001'N\u0007\u0002c)\u0011!gM\u0001\u0005O\u0016|WN\u0003\u00025\u0015\u0005\u0019!\u000e^:\n\u0005Y\n$aD$f_6,GO]=GC\u000e$xN]=\t\ra\u0002\u0001\u0015!\u00030\u000319Wm\\7GC\u000e$xN]=!\u0011\u001dQ\u0004A1A\u0005\u0002m\n1\"\u001b8ji&\fG.\u001b>fIV\tA\b\u0005\u0002\u0012{%\u0011aH\u0005\u0002\b\u0005>|G.Z1o\u0011\u0019\u0001\u0005\u0001)A\u0005y\u0005a\u0011N\\5uS\u0006d\u0017N_3eA!)!\t\u0001C!\u0007\u0006\u0019r-\u001a;HK>lW\r\u001e:z\rJ|WNR5mKR\u0011AI\u0013\t\u0004#\u0015;\u0015B\u0001$\u0013\u0005\u0019y\u0005\u000f^5p]B\u0011\u0001\u0007S\u0005\u0003\u0013F\u0012\u0001bR3p[\u0016$(/\u001f\u0005\u0006\u0017\u0006\u0003\r\u0001T\u0001\u0005M&dW\r\u0005\u0002N%6\taJ\u0003\u0002P!\u0006\u0011\u0011n\u001c\u0006\u0002#\u0006!!.\u0019<b\u0013\t\u0019fJ\u0001\u0003GS2,\u0007\"B+\u0001\t\u00032\u0016AC2b]B\u0013xnY3tgR\u0019q\u000bX/\u0011\u0005a[V\"A-\u000b\u0005i\u0003\u0016\u0001\u00027b]\u001eL!AP-\t\u000b-#\u0006\u0019\u0001'\t\u000by#\u0006\u0019A0\u0002\u00075\f\u0007\u000f\u0005\u0003aG\u0016,W\"A1\u000b\u0005\t\u0004\u0016\u0001B;uS2L!\u0001Z1\u0003\u00075\u000b\u0007\u000f\u0005\u0002gS:\u0011\u0011cZ\u0005\u0003QJ\ta\u0001\u0015:fI\u00164\u0017B\u00016l\u0005\u0019\u0019FO]5oO*\u0011\u0001N\u0005\u0005\u0006[\u0002!\tE\\\u0001\u0010O\u0016$H)\u0019;f\rJ|WNR5mKR\u0011qn\u001d\t\u0004#\u0015\u0003\bC\u00011r\u0013\t\u0011\u0018M\u0001\u0003ECR,\u0007\"B&m\u0001\u0004a\u0005\"B;\u0001\t\u00131\u0018AF4fi&k\u0017mZ3C_VtGm]$f_6,GO]=\u0015\u0005\u0011;\b\"B&u\u0001\u0004A\bCA=}\u001b\u0005Q(BA\u0002|\u0015\t\u0019A\"\u0003\u0002~u\n9A)\u0019;bg\u0016$\bBB@\u0001\t\u0013\t\t!\u0001\tbaBd\u0017\u0010\u0016:b]N4wN]7feRA\u00111AA\u0006\u0003+\tI\u0002\u0005\u0003\u0012\u000b\u0006\u0015\u0001c\u0001\u0019\u0002\b%\u0019\u0011\u0011B\u0019\u0003\u0015\r{wN\u001d3j]\u0006$X\rC\u0004\u0002\u000ey\u0004\r!a\u0004\u0002\u0003a\u00042!EA\t\u0013\r\t\u0019B\u0005\u0002\u0007\t>,(\r\\3\t\u000f\u0005]a\u00101\u0001\u0002\u0010\u0005\t\u0011\u0010C\u0004\u0002\u001cy\u0004\r!!\b\u0002\tQ\u0014\u0018M\u001c\t\u0004s\u0006}\u0011bAA\u0011u\nYAK]1og\u001a|'/\\3s\u000f\u001d\t)C\u0001E\u0001\u0003O\tqb\u0012#B\u0019\u001aKG.\u001a%b]\u0012dWM\u001d\t\u0004W\u0005%bAB\u0001\u0003\u0011\u0003\tYcE\u0002\u0002*AAq\u0001KA\u0015\t\u0003\ty\u0003\u0006\u0002\u0002(!Q\u00111GA\u0015\u0005\u0004%\t!!\u000e\u0002\u000f\u0011\u001cHoX:sgV\tQ\r\u0003\u0005\u0002:\u0005%\u0002\u0015!\u0003f\u0003!!7\u000f^0teN\u0004\u0003BCA\u001f\u0003S\u0011\r\u0011\"\u0001\u0002@\u0005!q\u000e\u001d;t+\t\t\t\u0005\u0005\u0003a\u0003\u0007*\u0017bAA#C\n1a+Z2u_JD\u0011\"!\u0013\u0002*\u0001\u0006I!!\u0011\u0002\u000b=\u0004Ho\u001d\u0011\t\u0015\u00055\u0013\u0011\u0006b\u0001\n\u0003\ty%A\u0003nS:D\u0016,\u0006\u0002\u0002\u0010!I\u00111KA\u0015A\u0003%\u0011qB\u0001\u0007[&t\u0007,\u0017\u0011")
public class GDALFileHandler
implements AbstractFileHandler,
LazyLogging {
    private final GeometryFactory geomFactory;
    private final boolean initialized;
    private final Logger logger;
    private final ThreadLocal<SimpleFeatureBuilder> builderLocal;
    private final Z3FeatureIdGenerator featureIdGenerator;
    private volatile boolean bitmap$0;

    public static double minXY() {
        return GDALFileHandler$.MODULE$.minXY();
    }

    public static Vector<String> opts() {
        return GDALFileHandler$.MODULE$.opts();
    }

    public static String dst_srs() {
        return GDALFileHandler$.MODULE$.dst_srs();
    }

    private Logger logger$lzycompute() {
        GDALFileHandler gDALFileHandler = this;
        synchronized (gDALFileHandler) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public SimpleFeature buildSimpleFeature(File file, Map<String, String> params) {
        return AbstractFileHandler.class.buildSimpleFeature((AbstractFileHandler)this, (File)file, params);
    }

    public Date getDate(File file, Map<String, String> params) {
        return AbstractFileHandler.class.getDate((AbstractFileHandler)this, (File)file, params);
    }

    public Option<Date> getDateFromParams(Map<String, String> params) {
        return AbstractFileHandler.class.getDateFromParams((AbstractFileHandler)this, params);
    }

    public Geometry getGeometry(File file, Map<String, String> params) {
        return AbstractFileHandler.class.getGeometry((AbstractFileHandler)this, (File)file, params);
    }

    public Option<Geometry> getGeometryFromParams(Map<String, String> params) {
        return AbstractFileHandler.class.getGeometryFromParams((AbstractFileHandler)this, params);
    }

    public Option<String> getFileNameFromParams(Map<String, String> params) {
        return BlobStoreFileName.class.getFileNameFromParams((BlobStoreFileName)this, params);
    }

    public String getFileName(File file, Map<String, String> params) {
        return BlobStoreFileName.class.getFileName((BlobStoreFileName)this, (File)file, params);
    }

    public ThreadLocal<SimpleFeatureBuilder> builderLocal() {
        return this.builderLocal;
    }

    public Z3FeatureIdGenerator featureIdGenerator() {
        return this.featureIdGenerator;
    }

    public void org$locationtech$geomesa$blob$api$handlers$BlobStoreSimpleFeatureBuilder$_setter_$builderLocal_$eq(ThreadLocal x$1) {
        this.builderLocal = x$1;
    }

    public void org$locationtech$geomesa$blob$api$handlers$BlobStoreSimpleFeatureBuilder$_setter_$featureIdGenerator_$eq(Z3FeatureIdGenerator x$1) {
        this.featureIdGenerator = x$1;
    }

    public SimpleFeature buildBlobSimpleFeature(String fileName, Geometry geom, Date dtg) {
        return BlobStoreSimpleFeatureBuilder.class.buildBlobSimpleFeature((BlobStoreSimpleFeatureBuilder)this, (String)fileName, (Geometry)geom, (Date)dtg);
    }

    public GeometryFactory geomFactory() {
        return this.geomFactory;
    }

    public boolean initialized() {
        return this.initialized;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Geometry> getGeometryFromFile(File file) {
        BoxedUnit boxedUnit;
        Option<Geometry> option;
        Dataset gdalFile;
        if (this.initialized()) {
            gdalFile = gdal.Open((String)file.getAbsolutePath(), (int)gdalconstConstants.GA_ReadOnly);
            if (gdalFile == null) {
                option = None$.MODULE$;
                return option;
            }
            option = this.getImageBoundsGeometry(gdalFile);
            return option;
        }
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Unable to proceed - {} was not properly initialized", new Object[]{this.getClass()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        option = None$.MODULE$;
        return option;
        finally {
            gdalFile.delete();
        }
    }

    public Boolean canProcess(File file, Map<String, String> map) {
        Boolean bl;
        if (this.initialized()) {
            Dataset potentialGdalDataSet = gdal.Open((String)file.getAbsolutePath(), (int)gdalconstConstants.GA_ReadOnly);
            if (potentialGdalDataSet == null) {
                bl = Predef$.MODULE$.boolean2Boolean(false);
            } else {
                potentialGdalDataSet.delete();
                bl = Predef$.MODULE$.boolean2Boolean(true);
            }
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Unable to proceed - {} was not properly initialized", new Object[]{this.getClass()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = Predef$.MODULE$.boolean2Boolean(false);
        }
        return bl;
    }

    public Option<Date> getDateFromFile(File file) {
        return AbstractFileHandler.class.getDateFromFile((AbstractFileHandler)this, (File)file);
    }

    private Option<Geometry> getImageBoundsGeometry(Dataset file) {
        double maxX = (double)file.getRasterXSize() - GDALFileHandler$.MODULE$.minXY();
        double maxY = (double)file.getRasterYSize() - GDALFileHandler$.MODULE$.minXY();
        Tuple2[] coordinates = (Tuple2[])((Object[])new Tuple2[]{new Tuple2.mcDD.sp(GDALFileHandler$.MODULE$.minXY(), GDALFileHandler$.MODULE$.minXY()), new Tuple2.mcDD.sp(maxX, GDALFileHandler$.MODULE$.minXY()), new Tuple2.mcDD.sp(maxX, maxY), new Tuple2.mcDD.sp(GDALFileHandler$.MODULE$.minXY(), maxY), new Tuple2.mcDD.sp(GDALFileHandler$.MODULE$.minXY(), GDALFileHandler$.MODULE$.minXY())});
        Transformer transformer = new Transformer(file, null, GDALFileHandler$.MODULE$.opts());
        return new Some((Object)this.geomFactory().createPolygon((Coordinate[])Predef$.MODULE$.refArrayOps((Object[])coordinates).flatMap((Function1)new Serializable(this, transformer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GDALFileHandler $outer;
            private final Transformer transformer$1;

            public final Iterable<Coordinate> apply(Tuple2<Object, Object> p) {
                return Option$.MODULE$.option2Iterable(this.$outer.org$locationtech$geomesa$blob$handlers$gdal$GDALFileHandler$$applyTransformer(p._1$mcD$sp(), p._2$mcD$sp(), this.transformer$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.transformer$1 = transformer$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Coordinate.class)))));
    }

    public Option<Coordinate> org$locationtech$geomesa$blob$handlers$gdal$GDALFileHandler$$applyTransformer(double x, double y, Transformer tran) {
        Try try_;
        block7: {
            Option option;
            block6: {
                Option p;
                block5: {
                    BoxedUnit boxedUnit;
                    try_ = Try$.MODULE$.apply((Function0)new Serializable(this, x, y, tran){
                        public static final long serialVersionUID = 0L;
                        private final double x$1;
                        private final double y$1;
                        private final Transformer tran$1;

                        public final Option<Coordinate> apply() {
                            double[] point = (double[])Array$.MODULE$.ofDim(3, ClassTag$.MODULE$.Double());
                            int ret = this.tran$1.TransformPoint(point, 0, this.x$1, this.y$1);
                            return ret == 0 ? None$.MODULE$ : new Some((Object)new Coordinate(point[0], point[1]));
                        }
                        {
                            this.x$1 = x$1;
                            this.y$1 = y$1;
                            this.tran$1 = tran$1;
                        }
                    });
                    if (!(try_ instanceof Failure)) break block5;
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Failed to apply GDAL Transformer in GDALFileHandler", e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    option = None$.MODULE$;
                    break block6;
                }
                if (!(try_ instanceof Success)) break block7;
                Success success = (Success)try_;
                option = p = (Option)success.value();
            }
            return option;
        }
        throw new MatchError((Object)try_);
    }

    public GDALFileHandler() {
        Try try_;
        block9: {
            boolean bl;
            block8: {
                BoxedUnit boxedUnit;
                block7: {
                    BoxedUnit boxedUnit2;
                    BlobStoreSimpleFeatureBuilder.class.$init$((BlobStoreSimpleFeatureBuilder)this);
                    BlobStoreFileName.class.$init$((BlobStoreFileName)this);
                    AbstractFileHandler.class.$init$((AbstractFileHandler)this);
                    LazyLogging.class.$init$((LazyLogging)this);
                    this.geomFactory = new GeometryFactory();
                    try_ = Try$.MODULE$.apply((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            gdal.AllRegister();
                        }
                    });
                    if (!(try_ instanceof Success)) break block7;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Successfully loaded GDAL native interface bindings");
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    bl = true;
                    break block8;
                }
                if (!(try_ instanceof Failure)) break block9;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Failed to load GDAL native libraries in GeoMesa GDAL FileHandler, ensure that the path of the native GDAL libraries and JNI libraries are in the LD_LIBRARY_PATH environment variable", e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                bl = false;
            }
            this.initialized = bl;
            return;
        }
        throw new MatchError((Object)try_);
    }
}

