/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.analytic;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.List;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.util.NullProgressListener;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.analytic.StatsVisitor;
import org.opengis.feature.FeatureVisitor;
import org.opengis.util.ProgressListener;
import scala.Array$;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@DescribeProcess(title="Stats Process", description="Gathers statistics for a data set")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\u0001\u0003\u00015\u0011Ab\u0015;biN\u0004&o\\2fgNT!a\u0001\u0003\u0002\u0011\u0005t\u0017\r\\=uS\u000eT!!\u0002\u0004\u0002\u000fA\u0014xnY3tg*\u0011q\u0001C\u0001\bO\u0016|W.Z:b\u0015\tI!\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001aB\u0006\u000e\u0011\u0005=!R\"\u0001\t\u000b\u0005E\u0011\u0012\u0001\u00027b]\u001eT\u0011aE\u0001\u0005U\u00064\u0018-\u0003\u0002\u0016!\t1qJ\u00196fGR\u0004\"a\u0006\r\u000e\u0003\u0011I!!\u0007\u0003\u0003\u001d\u001d+w.T3tCB\u0013xnY3tgB\u00111DI\u0007\u00029)\u0011QDH\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003?\u0001\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002C\u0005\u00191m\\7\n\u0005\rb\"a\u0003'bufdunZ4j]\u001eDQ!\n\u0001\u0005\u0002\u0019\na\u0001P5oSRtD#A\u0014\u0011\u0005!\u0002Q\"\u0001\u0002\t\u000b)\u0002A\u0011A\u0016\u0002\u000f\u0015DXmY;uKR)AFN#VAB\u0011Q\u0006N\u0007\u0002])\u0011q\u0006M\u0001\u0007g&l\u0007\u000f\\3\u000b\u0005E\u0012\u0014\u0001\u00023bi\u0006T!a\r\u0006\u0002\u0011\u001d,w\u000e^8pYNL!!\u000e\u0018\u0003/MKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0007>dG.Z2uS>t\u0007\"B\u001c*\u0001\u0004a\u0013\u0001\u00034fCR,(/Z:)\rYJ\u0004)\u0011\"D!\tQd(D\u0001<\u0015\taT(A\u0004gC\u000e$xN]=\u000b\u0005\u0015\u0011\u0014BA <\u0005E!Um]2sS\n,\u0007+\u0019:b[\u0016$XM]\u0001\u0005]\u0006lW-I\u00018\u0003-!Wm]2sSB$\u0018n\u001c8\"\u0003\u0011\u000b\u0011\u0005\u00165fA\u0019,\u0017\r^;sK\u0002\u001aX\r\u001e\u0011p]\u0002:\b.[2iAQ|\u0007%];fefDQAR\u0015A\u0002\u001d\u000b!b\u001d;biN#(/\u001b8h!\tAeJ\u0004\u0002J\u00196\t!JC\u0001L\u0003\u0015\u00198-\u00197b\u0013\ti%*\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001fB\u0013aa\u0015;sS:<'BA'KQ\u0019)\u0015\b\u0011*C'\u0006\na)I\u0001U\u0003=\"\u0006.\u001a\u0011tiJLgn\u001a\u0011j]\u0012L7-\u0019;j]\u001e\u0004s\u000f[1uAM$\u0018\r^:!i>\u0004\u0013N\\:uC:$\u0018.\u0019;f\u0011\u001d1\u0016\u0006%AA\u0002]\u000ba!\u001a8d_\u0012,\u0007CA\bY\u0013\tI\u0006CA\u0004C_>dW-\u00198)\u0011UK\u0004i\u0017/^\u0005z\u000b\u0013AV\u0001\u0004[&tW$\u0001\u0001\"\u0003}\u000bAEU3ukJt\u0007\u0005\u001e5fAY\fG.^3tA\u0015t7m\u001c3fI\u0002z'\u000fI1tA)\u001cxN\u001c\u0005\bC&\u0002\n\u00111\u0001c\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0004G\u001a<U\"\u00013\u000b\u0005\u0015\u0014\u0012\u0001B;uS2L!a\u001a3\u0003\t1K7\u000f\u001e\u0015\rAf\u0002\u0015\u000eX/kW2l'I\\\u0011\u0002C\u0006\u0019Q.\u0019=\u001e\u0005\u0001\u0001\u0019AD2pY2,7\r^5p]RK\b/Z\u0012\u0002\u000f\u0006\nq.A\u001eUQ\u0016\u0004\u0003O]8qKJ$\u0018.Z:!_\u0001\"(/\u00198tM>\u0014Xn\u001d\u0011u_\u0002\n\u0007\u000f\u001d7zA\t,gm\u001c:fA\u001d\fG\u000f[3sS:<\u0007e\u001d;biNDC!K9CiB\u0011!H]\u0005\u0003gn\u0012a\u0002R3tGJL'-\u001a*fgVdG/I\u0001v\u0003eyU\u000f\u001e9vi\u00022W-\u0019;ve\u0016\u00043m\u001c7mK\u000e$\u0018n\u001c8\t\u000f]\u0004\u0011\u0013!C\u0001q\u0006\tR\r_3dkR,G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0003eT#a\u0016>,\u0003m\u00042\u0001`A\u0002\u001b\u0005i(B\u0001@\u0000\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0002)\u000b!\"\u00198o_R\fG/[8o\u0013\r\t)! \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA\u0005\u0001E\u0005I\u0011AA\u0006\u0003E)\u00070Z2vi\u0016$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u001bQ#A\u0019>)\u0015\u0001\t\t\"a\u0006\u0002\u001a\t\u000bi\u0002E\u0002;\u0003'I1!!\u0006<\u0005=!Um]2sS\n,\u0007K]8dKN\u001c\u0018!\u0002;ji2,\u0017EAA\u000e\u00035\u0019F/\u0019;tAA\u0013xnY3tg\u0006\u0012\u0011qD\u0001\"\u000f\u0006$\b.\u001a:tAM$\u0018\r^5ti&\u001c7\u000f\t4pe\u0002\n\u0007\u0005Z1uC\u0002\u001aX\r\u001e")
public class StatsProcess
implements GeoMesaProcess,
LazyLogging {
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        StatsProcess statsProcess = this;
        synchronized (statsProcess) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @DescribeResult(description="Output feature collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="features", description="The feature set on which to query") SimpleFeatureCollection features, @DescribeParameter(name="statString", description="The string indicating what stats to instantiate") String statString, @DescribeParameter(name="encode", min=0, description="Return the values encoded or as json") Boolean encode, @DescribeParameter(name="properties", min=0, max=128, collectionType=String.class, description="The properties / transforms to apply before gathering stats") List<String> properties) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting stats iterator process on type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{features.getClass().getName()})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String[] propsArray = (String[])Option$.MODULE$.apply(properties).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String[] apply(List<String> x$1) {
                return (String[])x$1.toArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
            }
        }).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String[] x$2) {
                return x$2.length > 0;
            }
        }).orNull(Predef$.MODULE$.$conforms());
        StatsVisitor visitor = new StatsVisitor(features, statString, Option$.MODULE$.apply((Object)encode).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Boolean x$3) {
                return x$3;
            }
        }), propsArray);
        features.accepts((FeatureVisitor)visitor, (ProgressListener)new NullProgressListener());
        return visitor.getResult().results();
    }

    public Boolean execute$default$3() {
        return null;
    }

    public List<String> execute$default$4() {
        return null;
    }

    public StatsProcess() {
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

