/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.query;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.util.List;
import org.geotools.data.Query;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.process.FeatureResult;
import org.locationtech.geomesa.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.process.GeoMesaProcessVisitor$class;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.Conversions;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.DWithin;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001B\u0001\u0003\u00015\u0011\u0001\u0003\u0015:pq&l\u0017\u000e^=WSNLGo\u001c:\u000b\u0005\r!\u0011!B9vKJL(BA\u0003\u0007\u0003\u001d\u0001(o\\2fgNT!a\u0002\u0005\u0002\u000f\u001d,w.\\3tC*\u0011\u0011BC\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\f\u001b!\tyA#D\u0001\u0011\u0015\t\t\"#\u0001\u0003mC:<'\"A\n\u0002\t)\fg/Y\u0005\u0003+A\u0011aa\u00142kK\u000e$\bCA\f\u0019\u001b\u0005!\u0011BA\r\u0005\u0005U9Um\\'fg\u0006\u0004&o\\2fgN4\u0016n]5u_J\u0004\"a\u0007\u0012\u000e\u0003qQ!!\b\u0010\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005}\u0001\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\u0005\n1aY8n\u0013\t\u0019CDA\u0006MCjLHj\\4hS:<\u0007\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\u0002\u001b%t\u0007/\u001e;GK\u0006$XO]3t!\t9c&D\u0001)\u0015\tI#&\u0001\u0004tS6\u0004H.\u001a\u0006\u0003W1\nA\u0001Z1uC*\u0011QFC\u0001\tO\u0016|Go\\8mg&\u0011q\u0006\u000b\u0002\u0018'&l\u0007\u000f\\3GK\u0006$XO]3D_2dWm\u0019;j_:D\u0001\"\r\u0001\u0003\u0002\u0003\u0006IAJ\u0001\rI\u0006$\u0018MR3biV\u0014Xm\u001d\u0005\tg\u0001\u0011\t\u0011)A\u0005i\u0005q!-\u001e4gKJ$\u0015n\u001d;b]\u000e,\u0007CA\b6\u0013\t1\u0004C\u0001\u0004E_V\u0014G.\u001a\u0005\u0006q\u0001!\t!O\u0001\u0007y%t\u0017\u000e\u001e \u0015\tibTH\u0010\t\u0003w\u0001i\u0011A\u0001\u0005\u0006K]\u0002\rA\n\u0005\u0006c]\u0002\rA\n\u0005\u0006g]\u0002\r\u0001\u000e\u0005\b\u0001\u0002\u0011\r\u0011\"\u0003B\u0003\u00199Wm\u001c$bGV\t!\t\u0005\u0002D\u00156\tAI\u0003\u0002F\r\u0006!q-Z8n\u0015\t9\u0005*A\u0002kiNT!!\u0013\u0011\u0002\u001dYLg/\u001b3t_2,H/[8og&\u00111\n\u0012\u0002\u0010\u000f\u0016|W.\u001a;ss\u001a\u000b7\r^8ss\"1Q\n\u0001Q\u0001\n\t\u000bqaZ3p\r\u0006\u001c\u0007\u0005C\u0004P\u0001\t\u0007I\u0011\u0002)\u0002\u0005\u00194W#A)\u0011\u0005I;V\"A*\u000b\u0005Q+\u0016A\u00024jYR,'O\u0003\u0002W\u0015\u00059q\u000e]3oO&\u001c\u0018B\u0001-T\u000591\u0015\u000e\u001c;fe\u001a\u000b7\r^8ssJBaA\u0017\u0001!\u0002\u0013\t\u0016a\u00014gA!AA\f\u0001EC\u0002\u0013%Q,\u0001\u0007nC:,\u0018\r\u001c$jYR,'/F\u0001_!\t\u0011v,\u0003\u0002a'\n1a)\u001b7uKJD\u0001B\u0019\u0001\t\u0002\u0003\u0006KAX\u0001\u000e[\u0006tW/\u00197GS2$XM\u001d\u0011\t\u000f\u0011\u0004!\u0019!C\u0005K\u0006\u0011R.\u00198vC24\u0016n]5u%\u0016\u001cX\u000f\u001c;t+\u00051\u0007CA4k\u001b\u0005A'BA5+\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003W\"\u0014Q\u0003T5ti\u001a+\u0017\r^;sK\u000e{G\u000e\\3di&|g\u000e\u0003\u0004n\u0001\u0001\u0006IAZ\u0001\u0014[\u0006tW/\u00197WSNLGOU3tk2$8\u000f\t\u0005\b_\u0002\u0001\r\u0011\"\u0003q\u0003)\u0011Xm];mi\u000e\u000bGnY\u000b\u0002cB\u0011qC]\u0005\u0003g\u0012\u0011QBR3biV\u0014XMU3tk2$\bbB;\u0001\u0001\u0004%IA^\u0001\u000fe\u0016\u001cX\u000f\u001c;DC2\u001cw\fJ3r)\t9X\u0010\u0005\u0002yw6\t\u0011PC\u0001{\u0003\u0015\u00198-\u00197b\u0013\ta\u0018P\u0001\u0003V]&$\bb\u0002@u\u0003\u0003\u0005\r!]\u0001\u0004q\u0012\n\u0004bBA\u0001\u0001\u0001\u0006K!]\u0001\fe\u0016\u001cX\u000f\u001c;DC2\u001c\u0007\u0005C\u0004\u0002\u0006\u0001!\t%a\u0002\u0002\u000bYL7/\u001b;\u0015\u0007]\fI\u0001\u0003\u0005\u0002\f\u0005\r\u0001\u0019AA\u0007\u0003\u001d1W-\u0019;ve\u0016\u0004B!a\u0004\u0002\u00145\u0011\u0011\u0011\u0003\u0006\u0004\u0003\u0017)\u0016\u0002BA\u000b\u0003#\u0011qAR3biV\u0014X\rC\u0004\u0002\u001a\u0001!\t%a\u0007\u0002\u0013\u001d,GOU3tk2$H#A9\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"\u00059Q\r_3dkR,G#B<\u0002$\u00055\u0002\u0002CA\u0013\u0003;\u0001\r!a\n\u0002\rM|WO]2f!\r9\u0013\u0011F\u0005\u0004\u0003WA#aE*j[BdWMR3biV\u0014XmU8ve\u000e,\u0007bB\u0002\u0002\u001e\u0001\u0007\u0011q\u0006\t\u0005\u0003c\t\u0019$D\u0001+\u0013\r\t)D\u000b\u0002\u0006#V,'/\u001f\u0005\b\u0003s\u0001A\u0011BA\u001e\u00039!w/\u001b;iS:4\u0015\u000e\u001c;feN$2AXA\u001f\u0011!\ty$a\u000eA\u0002\u0005\u0005\u0013!\u0004:fcV,7\u000f^3e+:LG\u000f\u0005\u0003\u0002D\u0005%cb\u0001=\u0002F%\u0019\u0011qI=\u0002\rA\u0013X\rZ3g\u0013\u0011\tY%!\u0014\u0003\rM#(/\u001b8h\u0015\r\t9%\u001f")
public class ProximityVisitor
implements GeoMesaProcessVisitor,
LazyLogging {
    private final SimpleFeatureCollection inputFeatures;
    private final SimpleFeatureCollection dataFeatures;
    public final Double org$locationtech$geomesa$process$query$ProximityVisitor$$bufferDistance;
    private final GeometryFactory geoFac;
    private final FilterFactory2 org$locationtech$geomesa$process$query$ProximityVisitor$$ff;
    private Filter manualFilter;
    private final ListFeatureCollection manualVisitResults;
    private FeatureResult resultCalc;
    private final Logger logger;
    private volatile byte bitmap$0;

    private Filter manualFilter$lzycompute() {
        ProximityVisitor proximityVisitor = this;
        synchronized (proximityVisitor) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.manualFilter = this.dwithinFilters("degrees");
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.manualFilter;
        }
    }

    private Logger logger$lzycompute() {
        ProximityVisitor proximityVisitor = this;
        synchronized (proximityVisitor) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public List<Expression> getExpressions() {
        return GeoMesaProcessVisitor$class.getExpressions(this);
    }

    private GeometryFactory geoFac() {
        return this.geoFac;
    }

    public FilterFactory2 org$locationtech$geomesa$process$query$ProximityVisitor$$ff() {
        return this.org$locationtech$geomesa$process$query$ProximityVisitor$$ff;
    }

    private Filter manualFilter() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.manualFilter$lzycompute() : this.manualFilter;
    }

    private ListFeatureCollection manualVisitResults() {
        return this.manualVisitResults;
    }

    private FeatureResult resultCalc() {
        return this.resultCalc;
    }

    private void resultCalc_$eq(FeatureResult x$1) {
        this.resultCalc = x$1;
    }

    public void visit(Feature feature) {
        SimpleFeature sf = (SimpleFeature)feature;
        if (this.manualFilter().evaluate((Object)sf)) {
            this.manualVisitResults().add(sf);
        }
    }

    public FeatureResult getResult() {
        return this.resultCalc();
    }

    @Override
    public void execute(SimpleFeatureSource source, Query query) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running Geomesa Proximity Search on source type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{source.getClass().getName()})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Filter combinedFilter = package$.MODULE$.mergeFilters(query.getFilter(), this.dwithinFilters("meters"));
        this.resultCalc_$eq(new FeatureResult(source.getFeatures(combinedFilter)));
    }

    private Filter dwithinFilters(String requestedUnit) {
        PropertyName geomProperty = this.org$locationtech$geomesa$process$query$ProximityVisitor$$ff().property(this.dataFeatures.getSchema().getGeometryDescriptor().getName());
        CloseableIterator geomFilters = SelfClosingIterator$.MODULE$.apply(this.inputFeatures.features()).map((Function1)new Serializable(this, requestedUnit, geomProperty){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProximityVisitor $outer;
            private final String requestedUnit$1;
            private final PropertyName geomProperty$1;

            public final DWithin apply(SimpleFeature sf) {
                String string = this.requestedUnit$1;
                double d = "degrees".equals(string) ? Conversions.RichGeometry$.MODULE$.distanceDegrees$extension(Conversions$.MODULE$.RichGeometry(Conversions.RichSimpleFeature$.MODULE$.geometry$extension(Conversions$.MODULE$.RichSimpleFeature(sf))), Predef$.MODULE$.Double2double(this.$outer.org$locationtech$geomesa$process$query$ProximityVisitor$$bufferDistance)) : Predef$.MODULE$.Double2double(this.$outer.org$locationtech$geomesa$process$query$ProximityVisitor$$bufferDistance);
                double dist = d;
                return this.$outer.org$locationtech$geomesa$process$query$ProximityVisitor$$ff().dwithin((Expression)this.geomProperty$1, (Expression)this.$outer.org$locationtech$geomesa$process$query$ProximityVisitor$$ff().literal((Object)Conversions.RichSimpleFeature$.MODULE$.geometry$extension(Conversions$.MODULE$.RichSimpleFeature(sf))), dist, "meters");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.requestedUnit$1 = requestedUnit$1;
                this.geomProperty$1 = geomProperty$1;
            }
        });
        return this.org$locationtech$geomesa$process$query$ProximityVisitor$$ff().or(JavaConversions$.MODULE$.seqAsJavaList(geomFilters.toSeq()));
    }

    public ProximityVisitor(SimpleFeatureCollection inputFeatures, SimpleFeatureCollection dataFeatures, Double bufferDistance) {
        this.inputFeatures = inputFeatures;
        this.dataFeatures = dataFeatures;
        this.org$locationtech$geomesa$process$query$ProximityVisitor$$bufferDistance = bufferDistance;
        GeoMesaProcessVisitor$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        this.geoFac = new GeometryFactory();
        this.org$locationtech$geomesa$process$query$ProximityVisitor$$ff = CommonFactoryFinder.getFilterFactory2();
        this.manualVisitResults = new ListFeatureCollection((SimpleFeatureType)dataFeatures.getSchema());
        this.resultCalc = new FeatureResult((SimpleFeatureCollection)this.manualVisitResults());
    }
}

