/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.transform;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileWriter;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileWriter$;
import org.locationtech.geomesa.arrow.package$;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary$;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.process.GeoMesaProcessVisitor$class;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureOrdering$;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.expression.Expression;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeqLike;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@DescribeProcess(title="Arrow Conversion", description="Converts a feature collection to arrow format")
@ScalaSignature(bytes="\u0006\u0001\r%h\u0001B\u0001\u0003\u00015\u0011a#\u0011:s_^\u001cuN\u001c<feNLwN\u001c)s_\u000e,7o\u001d\u0006\u0003\u0007\u0011\t\u0011\u0002\u001e:b]N4wN]7\u000b\u0005\u00151\u0011a\u00029s_\u000e,7o\u001d\u0006\u0003\u000f!\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\n\u0015\u0005aAn\\2bi&|g\u000e^3dQ*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dYQ\u0002CA\b\u0015\u001b\u0005\u0001\"BA\t\u0013\u0003\u0011a\u0017M\\4\u000b\u0003M\tAA[1wC&\u0011Q\u0003\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005]AR\"\u0001\u0003\n\u0005e!!AD$f_6+7/\u0019)s_\u000e,7o\u001d\t\u00037\tj\u0011\u0001\b\u0006\u0003;y\tAb]2bY\u0006dwnZ4j]\u001eT!a\b\u0011\u0002\u0011QL\b/Z:bM\u0016T\u0011!I\u0001\u0004G>l\u0017BA\u0012\u001d\u0005-a\u0015M_=M_\u001e<\u0017N\\4\t\u000b\u0015\u0002A\u0011\u0001\u0014\u0002\rqJg.\u001b;?)\u00059\u0003C\u0001\u0015\u0001\u001b\u0005\u0011\u0001\"\u0002\u0016\u0001\t\u0003Y\u0013aB3yK\u000e,H/\u001a\u000b\nYm\"vl]=\u0000\u0003\u0017\u00012!\f\u00193\u001b\u0005q#BA\u0018\u0013\u0003\u0011)H/\u001b7\n\u0005Er#\u0001C%uKJ\fGo\u001c:\u0011\u0007M2\u0004(D\u00015\u0015\u0005)\u0014!B:dC2\f\u0017BA\u001c5\u0005\u0015\t%O]1z!\t\u0019\u0014(\u0003\u0002;i\t!!)\u001f;f\u0011\u0015a\u0014\u00061\u0001>\u0003!1W-\u0019;ve\u0016\u001c\bC\u0001 F\u001b\u0005y$B\u0001!B\u0003\u0019\u0019\u0018.\u001c9mK*\u0011!iQ\u0001\u0005I\u0006$\u0018M\u0003\u0002E\u0015\u0005Aq-Z8u_>d7/\u0003\u0002G\u007f\t92+[7qY\u00164U-\u0019;ve\u0016\u001cu\u000e\u001c7fGRLwN\u001c\u0015\u0007w!{\u0005+\u0015*\u0011\u0005%kU\"\u0001&\u000b\u0005-c\u0015a\u00024bGR|'/\u001f\u0006\u0003\u000b\rK!A\u0014&\u0003#\u0011+7o\u0019:jE\u0016\u0004\u0016M]1nKR,'/\u0001\u0003oC6,\u0017%\u0001\u001f\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u0011\u0002'\u0006\u0011\u0013J\u001c9vi\u00022W-\u0019;ve\u0016\u00043m\u001c7mK\u000e$\u0018n\u001c8!i>\u0004SM\\2pI\u0016DQ!V\u0015A\u0002Y\u000b1\"\u001b8dYV$WMR5egB\u0011qbV\u0005\u00031B\u0011qAQ8pY\u0016\fg\u000e\u000b\u0005U\u0011>S\u0016kW/_C\u0005)\u0016%\u0001/\u0002C%s7\r\\;eK\u00022W-\u0019;ve\u0016\u0004\u0013\nR:!S:\u0004\u0013M\u001d:po\u00022\u0017\u000e\\3\u0002\u00075Lg.H\u0001\u0001\u0011\u0015\u0001\u0017\u00061\u0001b\u0003A!\u0017n\u0019;j_:\f'/\u001f$jK2$7\u000fE\u0002.E\u0012L!a\u0019\u0018\u0003\t1K7\u000f\u001e\t\u0003K\"t!a\r4\n\u0005\u001d$\u0014A\u0002)sK\u0012,g-\u0003\u0002jU\n11\u000b\u001e:j]\u001eT!a\u001a\u001b)\u0019}Cu\n\\)n;z{\u0007/\u001d:\"\u0003\u0001\f\u0013A\\\u0001 \u0003R$(/\u001b2vi\u0016\u001c\b\u0005^8!I&\u001cG/[8oCJL\b%\u001a8d_\u0012,\u0017aA7bqv\u0011\u0001\u0001a\u0001\u000fG>dG.Z2uS>tG+\u001f9fG\u0005!\u0007\"\u0002;*\u0001\u00041\u0016!F;tK\u000e\u000b7\r[3e\t&\u001cG/[8oCJLWm\u001d\u0015\tg\"{e/U<^=\u0006\nA/I\u0001y\u0003e+6/\u001a\u0011dC\u000eDW\r\u001a\u0011u_Bl3\u000eI:uCR\u001c\b\u0005K5gA\u00054\u0018-\u001b7bE2,\u0017\u0006\f\u0011pe\u0002\u0012XO\u001c\u0011bA\u0011Lh.Y7jG\u0002\u001aH/\u0019;tAE,XM]=!i>\u0004#-^5mI\u0002\"\u0017n\u0019;j_:\f'/[3t\u0011\u0015Q\u0018\u00061\u0001e\u0003%\u0019xN\u001d;GS\u0016dG\r\u000b\u0005z\u0011>c\u0018+`/_C\u0005Q\u0018%\u0001@\u0002)\u0005#HO]5ckR,\u0007\u0005^8!g>\u0014H\u000f\t2z\u0011\u0019\t\t!\u000ba\u0001-\u0006Y1o\u001c:u%\u00164XM]:fQ)y\bjTA\u0003#\u0006\u001dQLX\u0011\u0003\u0003\u0003\t#!!\u0003\u0002=I+g/\u001a:tK\u0002\"\b.\u001a\u0011eK\u001a\fW\u000f\u001c;!g>\u0014H\u000fI8sI\u0016\u0014\bbBA\u0007S\u0001\u0007\u0011qB\u0001\nE\u0006$8\r[*ju\u0016\u00042aDA\t\u0013\r\t\u0019\u0002\u0005\u0002\b\u0013:$XmZ3sQ-\tY\u0001S(\u0002\u0018E\u000bI\"\u00180\"\u0005\u00055\u0011EAA\u000e\u0003IrU/\u001c2fe\u0002zg\r\t4fCR,(/Z:!i>\u0004\u0013N\\2mk\u0012,\u0007%\u001b8!K\u0006\u001c\u0007\u000e\t:fG>\u0014H\r\t2bi\u000eD\u0007FB\u0015\u0002 E\u000b)\u0003E\u0002J\u0003CI1!a\tK\u00059!Um]2sS\n,'+Z:vYR\f#!a\n\u00025\u0015s7m\u001c3fI\u00022W-\u0019;ve\u0016\u00043m\u001c7mK\u000e$\u0018n\u001c8)\u0015\u0001\tY#!\r\u00024E\u000b9\u0004E\u0002J\u0003[I1!a\fK\u0005=!Um]2sS\n,\u0007K]8dKN\u001c\u0018!\u0002;ji2,\u0017EAA\u001b\u0003A\t%O]8xA\r{gN^3sg&|g.\t\u0002\u0002:\u0005i3i\u001c8wKJ$8\u000fI1!M\u0016\fG/\u001e:fA\r|G\u000e\\3di&|g\u000e\t;pA\u0005\u0014(o\\<!M>\u0014X.\u0019;\b\u000f\u0005u\"\u0001#\u0001\u0002@\u00051\u0012I\u001d:po\u000e{gN^3sg&|g\u000e\u0015:pG\u0016\u001c8\u000fE\u0002)\u0003\u00032a!\u0001\u0002\t\u0002\u0005\r3\u0003BA!\u0003\u000b\u00022aMA$\u0013\r\tI\u0005\u000e\u0002\u0007\u0003:L(+\u001a4\t\u000f\u0015\n\t\u0005\"\u0001\u0002NQ\u0011\u0011q\b\u0004\b\u0003#\n\t\u0005AA*\u00051\t%O]8x-&\u001c\u0018\u000e^8s'\u0019\tyEDA+5A\u0019q#a\u0016\n\u0007\u0005eCAA\u000bHK>lUm]1Qe>\u001cWm]:WSNLGo\u001c:\t\u0017\u0005u\u0013q\nB\u0001B\u0003%\u0011qL\u0001\u0004g\u001a$\b\u0003BA1\u0003[j!!a\u0019\u000b\u0007\u0001\u000b)G\u0003\u0003\u0002h\u0005%\u0014a\u00024fCR,(/\u001a\u0006\u0004\u0003WR\u0011aB8qK:<\u0017n]\u0005\u0005\u0003_\n\u0019GA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016D1\"a\u001d\u0002P\t\u0005\t\u0015!\u0003\u0002v\u0005AQM\\2pI&tw\r\u0005\u0003\u0002x\u0005}e\u0002BA=\u00033sA!a\u001f\u0002\u0014:!\u0011QPAH\u001d\u0011\ty(!$\u000f\t\u0005\u0005\u00151\u0012\b\u0005\u0003\u0007\u000bI)\u0004\u0002\u0002\u0006*\u0019\u0011q\u0011\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011BA\u0005\u000b\u0013\t9\u0001\"C\u0002\u0002\u0012\u001a\tQ!\u0019:s_^LA!!&\u0002\u0018\u00061a/Z2u_JT1!!%\u0007\u0013\u0011\tY*!(\u0002'MKW\u000e\u001d7f\r\u0016\fG/\u001e:f-\u0016\u001cGo\u001c:\u000b\t\u0005U\u0015qS\u0005\u0005\u0003C\u000b\u0019KA\u000bTS6\u0004H.\u001a$fCR,(/Z#oG>$\u0017N\\4\u000b\t\u0005m\u0015Q\u0014\u0005\u000bA\u0006=#\u0011!Q\u0001\n\u0005\u001d\u0006#BAU\u0003g#g\u0002BAV\u0003_sA!a!\u0002.&\tQ'C\u0002\u00022R\nq\u0001]1dW\u0006<W-\u0003\u0003\u00026\u0006]&aA*fc*\u0019\u0011\u0011\u0017\u001b\t\u0017\u0005m\u0016q\nB\u0001B\u0003%\u0011QX\u0001\u0012G\u0006\u001c\u0007.\u001a#jGRLwN\\1sS\u0016\u001c\b#B\u001a\u0002@\u0006\r\u0017bAAai\t1q\n\u001d;j_:\u00042aMAc\u0013\tAF\u0007\u0003\u0006{\u0003\u001f\u0012\t\u0011)A\u0005\u0003\u0013\u0004BaMA`I\"Y\u0011\u0011AA(\u0005\u0003\u0005\u000b\u0011BA_\u0011-\ti!a\u0014\u0003\u0002\u0003\u0006I!a4\u0011\u0007M\n\t.C\u0002\u0002TR\u00121!\u00138u\u0011\u001d)\u0013q\nC\u0001\u0003/$\u0002#!7\u0002^\u0006}\u0017\u0011]Ar\u0003K\f9/!;\u0011\t\u0005m\u0017qJ\u0007\u0003\u0003\u0003B\u0001\"!\u0018\u0002V\u0002\u0007\u0011q\f\u0005\t\u0003g\n)\u000e1\u0001\u0002v!9\u0001-!6A\u0002\u0005\u001d\u0006\u0002CA^\u0003+\u0004\r!!0\t\u000fi\f)\u000e1\u0001\u0002J\"A\u0011\u0011AAk\u0001\u0004\ti\f\u0003\u0005\u0002\u000e\u0005U\u0007\u0019AAh\u0011-\ti/a\u0014\t\u0006\u0004%I!a<\u0002\u001b5\fg.^1m-&\u001c\u0018\u000e^8s+\t\t\t\u0010\u0005\u0003\u0002\\\u0006MhACA{\u0003\u0003\u0002\n1%\u0001\u0002x\n\u0011\u0012I\u001d:po6\u000bg.^1m-&\u001c\u0018\u000e^8s'\u0011\t\u00190!\u0012\t\u0011\u0005m\u00181\u001fD\u0001\u0003{\fQA^5tSR$B!a@\u0003\u0006A\u00191G!\u0001\n\u0007\t\rAG\u0001\u0003V]&$\b\u0002CA4\u0003s\u0004\rAa\u0002\u0011\t\u0005\u0005$\u0011B\u0005\u0005\u0005\u0017\t\u0019GA\u0007TS6\u0004H.\u001a$fCR,(/\u001a\u0005\t\u0005\u001f\t\u0019P\"\u0001\u0003\u0012\u00059!/Z:vYR\u001cXC\u0001B\n!\u0015\tIK!\u00063\u0013\r\t\u0014q\u0017\u0005\f\u00053\ty\u0005#A!B\u0013\t\t0\u0001\bnC:,\u0018\r\u001c,jg&$xN\u001d\u0011\t\u0019\tu\u0011q\na\u0001\u0002\u0004%IA!\u0005\u0002\rI,7/\u001e7u\u00111\u0011\t#a\u0014A\u0002\u0003\u0007I\u0011\u0002B\u0012\u0003)\u0011Xm];mi~#S-\u001d\u000b\u0005\u0003\u007f\u0014)\u0003\u0003\u0006\u0003(\t}\u0011\u0011!a\u0001\u0005'\t1\u0001\u001f\u00132\u0011%\u0011Y#a\u0014!B\u0013\u0011\u0019\"A\u0004sKN,H\u000e\u001e\u0011\t\u0011\t=\u0012q\nC!\u0005c\t\u0011bZ3u%\u0016\u001cX\u000f\u001c;\u0015\u0005\tM\u0002\u0003BAn\u0005k1qAa\u000e\u0002B\u0001\u0013IDA\u0006BeJ|wOU3tk2$8\u0003\u0003B\u001b\u0005w\u0011IEa\u0014\u0011\t\tu\"QI\u0007\u0003\u0005\u007fQAA!\u0011\u0003D\u00059a/[:ji>\u0014(bAA4\u0007&!!q\tB \u0005I\t%m\u001d;sC\u000e$8)\u00197d%\u0016\u001cX\u000f\u001c;\u0011\u0007M\u0012Y%C\u0002\u0003NQ\u0012q\u0001\u0015:pIV\u001cG\u000fE\u00024\u0005#J1Aa\u00155\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011-\u0011yA!\u000e\u0003\u0016\u0004%\tAa\u0016\u0016\u00031B!Ba\u0017\u00036\tE\t\u0015!\u0003-\u0003!\u0011Xm];miN\u0004\u0003bB\u0013\u00036\u0011\u0005!q\f\u000b\u0005\u0005g\u0011\t\u0007C\u0004\u0003\u0010\tu\u0003\u0019\u0001\u0017\t\u0011\t\u0015$Q\u0007C!\u0005O\n\u0001bZ3u-\u0006dW/\u001a\u000b\u0003\u0003\u000bB!Ba\u001b\u00036\u0005\u0005I\u0011\u0001B7\u0003\u0011\u0019w\u000e]=\u0015\t\tM\"q\u000e\u0005\n\u0005\u001f\u0011I\u0007%AA\u00021B!Ba\u001d\u00036E\u0005I\u0011\u0001B;\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa\u001e+\u00071\u0012Ih\u000b\u0002\u0003|A!!Q\u0010BD\u001b\t\u0011yH\u0003\u0003\u0003\u0002\n\r\u0015!C;oG\",7m[3e\u0015\r\u0011)\tN\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002BE\u0005\u007f\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\u0011iI!\u000e\u0002\u0002\u0013\u0005#qR\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\tE\u0005cA\b\u0003\u0014&\u0011\u0011\u000e\u0005\u0005\u000b\u0005/\u0013)$!A\u0005\u0002\te\u0015\u0001\u00049s_\u0012,8\r^!sSRLXCAAh\u0011)\u0011iJ!\u000e\u0002\u0002\u0013\u0005!qT\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011\tKa*\u0011\u0007M\u0012\u0019+C\u0002\u0003&R\u00121!\u00118z\u0011)\u00119Ca'\u0002\u0002\u0003\u0007\u0011q\u001a\u0005\u000b\u0005W\u0013)$!A\u0005B\t5\u0016a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t=\u0006C\u0002BY\u0005o\u0013\t+\u0004\u0002\u00034*\u0019!Q\u0017\u001b\u0002\u0015\r|G\u000e\\3di&|g.C\u00022\u0005gC!Ba/\u00036\u0005\u0005I\u0011\u0001B_\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAb\u0005\u007fC!Ba\n\u0003:\u0006\u0005\t\u0019\u0001BQ\u0011)\u0011\u0019M!\u000e\u0002\u0002\u0013\u0005#QY\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011q\u001a\u0005\u000b\u0005\u0013\u0014)$!A\u0005B\t-\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0002D\n5\u0007B\u0003B\u0014\u0005\u000f\f\t\u00111\u0001\u0003\"\"A\u00111`A(\t\u0003\u0012\t\u000e\u0006\u0003\u0002\u0000\nM\u0007\u0002CA4\u0005\u001f\u0004\rA!6\u0011\t\t]'\u0011\\\u0007\u0003\u0003KJAAa7\u0002f\t9a)Z1ukJ,\u0007b\u0002\u0016\u0002P\u0011\u0005#q\u001c\u000b\u0007\u0003\u007f\u0014\tOa;\t\u0011\t\r(Q\u001ca\u0001\u0005K\faa]8ve\u000e,\u0007c\u0001 \u0003h&\u0019!\u0011^ \u0003'MKW\u000e\u001d7f\r\u0016\fG/\u001e:f'>,(oY3\t\u0011\t5(Q\u001ca\u0001\u0005_\fQ!];fef\u0004BA!=\u0003t6\t\u0011)C\u0002\u0003v\u0006\u0013Q!U;fef4qA!?\u0002B\u0011\u0011YP\u0001\rTS6\u0004H.Z!se><X*\u00198vC24\u0016n]5u_J\u001cbAa>\u0002F\u0005E\bbCA/\u0005o\u0014\t\u0011)A\u0005\u0003?B1\"a\u001d\u0003x\n\u0005\t\u0015!\u0003\u0002v!Y\u0011Q\u0002B|\u0005\u0003\u0005\u000b\u0011BAh\u0011\u001d)#q\u001fC\u0001\u0007\u000b!\u0002ba\u0002\u0004\n\r-1Q\u0002\t\u0005\u00037\u00149\u0010\u0003\u0005\u0002^\r\r\u0001\u0019AA0\u0011!\t\u0019ha\u0001A\u0002\u0005U\u0004\u0002CA\u0007\u0007\u0007\u0001\r!a4\t\u0015\rE!q\u001fb\u0001\n\u0013\u0019\u0019\"A\u0002pkR,\"a!\u0006\u0011\t\r]1QD\u0007\u0003\u00073Q1aa\u0007\u0013\u0003\tIw.\u0003\u0003\u0004 \re!!\u0006\"zi\u0016\f%O]1z\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\n\u0007G\u00119\u0010)A\u0005\u0007+\tAa\\;uA!Q1q\u0005B|\u0005\u0004%Ia!\u000b\u0002\u000b\tLH/Z:\u0016\u0005\r-\u0002#BB\u0017\u0007g\u0011TBAB\u0018\u0015\u0011\u0019\tDa-\u0002\u000f5,H/\u00192mK&!1QGB\u0018\u0005)a\u0015n\u001d;Ck\u001a4WM\u001d\u0005\n\u0007s\u00119\u0010)A\u0005\u0007W\taAY=uKN\u0004\u0003BCB\u001f\u0005o\u0004\r\u0011\"\u0003\u0004@\u0005)1m\\;oiV\u00111\u0011\t\t\u0004g\r\r\u0013bAB#i\t!Aj\u001c8h\u0011)\u0019IEa>A\u0002\u0013%11J\u0001\nG>,h\u000e^0%KF$B!a@\u0004N!Q!qEB$\u0003\u0003\u0005\ra!\u0011\t\u0013\rE#q\u001fQ!\n\r\u0005\u0013AB2pk:$\b\u0005\u0003\u0006\u0004V\t](\u0019!C\u0005\u0007/\naa\u001e:ji\u0016\u0014XCAB-!\u0011\u0019Yfa\u0018\u000e\u0005\ru#\u0002BB\u000e\u0003/KAa!\u0019\u0004^\ta2+[7qY\u00164U-\u0019;ve\u0016\f%O]8x\r&dWm\u0016:ji\u0016\u0014\b\"CB3\u0005o\u0004\u000b\u0011BB-\u0003\u001d9(/\u001b;fe\u0002B\u0001\"a?\u0003x\u0012\u00053\u0011\u000e\u000b\u0005\u0003\u007f\u001cY\u0007\u0003\u0005\u0002h\r\u001d\u0004\u0019\u0001B\u0004\u0011!\u0011yAa>\u0005B\tEaaBB9\u0003\u0003\"11\u000f\u0002\u001a\u0007>l\u0007\u000f\\3y\u0003J\u0014xn^'b]V\fGNV5tSR|'o\u0005\u0004\u0004p\u0005\u0015\u0013\u0011\u001f\u0005\f\u0003;\u001ayG!A!\u0002\u0013\ty\u0006C\u0006\u0002t\r=$\u0011!Q\u0001\n\u0005U\u0004B\u00031\u0004p\t\u0005\t\u0015!\u0003\u0002(\"Y1QPB8\u0005\u0003\u0005\u000b\u0011BB@\u0003\u0011\u0019xN\u001d;\u0011\u000bM\nyl!!\u0011\rM\u001a\u0019\tZAb\u0013\r\u0019)\t\u000e\u0002\u0007)V\u0004H.\u001a\u001a\t\u0017\u000551q\u000eB\u0001B\u0003%\u0011q\u001a\u0005\bK\r=D\u0011ABF)1\u0019iia$\u0004\u0012\u000eM5QSBL!\u0011\tYna\u001c\t\u0011\u0005u3\u0011\u0012a\u0001\u0003?B\u0001\"a\u001d\u0004\n\u0002\u0007\u0011Q\u000f\u0005\bA\u000e%\u0005\u0019AAT\u0011!\u0019ih!#A\u0002\r}\u0004\u0002CA\u0007\u0007\u0013\u0003\r!a4\t\u0013q\u001ayG1A\u0005\n\rmUCABO!\u0019\u0019ica(\u0003\b%!1\u0011UB\u0018\u0005-\t%O]1z\u0005V4g-\u001a:\t\u0013\r\u00156q\u000eQ\u0001\n\ru\u0015!\u00034fCR,(/Z:!\u0011!\tYpa\u001c\u0005B\r%F\u0003BA\u0000\u0007WC\u0001\"a\u001a\u0004(\u0002\u0007!q\u0001\u0005\t\u0005\u001f\u0019y\u0007\"\u0011\u0003\u0012\u001dQ1\u0011WA!\u0003\u0003E\taa-\u0002\u0017\u0005\u0013(o\\<SKN,H\u000e\u001e\t\u0005\u00037\u001c)L\u0002\u0006\u00038\u0005\u0005\u0013\u0011!E\u0001\u0007o\u001bba!.\u0004:\n=\u0003cBB^\u0007\u0003d#1G\u0007\u0003\u0007{S1aa05\u0003\u001d\u0011XO\u001c;j[\u0016LAaa1\u0004>\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\t\u000f\u0015\u001a)\f\"\u0001\u0004HR\u001111\u0017\u0005\u000b\u0007\u0017\u001c),!A\u0005F\r5\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\tE\u0005BCBi\u0007k\u000b\t\u0011\"!\u0004T\u0006)\u0011\r\u001d9msR!!1GBk\u0011\u001d\u0011yaa4A\u00021B!b!7\u00046\u0006\u0005I\u0011QBn\u0003\u001d)h.\u00199qYf$Ba!8\u0004`B!1'a0-\u0011)\u0019\toa6\u0002\u0002\u0003\u0007!1G\u0001\u0004q\u0012\u0002\u0004BCBs\u0007k\u000b\t\u0011\"\u0003\u0004h\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005q\u0001")
public class ArrowConversionProcess
implements GeoMesaProcess,
LazyLogging {
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        ArrowConversionProcess arrowConversionProcess = this;
        synchronized (arrowConversionProcess) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @DescribeResult(description="Encoded feature collection")
    public java.util.Iterator<byte[]> execute(@DescribeParameter(name="features", description="Input feature collection to encode") SimpleFeatureCollection features, @DescribeParameter(name="includeFids", description="Include feature IDs in arrow file", min=0) Boolean includeFids, @DescribeParameter(name="dictionaryFields", description="Attributes to dictionary encode", min=0, max=128, collectionType=String.class) java.util.List<String> dictionaryFields, @DescribeParameter(name="useCachedDictionaries", description="Use cached top-k stats (if available), or run a dynamic stats query to build dictionaries", min=0) Boolean useCachedDictionaries, @DescribeParameter(name="sortField", description="Attribute to sort by", min=0) String sortField, @DescribeParameter(name="sortReverse", description="Reverse the default sort order", min=0) Boolean sortReverse, @DescribeParameter(name="batchSize", description="Number of features to include in each record batch", min=0) Integer batchSize) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running arrow encoding for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{features.getClass().getName()})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        SimpleFeatureType sft = (SimpleFeatureType)features.getSchema();
        Seq toEncode = (Seq)Option$.MODULE$.apply(dictionaryFields).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(java.util.List<String> x$1) {
                return JavaConversions$.MODULE$.asScalaBuffer(x$1).toSeq();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
        toEncode.foreach((Function1)new Serializable(this, sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final void apply(String attribute) {
                if (this.sft$1.indexOf(attribute) == -1) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attribute ", " doesn't exist in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attribute, this.sft$1})));
                }
            }
            {
                this.sft$1 = sft$1;
            }
        });
        Option cacheDictionaries = Option$.MODULE$.apply((Object)useCachedDictionaries).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Boolean x$2) {
                return x$2;
            }
        });
        SimpleFeatureVector.SimpleFeatureEncoding encoding = SimpleFeatureVector.SimpleFeatureEncoding$.MODULE$.min(Option$.MODULE$.apply((Object)includeFids).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Boolean x$3) {
                return x$3;
            }
        }));
        Option reverse = Option$.MODULE$.apply((Object)sortReverse).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Boolean x$4) {
                return x$4;
            }
        });
        int batch = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)batchSize).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Integer x$5) {
                return x$5;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 100000;
            }
        }));
        ArrowVisitor visitor = new ArrowVisitor(sft, encoding, (Seq<String>)toEncode, (Option<Object>)cacheDictionaries, (Option<String>)Option$.MODULE$.apply((Object)sortField), (Option<Object>)reverse, batch);
        features.accepts((FeatureVisitor)visitor, null);
        return visitor.getResult().results();
    }

    public ArrowConversionProcess() {
        LazyLogging.class.$init$((LazyLogging)this);
    }

    public static class ArrowResult
    extends AbstractCalcResult
    implements Product,
    Serializable {
        private final java.util.Iterator<byte[]> results;

        public java.util.Iterator<byte[]> results() {
            return this.results;
        }

        public Object getValue() {
            return this.results();
        }

        public ArrowResult copy(java.util.Iterator<byte[]> results) {
            return new ArrowResult(results);
        }

        public java.util.Iterator<byte[]> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "ArrowResult";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 0: 
            }
            return this.results();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ArrowResult;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ArrowResult)) return false;
            boolean bl = true;
            if (!bl) return false;
            ArrowResult arrowResult = (ArrowResult)((Object)x$1);
            java.util.Iterator<byte[]> iterator = this.results();
            java.util.Iterator<byte[]> iterator2 = arrowResult.results();
            if (iterator == null) {
                if (iterator2 != null) {
                    return false;
                }
            } else if (!iterator.equals(iterator2)) return false;
            if (!arrowResult.canEqual((Object)this)) return false;
            return true;
        }

        public ArrowResult(java.util.Iterator<byte[]> results) {
            this.results = results;
            Product.class.$init$((Product)this);
        }
    }

    public static class ArrowVisitor
    implements GeoMesaProcessVisitor,
    LazyLogging {
        private final SimpleFeatureType sft;
        private final SimpleFeatureVector.SimpleFeatureEncoding encoding;
        private final Seq<String> dictionaryFields;
        private final Option<Object> cacheDictionaries;
        private final Option<String> sortField;
        public final Option<Object> org$locationtech$geomesa$process$transform$ArrowConversionProcess$ArrowVisitor$$sortReverse;
        private final int batchSize;
        private ArrowManualVisitor manualVisitor;
        private Iterator<byte[]> result;
        private final Logger logger;
        private volatile byte bitmap$0;

        private ArrowManualVisitor manualVisitor$lzycompute() {
            ArrowVisitor arrowVisitor = this;
            synchronized (arrowVisitor) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    ArrowManualVisitor arrowManualVisitor;
                    if (this.dictionaryFields.isEmpty() && this.sortField.isEmpty()) {
                        arrowManualVisitor = new SimpleArrowManualVisitor(this.sft, this.encoding, this.batchSize);
                    } else {
                        Option sort = this.sortField.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ArrowVisitor $outer;

                            public final Tuple2<String, Object> apply(String s) {
                                return new Tuple2((Object)s, this.$outer.org$locationtech$geomesa$process$transform$ArrowConversionProcess$ArrowVisitor$$sortReverse.getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply() {
                                        return this.apply$mcZ$sp();
                                    }

                                    public boolean apply$mcZ$sp() {
                                        return false;
                                    }
                                }));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        arrowManualVisitor = new ComplexArrowManualVisitor(this.sft, this.encoding, this.dictionaryFields, (Option<Tuple2<String, Object>>)sort, this.batchSize);
                    }
                    this.manualVisitor = arrowManualVisitor;
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
                return this.manualVisitor;
            }
        }

        private Logger logger$lzycompute() {
            ArrowVisitor arrowVisitor = this;
            synchronized (arrowVisitor) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.logger = LazyLogging.class.logger((LazyLogging)this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
                return this.logger;
            }
        }

        public Logger logger() {
            return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
        }

        @Override
        public java.util.List<Expression> getExpressions() {
            return GeoMesaProcessVisitor$class.getExpressions(this);
        }

        private ArrowManualVisitor manualVisitor() {
            return (byte)(this.bitmap$0 & 1) == 0 ? this.manualVisitor$lzycompute() : this.manualVisitor;
        }

        private Iterator<byte[]> result() {
            return this.result;
        }

        private void result_$eq(Iterator<byte[]> x$1) {
            this.result = x$1;
        }

        public ArrowResult getResult() {
            return this.result() == null ? new ArrowResult(JavaConversions$.MODULE$.asJavaIterator(this.manualVisitor().results())) : new ArrowResult(JavaConversions$.MODULE$.asJavaIterator(this.result()));
        }

        public void visit(Feature feature) {
            this.manualVisitor().visit((SimpleFeature)feature);
        }

        @Override
        public void execute(SimpleFeatureSource source, Query query) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Visiting source type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{source.getClass().getName()})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_ENCODE(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_DICTIONARY_FIELDS(), (Object)this.dictionaryFields.mkString(","));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_INCLUDE_FID(), (Object)BoxesRunTime.boxToBoolean((boolean)this.encoding.fids()));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_BATCH_SIZE(), (Object)BoxesRunTime.boxToInteger((int)this.batchSize));
            this.cacheDictionaries.foreach((Function1)new Serializable(this, query){
                public static final long serialVersionUID = 0L;
                private final Query query$1;

                public final Object apply(boolean x$6) {
                    return this.query$1.getHints().put((Object)QueryHints$.MODULE$.ARROW_DICTIONARY_CACHED(), (Object)BoxesRunTime.boxToBoolean((boolean)x$6));
                }
                {
                    this.query$1 = query$1;
                }
            });
            this.sortField.foreach((Function1)new Serializable(this, query){
                public static final long serialVersionUID = 0L;
                private final Query query$1;

                public final Object apply(String x$7) {
                    return this.query$1.getHints().put((Object)QueryHints$.MODULE$.ARROW_SORT_FIELD(), (Object)x$7);
                }
                {
                    this.query$1 = query$1;
                }
            });
            this.org$locationtech$geomesa$process$transform$ArrowConversionProcess$ArrowVisitor$$sortReverse.foreach((Function1)new Serializable(this, query){
                public static final long serialVersionUID = 0L;
                private final Query query$1;

                public final Object apply(boolean x$8) {
                    return this.query$1.getHints().put((Object)QueryHints$.MODULE$.ARROW_SORT_REVERSE(), (Object)BoxesRunTime.boxToBoolean((boolean)x$8));
                }
                {
                    this.query$1 = query$1;
                }
            });
            SelfClosingIterator features = SelfClosingIterator$.MODULE$.apply(source.getFeatures(query));
            this.result_$eq((Iterator<byte[]>)features.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte[] apply(SimpleFeature x$9) {
                    return (byte[])x$9.getAttribute(0);
                }
            }));
        }

        public ArrowVisitor(SimpleFeatureType sft, SimpleFeatureVector.SimpleFeatureEncoding encoding, Seq<String> dictionaryFields, Option<Object> cacheDictionaries, Option<String> sortField, Option<Object> sortReverse, int batchSize) {
            this.sft = sft;
            this.encoding = encoding;
            this.dictionaryFields = dictionaryFields;
            this.cacheDictionaries = cacheDictionaries;
            this.sortField = sortField;
            this.org$locationtech$geomesa$process$transform$ArrowConversionProcess$ArrowVisitor$$sortReverse = sortReverse;
            this.batchSize = batchSize;
            GeoMesaProcessVisitor$class.$init$(this);
            LazyLogging.class.$init$((LazyLogging)this);
        }
    }

    public static interface ArrowManualVisitor {
        public void visit(SimpleFeature var1);

        public Iterator<byte[]> results();
    }

    public static class SimpleArrowManualVisitor
    implements ArrowManualVisitor {
        private final int batchSize;
        private final ByteArrayOutputStream out;
        private final ListBuffer<byte[]> bytes;
        private long count;
        private final SimpleFeatureArrowFileWriter writer;

        private ByteArrayOutputStream out() {
            return this.out;
        }

        private ListBuffer<byte[]> bytes() {
            return this.bytes;
        }

        private long count() {
            return this.count;
        }

        private void count_$eq(long x$1) {
            this.count = x$1;
        }

        private SimpleFeatureArrowFileWriter writer() {
            return this.writer;
        }

        @Override
        public void visit(SimpleFeature feature) {
            this.writer().add(feature);
            this.count_$eq(this.count() + 1L);
            if (this.count() % (long)this.batchSize == 0L) {
                this.writer().flush();
                this.bytes().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.out().toByteArray()}));
                this.out().reset();
            }
        }

        @Override
        public Iterator<byte[]> results() {
            this.writer().close();
            this.bytes().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.out().toByteArray()}));
            return this.bytes().iterator();
        }

        public SimpleArrowManualVisitor(SimpleFeatureType sft, SimpleFeatureVector.SimpleFeatureEncoding encoding, int batchSize) {
            this.batchSize = batchSize;
            this.out = new ByteArrayOutputStream();
            this.bytes = (ListBuffer)ListBuffer$.MODULE$.empty();
            this.count = 0L;
            this.writer = new SimpleFeatureArrowFileWriter(sft, (OutputStream)this.out(), Predef$.MODULE$.Map().empty(), encoding, SimpleFeatureArrowFileWriter$.MODULE$.$lessinit$greater$default$5(), package$.MODULE$.allocator());
        }
    }

    public static class ComplexArrowManualVisitor
    implements ArrowManualVisitor {
        public final SimpleFeatureType org$locationtech$geomesa$process$transform$ArrowConversionProcess$ComplexArrowManualVisitor$$sft;
        private final SimpleFeatureVector.SimpleFeatureEncoding encoding;
        private final Seq<String> dictionaryFields;
        private final Option<Tuple2<String, Object>> sort;
        public final int org$locationtech$geomesa$process$transform$ArrowConversionProcess$ComplexArrowManualVisitor$$batchSize;
        private final ArrayBuffer<SimpleFeature> features;

        private ArrayBuffer<SimpleFeature> features() {
            return this.features;
        }

        @Override
        public void visit(SimpleFeature feature) {
            this.features().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleFeature[]{ScalaSimpleFeature$.MODULE$.copy(feature)}));
        }

        @Override
        public Iterator<byte[]> results() {
            Option option;
            block7: {
                Iterator iterator;
                Map dictionaries;
                block6: {
                    block5: {
                        Option ordering;
                        Map map;
                        if (this.dictionaryFields.isEmpty()) {
                            map = Predef$.MODULE$.Map().empty();
                        } else {
                            Seq indicesAndValues = (Seq)this.dictionaryFields.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ ComplexArrowManualVisitor $outer;

                                public final Tuple3<String, Object, HashSet<Object>> apply(String field) {
                                    return new Tuple3((Object)field, (Object)BoxesRunTime.boxToInteger((int)this.$outer.org$locationtech$geomesa$process$transform$ArrowConversionProcess$ComplexArrowManualVisitor$$sft.indexOf(field)), (Object)HashSet$.MODULE$.empty());
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                            this.features().foreach((Function1)new Serializable(this, indicesAndValues){
                                public static final long serialVersionUID = 0L;
                                private final Seq indicesAndValues$1;

                                public final void apply(SimpleFeature f) {
                                    this.indicesAndValues$1.foreach((Function1)new Serializable(this, f){
                                        public static final long serialVersionUID = 0L;
                                        private final SimpleFeature f$1;

                                        public final boolean apply(Tuple3<String, Object, HashSet<Object>> x0$1) {
                                            Tuple3<String, Object, HashSet<Object>> tuple3 = x0$1;
                                            if (tuple3 != null) {
                                                int i = BoxesRunTime.unboxToInt((Object)tuple3._2());
                                                HashSet v = (HashSet)tuple3._3();
                                                boolean bl = v.add(this.f$1.getAttribute(i));
                                                return bl;
                                            }
                                            throw new MatchError(tuple3);
                                        }
                                        {
                                            this.f$1 = f$1;
                                        }
                                    });
                                }
                                {
                                    this.indicesAndValues$1 = indicesAndValues$1;
                                }
                            });
                            map = ((TraversableOnce)indicesAndValues.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Tuple2<String, ArrowDictionary> apply(Tuple3<String, Object, HashSet<Object>> x0$2) {
                                    Tuple3<String, Object, HashSet<Object>> tuple3 = x0$2;
                                    if (tuple3 != null) {
                                        String n = (String)tuple3._1();
                                        HashSet v = (HashSet)tuple3._3();
                                        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)n), (Object)ArrowDictionary$.MODULE$.create(v.toSeq()));
                                        return tuple2;
                                    }
                                    throw new MatchError(tuple3);
                                }
                            }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                        }
                        dictionaries = map;
                        option = ordering = this.sort.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ComplexArrowManualVisitor $outer;

                            public final Ordering<SimpleFeature> apply(Tuple2<String, Object> x0$3) {
                                Tuple2<String, Object> tuple2 = x0$3;
                                if (tuple2 != null) {
                                    String field = (String)tuple2._1();
                                    boolean reverse = tuple2._2$mcZ$sp();
                                    Ordering o = SimpleFeatureOrdering$.MODULE$.apply(this.$outer.org$locationtech$geomesa$process$transform$ArrowConversionProcess$ComplexArrowManualVisitor$$sft.indexOf(field));
                                    Ordering ordering = reverse ? o.reverse() : o;
                                    return ordering;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        if (!None$.MODULE$.equals(option)) break block5;
                        iterator = this.features().iterator();
                        break block6;
                    }
                    if (!(option instanceof Some)) break block7;
                    Some some = (Some)option;
                    Ordering o = (Ordering)some.x();
                    iterator = ((IndexedSeqLike)this.features().sorted(o)).iterator();
                }
                Iterator sorted = iterator;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                SimpleFeatureArrowFileWriter writer = new SimpleFeatureArrowFileWriter(this.org$locationtech$geomesa$process$transform$ArrowConversionProcess$ComplexArrowManualVisitor$$sft, (OutputStream)out, dictionaries, this.encoding, this.sort, package$.MODULE$.allocator());
                return new Iterator<byte[]>(this, sorted, out, writer){
                    private final /* synthetic */ ComplexArrowManualVisitor $outer;
                    private final Iterator sorted$1;
                    private final ByteArrayOutputStream out$1;
                    private final SimpleFeatureArrowFileWriter writer$1;

                    public Iterator<byte[]> seq() {
                        return Iterator.class.seq((Iterator)this);
                    }

                    public boolean isEmpty() {
                        return Iterator.class.isEmpty((Iterator)this);
                    }

                    public boolean isTraversableAgain() {
                        return Iterator.class.isTraversableAgain((Iterator)this);
                    }

                    public boolean hasDefiniteSize() {
                        return Iterator.class.hasDefiniteSize((Iterator)this);
                    }

                    public Iterator<byte[]> take(int n) {
                        return Iterator.class.take((Iterator)this, (int)n);
                    }

                    public Iterator<byte[]> drop(int n) {
                        return Iterator.class.drop((Iterator)this, (int)n);
                    }

                    public Iterator<byte[]> slice(int from, int until) {
                        return Iterator.class.slice((Iterator)this, (int)from, (int)until);
                    }

                    public <B> Iterator<B> map(Function1<byte[], B> f) {
                        return Iterator.class.map((Iterator)this, f);
                    }

                    public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                        return Iterator.class.$plus$plus((Iterator)this, that);
                    }

                    public <B> Iterator<B> flatMap(Function1<byte[], GenTraversableOnce<B>> f) {
                        return Iterator.class.flatMap((Iterator)this, f);
                    }

                    public Iterator<byte[]> filter(Function1<byte[], Object> p) {
                        return Iterator.class.filter((Iterator)this, p);
                    }

                    public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<byte[], B, Object> p) {
                        return Iterator.class.corresponds((Iterator)this, that, p);
                    }

                    public Iterator<byte[]> withFilter(Function1<byte[], Object> p) {
                        return Iterator.class.withFilter((Iterator)this, p);
                    }

                    public Iterator<byte[]> filterNot(Function1<byte[], Object> p) {
                        return Iterator.class.filterNot((Iterator)this, p);
                    }

                    public <B> Iterator<B> collect(PartialFunction<byte[], B> pf) {
                        return Iterator.class.collect((Iterator)this, pf);
                    }

                    public <B> Iterator<B> scanLeft(B z, Function2<B, byte[], B> op) {
                        return Iterator.class.scanLeft((Iterator)this, z, op);
                    }

                    public <B> Iterator<B> scanRight(B z, Function2<byte[], B, B> op) {
                        return Iterator.class.scanRight((Iterator)this, z, op);
                    }

                    public Iterator<byte[]> takeWhile(Function1<byte[], Object> p) {
                        return Iterator.class.takeWhile((Iterator)this, p);
                    }

                    public Tuple2<Iterator<byte[]>, Iterator<byte[]>> partition(Function1<byte[], Object> p) {
                        return Iterator.class.partition((Iterator)this, p);
                    }

                    public Tuple2<Iterator<byte[]>, Iterator<byte[]>> span(Function1<byte[], Object> p) {
                        return Iterator.class.span((Iterator)this, p);
                    }

                    public Iterator<byte[]> dropWhile(Function1<byte[], Object> p) {
                        return Iterator.class.dropWhile((Iterator)this, p);
                    }

                    public <B> Iterator<Tuple2<byte[], B>> zip(Iterator<B> that) {
                        return Iterator.class.zip((Iterator)this, that);
                    }

                    public <A1> Iterator<A1> padTo(int len, A1 elem) {
                        return Iterator.class.padTo((Iterator)this, (int)len, elem);
                    }

                    public Iterator<Tuple2<byte[], Object>> zipWithIndex() {
                        return Iterator.class.zipWithIndex((Iterator)this);
                    }

                    public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                        return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
                    }

                    public <U> void foreach(Function1<byte[], U> f) {
                        Iterator.class.foreach((Iterator)this, f);
                    }

                    public boolean forall(Function1<byte[], Object> p) {
                        return Iterator.class.forall((Iterator)this, p);
                    }

                    public boolean exists(Function1<byte[], Object> p) {
                        return Iterator.class.exists((Iterator)this, p);
                    }

                    public boolean contains(Object elem) {
                        return Iterator.class.contains((Iterator)this, (Object)elem);
                    }

                    public Option<byte[]> find(Function1<byte[], Object> p) {
                        return Iterator.class.find((Iterator)this, p);
                    }

                    public int indexWhere(Function1<byte[], Object> p) {
                        return Iterator.class.indexWhere((Iterator)this, p);
                    }

                    public <B> int indexOf(B elem) {
                        return Iterator.class.indexOf((Iterator)this, elem);
                    }

                    public BufferedIterator<byte[]> buffered() {
                        return Iterator.class.buffered((Iterator)this);
                    }

                    public <B> Iterator.GroupedIterator<B> grouped(int size) {
                        return Iterator.class.grouped((Iterator)this, (int)size);
                    }

                    public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                        return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
                    }

                    public int length() {
                        return Iterator.class.length((Iterator)this);
                    }

                    public Tuple2<Iterator<byte[]>, Iterator<byte[]>> duplicate() {
                        return Iterator.class.duplicate((Iterator)this);
                    }

                    public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                        return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
                    }

                    public <B> void copyToArray(Object xs, int start, int len) {
                        Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
                    }

                    public boolean sameElements(Iterator<?> that) {
                        return Iterator.class.sameElements((Iterator)this, that);
                    }

                    public Traversable<byte[]> toTraversable() {
                        return Iterator.class.toTraversable((Iterator)this);
                    }

                    public Iterator<byte[]> toIterator() {
                        return Iterator.class.toIterator((Iterator)this);
                    }

                    public Stream<byte[]> toStream() {
                        return Iterator.class.toStream((Iterator)this);
                    }

                    public String toString() {
                        return Iterator.class.toString((Iterator)this);
                    }

                    public <B> int sliding$default$2() {
                        return Iterator.class.sliding$default$2((Iterator)this);
                    }

                    public List<byte[]> reversed() {
                        return TraversableOnce.class.reversed((TraversableOnce)this);
                    }

                    public int size() {
                        return TraversableOnce.class.size((TraversableOnce)this);
                    }

                    public boolean nonEmpty() {
                        return TraversableOnce.class.nonEmpty((TraversableOnce)this);
                    }

                    public int count(Function1<byte[], Object> p) {
                        return TraversableOnce.class.count((TraversableOnce)this, p);
                    }

                    public <B> Option<B> collectFirst(PartialFunction<byte[], B> pf) {
                        return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
                    }

                    public <B> B $div$colon(B z, Function2<B, byte[], B> op) {
                        return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
                    }

                    public <B> B $colon$bslash(B z, Function2<byte[], B, B> op) {
                        return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
                    }

                    public <B> B foldLeft(B z, Function2<B, byte[], B> op) {
                        return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
                    }

                    public <B> B foldRight(B z, Function2<byte[], B, B> op) {
                        return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
                    }

                    public <B> B reduceLeft(Function2<B, byte[], B> op) {
                        return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
                    }

                    public <B> B reduceRight(Function2<byte[], B, B> op) {
                        return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceLeftOption(Function2<B, byte[], B> op) {
                        return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceRightOption(Function2<byte[], B, B> op) {
                        return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
                    }

                    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
                    }

                    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                        return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
                    }

                    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
                    }

                    public <B> B aggregate(Function0<B> z, Function2<B, byte[], B> seqop, Function2<B, B, B> combop) {
                        return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
                    }

                    public <B> B sum(Numeric<B> num) {
                        return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
                    }

                    public <B> B product(Numeric<B> num) {
                        return (B)TraversableOnce.class.product((TraversableOnce)this, num);
                    }

                    public Object min(Ordering cmp) {
                        return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object max(Ordering cmp) {
                        return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object maxBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public Object minBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public <B> void copyToBuffer(Buffer<B> dest) {
                        TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
                    }

                    public <B> void copyToArray(Object xs, int start) {
                        TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
                    }

                    public <B> void copyToArray(Object xs) {
                        TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
                    }

                    public <B> Object toArray(ClassTag<B> evidence$1) {
                        return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
                    }

                    public List<byte[]> toList() {
                        return TraversableOnce.class.toList((TraversableOnce)this);
                    }

                    public Iterable<byte[]> toIterable() {
                        return TraversableOnce.class.toIterable((TraversableOnce)this);
                    }

                    public Seq<byte[]> toSeq() {
                        return TraversableOnce.class.toSeq((TraversableOnce)this);
                    }

                    public IndexedSeq<byte[]> toIndexedSeq() {
                        return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
                    }

                    public <B> Buffer<B> toBuffer() {
                        return TraversableOnce.class.toBuffer((TraversableOnce)this);
                    }

                    public <B> Set<B> toSet() {
                        return TraversableOnce.class.toSet((TraversableOnce)this);
                    }

                    public Vector<byte[]> toVector() {
                        return TraversableOnce.class.toVector((TraversableOnce)this);
                    }

                    public <Col> Col to(CanBuildFrom<Nothing$, byte[], Col> cbf) {
                        return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
                    }

                    public <T, U> Map<T, U> toMap(Predef.$less$colon$less<byte[], Tuple2<T, U>> ev) {
                        return TraversableOnce.class.toMap((TraversableOnce)this, ev);
                    }

                    public String mkString(String start, String sep, String end) {
                        return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
                    }

                    public String mkString(String sep) {
                        return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
                    }

                    public String mkString() {
                        return TraversableOnce.class.mkString((TraversableOnce)this);
                    }

                    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                    }

                    public StringBuilder addString(StringBuilder b, String sep) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
                    }

                    public StringBuilder addString(StringBuilder b) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
                    }

                    public boolean hasNext() {
                        return this.sorted$1.hasNext();
                    }

                    public byte[] next() {
                        this.out$1.reset();
                        for (int i = 0; i < this.$outer.org$locationtech$geomesa$process$transform$ArrowConversionProcess$ComplexArrowManualVisitor$$batchSize && this.sorted$1.hasNext(); ++i) {
                            this.writer$1.add((SimpleFeature)this.sorted$1.next());
                        }
                        if (this.sorted$1.hasNext()) {
                            this.writer$1.flush();
                        } else {
                            this.writer$1.close();
                        }
                        return this.out$1.toByteArray();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.sorted$1 = sorted$1;
                        this.out$1 = out$1;
                        this.writer$1 = writer$1;
                        TraversableOnce.class.$init$((TraversableOnce)this);
                        Iterator.class.$init$((Iterator)this);
                    }
                };
            }
            throw new MatchError((Object)option);
        }

        public ComplexArrowManualVisitor(SimpleFeatureType sft, SimpleFeatureVector.SimpleFeatureEncoding encoding, Seq<String> dictionaryFields, Option<Tuple2<String, Object>> sort, int batchSize) {
            this.org$locationtech$geomesa$process$transform$ArrowConversionProcess$ComplexArrowManualVisitor$$sft = sft;
            this.encoding = encoding;
            this.dictionaryFields = dictionaryFields;
            this.sort = sort;
            this.org$locationtech$geomesa$process$transform$ArrowConversionProcess$ComplexArrowManualVisitor$$batchSize = batchSize;
            this.features = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        }
    }
}

