/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert.xml;

import com.typesafe.config.Config;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.locationtech.geomesa.convert.AbstractSimpleFeatureConverterFactory;
import org.locationtech.geomesa.convert.ConvertParseOpts;
import org.locationtech.geomesa.convert.EnrichmentCache;
import org.locationtech.geomesa.convert.Field;
import org.locationtech.geomesa.convert.LineMode$;
import org.locationtech.geomesa.convert.SimpleField;
import org.locationtech.geomesa.convert.Transformers;
import org.locationtech.geomesa.convert.Transformers$;
import org.locationtech.geomesa.convert.xml.XMLConverter;
import org.locationtech.geomesa.convert.xml.XMLField;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001B\u0001\u0003\u00015\u00111\u0003W'M\u0007>tg/\u001a:uKJ4\u0015m\u0019;pefT!a\u0001\u0003\u0002\u0007alGN\u0003\u0002\u0006\r\u000591m\u001c8wKJ$(BA\u0004\t\u0003\u001d9Wm\\7fg\u0006T!!\u0003\u0006\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u001d!\ry\u0001CE\u0007\u0002\t%\u0011\u0011\u0003\u0002\u0002&\u0003\n\u001cHO]1diNKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0007>tg/\u001a:uKJ4\u0015m\u0019;pef\u0004\"aE\r\u000f\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0002\rA\u0013X\rZ3g\u0013\tQ2D\u0001\u0004TiJLgn\u001a\u0006\u00031U\u0001\"!\b\u0013\u000e\u0003yQ!a\b\u0011\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005\u0005\u0012\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\r\n1aY8n\u0013\t)cDA\u0006MCjLHj\\4hS:<\u0007\"B\u0014\u0001\t\u0003A\u0013A\u0002\u001fj]&$h\bF\u0001*!\tQ\u0003!D\u0001\u0003\u0011\u001da\u0003A1A\u0005\n5\na\u0001\u001f9bi\"\u001cX#\u0001\u0018\u0011\u0007=\"d'D\u00011\u0015\t\t$'\u0001\u0003mC:<'\"A\u001a\u0002\t)\fg/Y\u0005\u0003kA\u00121\u0002\u00165sK\u0006$Gj\\2bYB\u0011q'P\u0007\u0002q)\u0011\u0011HO\u0001\u0006qB\fG\u000f\u001b\u0006\u0003\u0007mR\u0011\u0001P\u0001\u0006U\u00064\u0018\r_\u0005\u0003}a\u0012Q\u0001\u0017)bi\"Da\u0001\u0011\u0001!\u0002\u0013q\u0013a\u0002=qCRD7\u000f\t\u0005\b\u0005\u0002\u0011\r\u0011\"\u0015D\u00035!\u0018\u0010]3U_B\u0013xnY3tgV\tA\t\u0005\u00020\u000b&\u0011!\u0004\r\u0005\u0007\u000f\u0002\u0001\u000b\u0011\u0002#\u0002\u001dQL\b/\u001a+p!J|7-Z:tA!)\u0011\n\u0001C!\u0015\u0006q!-^5mI\u000e{gN^3si\u0016\u0014HcA&O5B\u0011!\u0006T\u0005\u0003\u001b\n\u0011A\u0002W'M\u0007>tg/\u001a:uKJDQa\u0014%A\u0002A\u000b1a\u001d4u!\t\t\u0006,D\u0001S\u0015\t\u0019F+\u0001\u0004tS6\u0004H.\u001a\u0006\u0003+Z\u000bqAZ3biV\u0014XM\u0003\u0002X\u0015\u00059q\u000e]3oO&\u001c\u0018BA-S\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/\u001a\u0005\u00067\"\u0003\r\u0001X\u0001\u0005G>tg\r\u0005\u0002^A6\taL\u0003\u0002`A\u000511m\u001c8gS\u001eL!!\u00190\u0003\r\r{gNZ5h\u0011\u0015I\u0005\u0001\"\u0015d)-YE-\u001a4{\u0003\u001f\tI\"!\n\t\u000b=\u0013\u0007\u0019\u0001)\t\u000bm\u0013\u0007\u0019\u0001/\t\u000b\u001d\u0014\u0007\u0019\u00015\u0002\u0013%$')^5mI\u0016\u0014\bCA5x\u001d\tQWO\u0004\u0002li:\u0011An\u001d\b\u0003[Jt!A\\9\u000e\u0003=T!\u0001\u001d\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u0011a\u000fB\u0001\r)J\fgn\u001d4pe6,'o]\u0005\u0003qf\u0014A!\u0012=qe*\u0011a\u000f\u0002\u0005\u0006w\n\u0004\r\u0001`\u0001\u0007M&,G\u000eZ:\u0011\u000bu\f)!!\u0003\u000e\u0003yT1a`A\u0001\u0003%IW.\\;uC\ndWMC\u0002\u0002\u0004U\t!bY8mY\u0016\u001cG/[8o\u0013\r\t9A \u0002\u000b\u0013:$W\r_3e'\u0016\f\bcA\b\u0002\f%\u0019\u0011Q\u0002\u0003\u0003\u000b\u0019KW\r\u001c3\t\u000f\u0005E!\r1\u0001\u0002\u0014\u0005yQo]3s\t\u0006$\u0018MQ;jY\u0012,'\u000fE\u0003\u0014\u0003+\u0011\u0002.C\u0002\u0002\u0018m\u00111!T1q\u0011\u001d\tYB\u0019a\u0001\u0003;\tQbY1dQ\u0016\u001cVM\u001d<jG\u0016\u001c\bCB\n\u0002\u0016I\ty\u0002E\u0002\u0010\u0003CI1!a\t\u0005\u0005=)eN]5dQ6,g\u000e^\"bG\",\u0007bBA\u0014E\u0002\u0007\u0011\u0011F\u0001\na\u0006\u00148/Z(qiN\u00042aDA\u0016\u0013\r\ti\u0003\u0002\u0002\u0011\u0007>tg/\u001a:u!\u0006\u00148/Z(qiNDq!!\r\u0001\t#\n\u0019$\u0001\u0006ck&dGMR5fY\u0012$B!!\u0003\u00026!9\u0011qGA\u0018\u0001\u0004a\u0016!\u00024jK2$\u0007bBA\u001e\u0001\u0011%\u0011QH\u0001\tO\u0016$\b\fU1uQR\u0019a'a\u0010\t\rm\u000bI\u00041\u0001]\u0001")
public class XMLConverterFactory
extends AbstractSimpleFeatureConverterFactory<String> {
    private final ThreadLocal<XPath> xpaths = new ThreadLocal();
    private final String typeToProcess;

    private ThreadLocal<XPath> xpaths() {
        return this.xpaths;
    }

    public String typeToProcess() {
        return this.typeToProcess;
    }

    public XMLConverter buildConverter(SimpleFeatureType sft, Config conf) {
        this.xpaths().set(this.getXPath(conf));
        try {
            return (XMLConverter)super.buildConverter(sft, conf);
        }
        finally {
            this.xpaths().remove();
        }
    }

    public XMLConverter buildConverter(SimpleFeatureType sft, Config conf, Transformers.Expr idBuilder, IndexedSeq<Field> fields, Map<String, Transformers.Expr> userDataBuilder, Map<String, EnrichmentCache> cacheServices, ConvertParseOpts parseOpts) {
        None$ featurePath = conf.hasPath("feature-path") ? new Some((Object)this.xpaths().get().compile(conf.getString("feature-path"))) : None$.MODULE$;
        None$ xsd = conf.hasPath("xsd") ? new Some((Object)conf.getString("xsd")) : None$.MODULE$;
        Enumeration.Value lineMode = LineMode$.MODULE$.getLineMode(conf);
        return new XMLConverter(sft, idBuilder, (Option<XPathExpression>)featurePath, (Option<String>)xsd, fields, userDataBuilder, cacheServices, parseOpts, lineMode);
    }

    public Field buildField(Config field) {
        String name = field.getString("name");
        Transformers.Expr transform = field.hasPath("transform") ? Transformers$.MODULE$.parseTransform(field.getString("transform")) : null;
        return field.hasPath("path") ? new XMLField(name, this.xpaths().get().compile(field.getString("path")), transform) : new SimpleField(name, transform);
    }

    private XPath getXPath(Config conf) {
        XPathFactory xPathFactory;
        String provider = conf.hasPath("xpath-factory") ? conf.getString("xpath-factory") : "net.sf.saxon.xpath.XPathFactoryImpl";
        try {
            BoxedUnit boxedUnit;
            XPathFactory res = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom", provider, ((Object)((Object)this)).getClass().getClassLoader());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded xpath factory ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{res.getClass()})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            xPathFactory = res;
        }
        catch (Throwable throwable) {
            XPathFactory xPathFactory2;
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to load xpath provider '", "': ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{provider, e.toString()}))).append((Object)"Xpath queries may be slower - check your classpath").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            xPathFactory = xPathFactory2 = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        }
        XPathFactory factory = xPathFactory;
        return factory.newXPath();
    }

    public XMLConverterFactory() {
        this.typeToProcess = "xml";
    }
}

