/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import com.vividsolutions.jts.geom.Envelope;
import org.geotools.process.vector.GridTransform;

public class HeatmapSurface {
    private static final int GAUSSIAN_APPROX_ITER = 4;
    private Envelope srcEnv;
    private int xSize;
    private int ySize;
    private GridTransform gridTrans;
    private float[][] grid;
    private int kernelRadiusGrid;

    public HeatmapSurface(int kernelRadius, Envelope srcEnv, int xSize, int ySize) {
        this.kernelRadiusGrid = Math.max(kernelRadius, 0);
        this.srcEnv = srcEnv;
        this.xSize = xSize;
        this.ySize = ySize;
        this.init();
    }

    private void init() {
        this.gridTrans = new GridTransform(this.srcEnv, this.xSize, this.ySize);
        this.gridTrans.setClamp(false);
        int xSizeExp = this.xSize + 2 * this.kernelRadiusGrid;
        int ySizeExp = this.ySize + 2 * this.kernelRadiusGrid;
        this.grid = new float[xSizeExp][ySizeExp];
    }

    public void addPoint(double x, double y, double value) {
        int gi = this.gridTrans.i(x) + this.kernelRadiusGrid;
        int gj = this.gridTrans.j(y) + this.kernelRadiusGrid;
        if (gi < 0 || gi > this.grid.length || gj < 0 || gj > this.grid[0].length) {
            return;
        }
        float[] fArray = this.grid[gi];
        int n = gj;
        fArray[n] = (float)((double)fArray[n] + value);
    }

    public float[][] computeSurface() {
        this.computeHeatmap(this.grid, this.kernelRadiusGrid);
        float[][] gridOut = this.extractGrid(this.grid, this.kernelRadiusGrid, this.kernelRadiusGrid, this.xSize, this.ySize);
        return gridOut;
    }

    private float[][] extractGrid(float[][] grid, int xBase, int yBase, int xSize, int ySize) {
        float[][] gridExtract = new float[xSize][ySize];
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                gridExtract[i][j] = grid[xBase + i][yBase + j];
            }
        }
        return gridExtract;
    }

    private float[][] computeHeatmap(float[][] grid, int kernelRadius) {
        int xSize = grid.length;
        int ySize = grid[0].length;
        int baseBoxKernelRadius = kernelRadius / 4;
        int radiusIncBreak = kernelRadius - baseBoxKernelRadius * 4;
        float[][] grid2 = new float[ySize][xSize];
        for (int count = 0; count < 4; ++count) {
            int boxKernelRadius = baseBoxKernelRadius;
            if (count < radiusIncBreak) {
                ++boxKernelRadius;
            }
            this.boxBlur(boxKernelRadius, grid, grid2);
            this.boxBlur(boxKernelRadius, grid2, grid);
        }
        this.normalize(grid);
        return grid;
    }

    private void testNormalizeFactor(int baseBoxKernelRadius, int radiusIncBreak) {
        double val = 1.0;
        for (int count = 0; count < 4; ++count) {
            int boxKernelRadius = baseBoxKernelRadius;
            if (count < radiusIncBreak) {
                ++boxKernelRadius;
            }
            int dia = 2 * boxKernelRadius + 1;
            float kernelVal = this.kernelVal(boxKernelRadius);
            System.out.println(boxKernelRadius + " kernel val = " + kernelVal);
            val = count == 0 ? val * 1.0 * (double)kernelVal : val * (double)dia * (double)kernelVal;
            System.out.println("norm val = " + val);
            val = count == 0 ? val * 1.0 * (double)kernelVal : val * (double)dia * (double)kernelVal;
        }
        System.out.println("norm factor = " + val);
    }

    private void normalize(float[][] grid) {
        float max = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < grid.length; ++i) {
            for (int j = 0; j < grid[0].length; ++j) {
                if (!(grid[i][j] > max)) continue;
                max = grid[i][j];
            }
        }
        float normFactor = 1.0f / max;
        for (int i = 0; i < grid.length; ++i) {
            int j = 0;
            while (j < grid[0].length) {
                float[] fArray = grid[i];
                int n = j++;
                fArray[n] = fArray[n] * normFactor;
            }
        }
    }

    private float kernelVal(int kernelRadius) {
        float val = 1.0f / (float)(2 * kernelRadius + 1);
        return val;
    }

    private void boxBlur(int kernelRadius, float[][] input, float[][] output) {
        int width = input.length;
        int height = input[0].length;
        float kernelVal = this.kernelVal(kernelRadius);
        for (int j = 0; j < height; ++j) {
            int i;
            double tot = 0.0;
            for (i = -kernelRadius; i <= kernelRadius; ++i) {
                if (i < 0 || i >= width) continue;
                tot += (double)(kernelVal * input[i][j]);
            }
            output[j][0] = (float)tot;
            for (i = 1; i < width; ++i) {
                int inext;
                int iprev = i - 1 - kernelRadius;
                if (iprev >= 0) {
                    tot -= (double)(kernelVal * input[iprev][j]);
                }
                if ((inext = i + kernelRadius) < width) {
                    tot += (double)(kernelVal * input[inext][j]);
                }
                output[j][i] = (float)tot;
            }
        }
    }
}

