/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.geotools.util.logging.Logging;

public class HTTPURIHandler
extends URIHandlerImpl {
    static final int DEFAULT_CONNECTION_TIMEOUT = Integer.getInteger("org.geotools.xsd.http.connectionTimeout", 10000);
    static final int DEFAULT_READ_TIMEOUT = Integer.getInteger("org.geotools.xsd.http.readTimeout", 10000);
    static final Logger LOGGER = Logging.getLogger(HTTPURIHandler.class);
    int connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
    int readTimeout = DEFAULT_READ_TIMEOUT;

    public boolean canHandle(URI uri) {
        return "http".equals(uri.scheme()) || "https".equals(uri.scheme());
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        try {
            HttpURLConnection httpConnection = this.getConnection(uri);
            httpConnection.setConnectTimeout(this.connectionTimeout);
            httpConnection.setReadTimeout(this.readTimeout);
            InputStream result = httpConnection.getInputStream();
            Map response = this.getResponse(options);
            if (response != null) {
                response.put("TIME_STAMP", httpConnection.getLastModified());
            }
            return result;
        }
        catch (RuntimeException exception) {
            throw new Resource.IOWrappedException((Exception)exception);
        }
    }

    protected HttpURLConnection getConnection(URI uri) throws IOException {
        String s = uri.toString();
        LOGGER.log(Level.INFO, s);
        URL url = new URL(s);
        return (HttpURLConnection)url.openConnection();
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }
}

