/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.vector;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.NullableFloat8Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.AbstractContainerVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.types.pojo.Field;
import org.locationtech.geomesa.arrow.vector.GeometryFields;
import org.locationtech.geomesa.arrow.vector.impl.AbstractPointVector;

public class PointVector
extends AbstractPointVector {
    public static final List<Field> fields = GeometryFields.XY_DOUBLE;

    public PointVector(String name, BufferAllocator allocator, @Nullable Map<String, String> metadata) {
        super(name, allocator, metadata);
    }

    public PointVector(String name, AbstractContainerVector container, @Nullable Map<String, String> metadata) {
        super(name, container, metadata);
    }

    public PointVector(FixedSizeListVector vector) {
        super(vector);
    }

    @Override
    protected List<Field> getFields() {
        return fields;
    }

    @Override
    protected AbstractPointVector.PointWriter createWriter(FixedSizeListVector vector) {
        return new PointDoubleWriter(vector);
    }

    @Override
    protected AbstractPointVector.PointReader createReader(FixedSizeListVector vector) {
        return new PointDoubleReader(vector);
    }

    public static class PointDoubleReader
    extends AbstractPointVector.PointReader {
        private NullableFloat8Vector.Accessor accessor;

        public PointDoubleReader(FixedSizeListVector vector) {
            super(vector);
        }

        @Override
        protected void setOrdinalAccessor(ValueVector.Accessor accessor) {
            this.accessor = (NullableFloat8Vector.Accessor)accessor;
        }

        @Override
        protected double readOrdinal(int index) {
            return this.accessor.get(index);
        }
    }

    public static class PointDoubleWriter
    extends AbstractPointVector.PointWriter {
        private NullableFloat8Vector.Mutator mutator;

        public PointDoubleWriter(FixedSizeListVector vector) {
            super(vector);
        }

        @Override
        protected void setOrdinalMutator(ValueVector.Mutator mutator) {
            this.mutator = (NullableFloat8Vector.Mutator)mutator;
        }

        @Override
        protected void writeOrdinal(int index, double ordinal) {
            this.mutator.setSafe(index, ordinal);
        }
    }
}

