/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.vector.impl;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.util.List;
import java.util.Map;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.complex.AbstractContainerVector;
import org.apache.arrow.vector.complex.BaseRepeatedValueVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.locationtech.geomesa.arrow.vector.GeometryVector;
import org.locationtech.geomesa.arrow.vector.impl.AbstractGeometryReader;
import org.locationtech.geomesa.arrow.vector.impl.AbstractGeometryWriter;

public abstract class AbstractPolygonVector
implements GeometryVector<Polygon, ListVector> {
    private final ListVector vector;
    private final PolygonWriter writer;
    private final PolygonReader reader;

    private static FieldType createFieldType(Map<String, String> metadata) {
        return new FieldType(true, (ArrowType)ArrowType.List.INSTANCE, null, metadata);
    }

    protected AbstractPolygonVector(String name, BufferAllocator allocator, Map<String, String> metadata) {
        this(new ListVector(name, allocator, AbstractPolygonVector.createFieldType(metadata), null));
    }

    protected AbstractPolygonVector(String name, AbstractContainerVector container, Map<String, String> metadata) {
        this((ListVector)container.addOrGet(name, AbstractPolygonVector.createFieldType(metadata), ListVector.class));
    }

    protected AbstractPolygonVector(ListVector vector) {
        if (vector.getDataVector().equals(BaseRepeatedValueVector.DEFAULT_DATA_VECTOR)) {
            vector.initializeChildrenFromFields(this.getFields());
            vector.allocateNew();
        }
        this.vector = vector;
        this.writer = this.createWriter(vector);
        this.reader = this.createReader(vector);
    }

    protected abstract List<Field> getFields();

    protected abstract PolygonWriter createWriter(ListVector var1);

    protected abstract PolygonReader createReader(ListVector var1);

    public PolygonWriter getWriter() {
        return this.writer;
    }

    public PolygonReader getReader() {
        return this.reader;
    }

    @Override
    public ListVector getVector() {
        return this.vector;
    }

    @Override
    public void close() throws Exception {
        this.vector.close();
    }

    public static abstract class PolygonReader
    extends AbstractGeometryReader<Polygon> {
        private final ListVector.Accessor accessor;
        private final UInt4Vector.Accessor outerOffsets;
        private final UInt4Vector.Accessor offsets;

        public PolygonReader(ListVector vector) {
            this.accessor = vector.getAccessor();
            this.outerOffsets = ((UInt4Vector)vector.getFieldInnerVectors().get(1)).getAccessor();
            FieldVector innerList = (FieldVector)vector.getChildrenFromFields().get(0);
            this.offsets = ((UInt4Vector)innerList.getFieldInnerVectors().get(1)).getAccessor();
            this.setOrdinalAccessor(((FieldVector)((FieldVector)innerList.getChildrenFromFields().get(0)).getChildrenFromFields().get(0)).getAccessor());
        }

        @Override
        public Polygon get(int index) {
            if (this.accessor.isNull(index)) {
                return null;
            }
            int outerOffsetStart = this.outerOffsets.get(index);
            LinearRing shell = null;
            LinearRing[] holes = new LinearRing[this.outerOffsets.get(index + 1) - outerOffsetStart - 1];
            for (int j = 0; j < holes.length + 1; ++j) {
                int offsetStart = this.offsets.get(outerOffsetStart + j);
                Coordinate[] coordinates = new Coordinate[this.offsets.get(outerOffsetStart + j + 1) - offsetStart];
                for (int i = 0; i < coordinates.length; ++i) {
                    double y = this.readOrdinal((offsetStart + i) * 2);
                    double x = this.readOrdinal((offsetStart + i) * 2 + 1);
                    coordinates[i] = new Coordinate(x, y);
                }
                LinearRing ring = GeometryVector.factory.createLinearRing(coordinates);
                if (j == 0) {
                    shell = ring;
                    continue;
                }
                holes[j - 1] = ring;
            }
            return GeometryVector.factory.createPolygon(shell, holes);
        }

        @Override
        public int getValueCount() {
            return this.accessor.getValueCount();
        }

        @Override
        public int getNullCount() {
            return this.accessor.getNullCount();
        }
    }

    public static abstract class PolygonWriter
    extends AbstractGeometryWriter<Polygon> {
        private final BitVector.Mutator nullSet;
        private final ListVector.Mutator mutator;
        private final ListVector.Mutator innerMutator;
        private final FixedSizeListVector.Mutator tupleMutator;

        protected PolygonWriter(ListVector vector) {
            this.nullSet = ((BitVector)vector.getFieldInnerVectors().get(0)).getMutator();
            ListVector innerList = (ListVector)vector.getChildrenFromFields().get(0);
            FixedSizeListVector tuples = (FixedSizeListVector)innerList.getChildrenFromFields().get(0);
            this.mutator = vector.getMutator();
            this.innerMutator = innerList.getMutator();
            this.tupleMutator = tuples.getMutator();
            this.setOrdinalMutator(((FieldVector)tuples.getChildrenFromFields().get(0)).getMutator());
        }

        @Override
        public void set(int index, Polygon geom) {
            if (geom == null) {
                this.nullSet.setSafe(index, 0);
            } else {
                int innerIndex = this.mutator.startNewValue(index);
                for (int i = 0; i < geom.getNumInteriorRing() + 1; ++i) {
                    LineString line = i == 0 ? geom.getExteriorRing() : geom.getInteriorRingN(i - 1);
                    int position = this.innerMutator.startNewValue(innerIndex + i);
                    for (int j = 0; j < line.getNumPoints(); ++j) {
                        Coordinate p = line.getCoordinateN(j);
                        this.tupleMutator.setNotNull(position + j);
                        this.writeOrdinal((position + j) * 2, p.y);
                        this.writeOrdinal((position + j) * 2 + 1, p.x);
                    }
                    this.innerMutator.endValue(innerIndex + i, line.getNumPoints());
                }
                this.mutator.endValue(index, geom.getNumInteriorRing() + 1);
            }
        }

        @Override
        public void setValueCount(int count) {
            this.mutator.setValueCount(count);
        }
    }
}

