/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.filter;

import com.typesafe.scalalogging.Logger;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.geomesa.arrow.features.ArrowSimpleFeature;
import org.locationtech.geomesa.arrow.filter.ArrowFilterOptimizer$;
import org.locationtech.geomesa.arrow.vector.ArrowAttributeReader;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.arrow.vector.ArrowDictionaryReader;
import org.locationtech.geomesa.arrow.vector.GeometryVector;
import org.locationtech.geomesa.utils.geotools.package$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import scala.Array$;
import scala.MatchError;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0011-w!B\u0001\u0003\u0011\u0003i\u0011\u0001F!se><h)\u001b7uKJ|\u0005\u000f^5nSj,'O\u0003\u0002\u0004\t\u00051a-\u001b7uKJT!!\u0002\u0004\u0002\u000b\u0005\u0014(o\\<\u000b\u0005\u001dA\u0011aB4f_6,7/\u0019\u0006\u0003\u0013)\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011aC\u0001\u0004_J<7\u0001\u0001\t\u0003\u001d=i\u0011A\u0001\u0004\u0006!\tA\t!\u0005\u0002\u0015\u0003J\u0014xn\u001e$jYR,'o\u00149uS6L'0\u001a:\u0014\u0007=\u0011\u0002\u0004\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VM\u001a\t\u00033\u0001j\u0011A\u0007\u0006\u00037q\tAb]2bY\u0006dwnZ4j]\u001eT!!\b\u0010\u0002\u0011QL\b/Z:bM\u0016T\u0011aH\u0001\u0004G>l\u0017BA\u0011\u001b\u0005-a\u0015M_=M_\u001e<\u0017N\\4\t\u000b\rzA\u0011\u0001\u0013\u0002\rqJg.\u001b;?)\u0005i\u0001b\u0002\u0014\u0010\u0005\u0004%IaJ\u0001\u0003M\u001a,\u0012\u0001\u000b\t\u0003S5j\u0011A\u000b\u0006\u0003\u0007-R!\u0001\f\u0006\u0002\u000f=\u0004XM\\4jg&\u0011aF\u000b\u0002\u000f\r&dG/\u001a:GC\u000e$xN]=3\u0011\u0019\u0001t\u0002)A\u0005Q\u0005\u0019aM\u001a\u0011\t\u000bIzA\u0011A\u001a\u0002\u000fI,wO]5uKR!Ag\u000e\u001dC!\tIS'\u0003\u00027U\t1a)\u001b7uKJDQaA\u0019A\u0002QBQ!O\u0019A\u0002i\n1a\u001d4u!\tY\u0004)D\u0001=\u0015\tid(\u0001\u0004tS6\u0004H.\u001a\u0006\u0003\u007f-\nqAZ3biV\u0014X-\u0003\u0002By\t\t2+[7qY\u00164U-\u0019;ve\u0016$\u0016\u0010]3\t\u000b\r\u000b\u0004\u0019\u0001#\u0002\u0019\u0011L7\r^5p]\u0006\u0014\u0018.Z:\u0011\t\u0015C5J\u0014\b\u0003'\u0019K!a\u0012\u000b\u0002\rA\u0013X\rZ3g\u0013\tI%JA\u0002NCBT!a\u0012\u000b\u0011\u0005\u0015c\u0015BA'K\u0005\u0019\u0019FO]5oOB\u0011qJU\u0007\u0002!*\u0011\u0011\u000bB\u0001\u0007m\u0016\u001cGo\u001c:\n\u0005M\u0003&aD!se><H)[2uS>t\u0017M]=\t\u000bU{A\u0011\u0002,\u0002\u001bI,wO]5uK\u001aKG\u000e^3s)\u0011!t\u000bW-\t\u000b\r!\u0006\u0019\u0001\u001b\t\u000be\"\u0006\u0019\u0001\u001e\t\u000b\r#\u0006\u0019\u0001#\t\u000bm{A\u0011\u0002/\u0002\u0017I,wO]5uK\n\u0013u\u000e\u001f\u000b\u0004iu#\u0007\"B\u0002[\u0001\u0004q\u0006CA0c\u001b\u0005\u0001'BA1+\u0003\u001d\u0019\b/\u0019;jC2L!a\u00191\u0003\t\t\u0013u\n\u0017\u0005\u0006si\u0003\rA\u000f\u0005\u0006M>!IaZ\u0001\u000ee\u0016<(/\u001b;f\tV\u0014\u0018N\\4\u0015\u0007QBw\u000eC\u0003\u0004K\u0002\u0007\u0011\u000e\u0005\u0002k[6\t1N\u0003\u0002mU\u0005AA/Z7q_J\fG.\u0003\u0002oW\n1A)\u001e:j]\u001eDQ!O3A\u0002iBQ!]\b\u0005\nI\faB]3xe&$XMQ3uo\u0016,g\u000eF\u00025g^DQa\u00019A\u0002Q\u0004\"!K;\n\u0005YT#!\u0005)s_B,'\u000f^=Jg\n+Go^3f]\")\u0011\b\u001da\u0001u!)\u0011p\u0004C\u0005u\u0006A\"/Z<sSR,\u0007K]8qKJ$\u00180S:FcV\fG\u000eV8\u0015\u000bQZx0!\u0001\t\u000b\rA\b\u0019\u0001?\u0011\u0005%j\u0018B\u0001@+\u0005E\u0001&o\u001c9feRL\u0018j]#rk\u0006dGk\u001c\u0005\u0006sa\u0004\rA\u000f\u0005\u0006\u0007b\u0004\r\u0001\u0012\u0004\u0007\u0003\u000by\u0001)a\u0002\u0003\u001d\u0005\u0013(o\\<Q_&tGO\u0011\"pqNI\u00111AA\u0005i\u0005e\u0011q\u0004\t\u0005\u0003\u0017\t)\"\u0004\u0002\u0002\u000e)!\u0011qBA\t\u0003\u0011a\u0017M\\4\u000b\u0005\u0005M\u0011\u0001\u00026bm\u0006LA!a\u0006\u0002\u000e\t1qJ\u00196fGR\u00042aEA\u000e\u0013\r\ti\u0002\u0006\u0002\b!J|G-^2u!\r\u0019\u0012\u0011E\u0005\u0004\u0003G!\"\u0001D*fe&\fG.\u001b>bE2,\u0007bCA\u0014\u0003\u0007\u0011)\u001a!C\u0001\u0003S\t\u0011![\u000b\u0003\u0003W\u00012aEA\u0017\u0013\r\ty\u0003\u0006\u0002\u0004\u0013:$\bbCA\u001a\u0003\u0007\u0011\t\u0012)A\u0005\u0003W\t!!\u001b\u0011\t\u0017\u0005]\u00121\u0001BK\u0002\u0013\u0005\u0011\u0011H\u0001\u0005q6Lg.\u0006\u0002\u0002<A\u00191#!\u0010\n\u0007\u0005}BC\u0001\u0004E_V\u0014G.\u001a\u0005\f\u0003\u0007\n\u0019A!E!\u0002\u0013\tY$A\u0003y[&t\u0007\u0005C\u0006\u0002H\u0005\r!Q3A\u0005\u0002\u0005e\u0012\u0001B=nS:D1\"a\u0013\u0002\u0004\tE\t\u0015!\u0003\u0002<\u0005)\u00110\\5oA!Y\u0011qJA\u0002\u0005+\u0007I\u0011AA\u001d\u0003\u0011AX.\u0019=\t\u0017\u0005M\u00131\u0001B\tB\u0003%\u00111H\u0001\u0006q6\f\u0007\u0010\t\u0005\f\u0003/\n\u0019A!f\u0001\n\u0003\tI$\u0001\u0003z[\u0006D\bbCA.\u0003\u0007\u0011\t\u0012)A\u0005\u0003w\tQ!_7bq\u0002BqaIA\u0002\t\u0003\ty\u0006\u0006\u0007\u0002b\u0005\u0015\u0014qMA5\u0003W\ni\u0007\u0005\u0003\u0002d\u0005\rQ\"A\b\t\u0011\u0005\u001d\u0012Q\fa\u0001\u0003WA\u0001\"a\u000e\u0002^\u0001\u0007\u00111\b\u0005\t\u0003\u000f\ni\u00061\u0001\u0002<!A\u0011qJA/\u0001\u0004\tY\u0004\u0003\u0005\u0002X\u0005u\u0003\u0019AA\u001e\u0011!\t\t(a\u0001\u0005B\u0005M\u0014AB1dG\u0016\u0004H\u000fF\u0003\u0013\u0003k\ny\b\u0003\u0005\u0002x\u0005=\u0004\u0019AA=\u0003\u001d1\u0018n]5u_J\u00042!KA>\u0013\r\tiH\u000b\u0002\u000e\r&dG/\u001a:WSNLGo\u001c:\t\u000f\u0005\u0005\u0015q\u000ea\u0001%\u0005IQ\r\u001f;sC\u0012\u000bG/\u0019\u0005\t\u0003\u000b\u000b\u0019\u0001\"\u0011\u0002\b\u0006AQM^1mk\u0006$X\r\u0006\u0003\u0002\n\u0006=\u0005cA\n\u0002\f&\u0019\u0011Q\u0012\u000b\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0011SAB\u0001\u0004\u0011\u0012!A8\t\u0015\u0005U\u00151AA\u0001\n\u0003\t9*\u0001\u0003d_BLH\u0003DA1\u00033\u000bY*!(\u0002 \u0006\u0005\u0006BCA\u0014\u0003'\u0003\n\u00111\u0001\u0002,!Q\u0011qGAJ!\u0003\u0005\r!a\u000f\t\u0015\u0005\u001d\u00131\u0013I\u0001\u0002\u0004\tY\u0004\u0003\u0006\u0002P\u0005M\u0005\u0013!a\u0001\u0003wA!\"a\u0016\u0002\u0014B\u0005\t\u0019AA\u001e\u0011)\t)+a\u0001\u0012\u0002\u0013\u0005\u0011qU\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tIK\u000b\u0003\u0002,\u0005-6FAAW!\u0011\ty+!/\u000e\u0005\u0005E&\u0002BAZ\u0003k\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]F#\u0001\u0006b]:|G/\u0019;j_:LA!a/\u00022\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\u0005}\u00161AI\u0001\n\u0003\t\t-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\r'\u0006BA\u001e\u0003WC!\"a2\u0002\u0004E\u0005I\u0011AAa\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIMB!\"a3\u0002\u0004E\u0005I\u0011AAa\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQB!\"a4\u0002\u0004E\u0005I\u0011AAa\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIUB!\"a5\u0002\u0004\u0005\u0005I\u0011IAk\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u001b\t\u0005\u0003\u0017\tI.C\u0002N\u0003\u001bA!\"!8\u0002\u0004\u0005\u0005I\u0011AA\u0015\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u0011)\t\t/a\u0001\u0002\u0002\u0013\u0005\u00111]\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t)/a;\u0011\u0007M\t9/C\u0002\u0002jR\u00111!\u00118z\u0011)\ti/a8\u0002\u0002\u0003\u0007\u00111F\u0001\u0004q\u0012\n\u0004BCAy\u0003\u0007\t\t\u0011\"\u0011\u0002t\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002vB1\u0011q_A\u007f\u0003Kl!!!?\u000b\u0007\u0005mH#\u0001\u0006d_2dWm\u0019;j_:LA!a@\u0002z\nA\u0011\n^3sCR|'\u000f\u0003\u0006\u0003\u0004\u0005\r\u0011\u0011!C\u0001\u0005\u000b\t\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0013\u00139\u0001\u0003\u0006\u0002n\n\u0005\u0011\u0011!a\u0001\u0003KD!Ba\u0003\u0002\u0004\u0005\u0005I\u0011\tB\u0007\u0003!A\u0017m\u001d5D_\u0012,GCAA\u0016\u0011)\u0011\t\"a\u0001\u0002\u0002\u0013\u0005#1C\u0001\ti>\u001cFO]5oOR\u0011\u0011q\u001b\u0005\u000b\u0005/\t\u0019!!A\u0005B\te\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0002\n\nm\u0001BCAw\u0005+\t\t\u00111\u0001\u0002f\u001eI!qD\b\u0002\u0002#\u0005!\u0011E\u0001\u000f\u0003J\u0014xn\u001e)pS:$(IQ8y!\u0011\t\u0019Ga\t\u0007\u0013\u0005\u0015q\"!A\t\u0002\t\u00152C\u0002B\u0012\u0005O\ty\u0002\u0005\t\u0003*\t=\u00121FA\u001e\u0003w\tY$a\u000f\u0002b5\u0011!1\u0006\u0006\u0004\u0005[!\u0012a\u0002:v]RLW.Z\u0005\u0005\u0005c\u0011YCA\tBEN$(/Y2u\rVt7\r^5p]VBqa\tB\u0012\t\u0003\u0011)\u0004\u0006\u0002\u0003\"!Q!\u0011\u0003B\u0012\u0003\u0003%)Ea\u0005\t\u0015\tm\"1EA\u0001\n\u0003\u0013i$A\u0003baBd\u0017\u0010\u0006\u0007\u0002b\t}\"\u0011\tB\"\u0005\u000b\u00129\u0005\u0003\u0005\u0002(\te\u0002\u0019AA\u0016\u0011!\t9D!\u000fA\u0002\u0005m\u0002\u0002CA$\u0005s\u0001\r!a\u000f\t\u0011\u0005=#\u0011\ba\u0001\u0003wA\u0001\"a\u0016\u0003:\u0001\u0007\u00111\b\u0005\u000b\u0005\u0017\u0012\u0019#!A\u0005\u0002\n5\u0013aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u001f\u0012Y\u0006E\u0003\u0014\u0005#\u0012)&C\u0002\u0003TQ\u0011aa\u00149uS>t\u0007#D\n\u0003X\u0005-\u00121HA\u001e\u0003w\tY$C\u0002\u0003ZQ\u0011a\u0001V;qY\u0016,\u0004B\u0003B/\u0005\u0013\n\t\u00111\u0001\u0002b\u0005\u0019\u0001\u0010\n\u0019\t\u0015\t\u0005$1EA\u0001\n\u0013\u0011\u0019'A\u0006sK\u0006$'+Z:pYZ,GCAA\u0005\r\u0019\u00119g\u0004!\u0003j\t\u0019\u0012I\u001d:po2Kg.Z*ue&twM\u0011\"pqNI!QMA\u0005i\u0005e\u0011q\u0004\u0005\f\u0003O\u0011)G!f\u0001\n\u0003\tI\u0003C\u0006\u00024\t\u0015$\u0011#Q\u0001\n\u0005-\u0002bCA\u001c\u0005K\u0012)\u001a!C\u0001\u0003sA1\"a\u0011\u0003f\tE\t\u0015!\u0003\u0002<!Y\u0011q\tB3\u0005+\u0007I\u0011AA\u001d\u0011-\tYE!\u001a\u0003\u0012\u0003\u0006I!a\u000f\t\u0017\u0005=#Q\rBK\u0002\u0013\u0005\u0011\u0011\b\u0005\f\u0003'\u0012)G!E!\u0002\u0013\tY\u0004C\u0006\u0002X\t\u0015$Q3A\u0005\u0002\u0005e\u0002bCA.\u0005K\u0012\t\u0012)A\u0005\u0003wAqa\tB3\t\u0003\u0011\t\t\u0006\u0007\u0003\u0004\n\u0015%q\u0011BE\u0005\u0017\u0013i\t\u0005\u0003\u0002d\t\u0015\u0004\u0002CA\u0014\u0005\u007f\u0002\r!a\u000b\t\u0011\u0005]\"q\u0010a\u0001\u0003wA\u0001\"a\u0012\u0003\u0000\u0001\u0007\u00111\b\u0005\t\u0003\u001f\u0012y\b1\u0001\u0002<!A\u0011q\u000bB@\u0001\u0004\tY\u0004\u0003\u0006\u0003\u0012\n\u0015$\u0019!C\u0005\u0005'\u000bAB\u00192pq\u0016sg/\u001a7pa\u0016,\"A!&\u0011\t\t]%QU\u0007\u0003\u00053SAAa'\u0003\u001e\u0006\u0019!\u000e^:\u000b\t\t}%\u0011U\u0001\tO\u0016|W.\u001a;ss*\u0019!1\u0015\u0006\u0002\u0011\u001d,w\u000e^8pYNLAAa*\u0003\u001a\n\u0011\"+\u001a4fe\u0016t7-\u001a3F]Z,Gn\u001c9f\u0011%\u0011YK!\u001a!\u0002\u0013\u0011)*A\u0007cE>DXI\u001c<fY>\u0004X\r\t\u0005\u000b\u0005_\u0013)G1A\u0005\n\tE\u0016\u0001\u00022c_b,\"Aa-\u0011\t\tU&\u0011Y\u0007\u0003\u0005oSAA!/\u0003<\u0006!q-Z8n\u0015\u0011\u0011YJ!0\u000b\u0007\t}f$\u0001\bwSZLGm]8mkRLwN\\:\n\t\t\r'q\u0017\u0002\t\u000f\u0016|W.\u001a;ss\"I!q\u0019B3A\u0003%!1W\u0001\u0006E\n|\u0007\u0010\t\u0005\t\u0003c\u0012)\u0007\"\u0011\u0003LR)!C!4\u0003P\"A\u0011q\u000fBe\u0001\u0004\tI\bC\u0004\u0002\u0002\n%\u0007\u0019\u0001\n\t\u0011\u0005\u0015%Q\rC!\u0005'$B!!#\u0003V\"9\u0011\u0011\u0013Bi\u0001\u0004\u0011\u0002BCAK\u0005K\n\t\u0011\"\u0001\u0003ZRa!1\u0011Bn\u0005;\u0014yN!9\u0003d\"Q\u0011q\u0005Bl!\u0003\u0005\r!a\u000b\t\u0015\u0005]\"q\u001bI\u0001\u0002\u0004\tY\u0004\u0003\u0006\u0002H\t]\u0007\u0013!a\u0001\u0003wA!\"a\u0014\u0003XB\u0005\t\u0019AA\u001e\u0011)\t9Fa6\u0011\u0002\u0003\u0007\u00111\b\u0005\u000b\u0003K\u0013)'%A\u0005\u0002\u0005\u001d\u0006BCA`\u0005K\n\n\u0011\"\u0001\u0002B\"Q\u0011q\u0019B3#\u0003%\t!!1\t\u0015\u0005-'QMI\u0001\n\u0003\t\t\r\u0003\u0006\u0002P\n\u0015\u0014\u0013!C\u0001\u0003\u0003D!\"a5\u0003f\u0005\u0005I\u0011IAk\u0011)\tiN!\u001a\u0002\u0002\u0013\u0005\u0011\u0011\u0006\u0005\u000b\u0003C\u0014)'!A\u0005\u0002\tUH\u0003BAs\u0005oD!\"!<\u0003t\u0006\u0005\t\u0019AA\u0016\u0011)\t\tP!\u001a\u0002\u0002\u0013\u0005\u00131\u001f\u0005\u000b\u0005\u0007\u0011)'!A\u0005\u0002\tuH\u0003BAE\u0005\u007fD!\"!<\u0003|\u0006\u0005\t\u0019AAs\u0011)\u0011YA!\u001a\u0002\u0002\u0013\u0005#Q\u0002\u0005\u000b\u0005#\u0011)'!A\u0005B\tM\u0001B\u0003B\f\u0005K\n\t\u0011\"\u0011\u0004\bQ!\u0011\u0011RB\u0005\u0011)\tio!\u0002\u0002\u0002\u0003\u0007\u0011Q]\u0004\n\u0007\u001by\u0011\u0011!E\u0001\u0007\u001f\t1#\u0011:s_^d\u0015N\\3TiJLgn\u001a\"C_b\u0004B!a\u0019\u0004\u0012\u0019I!qM\b\u0002\u0002#\u000511C\n\u0007\u0007#\u0019)\"a\b\u0011!\t%\"qFA\u0016\u0003w\tY$a\u000f\u0002<\t\r\u0005bB\u0012\u0004\u0012\u0011\u00051\u0011\u0004\u000b\u0003\u0007\u001fA!B!\u0005\u0004\u0012\u0005\u0005IQ\tB\n\u0011)\u0011Yd!\u0005\u0002\u0002\u0013\u00055q\u0004\u000b\r\u0005\u0007\u001b\tca\t\u0004&\r\u001d2\u0011\u0006\u0005\t\u0003O\u0019i\u00021\u0001\u0002,!A\u0011qGB\u000f\u0001\u0004\tY\u0004\u0003\u0005\u0002H\ru\u0001\u0019AA\u001e\u0011!\tye!\bA\u0002\u0005m\u0002\u0002CA,\u0007;\u0001\r!a\u000f\t\u0015\t-3\u0011CA\u0001\n\u0003\u001bi\u0003\u0006\u0003\u0003P\r=\u0002B\u0003B/\u0007W\t\t\u00111\u0001\u0003\u0004\"Q!\u0011MB\t\u0003\u0003%IAa\u0019\u0007\r\rUr\u0002QB\u001c\u0005-\t%O]8x\tV\u0014\u0018N\\4\u0014\u0013\rM\u0012\u0011\u0002\u001b\u0002\u001a\u0005}\u0001bCA\u0014\u0007g\u0011)\u001a!C\u0001\u0003SA1\"a\r\u00044\tE\t\u0015!\u0003\u0002,!Y1qHB\u001a\u0005+\u0007I\u0011AB!\u0003\u0015awn^3s+\t\u0019\u0019\u0005E\u0002\u0014\u0007\u000bJ1aa\u0012\u0015\u0005\u0011auN\\4\t\u0017\r-31\u0007B\tB\u0003%11I\u0001\u0007Y><XM\u001d\u0011\t\u0017\r=31\u0007BK\u0002\u0013\u00051\u0011I\u0001\u0006kB\u0004XM\u001d\u0005\f\u0007'\u001a\u0019D!E!\u0002\u0013\u0019\u0019%\u0001\u0004vaB,'\u000f\t\u0005\bG\rMB\u0011AB,)!\u0019Ifa\u0017\u0004^\r}\u0003\u0003BA2\u0007gA\u0001\"a\n\u0004V\u0001\u0007\u00111\u0006\u0005\t\u0007\u007f\u0019)\u00061\u0001\u0004D!A1qJB+\u0001\u0004\u0019\u0019\u0005\u0003\u0005\u0002r\rMB\u0011IB2)\u0015\u00112QMB4\u0011!\t9h!\u0019A\u0002\u0005e\u0004bBAA\u0007C\u0002\rA\u0005\u0005\t\u0003\u000b\u001b\u0019\u0004\"\u0011\u0004lQ!\u0011\u0011RB7\u0011\u001d\t\tj!\u001bA\u0002IA!\"!&\u00044\u0005\u0005I\u0011AB9)!\u0019Ifa\u001d\u0004v\r]\u0004BCA\u0014\u0007_\u0002\n\u00111\u0001\u0002,!Q1qHB8!\u0003\u0005\raa\u0011\t\u0015\r=3q\u000eI\u0001\u0002\u0004\u0019\u0019\u0005\u0003\u0006\u0002&\u000eM\u0012\u0013!C\u0001\u0003OC!\"a0\u00044E\u0005I\u0011AB?+\t\u0019yH\u000b\u0003\u0004D\u0005-\u0006BCAd\u0007g\t\n\u0011\"\u0001\u0004~!Q\u00111[B\u001a\u0003\u0003%\t%!6\t\u0015\u0005u71GA\u0001\n\u0003\tI\u0003\u0003\u0006\u0002b\u000eM\u0012\u0011!C\u0001\u0007\u0013#B!!:\u0004\f\"Q\u0011Q^BD\u0003\u0003\u0005\r!a\u000b\t\u0015\u0005E81GA\u0001\n\u0003\n\u0019\u0010\u0003\u0006\u0003\u0004\rM\u0012\u0011!C\u0001\u0007##B!!#\u0004\u0014\"Q\u0011Q^BH\u0003\u0003\u0005\r!!:\t\u0015\t-11GA\u0001\n\u0003\u0012i\u0001\u0003\u0006\u0003\u0012\rM\u0012\u0011!C!\u0005'A!Ba\u0006\u00044\u0005\u0005I\u0011IBN)\u0011\tIi!(\t\u0015\u000558\u0011TA\u0001\u0002\u0004\t)oB\u0005\u0004\">\t\t\u0011#\u0001\u0004$\u0006Y\u0011I\u001d:po\u0012+(/\u001b8h!\u0011\t\u0019g!*\u0007\u0013\rUr\"!A\t\u0002\r\u001d6CBBS\u0007S\u000by\u0002\u0005\u0007\u0003*\r-\u00161FB\"\u0007\u0007\u001aI&\u0003\u0003\u0004.\n-\"!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8og!91e!*\u0005\u0002\rEFCABR\u0011)\u0011\tb!*\u0002\u0002\u0013\u0015#1\u0003\u0005\u000b\u0005w\u0019)+!A\u0005\u0002\u000e]F\u0003CB-\u0007s\u001bYl!0\t\u0011\u0005\u001d2Q\u0017a\u0001\u0003WA\u0001ba\u0010\u00046\u0002\u000711\t\u0005\t\u0007\u001f\u001a)\f1\u0001\u0004D!Q!1JBS\u0003\u0003%\ti!1\u0015\t\r\r71\u001a\t\u0006'\tE3Q\u0019\t\n'\r\u001d\u00171FB\"\u0007\u0007J1a!3\u0015\u0005\u0019!V\u000f\u001d7fg!Q!QLB`\u0003\u0003\u0005\ra!\u0017\t\u0015\t\u00054QUA\u0001\n\u0013\u0011\u0019G\u0002\u0004\u0004R>\u000151\u001b\u0002\u0011\u0003J\u0014xn\u001e\"fi^,WM\u001c#bi\u0016\u001c\u0012ba4\u0002\nQ\nI\"a\b\t\u0017\u0005\u001d2q\u001aBK\u0002\u0013\u0005\u0011\u0011\u0006\u0005\f\u0003g\u0019yM!E!\u0002\u0013\tY\u0003C\u0006\u0004@\r='Q3A\u0005\u0002\r\u0005\u0003bCB&\u0007\u001f\u0014\t\u0012)A\u0005\u0007\u0007B1ba\u0014\u0004P\nU\r\u0011\"\u0001\u0004B!Y11KBh\u0005#\u0005\u000b\u0011BB\"\u0011\u001d\u00193q\u001aC\u0001\u0007G$\u0002b!:\u0004h\u000e%81\u001e\t\u0005\u0003G\u001ay\r\u0003\u0005\u0002(\r\u0005\b\u0019AA\u0016\u0011!\u0019yd!9A\u0002\r\r\u0003\u0002CB(\u0007C\u0004\raa\u0011\t\u0011\u0005E4q\u001aC!\u0007_$RAEBy\u0007gD\u0001\"a\u001e\u0004n\u0002\u0007\u0011\u0011\u0010\u0005\b\u0003\u0003\u001bi\u000f1\u0001\u0013\u0011!\t)ia4\u0005B\r]H\u0003BAE\u0007sDq!!%\u0004v\u0002\u0007!\u0003\u0003\u0006\u0002\u0016\u000e=\u0017\u0011!C\u0001\u0007{$\u0002b!:\u0004\u0000\u0012\u0005A1\u0001\u0005\u000b\u0003O\u0019Y\u0010%AA\u0002\u0005-\u0002BCB \u0007w\u0004\n\u00111\u0001\u0004D!Q1qJB~!\u0003\u0005\raa\u0011\t\u0015\u0005\u00156qZI\u0001\n\u0003\t9\u000b\u0003\u0006\u0002@\u000e=\u0017\u0013!C\u0001\u0007{B!\"a2\u0004PF\u0005I\u0011AB?\u0011)\t\u0019na4\u0002\u0002\u0013\u0005\u0013Q\u001b\u0005\u000b\u0003;\u001cy-!A\u0005\u0002\u0005%\u0002BCAq\u0007\u001f\f\t\u0011\"\u0001\u0005\u0012Q!\u0011Q\u001dC\n\u0011)\ti\u000fb\u0004\u0002\u0002\u0003\u0007\u00111\u0006\u0005\u000b\u0003c\u001cy-!A\u0005B\u0005M\bB\u0003B\u0002\u0007\u001f\f\t\u0011\"\u0001\u0005\u001aQ!\u0011\u0011\u0012C\u000e\u0011)\ti\u000fb\u0006\u0002\u0002\u0003\u0007\u0011Q\u001d\u0005\u000b\u0005\u0017\u0019y-!A\u0005B\t5\u0001B\u0003B\t\u0007\u001f\f\t\u0011\"\u0011\u0003\u0014!Q!qCBh\u0003\u0003%\t\u0005b\t\u0015\t\u0005%EQ\u0005\u0005\u000b\u0003[$\t#!AA\u0002\u0005\u0015x!\u0003C\u0015\u001f\u0005\u0005\t\u0012\u0001C\u0016\u0003A\t%O]8x\u0005\u0016$x/Z3o\t\u0006$X\r\u0005\u0003\u0002d\u00115b!CBi\u001f\u0005\u0005\t\u0012\u0001C\u0018'\u0019!i\u0003\"\r\u0002 Aa!\u0011FBV\u0003W\u0019\u0019ea\u0011\u0004f\"91\u0005\"\f\u0005\u0002\u0011UBC\u0001C\u0016\u0011)\u0011\t\u0002\"\f\u0002\u0002\u0013\u0015#1\u0003\u0005\u000b\u0005w!i#!A\u0005\u0002\u0012mB\u0003CBs\t{!y\u0004\"\u0011\t\u0011\u0005\u001dB\u0011\ba\u0001\u0003WA\u0001ba\u0010\u0005:\u0001\u000711\t\u0005\t\u0007\u001f\"I\u00041\u0001\u0004D!Q!1\nC\u0017\u0003\u0003%\t\t\"\u0012\u0015\t\r\rGq\t\u0005\u000b\u0005;\"\u0019%!AA\u0002\r\u0015\bB\u0003B1\t[\t\t\u0011\"\u0003\u0003d\u00191AQJ\bA\t\u001f\u0012Q#\u0011:s_^$\u0015n\u0019;j_:\f'/_#rk\u0006d7oE\u0005\u0005L\u0005%A'!\u0007\u0002 !Y\u0011q\u0005C&\u0005+\u0007I\u0011AA\u0015\u0011-\t\u0019\u0004b\u0013\u0003\u0012\u0003\u0006I!a\u000b\t\u0017\u0011]C1\nBK\u0002\u0013\u0005\u0011\u0011F\u0001\u0006m\u0006dW/\u001a\u0005\f\t7\"YE!E!\u0002\u0013\tY#\u0001\u0004wC2,X\r\t\u0005\bG\u0011-C\u0011\u0001C0)\u0019!\t\u0007b\u0019\u0005fA!\u00111\rC&\u0011!\t9\u0003\"\u0018A\u0002\u0005-\u0002\u0002\u0003C,\t;\u0002\r!a\u000b\t\u0011\u0005ED1\nC!\tS\"RA\u0005C6\t[B\u0001\"a\u001e\u0005h\u0001\u0007\u0011\u0011\u0010\u0005\b\u0003\u0003#9\u00071\u0001\u0013\u0011!\t)\tb\u0013\u0005B\u0011ED\u0003BAE\tgBq!!%\u0005p\u0001\u0007!\u0003\u0003\u0006\u0002\u0016\u0012-\u0013\u0011!C\u0001\to\"b\u0001\"\u0019\u0005z\u0011m\u0004BCA\u0014\tk\u0002\n\u00111\u0001\u0002,!QAq\u000bC;!\u0003\u0005\r!a\u000b\t\u0015\u0005\u0015F1JI\u0001\n\u0003\t9\u000b\u0003\u0006\u0002@\u0012-\u0013\u0013!C\u0001\u0003OC!\"a5\u0005L\u0005\u0005I\u0011IAk\u0011)\ti\u000eb\u0013\u0002\u0002\u0013\u0005\u0011\u0011\u0006\u0005\u000b\u0003C$Y%!A\u0005\u0002\u0011\u001dE\u0003BAs\t\u0013C!\"!<\u0005\u0006\u0006\u0005\t\u0019AA\u0016\u0011)\t\t\u0010b\u0013\u0002\u0002\u0013\u0005\u00131\u001f\u0005\u000b\u0005\u0007!Y%!A\u0005\u0002\u0011=E\u0003BAE\t#C!\"!<\u0005\u000e\u0006\u0005\t\u0019AAs\u0011)\u0011Y\u0001b\u0013\u0002\u0002\u0013\u0005#Q\u0002\u0005\u000b\u0005#!Y%!A\u0005B\tM\u0001B\u0003B\f\t\u0017\n\t\u0011\"\u0011\u0005\u001aR!\u0011\u0011\u0012CN\u0011)\ti\u000fb&\u0002\u0002\u0003\u0007\u0011Q]\u0004\n\t?{\u0011\u0011!E\u0001\tC\u000bQ#\u0011:s_^$\u0015n\u0019;j_:\f'/_#rk\u0006d7\u000f\u0005\u0003\u0002d\u0011\rf!\u0003C'\u001f\u0005\u0005\t\u0012\u0001CS'\u0019!\u0019\u000bb*\u0002 AQ!\u0011\u0006CU\u0003W\tY\u0003\"\u0019\n\t\u0011-&1\u0006\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004bB\u0012\u0005$\u0012\u0005Aq\u0016\u000b\u0003\tCC!B!\u0005\u0005$\u0006\u0005IQ\tB\n\u0011)\u0011Y\u0004b)\u0002\u0002\u0013\u0005EQ\u0017\u000b\u0007\tC\"9\f\"/\t\u0011\u0005\u001dB1\u0017a\u0001\u0003WA\u0001\u0002b\u0016\u00054\u0002\u0007\u00111\u0006\u0005\u000b\u0005\u0017\"\u0019+!A\u0005\u0002\u0012uF\u0003\u0002C`\t\u000f\u0004Ra\u0005B)\t\u0003\u0004ra\u0005Cb\u0003W\tY#C\u0002\u0005FR\u0011a\u0001V;qY\u0016\u0014\u0004B\u0003B/\tw\u000b\t\u00111\u0001\u0005b!Q!\u0011\rCR\u0003\u0003%IAa\u0019")
public final class ArrowFilterOptimizer {
    public static Logger logger() {
        return ArrowFilterOptimizer$.MODULE$.logger();
    }

    public static Filter rewrite(Filter filter, SimpleFeatureType simpleFeatureType, Map<String, ArrowDictionary> map) {
        return ArrowFilterOptimizer$.MODULE$.rewrite(filter, simpleFeatureType, map);
    }

    public static class ArrowDuring
    implements Filter,
    Product,
    Serializable {
        private final int i;
        private final long lower;
        private final long upper;

        public int i() {
            return this.i;
        }

        public long lower() {
            return this.lower;
        }

        public long upper() {
            return this.upper;
        }

        public Object accept(FilterVisitor visitor, Object extraData) {
            return extraData;
        }

        public boolean evaluate(Object o) {
            ArrowSimpleFeature arrow = (ArrowSimpleFeature)o;
            long time = ((ArrowAttributeReader.ArrowDateReader)arrow.getReader(this.i())).getTime(arrow.getIndex());
            return time > this.lower() && time < this.upper();
        }

        public ArrowDuring copy(int i, long lower, long upper) {
            return new ArrowDuring(i, lower, upper);
        }

        public int copy$default$1() {
            return this.i();
        }

        public long copy$default$2() {
            return this.lower();
        }

        public long copy$default$3() {
            return this.upper();
        }

        public String productPrefix() {
            return "ArrowDuring";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Number number;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 2: {
                    number = BoxesRunTime.boxToLong((long)this.upper());
                    break;
                }
                case 1: {
                    number = BoxesRunTime.boxToLong((long)this.lower());
                    break;
                }
                case 0: {
                    number = BoxesRunTime.boxToInteger((int)this.i());
                }
            }
            return number;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ArrowDuring;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.i());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.lower()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.upper()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ArrowDuring)) return false;
            boolean bl = true;
            if (!bl) return false;
            ArrowDuring arrowDuring = (ArrowDuring)x$1;
            if (this.i() != arrowDuring.i()) return false;
            if (this.lower() != arrowDuring.lower()) return false;
            if (this.upper() != arrowDuring.upper()) return false;
            if (!arrowDuring.canEqual(this)) return false;
            return true;
        }

        public ArrowDuring(int i, long lower, long upper) {
            this.i = i;
            this.lower = lower;
            this.upper = upper;
            Product.class.$init$((Product)this);
        }
    }

    public static class ArrowPointBBox
    implements Filter,
    Product,
    Serializable {
        private final int i;
        private final double xmin;
        private final double ymin;
        private final double xmax;
        private final double ymax;

        public int i() {
            return this.i;
        }

        public double xmin() {
            return this.xmin;
        }

        public double ymin() {
            return this.ymin;
        }

        public double xmax() {
            return this.xmax;
        }

        public double ymax() {
            return this.ymax;
        }

        public Object accept(FilterVisitor visitor, Object extraData) {
            return extraData;
        }

        public boolean evaluate(Object o) {
            double x;
            int index;
            ArrowSimpleFeature arrow = (ArrowSimpleFeature)o;
            ArrowAttributeReader.ArrowPointReader reader = (ArrowAttributeReader.ArrowPointReader)arrow.getReader(this.i());
            double y = reader.readPointY(index = arrow.getIndex());
            return y < this.ymin() || y > this.ymax() ? false : (x = reader.readPointX(index)) >= this.xmin() && x <= this.xmax();
        }

        public ArrowPointBBox copy(int i, double xmin, double ymin, double xmax, double ymax) {
            return new ArrowPointBBox(i, xmin, ymin, xmax, ymax);
        }

        public int copy$default$1() {
            return this.i();
        }

        public double copy$default$2() {
            return this.xmin();
        }

        public double copy$default$3() {
            return this.ymin();
        }

        public double copy$default$4() {
            return this.xmax();
        }

        public double copy$default$5() {
            return this.ymax();
        }

        public String productPrefix() {
            return "ArrowPointBBox";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            Number number;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 4: {
                    number = BoxesRunTime.boxToDouble((double)this.ymax());
                    break;
                }
                case 3: {
                    number = BoxesRunTime.boxToDouble((double)this.xmax());
                    break;
                }
                case 2: {
                    number = BoxesRunTime.boxToDouble((double)this.ymin());
                    break;
                }
                case 1: {
                    number = BoxesRunTime.boxToDouble((double)this.xmin());
                    break;
                }
                case 0: {
                    number = BoxesRunTime.boxToInteger((int)this.i());
                }
            }
            return number;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ArrowPointBBox;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.i());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.xmin()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.ymin()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.xmax()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.ymax()));
            return Statics.finalizeHash((int)n, (int)5);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ArrowPointBBox)) return false;
            boolean bl = true;
            if (!bl) return false;
            ArrowPointBBox arrowPointBBox = (ArrowPointBBox)x$1;
            if (this.i() != arrowPointBBox.i()) return false;
            if (this.xmin() != arrowPointBBox.xmin()) return false;
            if (this.ymin() != arrowPointBBox.ymin()) return false;
            if (this.xmax() != arrowPointBBox.xmax()) return false;
            if (this.ymax() != arrowPointBBox.ymax()) return false;
            if (!arrowPointBBox.canEqual(this)) return false;
            return true;
        }

        public ArrowPointBBox(int i, double xmin, double ymin, double xmax, double ymax) {
            this.i = i;
            this.xmin = xmin;
            this.ymin = ymin;
            this.xmax = xmax;
            this.ymax = ymax;
            Product.class.$init$((Product)this);
        }
    }

    public static class ArrowBetweenDate
    implements Filter,
    Product,
    Serializable {
        private final int i;
        private final long lower;
        private final long upper;

        public int i() {
            return this.i;
        }

        public long lower() {
            return this.lower;
        }

        public long upper() {
            return this.upper;
        }

        public Object accept(FilterVisitor visitor, Object extraData) {
            return extraData;
        }

        public boolean evaluate(Object o) {
            ArrowSimpleFeature arrow = (ArrowSimpleFeature)o;
            long time = ((ArrowAttributeReader.ArrowDateReader)arrow.getReader(this.i())).getTime(arrow.getIndex());
            return time >= this.lower() && time <= this.upper();
        }

        public ArrowBetweenDate copy(int i, long lower, long upper) {
            return new ArrowBetweenDate(i, lower, upper);
        }

        public int copy$default$1() {
            return this.i();
        }

        public long copy$default$2() {
            return this.lower();
        }

        public long copy$default$3() {
            return this.upper();
        }

        public String productPrefix() {
            return "ArrowBetweenDate";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Number number;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 2: {
                    number = BoxesRunTime.boxToLong((long)this.upper());
                    break;
                }
                case 1: {
                    number = BoxesRunTime.boxToLong((long)this.lower());
                    break;
                }
                case 0: {
                    number = BoxesRunTime.boxToInteger((int)this.i());
                }
            }
            return number;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ArrowBetweenDate;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.i());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.lower()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.upper()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ArrowBetweenDate)) return false;
            boolean bl = true;
            if (!bl) return false;
            ArrowBetweenDate arrowBetweenDate = (ArrowBetweenDate)x$1;
            if (this.i() != arrowBetweenDate.i()) return false;
            if (this.lower() != arrowBetweenDate.lower()) return false;
            if (this.upper() != arrowBetweenDate.upper()) return false;
            if (!arrowBetweenDate.canEqual(this)) return false;
            return true;
        }

        public ArrowBetweenDate(int i, long lower, long upper) {
            this.i = i;
            this.lower = lower;
            this.upper = upper;
            Product.class.$init$((Product)this);
        }
    }

    public static class ArrowLineStringBBox
    implements Filter,
    Product,
    Serializable {
        private final int i;
        private final double xmin;
        private final double ymin;
        private final double xmax;
        private final double ymax;
        private final ReferencedEnvelope bboxEnvelope;
        private final Geometry bbox;

        public int i() {
            return this.i;
        }

        public double xmin() {
            return this.xmin;
        }

        public double ymin() {
            return this.ymin;
        }

        public double xmax() {
            return this.xmax;
        }

        public double ymax() {
            return this.ymax;
        }

        private ReferencedEnvelope bboxEnvelope() {
            return this.bboxEnvelope;
        }

        private Geometry bbox() {
            return this.bbox;
        }

        public Object accept(FilterVisitor visitor, Object extraData) {
            return extraData;
        }

        public boolean evaluate(Object o) {
            ArrowSimpleFeature arrow = (ArrowSimpleFeature)o;
            ArrowAttributeReader.ArrowLineStringReader reader = (ArrowAttributeReader.ArrowLineStringReader)arrow.getReader(this.i());
            Tuple2<Object, Object> tuple2 = reader.readOffsets(arrow.getIndex());
            if (tuple2 != null) {
                Tuple2.mcII.sp sp2;
                int start = tuple2._1$mcI$sp();
                int end = tuple2._2$mcI$sp();
                Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(start, end);
                int start2 = sp3._1$mcI$sp();
                int end2 = sp3._2$mcI$sp();
                Coordinate[] points = (Coordinate[])Array$.MODULE$.ofDim(2, ClassTag$.MODULE$.apply(Coordinate.class));
                for (int offset = start2; offset < end2; ++offset) {
                    LineString line;
                    double y = reader.readPointY(offset);
                    if (!(y >= this.ymin()) || !(y <= this.ymax())) continue;
                    double x = reader.readPointX(offset);
                    if (x >= this.xmin() && x <= this.xmax()) {
                        return true;
                    }
                    points[1] = points[0];
                    points[0] = new Coordinate(x, y);
                    if (offset <= start2 || !(line = GeometryVector.factory.createLineString(points)).getEnvelopeInternal().intersects((Envelope)this.bboxEnvelope()) || !line.intersects(this.bbox())) continue;
                    return true;
                }
                return false;
            }
            throw new MatchError(tuple2);
        }

        public ArrowLineStringBBox copy(int i, double xmin, double ymin, double xmax, double ymax) {
            return new ArrowLineStringBBox(i, xmin, ymin, xmax, ymax);
        }

        public int copy$default$1() {
            return this.i();
        }

        public double copy$default$2() {
            return this.xmin();
        }

        public double copy$default$3() {
            return this.ymin();
        }

        public double copy$default$4() {
            return this.xmax();
        }

        public double copy$default$5() {
            return this.ymax();
        }

        public String productPrefix() {
            return "ArrowLineStringBBox";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            Number number;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 4: {
                    number = BoxesRunTime.boxToDouble((double)this.ymax());
                    break;
                }
                case 3: {
                    number = BoxesRunTime.boxToDouble((double)this.xmax());
                    break;
                }
                case 2: {
                    number = BoxesRunTime.boxToDouble((double)this.ymin());
                    break;
                }
                case 1: {
                    number = BoxesRunTime.boxToDouble((double)this.xmin());
                    break;
                }
                case 0: {
                    number = BoxesRunTime.boxToInteger((int)this.i());
                }
            }
            return number;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ArrowLineStringBBox;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.i());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.xmin()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.ymin()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.xmax()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.ymax()));
            return Statics.finalizeHash((int)n, (int)5);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ArrowLineStringBBox)) return false;
            boolean bl = true;
            if (!bl) return false;
            ArrowLineStringBBox arrowLineStringBBox = (ArrowLineStringBBox)x$1;
            if (this.i() != arrowLineStringBBox.i()) return false;
            if (this.xmin() != arrowLineStringBBox.xmin()) return false;
            if (this.ymin() != arrowLineStringBBox.ymin()) return false;
            if (this.xmax() != arrowLineStringBBox.xmax()) return false;
            if (this.ymax() != arrowLineStringBBox.ymax()) return false;
            if (!arrowLineStringBBox.canEqual(this)) return false;
            return true;
        }

        public ArrowLineStringBBox(int i, double xmin, double ymin, double xmax, double ymax) {
            this.i = i;
            this.xmin = xmin;
            this.ymin = ymin;
            this.xmax = xmax;
            this.ymax = ymax;
            Product.class.$init$((Product)this);
            this.bboxEnvelope = new ReferencedEnvelope(xmin, xmax, ymin, ymax, package$.MODULE$.CRS_EPSG_4326());
            this.bbox = GeometryVector.factory.toGeometry((Envelope)this.bboxEnvelope());
        }
    }

    public static class ArrowDictionaryEquals
    implements Filter,
    Product,
    Serializable {
        private final int i;
        private final int value;

        public int i() {
            return this.i;
        }

        public int value() {
            return this.value;
        }

        public Object accept(FilterVisitor visitor, Object extraData) {
            return extraData;
        }

        public boolean evaluate(Object o) {
            ArrowSimpleFeature arrow = (ArrowSimpleFeature)o;
            return ((ArrowDictionaryReader)arrow.getReader(this.i())).getEncoded(arrow.getIndex()) == this.value();
        }

        public ArrowDictionaryEquals copy(int i, int value) {
            return new ArrowDictionaryEquals(i, value);
        }

        public int copy$default$1() {
            return this.i();
        }

        public int copy$default$2() {
            return this.value();
        }

        public String productPrefix() {
            return "ArrowDictionaryEquals";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Integer n;
            int n2 = x$1;
            switch (n2) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    n = BoxesRunTime.boxToInteger((int)this.value());
                    break;
                }
                case 0: {
                    n = BoxesRunTime.boxToInteger((int)this.i());
                }
            }
            return n;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ArrowDictionaryEquals;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.i());
            n = Statics.mix((int)n, (int)this.value());
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ArrowDictionaryEquals)) return false;
            boolean bl = true;
            if (!bl) return false;
            ArrowDictionaryEquals arrowDictionaryEquals = (ArrowDictionaryEquals)x$1;
            if (this.i() != arrowDictionaryEquals.i()) return false;
            if (this.value() != arrowDictionaryEquals.value()) return false;
            if (!arrowDictionaryEquals.canEqual(this)) return false;
            return true;
        }

        public ArrowDictionaryEquals(int i, int value) {
            this.i = i;
            this.value = value;
            Product.class.$init$((Product)this);
        }
    }
}

