/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.vector;

import com.vividsolutions.jts.geom.Geometry;
import io.netty.buffer.ArrowBuf;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.NullableBigIntVector;
import org.apache.arrow.vector.NullableBitVector;
import org.apache.arrow.vector.NullableFloat4Vector;
import org.apache.arrow.vector.NullableFloat8Vector;
import org.apache.arrow.vector.NullableIntVector;
import org.apache.arrow.vector.NullableSmallIntVector;
import org.apache.arrow.vector.NullableTinyIntVector;
import org.apache.arrow.vector.NullableVarBinaryVector;
import org.apache.arrow.vector.NullableVarCharVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.NullableMapVector;
import org.apache.arrow.vector.complex.writer.BaseWriter;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.locationtech.geomesa.arrow.package;
import org.locationtech.geomesa.arrow.vector.ArrowAttributeWriter;
import org.locationtech.geomesa.arrow.vector.ArrowAttributeWriter$ArrowNoopWriter$;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector$;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector$EncodingPrecision$;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector$SimpleFeatureEncoding$;
import org.locationtech.geomesa.features.serialization.ObjectType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.text.WKTUtils$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ArrowAttributeWriter$ {
    public static final ArrowAttributeWriter$ MODULE$;

    static {
        new ArrowAttributeWriter$();
    }

    public ArrowAttributeWriter id(NullableMapVector vector, boolean includeFids, BufferAllocator allocator) {
        ArrowAttributeWriter arrowAttributeWriter;
        if (includeFids) {
            String name = SimpleFeatureVector$.MODULE$.FeatureIdField();
            arrowAttributeWriter = this.apply(name, (Seq<Enumeration.Value>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{ObjectType$.MODULE$.STRING()}))), String.class, vector, (Option<ArrowDictionary>)None$.MODULE$, (Map<String, String>)Predef$.MODULE$.Map().empty(), null, allocator);
        } else {
            arrowAttributeWriter = ArrowAttributeWriter$ArrowNoopWriter$.MODULE$;
        }
        return arrowAttributeWriter;
    }

    public Seq<ArrowAttributeWriter> apply(SimpleFeatureType sft, NullableMapVector vector, Map<String, ArrowDictionary> dictionaries, SimpleFeatureVector.SimpleFeatureEncoding encoding, BufferAllocator allocator) {
        return (Seq)JavaConversions$.MODULE$.asScalaBuffer(sft.getAttributeDescriptors()).map((Function1)new Serializable(sft, vector, dictionaries, encoding, allocator){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;
            private final NullableMapVector vector$1;
            private final Map dictionaries$1;
            private final SimpleFeatureVector.SimpleFeatureEncoding encoding$1;
            private final BufferAllocator allocator$1;

            public final ArrowAttributeWriter apply(AttributeDescriptor descriptor) {
                String name = descriptor.getLocalName();
                Map metadata = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SimpleFeatureVector$.MODULE$.DescriptorKey()), (Object)SimpleFeatureTypes$.MODULE$.encodeDescriptor(this.sft$1, descriptor))}));
                Class classBinding = descriptor.getType().getBinding();
                Tuple2 tuple2 = ObjectType$.MODULE$.selectType(classBinding, descriptor.getUserData());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    Enumeration.Value objectType = (Enumeration.Value)tuple2._1();
                    Seq bindings = (Seq)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)objectType, (Object)bindings);
                    Enumeration.Value objectType2 = (Enumeration.Value)tuple23._1();
                    Seq bindings2 = (Seq)tuple23._2();
                    Option dictionary = this.dictionaries$1.get((Object)name);
                    return ArrowAttributeWriter$.MODULE$.apply(name, (Seq<Enumeration.Value>)((Seq)bindings2.$plus$colon((Object)objectType2, Seq$.MODULE$.canBuildFrom())), classBinding, this.vector$1, (Option<ArrowDictionary>)dictionary, (Map<String, String>)metadata, this.encoding$1, this.allocator$1);
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.sft$1 = sft$1;
                this.vector$1 = vector$1;
                this.dictionaries$1 = dictionaries$1;
                this.encoding$1 = encoding$1;
                this.allocator$1 = allocator$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    public ArrowAttributeWriter apply(String name, Seq<Enumeration.Value> bindings, Class<?> classBinding, NullableMapVector vector, Option<ArrowDictionary> dictionary, Map<String, String> metadata, SimpleFeatureVector.SimpleFeatureEncoding encoding, BufferAllocator allocator) {
        Option<ArrowDictionary> option;
        block25: {
            ArrowAttributeWriter arrowAttributeWriter;
            block24: {
                ArrowDictionary.HasArrowDictionary hasArrowDictionary;
                block9: {
                    block23: {
                        ArrowAttributeWriter arrowAttributeWriter2;
                        block11: {
                            Enumeration.Value value;
                            block22: {
                                block21: {
                                    block20: {
                                        block19: {
                                            block18: {
                                                block17: {
                                                    block16: {
                                                        block15: {
                                                            block14: {
                                                                block13: {
                                                                    block12: {
                                                                        ArrowAttributeWriter arrowAttributeWriter3;
                                                                        block10: {
                                                                            option = dictionary;
                                                                            if (!None$.MODULE$.equals(option)) break block9;
                                                                            value = (Enumeration.Value)bindings.head();
                                                                            Enumeration.Value value2 = ObjectType$.MODULE$.GEOMETRY();
                                                                            Enumeration.Value value3 = value;
                                                                            if (value2 != null ? !value2.equals(value3) : value3 != null) break block10;
                                                                            arrowAttributeWriter2 = new ArrowAttributeWriter.ArrowGeometryWriter(vector, name, classBinding, metadata, encoding.geometry());
                                                                            break block11;
                                                                        }
                                                                        Enumeration.Value value4 = ObjectType$.MODULE$.DATE();
                                                                        Enumeration.Value value5 = value;
                                                                        if (value4 != null ? !value4.equals(value5) : value5 != null) break block12;
                                                                        Enumeration.Value value6 = encoding.date();
                                                                        Enumeration.Value value7 = SimpleFeatureVector$EncodingPrecision$.MODULE$.Min();
                                                                        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                                                                            NullableIntVector child = this.ensureChildVector(vector, name, Types.MinorType.INT.getType(), NullableIntVector.class, metadata);
                                                                            arrowAttributeWriter3 = new ArrowAttributeWriter.ArrowDateSecondsWriter(child.getMutator());
                                                                        } else {
                                                                            NullableBigIntVector child = this.ensureChildVector(vector, name, Types.MinorType.BIGINT.getType(), NullableBigIntVector.class, metadata);
                                                                            arrowAttributeWriter3 = new ArrowAttributeWriter.ArrowDateMillisWriter(child.getMutator());
                                                                        }
                                                                        arrowAttributeWriter2 = arrowAttributeWriter3;
                                                                        break block11;
                                                                    }
                                                                    Enumeration.Value value8 = ObjectType$.MODULE$.STRING();
                                                                    Enumeration.Value value9 = value;
                                                                    if (value8 != null ? !value8.equals(value9) : value9 != null) break block13;
                                                                    NullableVarCharVector child = this.ensureChildVector(vector, name, Types.MinorType.VARCHAR.getType(), NullableVarCharVector.class, metadata);
                                                                    arrowAttributeWriter2 = new ArrowAttributeWriter.ArrowStringWriter(child.getMutator());
                                                                    break block11;
                                                                }
                                                                Enumeration.Value value10 = ObjectType$.MODULE$.INT();
                                                                Enumeration.Value value11 = value;
                                                                if (value10 != null ? !value10.equals(value11) : value11 != null) break block14;
                                                                NullableIntVector child = this.ensureChildVector(vector, name, Types.MinorType.INT.getType(), NullableIntVector.class, metadata);
                                                                arrowAttributeWriter2 = new ArrowAttributeWriter.ArrowIntWriter(child.getMutator());
                                                                break block11;
                                                            }
                                                            Enumeration.Value value12 = ObjectType$.MODULE$.LONG();
                                                            Enumeration.Value value13 = value;
                                                            if (value12 != null ? !value12.equals(value13) : value13 != null) break block15;
                                                            NullableBigIntVector child = this.ensureChildVector(vector, name, Types.MinorType.BIGINT.getType(), NullableBigIntVector.class, metadata);
                                                            arrowAttributeWriter2 = new ArrowAttributeWriter.ArrowLongWriter(child.getMutator());
                                                            break block11;
                                                        }
                                                        Enumeration.Value value14 = ObjectType$.MODULE$.FLOAT();
                                                        Enumeration.Value value15 = value;
                                                        if (value14 != null ? !value14.equals(value15) : value15 != null) break block16;
                                                        NullableFloat4Vector child = this.ensureChildVector(vector, name, Types.MinorType.FLOAT4.getType(), NullableFloat4Vector.class, metadata);
                                                        arrowAttributeWriter2 = new ArrowAttributeWriter.ArrowFloatWriter(child.getMutator());
                                                        break block11;
                                                    }
                                                    Enumeration.Value value16 = ObjectType$.MODULE$.DOUBLE();
                                                    Enumeration.Value value17 = value;
                                                    if (value16 != null ? !value16.equals(value17) : value17 != null) break block17;
                                                    NullableFloat8Vector child = this.ensureChildVector(vector, name, Types.MinorType.FLOAT8.getType(), NullableFloat8Vector.class, metadata);
                                                    arrowAttributeWriter2 = new ArrowAttributeWriter.ArrowDoubleWriter(child.getMutator());
                                                    break block11;
                                                }
                                                Enumeration.Value value18 = ObjectType$.MODULE$.BOOLEAN();
                                                Enumeration.Value value19 = value;
                                                if (value18 != null ? !value18.equals(value19) : value19 != null) break block18;
                                                NullableBitVector child = this.ensureChildVector(vector, name, Types.MinorType.BIT.getType(), NullableBitVector.class, metadata);
                                                arrowAttributeWriter2 = new ArrowAttributeWriter.ArrowBooleanWriter(child.getMutator());
                                                break block11;
                                            }
                                            Enumeration.Value value20 = ObjectType$.MODULE$.LIST();
                                            Enumeration.Value value21 = value;
                                            if (value20 != null ? !value20.equals(value21) : value21 != null) break block19;
                                            ListVector child = this.ensureChildVector(vector, name, Types.MinorType.LIST.getType(), ListVector.class, metadata);
                                            arrowAttributeWriter2 = new ArrowAttributeWriter.ArrowListWriter(vector.getWriter().list(name), (Enumeration.Value)bindings.apply(1), allocator);
                                            break block11;
                                        }
                                        Enumeration.Value value22 = ObjectType$.MODULE$.MAP();
                                        Enumeration.Value value23 = value;
                                        if (value22 != null ? !value22.equals(value23) : value23 != null) break block20;
                                        NullableMapVector child = this.ensureChildVector(vector, name, Types.MinorType.MAP.getType(), NullableMapVector.class, metadata);
                                        arrowAttributeWriter2 = new ArrowAttributeWriter.ArrowMapWriter(vector.getWriter().map(name), (Enumeration.Value)bindings.apply(1), (Enumeration.Value)bindings.apply(2), allocator);
                                        break block11;
                                    }
                                    Enumeration.Value value24 = ObjectType$.MODULE$.BYTES();
                                    Enumeration.Value value25 = value;
                                    if (value24 != null ? !value24.equals(value25) : value25 != null) break block21;
                                    NullableVarBinaryVector child = this.ensureChildVector(vector, name, Types.MinorType.VARBINARY.getType(), NullableVarBinaryVector.class, metadata);
                                    arrowAttributeWriter2 = new ArrowAttributeWriter.ArrowBytesWriter(child.getMutator());
                                    break block11;
                                }
                                Enumeration.Value value26 = ObjectType$.MODULE$.JSON();
                                Enumeration.Value value27 = value;
                                if (value26 != null ? !value26.equals(value27) : value27 != null) break block22;
                                NullableVarCharVector child = this.ensureChildVector(vector, name, Types.MinorType.VARCHAR.getType(), NullableVarCharVector.class, metadata);
                                arrowAttributeWriter2 = new ArrowAttributeWriter.ArrowStringWriter(child.getMutator());
                                break block11;
                            }
                            Enumeration.Value value28 = ObjectType$.MODULE$.UUID();
                            Enumeration.Value value29 = value;
                            if (value28 != null ? !value28.equals(value29) : value29 != null) break block23;
                            NullableVarCharVector child = this.ensureChildVector(vector, name, Types.MinorType.VARCHAR.getType(), NullableVarCharVector.class, metadata);
                            arrowAttributeWriter2 = new ArrowAttributeWriter.ArrowStringWriter(child.getMutator());
                        }
                        arrowAttributeWriter = arrowAttributeWriter2;
                        break block24;
                    }
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected object type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bindings.head()})));
                }
                if (!(option instanceof Some)) break block25;
                Some some = (Some)option;
                ArrowDictionary dict = (ArrowDictionary)some.x();
                DictionaryEncoding dictionaryEncoding = dict.encoding();
                package.TypeBindings dictionaryType = new package.TypeBindings(bindings, classBinding, encoding);
                if (dictionaryEncoding.getIndexType().getBitWidth() == 8) {
                    FieldType fieldType = new FieldType(true, Types.MinorType.TINYINT.getType(), dictionaryEncoding, JavaConversions$.MODULE$.mapAsJavaMap(metadata));
                    NullableTinyIntVector child = (NullableTinyIntVector)vector.addOrGet(name, fieldType, NullableTinyIntVector.class);
                    hasArrowDictionary = new ArrowAttributeWriter.ArrowDictionaryByteWriter(child.getMutator(), dict, dictionaryType);
                } else if (dictionaryEncoding.getIndexType().getBitWidth() == 16) {
                    FieldType fieldType = new FieldType(true, Types.MinorType.SMALLINT.getType(), dictionaryEncoding, JavaConversions$.MODULE$.mapAsJavaMap(metadata));
                    NullableSmallIntVector child = (NullableSmallIntVector)vector.addOrGet(name, fieldType, NullableSmallIntVector.class);
                    hasArrowDictionary = new ArrowAttributeWriter.ArrowDictionaryShortWriter(child.getMutator(), dict, dictionaryType);
                } else {
                    FieldType fieldType = new FieldType(true, Types.MinorType.INT.getType(), dictionaryEncoding, JavaConversions$.MODULE$.mapAsJavaMap(metadata));
                    NullableIntVector child = (NullableIntVector)vector.addOrGet(name, fieldType, NullableIntVector.class);
                    hasArrowDictionary = new ArrowAttributeWriter.ArrowDictionaryIntWriter(child.getMutator(), dict, dictionaryType);
                }
                arrowAttributeWriter = hasArrowDictionary;
            }
            return arrowAttributeWriter;
        }
        throw new MatchError(option);
    }

    public SimpleFeatureVector.SimpleFeatureEncoding apply$default$4() {
        return SimpleFeatureVector$SimpleFeatureEncoding$.MODULE$.min(false);
    }

    private <T extends FieldVector> T ensureChildVector(NullableMapVector vector, String name, ArrowType arrowType, Class<T> clazz, Map<String, String> metadata) {
        FieldVector child = vector.getChild(name);
        if (child == null) {
            child = vector.addOrGet(name, new FieldType(true, arrowType, null, JavaConversions$.MODULE$.mapAsJavaMap(metadata)), clazz);
            child.allocateNew();
        }
        return (T)child;
    }

    public Function1<Object, BoxedUnit> org$locationtech$geomesa$arrow$vector$ArrowAttributeWriter$$toListWriter(BaseWriter.ListWriter writer, Enumeration.Value binding, BufferAllocator allocator) {
        block12: {
            Object object;
            block4: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block6: {
                                        block5: {
                                            block3: {
                                                block2: {
                                                    Enumeration.Value value = binding;
                                                    Enumeration.Value value2 = ObjectType$.MODULE$.STRING();
                                                    if (!(value == null ? value2 != null : !value.equals(value2))) break block2;
                                                    Enumeration.Value value3 = binding;
                                                    Enumeration.Value value4 = ObjectType$.MODULE$.JSON();
                                                    if (!(value3 == null ? value4 != null : !value3.equals(value4))) break block2;
                                                    Enumeration.Value value5 = binding;
                                                    Enumeration.Value value6 = ObjectType$.MODULE$.UUID();
                                                    if (value5 != null ? !value5.equals(value6) : value6 != null) break block3;
                                                }
                                                object = new Serializable(writer, allocator){
                                                    public static final long serialVersionUID = 0L;
                                                    private final BaseWriter.ListWriter writer$1;
                                                    private final BufferAllocator allocator$2;

                                                    public final void apply(Object value) {
                                                        if (value != null) {
                                                            byte[] bytes = value.toString().getBytes(StandardCharsets.UTF_8);
                                                            ArrowBuf buffer = this.allocator$2.buffer(bytes.length);
                                                            buffer.setBytes(0, bytes);
                                                            this.writer$1.varChar().writeVarChar(0, bytes.length, buffer);
                                                            buffer.close();
                                                        }
                                                    }
                                                    {
                                                        this.writer$1 = writer$1;
                                                        this.allocator$2 = allocator$2;
                                                    }
                                                };
                                                break block4;
                                            }
                                            Enumeration.Value value = binding;
                                            Enumeration.Value value7 = ObjectType$.MODULE$.INT();
                                            if (value != null ? !value.equals(value7) : value7 != null) break block5;
                                            object = new Serializable(writer){
                                                public static final long serialVersionUID = 0L;
                                                private final BaseWriter.ListWriter writer$1;

                                                public final void apply(Object value) {
                                                    if (value != null) {
                                                        this.writer$1.integer().writeInt(BoxesRunTime.unboxToInt((Object)value));
                                                    }
                                                }
                                                {
                                                    this.writer$1 = writer$1;
                                                }
                                            };
                                            break block4;
                                        }
                                        Enumeration.Value value = binding;
                                        Enumeration.Value value8 = ObjectType$.MODULE$.LONG();
                                        if (value != null ? !value.equals(value8) : value8 != null) break block6;
                                        object = new Serializable(writer){
                                            public static final long serialVersionUID = 0L;
                                            private final BaseWriter.ListWriter writer$1;

                                            public final void apply(Object value) {
                                                if (value != null) {
                                                    this.writer$1.bigInt().writeBigInt(BoxesRunTime.unboxToLong((Object)value));
                                                }
                                            }
                                            {
                                                this.writer$1 = writer$1;
                                            }
                                        };
                                        break block4;
                                    }
                                    Enumeration.Value value = binding;
                                    Enumeration.Value value9 = ObjectType$.MODULE$.FLOAT();
                                    if (value != null ? !value.equals(value9) : value9 != null) break block7;
                                    object = new Serializable(writer){
                                        public static final long serialVersionUID = 0L;
                                        private final BaseWriter.ListWriter writer$1;

                                        public final void apply(Object value) {
                                            if (value != null) {
                                                this.writer$1.float4().writeFloat4(BoxesRunTime.unboxToFloat((Object)value));
                                            }
                                        }
                                        {
                                            this.writer$1 = writer$1;
                                        }
                                    };
                                    break block4;
                                }
                                Enumeration.Value value = binding;
                                Enumeration.Value value10 = ObjectType$.MODULE$.DOUBLE();
                                if (value != null ? !value.equals(value10) : value10 != null) break block8;
                                object = new Serializable(writer){
                                    public static final long serialVersionUID = 0L;
                                    private final BaseWriter.ListWriter writer$1;

                                    public final void apply(Object value) {
                                        if (value != null) {
                                            this.writer$1.float8().writeFloat8(BoxesRunTime.unboxToDouble((Object)value));
                                        }
                                    }
                                    {
                                        this.writer$1 = writer$1;
                                    }
                                };
                                break block4;
                            }
                            Enumeration.Value value = binding;
                            Enumeration.Value value11 = ObjectType$.MODULE$.BOOLEAN();
                            if (value != null ? !value.equals(value11) : value11 != null) break block9;
                            object = new Serializable(writer){
                                public static final long serialVersionUID = 0L;
                                private final BaseWriter.ListWriter writer$1;

                                public final void apply(Object value) {
                                    if (value != null) {
                                        this.writer$1.bit().writeBit(BoxesRunTime.unboxToBoolean((Object)value) ? 1 : 0);
                                    }
                                }
                                {
                                    this.writer$1 = writer$1;
                                }
                            };
                            break block4;
                        }
                        Enumeration.Value value = binding;
                        Enumeration.Value value12 = ObjectType$.MODULE$.DATE();
                        if (value != null ? !value.equals(value12) : value12 != null) break block10;
                        object = new Serializable(writer){
                            public static final long serialVersionUID = 0L;
                            private final BaseWriter.ListWriter writer$1;

                            public final void apply(Object value) {
                                if (value != null) {
                                    this.writer$1.dateMilli().writeDateMilli(((Date)value).getTime());
                                }
                            }
                            {
                                this.writer$1 = writer$1;
                            }
                        };
                        break block4;
                    }
                    Enumeration.Value value = binding;
                    Enumeration.Value value13 = ObjectType$.MODULE$.GEOMETRY();
                    if (value != null ? !value.equals(value13) : value13 != null) break block11;
                    object = new Serializable(writer, allocator){
                        public static final long serialVersionUID = 0L;
                        private final BaseWriter.ListWriter writer$1;
                        private final BufferAllocator allocator$2;

                        public final void apply(Object value) {
                            if (value != null) {
                                byte[] bytes = WKTUtils$.MODULE$.write((Geometry)value).getBytes(StandardCharsets.UTF_8);
                                ArrowBuf buffer = this.allocator$2.buffer(bytes.length);
                                buffer.setBytes(0, bytes);
                                this.writer$1.varChar().writeVarChar(0, bytes.length, buffer);
                                buffer.close();
                            }
                        }
                        {
                            this.writer$1 = writer$1;
                            this.allocator$2 = allocator$2;
                        }
                    };
                    break block4;
                }
                Enumeration.Value value = binding;
                Enumeration.Value value14 = ObjectType$.MODULE$.BYTES();
                if (value != null ? !value.equals(value14) : value14 != null) break block12;
                object = new Serializable(writer, allocator){
                    public static final long serialVersionUID = 0L;
                    private final BaseWriter.ListWriter writer$1;
                    private final BufferAllocator allocator$2;

                    public final void apply(Object value) {
                        if (value != null) {
                            byte[] bytes = (byte[])value;
                            ArrowBuf buffer = this.allocator$2.buffer(bytes.length);
                            buffer.setBytes(0, bytes);
                            this.writer$1.varBinary().writeVarBinary(0, bytes.length, buffer);
                            buffer.close();
                        }
                    }
                    {
                        this.writer$1 = writer$1;
                        this.allocator$2 = allocator$2;
                    }
                };
            }
            return object;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected list object type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{binding})));
    }

    private ArrowAttributeWriter$() {
        MODULE$ = this;
    }
}

