/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.impl.PackedCoordinateSequenceFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.vector.VectorProcess;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.ProgressListener;

@DescribeProcess(title="Point Stacker", description="Aggregates a collection of points over a grid into one point per grid cell.")
public class PointStackerProcess
implements VectorProcess {
    public static final String ATTR_GEOM = "geom";
    public static final String ATTR_COUNT = "count";
    public static final String ATTR_COUNT_UNIQUE = "countunique";
    public static final String ATTR_NORM_COUNT = "normCount";
    public static final String ATTR_NORM_COUNT_UNIQUE = "normCountUnique";

    @DescribeResult(name="result", description="Aggregated feature collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="data", description="Input feature collection") SimpleFeatureCollection data, @DescribeParameter(name="cellSize", description="Grid cell size to aggregate to, in pixels") Integer cellSize, @DescribeParameter(name="normalize", description="Indicates whether to add fields normalized to the range 0-1.", defaultValue="false") Boolean argNormalize, @DescribeParameter(name="preserveLocation", description="Indicates wheter to preserve the original location of points for single/superimposed points", defaultValue="Never", min=0) PreserveLocation preserveLocation, @DescribeParameter(name="outputBBOX", description="Bounding box for target image extent") ReferencedEnvelope outputEnv, @DescribeParameter(name="outputWidth", description="Target image width in pixels", minValue=1.0) Integer outputWidth, @DescribeParameter(name="outputHeight", description="Target image height in pixels", minValue=1.0) Integer outputHeight, ProgressListener monitor) throws ProcessException, TransformException {
        CoordinateReferenceSystem srcCRS = ((SimpleFeatureType)data.getSchema()).getCoordinateReferenceSystem();
        CoordinateReferenceSystem dstCRS = outputEnv.getCoordinateReferenceSystem();
        MathTransform crsTransform = null;
        MathTransform invTransform = null;
        try {
            crsTransform = CRS.findMathTransform((CoordinateReferenceSystem)srcCRS, (CoordinateReferenceSystem)dstCRS);
            invTransform = crsTransform.inverse();
        }
        catch (FactoryException e) {
            throw new ProcessException(e);
        }
        boolean normalize = false;
        if (argNormalize != null) {
            normalize = argNormalize;
        }
        double cellSizeSrc = (double)cellSize.intValue() * outputEnv.getWidth() / (double)outputWidth.intValue();
        Collection<StackedPoint> stackedPts = this.stackPoints(data, crsTransform, cellSizeSrc, outputEnv.getMinX(), outputEnv.getMinY());
        SimpleFeatureType schema = this.createType(srcCRS, normalize);
        ListFeatureCollection result = new ListFeatureCollection(schema);
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(schema);
        GeometryFactory factory = new GeometryFactory(new PackedCoordinateSequenceFactory());
        double[] srcPt = new double[2];
        double[] dstPt = new double[2];
        int maxCount = 0;
        int maxCountUnique = 0;
        if (normalize) {
            for (StackedPoint sp : stackedPts) {
                if (maxCount < sp.getCount()) {
                    maxCount = sp.getCount();
                }
                if (maxCountUnique >= sp.getCount()) continue;
                maxCountUnique = sp.getCountUnique();
            }
        }
        for (StackedPoint sp : stackedPts) {
            Coordinate pt = this.getStackedPointLocation(preserveLocation, sp);
            srcPt[0] = pt.x;
            srcPt[1] = pt.y;
            invTransform.transform(srcPt, 0, dstPt, 0, 1);
            Coordinate psrc = new Coordinate(dstPt[0], dstPt[1]);
            Point point = factory.createPoint(psrc);
            fb.add((Object)point);
            fb.add((Object)sp.getCount());
            fb.add((Object)sp.getCountUnique());
            if (normalize) {
                fb.add((Object)((double)sp.getCount() / (double)maxCount));
                fb.add((Object)((double)sp.getCountUnique() / (double)maxCountUnique));
            }
            result.add(fb.buildFeature(null));
        }
        return result;
    }

    private Coordinate getStackedPointLocation(PreserveLocation preserveLocation, StackedPoint sp) {
        Coordinate pt = null;
        if (PreserveLocation.Single == preserveLocation) {
            if (sp.getCount() == 1) {
                pt = sp.getOriginalLocation();
            }
        } else if (PreserveLocation.Superimposed == preserveLocation && sp.getCountUnique() == 1) {
            pt = sp.getOriginalLocation();
        }
        if (pt == null) {
            pt = sp.getLocation();
        }
        return pt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<StackedPoint> stackPoints(SimpleFeatureCollection data, MathTransform crsTransform, double cellSize, double minX, double minY) throws TransformException {
        SimpleFeatureIterator featureIt = data.features();
        HashMap<Coordinate, StackedPoint> stackedPts = new HashMap<Coordinate, StackedPoint>();
        double[] srcPt = new double[2];
        double[] dstPt = new double[2];
        Coordinate indexPt = new Coordinate();
        try {
            while (featureIt.hasNext()) {
                SimpleFeature feature = (SimpleFeature)featureIt.next();
                Geometry geom = (Geometry)feature.getDefaultGeometry();
                Coordinate p = PointStackerProcess.getRepresentativePoint(geom);
                srcPt[0] = p.x;
                srcPt[1] = p.y;
                crsTransform.transform(srcPt, 0, dstPt, 0, 1);
                Coordinate pout = new Coordinate(dstPt[0], dstPt[1]);
                indexPt.x = pout.x;
                indexPt.y = pout.y;
                this.gridIndex(indexPt, cellSize);
                StackedPoint stkPt = (StackedPoint)stackedPts.get(indexPt);
                if (stkPt == null) {
                    double centreX = indexPt.x * cellSize + cellSize / 2.0;
                    double centreY = indexPt.y * cellSize + cellSize / 2.0;
                    stkPt = new StackedPoint(indexPt, new Coordinate(centreX, centreY));
                    stackedPts.put(stkPt.getKey(), stkPt);
                }
                stkPt.add(pout);
            }
        }
        finally {
            featureIt.close();
        }
        return stackedPts.values();
    }

    private static Coordinate getRepresentativePoint(Geometry g) {
        if (g.getNumPoints() == 1) {
            return g.getCoordinate();
        }
        return g.getCentroid().getCoordinate();
    }

    private void gridIndex(Coordinate griddedPt, double cellSize) {
        long ix = (long)(griddedPt.x / cellSize);
        long iy = (long)(griddedPt.y / cellSize);
        griddedPt.x = ix;
        griddedPt.y = iy;
    }

    private SimpleFeatureType createType(CoordinateReferenceSystem crs, boolean stretch) {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.add(ATTR_GEOM, Point.class, crs);
        tb.add(ATTR_COUNT, Integer.class);
        tb.add(ATTR_COUNT_UNIQUE, Integer.class);
        if (stretch) {
            tb.add(ATTR_NORM_COUNT, Double.class);
            tb.add(ATTR_NORM_COUNT_UNIQUE, Double.class);
        }
        tb.setName("stackedPoint");
        SimpleFeatureType sfType = tb.buildFeatureType();
        return sfType;
    }

    private static class StackedPoint {
        private Coordinate key;
        private Coordinate centerPt;
        private Coordinate location = null;
        private int count = 0;
        private Set<Coordinate> uniquePts;

        public StackedPoint(Coordinate key, Coordinate centerPt) {
            this.key = new Coordinate(key);
            this.centerPt = centerPt;
        }

        public Coordinate getKey() {
            return this.key;
        }

        public Coordinate getLocation() {
            return this.location;
        }

        public int getCount() {
            return this.count;
        }

        public int getCountUnique() {
            if (this.uniquePts == null) {
                return 1;
            }
            return this.uniquePts.size();
        }

        public void add(Coordinate pt) {
            ++this.count;
            if (this.uniquePts == null) {
                this.uniquePts = new HashSet<Coordinate>();
            }
            this.uniquePts.add(pt);
            this.pickNearestLocation(pt);
        }

        public Coordinate getOriginalLocation() {
            if (this.uniquePts != null && this.uniquePts.size() == 1) {
                return this.uniquePts.iterator().next();
            }
            return null;
        }

        private void pickNearestLocation(Coordinate pt) {
            if (this.location == null) {
                this.location = StackedPoint.average(this.centerPt, pt);
                return;
            }
            if (pt.distance(this.centerPt) < this.location.distance(this.centerPt)) {
                this.location = StackedPoint.average(this.centerPt, pt);
            }
        }

        private void pickCenterLocation(Coordinate pt) {
            if (this.location == null) {
                this.location = new Coordinate(pt);
                return;
            }
            this.location = this.centerPt;
        }

        private void pickFirstLocation(Coordinate pt) {
            if (this.location == null) {
                this.location = new Coordinate(pt);
            }
        }

        private static Coordinate average(Coordinate p1, Coordinate p2) {
            double x = (p1.x + p2.x) / 2.0;
            double y = (p1.y + p2.y) / 2.0;
            return new Coordinate(x, y);
        }
    }

    public static enum PreserveLocation {
        Single,
        Superimposed,
        Never;

    }
}

