/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.filters;

import java.io.Serializable;
import org.locationtech.geomesa.index.filters.Z3Filter$;
import org.locationtech.sfcurve.zorder.Z3$;
import scala.Function2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001B\u0001\u0003\u00015\u0011\u0001BW\u001aGS2$XM\u001d\u0006\u0003\u0007\u0011\tqAZ5mi\u0016\u00148O\u0003\u0002\u0006\r\u0005)\u0011N\u001c3fq*\u0011q\u0001C\u0001\bO\u0016|W.Z:b\u0015\tI!\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005UQR\"\u0001\f\u000b\u0005]A\u0012AA5p\u0015\u0005I\u0012\u0001\u00026bm\u0006L!a\u0007\f\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011u\u0001!Q1A\u0005\u0002y\ta\u0001_=wC2\u001cX#A\u0010\u0011\u0007=\u0001#%\u0003\u0002\"!\t)\u0011I\u001d:bsB\u0019q\u0002I\u0012\u0011\u0005=!\u0013BA\u0013\u0011\u0005\rIe\u000e\u001e\u0005\tO\u0001\u0011\t\u0011)A\u0005?\u00059\u00010\u001f<bYN\u0004\u0003\u0002C\u0015\u0001\u0005\u000b\u0007I\u0011\u0001\u0016\u0002\u000bQ4\u0018\r\\:\u0016\u0003-\u00022a\u0004\u0011 \u0011!i\u0003A!A!\u0002\u0013Y\u0013A\u0002;wC2\u001c\b\u0005\u0003\u00050\u0001\t\u0015\r\u0011\"\u00011\u0003!i\u0017N\\#q_\u000eDW#A\u0019\u0011\u0005=\u0011\u0014BA\u001a\u0011\u0005\u0015\u0019\u0006n\u001c:u\u0011!)\u0004A!A!\u0002\u0013\t\u0014!C7j]\u0016\u0003xn\u00195!\u0011!9\u0004A!b\u0001\n\u0003\u0001\u0014\u0001C7bq\u0016\u0003xn\u00195\t\u0011e\u0002!\u0011!Q\u0001\nE\n\u0011\"\\1y\u000bB|7\r\u001b\u0011\t\u0011m\u0002!Q1A\u0005\u0002q\nqA\u001f'f]\u001e$\b.F\u0001$\u0011!q\u0004A!A!\u0002\u0013\u0019\u0013\u0001\u0003>MK:<G\u000f\u001b\u0011\t\u000b\u0001\u0003A\u0011A!\u0002\rqJg.\u001b;?)\u0019\u0011E)\u0012$H\u0011B\u00111\tA\u0007\u0002\u0005!)Qd\u0010a\u0001?!)\u0011f\u0010a\u0001W!)qf\u0010a\u0001c!)qg\u0010a\u0001c!)1h\u0010a\u0001G!9!\n\u0001b\u0001\n\u0003Y\u0015A\u0002:poR{',F\u0001M!\u0015yQjT\u0012T\u0013\tq\u0005CA\u0005Gk:\u001cG/[8oeA\u0019q\u0002\t)\u0011\u0005=\t\u0016B\u0001*\u0011\u0005\u0011\u0011\u0015\u0010^3\u0011\u0005=!\u0016BA+\u0011\u0005\u0011auN\\4\t\r]\u0003\u0001\u0015!\u0003M\u0003\u001d\u0011xn\u001e+p5\u0002BQ!\u0017\u0001\u0005\u0002i\u000b\u0001\"\u001b8C_VtGm\u001d\u000b\u00047z\u0003\u0007CA\b]\u0013\ti\u0006CA\u0004C_>dW-\u00198\t\u000b}C\u0006\u0019A(\u0002\u0007\t,h\rC\u0003b1\u0002\u00071%\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\u0006G\u0002!\t\u0001Z\u0001\u000ea>Lg\u000e^%o\u0005>,h\u000eZ:\u0015\u0005m+\u0007\"\u00024c\u0001\u0004\u0019\u0016!\u0001>\t\u000b!\u0004A\u0011A5\u0002\u0019QLW.Z%o\u0005>,h\u000eZ:\u0015\u0007mSG\u000eC\u0003lO\u0002\u0007\u0011'A\u0003fa>\u001c\u0007\u000eC\u0003gO\u0002\u00071kB\u0003o\u0005!\u0005q.\u0001\u0005[g\u0019KG\u000e^3s!\t\u0019\u0005OB\u0003\u0002\u0005!\u0005\u0011oE\u0002q\u001dI\u0004\"aD:\n\u0005m\u0001\u0002\"\u0002!q\t\u0003)H#A8\t\u000b]\u0004H\u0011\u0001=\u0002\u0013\u001d,GOU8x)>TFC\u0001'z\u0011\u0015Yd\u000f1\u0001$\u0011\u0015Y\b\u000f\"\u0003}\u0003\u001dQHk\u001c*pob\"2aU?\u0000\u0011\u0015q(\u00101\u0001P\u0003\u0005\u0011\u0007BBA\u0001u\u0002\u00071%A\u0001j\u0011\u001d\t)\u0001\u001dC\u0005\u0003\u000f\tqA\u001f+p%><H\u0007F\u0003T\u0003\u0013\tY\u0001\u0003\u0004\u007f\u0003\u0007\u0001\ra\u0014\u0005\b\u0003\u0003\t\u0019\u00011\u0001$\u0011\u001d\ty\u0001\u001dC\u0005\u0003#\tqA\u001f+p%><8\u0007F\u0003T\u0003'\t)\u0002\u0003\u0004\u007f\u0003\u001b\u0001\ra\u0014\u0005\b\u0003\u0003\ti\u00011\u0001$\u0011\u001d\tI\u0002\u001dC\u0001\u00037\t!B]8x)>,\u0005o\\2i)\u0015\t\u0014QDA\u0011\u0011\u001d\ty\"a\u0006A\u0002=\u000bQAY=uKNDa!YA\f\u0001\u0004\u0019\u0003bBA\u0013a\u0012\u0005\u0011qE\u0001\fi>\u0014\u0015\u0010^3BeJ\f\u0017\u0010F\u0002P\u0003SAq!a\u000b\u0002$\u0001\u0007!)A\u0001g\u0011\u001d\ty\u0003\u001dC\u0001\u0003c\tQB\u001a:p[\nKH/Z!se\u0006LHc\u0001\"\u00024!9\u0011QGA\u0017\u0001\u0004y\u0015!A1\t\u0013\u0005e\u0002/!A\u0005\n\u0005m\u0012a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!\u0010\u0011\t\u0005}\u0012QI\u0007\u0003\u0003\u0003R1!a\u0011\u0019\u0003\u0011a\u0017M\\4\n\t\u0005\u001d\u0013\u0011\t\u0002\u0007\u001f\nTWm\u0019;")
public class Z3Filter
implements Serializable {
    private final int[][] xyvals;
    private final int[][][] tvals;
    private final short minEpoch;
    private final short maxEpoch;
    private final int zLength;
    private final Function2<byte[], Object, Object> rowToZ;

    public static Z3Filter fromByteArray(byte[] byArray) {
        return Z3Filter$.MODULE$.fromByteArray(byArray);
    }

    public static byte[] toByteArray(Z3Filter z3Filter) {
        return Z3Filter$.MODULE$.toByteArray(z3Filter);
    }

    public static short rowToEpoch(byte[] byArray, int n) {
        return Z3Filter$.MODULE$.rowToEpoch(byArray, n);
    }

    public static Function2<byte[], Object, Object> getRowToZ(int n) {
        return Z3Filter$.MODULE$.getRowToZ(n);
    }

    public int[][] xyvals() {
        return this.xyvals;
    }

    public int[][][] tvals() {
        return this.tvals;
    }

    public short minEpoch() {
        return this.minEpoch;
    }

    public short maxEpoch() {
        return this.maxEpoch;
    }

    public int zLength() {
        return this.zLength;
    }

    public Function2<byte[], Object, Object> rowToZ() {
        return this.rowToZ;
    }

    public boolean inBounds(byte[] buf, int offset) {
        long keyZ = BoxesRunTime.unboxToLong((Object)this.rowToZ().apply((Object)buf, (Object)BoxesRunTime.boxToInteger((int)offset)));
        return this.pointInBounds(keyZ) && this.timeInBounds(Z3Filter$.MODULE$.rowToEpoch(buf, offset), keyZ);
    }

    public boolean pointInBounds(long z) {
        int x = Z3$.MODULE$.d0$extension(Z3$.MODULE$.apply(z));
        int y = Z3$.MODULE$.d1$extension(Z3$.MODULE$.apply(z));
        for (int i = 0; i < this.xyvals().length; ++i) {
            int[] xy = this.xyvals()[i];
            if (x < xy[0] || x > xy[2] || y < xy[1] || y > xy[3]) continue;
            return true;
        }
        return false;
    }

    public boolean timeInBounds(short epoch, long z) {
        boolean bl;
        if (epoch > this.maxEpoch() || epoch < this.minEpoch()) {
            bl = true;
        } else {
            int[][] times = this.tvals()[epoch - this.minEpoch()];
            if (times == null) {
                bl = true;
            } else {
                int t = Z3$.MODULE$.d2$extension(Z3$.MODULE$.apply(z));
                for (int i = 0; i < times.length; ++i) {
                    int[] time = times[i];
                    if (t < time[0] || t > time[1]) continue;
                    return true;
                }
                bl = false;
            }
        }
        return bl;
    }

    public Z3Filter(int[][] xyvals, int[][][] tvals, short minEpoch, short maxEpoch, int zLength) {
        this.xyvals = xyvals;
        this.tvals = tvals;
        this.minEpoch = minEpoch;
        this.maxEpoch = maxEpoch;
        this.zLength = zLength;
        this.rowToZ = Z3Filter$.MODULE$.getRowToZ(zLength);
    }
}

