/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index;

import com.google.common.primitives.Bytes;
import java.nio.charset.StandardCharsets;
import org.geotools.factory.Hints;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.index.api.FilterStrategy;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.index.conf.HexSplitter;
import org.locationtech.geomesa.index.conf.TableSplitter;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.index.IdIndex;
import org.locationtech.geomesa.index.strategies.IdFilterStrategy$;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.collection.mutable.WrappedArray;
import scala.runtime.BoxedUnit;

public abstract class IdIndex$class {
    public static boolean supports(IdIndex $this, SimpleFeatureType sft) {
        return true;
    }

    public static Function1 writer(IdIndex $this, SimpleFeatureType sft, GeoMesaDataStore ds) {
        byte[] sharing = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSharingBytes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
        return new Serializable($this, sharing){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IdIndex $outer;
            private final byte[] sharing$1;

            public final Seq<W> apply(F wf) {
                byte[] row = Bytes.concat((byte[][])new byte[][]{this.sharing$1, wf.idBytes()});
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.createInsert(row, wf)}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sharing$1 = (byte[])sharing$1;
            }
        };
    }

    public static Function1 remover(IdIndex $this, SimpleFeatureType sft, GeoMesaDataStore ds) {
        byte[] sharing = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSharingBytes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
        return new Serializable($this, sharing){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IdIndex $outer;
            private final byte[] sharing$2;

            public final Seq<W> apply(F wf) {
                byte[] row = Bytes.concat((byte[][])new byte[][]{this.sharing$2, wf.idBytes()});
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.createDelete(row, wf)}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sharing$2 = (byte[])sharing$2;
            }
        };
    }

    public static Function3 getIdFromRow(IdIndex $this, SimpleFeatureType sft) {
        return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isTableSharing$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)) ? new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(byte[] row, int offset, int length) {
                return new String(row, offset + 1, length - 1, StandardCharsets.UTF_8);
            }
        } : new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(byte[] row, int offset, int length) {
                return new String(row, offset, length, StandardCharsets.UTF_8);
            }
        };
    }

    public static Seq getSplits(IdIndex $this, SimpleFeatureType sft) {
        WrappedArray wrappedArray;
        TableSplitter splitter = (TableSplitter)((Class)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSplitter$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Class<HexSplitter> apply() {
                return HexSplitter.class;
            }
        })).newInstance();
        byte[][] splits = splitter.getSplits(JavaConversions$.MODULE$.mapAsJavaMap((Map)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSplitterOptions$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))));
        if (RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isTableSharing$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))) {
            byte[] sharing = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSharingBytes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
            wrappedArray = (Seq)Predef$.MODULE$.refArrayOps((Object[])splits).map((Function1)new Serializable($this, sharing){
                public static final long serialVersionUID = 0L;
                private final byte[] sharing$3;

                public final byte[] apply(byte[] s) {
                    return Bytes.concat((byte[][])new byte[][]{this.sharing$3, s});
                }
                {
                    this.sharing$3 = (byte[])sharing$3;
                }
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        } else {
            wrappedArray = Predef$.MODULE$.wrapRefArray((Object[])splits);
        }
        return wrappedArray;
    }

    public static QueryPlan getQueryPlan(IdIndex $this, SimpleFeatureType sft, GeoMesaDataStore ds, FilterStrategy filter2, Hints hints, Explainer explain) {
        Option<Filter> option;
        block6: {
            QueryPlan queryPlan;
            block5: {
                byte[] prefix;
                block4: {
                    if (filter2.primary().isEmpty()) {
                        filter2.secondary().foreach((Function1)new Serializable($this, sft){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ IdIndex $outer;
                            private final SimpleFeatureType sft$1;

                            public final void apply(Filter f) {
                                BoxedUnit boxedUnit;
                                if (this.$outer.logger().underlying().isWarnEnabled()) {
                                    this.$outer.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running full table scan for schema ", " with filter ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sft$1.getTypeName(), package$.MODULE$.filterToString(f)})));
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.sft$1 = sft$1;
                            }
                        });
                    }
                    prefix = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSharingBytes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
                    option = filter2.primary();
                    if (!None$.MODULE$.equals(option)) break block4;
                    filter2.secondary().foreach((Function1)new Serializable($this, sft){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ IdIndex $outer;
                        private final SimpleFeatureType sft$1;

                        public final void apply(Filter f) {
                            BoxedUnit boxedUnit;
                            if (this.$outer.logger().underlying().isWarnEnabled()) {
                                this.$outer.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running full table scan for schema ", " with filter ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sft$1.getTypeName(), package$.MODULE$.filterToString(f)})));
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.sft$1 = sft$1;
                        }
                    });
                    queryPlan = $this.scanPlan(sft, ds, filter2, None$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.rangePrefix(prefix)})), filter2.secondary(), hints);
                    break block5;
                }
                if (!(option instanceof Some)) break block6;
                Some some = (Some)option;
                Filter primary = (Filter)some.x();
                Set<String> identifiers = IdFilterStrategy$.MODULE$.intersectIdFilters(primary);
                explain.apply((Function0<String>)new Serializable($this, identifiers){
                    public static final long serialVersionUID = 0L;
                    private final Set identifiers$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Extracted ID filter: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.identifiers$1.mkString(", ")}));
                    }
                    {
                        this.identifiers$1 = identifiers$1;
                    }
                });
                Seq ranges = (Seq)identifiers.toSeq().map((Function1)new Serializable($this, prefix){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ IdIndex $outer;
                    private final byte[] prefix$1;

                    public final R apply(String id) {
                        return this.$outer.rangeExact(Bytes.concat((byte[][])new byte[][]{this.prefix$1, id.getBytes(StandardCharsets.UTF_8)}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.prefix$1 = (byte[])prefix$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                queryPlan = $this.scanPlan(sft, ds, filter2, None$.MODULE$, ranges, filter2.secondary(), hints);
            }
            return queryPlan;
        }
        throw new MatchError(option);
    }

    public static void $init$(IdIndex $this) {
        $this.org$locationtech$geomesa$index$index$IdIndex$_setter_$name_$eq("id");
    }
}

