/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index;

import com.google.common.primitives.Longs;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import org.locationtech.geomesa.curve.XZ2SFC;
import org.locationtech.geomesa.curve.XZ2SFC$;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.FilterValues$;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.index.IndexKeySpace;
import org.locationtech.geomesa.index.index.IndexKeySpace$class;
import org.locationtech.geomesa.index.index.XZ2IndexValues;
import org.locationtech.geomesa.index.utils.ByteArrays$;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.package$;
import org.locationtech.sfcurve.IndexRange;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.util.control.NonFatal$;

public final class XZ2Index$
implements IndexKeySpace<XZ2IndexValues> {
    public static final XZ2Index$ MODULE$;
    private final int indexKeyLength;

    static {
        new XZ2Index$();
    }

    @Override
    public boolean toIndexKey$default$2() {
        return IndexKeySpace$class.toIndexKey$default$2(this);
    }

    @Override
    public int indexKeyLength() {
        return this.indexKeyLength;
    }

    @Override
    public boolean supports(SimpleFeatureType sft) {
        return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.nonPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
    }

    @Override
    public Function1<SimpleFeature, byte[]> toIndexKey(SimpleFeatureType sft, boolean lenient) {
        XZ2SFC sfc = XZ2SFC$.MODULE$.apply(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getXZPrecision$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        int geomIndex = sft.indexOf(sft.getGeometryDescriptor().getLocalName());
        return new Serializable(lenient, sfc, geomIndex){
            public static final long serialVersionUID = 0L;
            private final boolean lenient$1;
            private final XZ2SFC sfc$1;
            private final int geomIndex$1;

            /*
             * WARNING - void declaration
             */
            public final byte[] apply(SimpleFeature feature) {
                long xz;
                Geometry geom = (Geometry)feature.getAttribute(this.geomIndex$1);
                if (geom == null) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Null geometry in feature ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{feature.getID()})));
                }
                Envelope envelope = geom.getEnvelopeInternal();
                try {
                    xz = this.sfc$1.index(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), this.lenient$1);
                }
                catch (Throwable throwable) {
                    void var2_2;
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid xz value from geometry: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var2_2})), e);
                }
                return Longs.toByteArray((long)xz);
            }
            {
                this.lenient$1 = lenient$1;
                this.sfc$1 = sfc$1;
                this.geomIndex$1 = geomIndex$1;
            }
        };
    }

    @Override
    public XZ2IndexValues getIndexValues(SimpleFeatureType sft, Filter filter2, Explainer explain) {
        FilterValues extracted = FilterHelper$.MODULE$.extractGeometries(filter2, RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)), RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        FilterValues geometries = extracted.nonEmpty() ? extracted : new FilterValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Polygon[]{package$.MODULE$.WholeWorldPolygon()})), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
        explain.apply((Function0<String>)new Serializable(geometries){
            public static final long serialVersionUID = 0L;
            private final FilterValues geometries$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Geometries: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.geometries$1}));
            }
            {
                this.geometries$1 = geometries$1;
            }
        });
        XZ2SFC sfc = XZ2SFC$.MODULE$.apply(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getXZPrecision$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        Seq xy = (Seq)geometries.values().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple4<Object, Object, Object, Object> apply(Geometry geometry) {
                return GeometryUtils$.MODULE$.bounds(geometry);
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new XZ2IndexValues(sfc, (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)xy);
    }

    @Override
    public Iterator<Tuple2<byte[], byte[]>> getRanges(SimpleFeatureType sft, XZ2IndexValues values) {
        XZ2IndexValues xZ2IndexValues = values;
        if (xZ2IndexValues != null) {
            Tuple3 tuple3;
            XZ2SFC sfc = xZ2IndexValues.sfc();
            FilterValues<Geometry> geometries = xZ2IndexValues.geometries();
            Seq<Tuple4<Object, Object, Object, Object>> xy = xZ2IndexValues.bounds();
            Tuple3 tuple32 = tuple3 = new Tuple3((Object)sfc, geometries, xy);
            XZ2SFC sfc2 = (XZ2SFC)tuple32._1();
            FilterValues geometries2 = (FilterValues)tuple32._2();
            Seq xy2 = (Seq)tuple32._3();
            Option rangeTarget = QueryProperties$.MODULE$.SCAN_RANGES_TARGET().option().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(String x$4) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$4)).toInt();
                }
            });
            Seq zs = sfc2.ranges(xy2, rangeTarget);
            return zs.iterator().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<byte[], byte[]> apply(IndexRange r) {
                    return new Tuple2((Object)Longs.toByteArray((long)r.lower()), (Object)ByteArrays$.MODULE$.toBytesFollowingPrefix(r.upper()));
                }
            });
        }
        throw new MatchError((Object)xZ2IndexValues);
    }

    private XZ2Index$() {
        MODULE$ = this;
        IndexKeySpace$class.$init$(this);
        this.indexKeyLength = 8;
    }
}

