/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index;

import com.google.common.primitives.Bytes;
import com.vividsolutions.jts.geom.Geometry;
import java.nio.charset.StandardCharsets;
import org.geotools.factory.Hints;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.index.api.FilterStrategy;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.index.api.WrappedFeature;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.index.Z2Index;
import org.locationtech.geomesa.index.index.Z2Index$;
import org.locationtech.geomesa.index.index.Z2IndexValues;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.index.utils.SplitArrays$;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.VolatileByteRef;

public abstract class Z2Index$class {
    public static boolean supports(Z2Index $this, SimpleFeatureType sft) {
        return Z2Index$.MODULE$.supports(sft);
    }

    public static Function1 writer(Z2Index $this, SimpleFeatureType sft, GeoMesaDataStore ds) {
        byte[] sharing = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSharingBytes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
        IndexedSeq<byte[]> shards = SplitArrays$.MODULE$.apply(sft);
        Function1<SimpleFeature, byte[]> toIndexKey2 = Z2Index$.MODULE$.toIndexKey(sft, Z2Index$.MODULE$.toIndexKey$default$2());
        return new Serializable($this, sharing, shards, toIndexKey2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Z2Index $outer;
            private final byte[] sharing$1;
            private final IndexedSeq shards$1;
            private final Function1 toIndexKey$1;

            public final Seq<W> apply(F wf) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.createInsert(Z2Index$class.org$locationtech$geomesa$index$index$Z2Index$$getRowKey(this.$outer, this.sharing$1, this.shards$1, this.toIndexKey$1, wf), wf)}));
            }
            {
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sharing$1 = (byte[])sharing$1;
                this.shards$1 = var3_3;
                this.toIndexKey$1 = var4_4;
            }
        };
    }

    public static Function1 remover(Z2Index $this, SimpleFeatureType sft, GeoMesaDataStore ds) {
        byte[] sharing = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSharingBytes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
        IndexedSeq<byte[]> shards = SplitArrays$.MODULE$.apply(sft);
        Function1<SimpleFeature, byte[]> toIndexKey2 = Z2Index$.MODULE$.toIndexKey(sft, true);
        return new Serializable($this, sharing, shards, toIndexKey2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Z2Index $outer;
            private final byte[] sharing$2;
            private final IndexedSeq shards$2;
            private final Function1 toIndexKey$2;

            public final Seq<W> apply(F wf) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.createDelete(Z2Index$class.org$locationtech$geomesa$index$index$Z2Index$$getRowKey(this.$outer, this.sharing$2, this.shards$2, this.toIndexKey$2, wf), wf)}));
            }
            {
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sharing$2 = (byte[])sharing$2;
                this.shards$2 = var3_3;
                this.toIndexKey$2 = var4_4;
            }
        };
    }

    public static byte[] org$locationtech$geomesa$index$index$Z2Index$$getRowKey(Z2Index $this, byte[] sharing, IndexedSeq shards, Function1 toIndexKey2, WrappedFeature wrapper) {
        byte[] split = (byte[])shards.apply(wrapper.idHash() % shards.length());
        byte[] z = (byte[])toIndexKey2.apply((Object)wrapper.feature());
        return Bytes.concat((byte[][])new byte[][]{sharing, split, z, wrapper.idBytes()});
    }

    public static Function3 getIdFromRow(Z2Index $this, SimpleFeatureType sft) {
        int start = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isTableSharing$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)) ? 10 : 9;
        return new Serializable($this, start){
            public static final long serialVersionUID = 0L;
            private final int start$1;

            public final String apply(byte[] row, int offset, int length) {
                return new String(row, offset + this.start$1, length - this.start$1, StandardCharsets.UTF_8);
            }
            {
                this.start$1 = start$1;
            }
        };
    }

    public static Seq getSplits(Z2Index $this, SimpleFeatureType sft) {
        IndexedSeq indexedSeq;
        IndexedSeq splits = (IndexedSeq)SplitArrays$.MODULE$.apply(sft).drop(1);
        if (RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isTableSharing$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))) {
            byte[] sharing = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSharingBytes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
            indexedSeq = (Seq)splits.map((Function1)new Serializable($this, sharing){
                public static final long serialVersionUID = 0L;
                private final byte[] sharing$3;

                public final byte[] apply(byte[] s) {
                    return Bytes.concat((byte[][])new byte[][]{this.sharing$3, s});
                }
                {
                    this.sharing$3 = (byte[])sharing$3;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
        } else {
            indexedSeq = splits;
        }
        return indexedSeq;
    }

    public static QueryPlan getQueryPlan(Z2Index $this, SimpleFeatureType sft, GeoMesaDataStore ds, FilterStrategy filter2, Hints hints, Explainer explain) {
        Option<Filter> option;
        block6: {
            Tuple2 tuple2;
            VolatileByteRef bitmap$0;
            BooleanRef simpleGeoms$lzy;
            block5: {
                byte[] sharing;
                block4: {
                    simpleGeoms$lzy = BooleanRef.zero();
                    bitmap$0 = VolatileByteRef.create((byte)0);
                    sharing = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSharingBytes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
                    option = filter2.primary();
                    if (!None$.MODULE$.equals(option)) break block4;
                    filter2.secondary().foreach((Function1)new Serializable($this, sft){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Z2Index $outer;
                        private final SimpleFeatureType sft$1;

                        public final void apply(Filter f) {
                            BoxedUnit boxedUnit;
                            if (this.$outer.logger().underlying().isWarnEnabled()) {
                                this.$outer.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running full table scan for schema ", " with filter ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sft$1.getTypeName(), package$.MODULE$.filterToString(f)})));
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.sft$1 = sft$1;
                        }
                    });
                    tuple2 = new Tuple2((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.rangePrefix(sharing)})), (Object)None$.MODULE$);
                    break block5;
                }
                if (!(option instanceof Some)) break block6;
                Some some = (Some)option;
                Filter f = (Filter)some.x();
                IndexedSeq splits = SplitArrays$.MODULE$.apply(sft);
                IndexedSeq prefixes = sharing.length == 0 ? splits : (IndexedSeq)splits.map((Function1)new Serializable($this, sharing){
                    public static final long serialVersionUID = 0L;
                    private final byte[] sharing$4;

                    public final byte[] apply(byte[] x$1) {
                        return Bytes.concat((byte[][])new byte[][]{this.sharing$4, x$1});
                    }
                    {
                        this.sharing$4 = (byte[])sharing$4;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                Z2IndexValues indexValues = Z2Index$.MODULE$.getIndexValues(sft, f, explain);
                Seq ranges = Z2Index$.MODULE$.getRanges(sft, indexValues).flatMap((Function1)new Serializable($this, prefixes){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Z2Index $outer;
                    private final IndexedSeq prefixes$1;

                    public final IndexedSeq<R> apply(Tuple2<byte[], byte[]> x0$1) {
                        Tuple2<byte[], byte[]> tuple2 = x0$1;
                        if (tuple2 != null) {
                            byte[] s = (byte[])tuple2._1();
                            byte[] e = (byte[])tuple2._2();
                            IndexedSeq indexedSeq = (IndexedSeq)this.prefixes$1.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ Z2Index$.anonfun.4 $outer;
                                private final byte[] s$1;
                                private final byte[] e$1;

                                public final R apply(byte[] p) {
                                    return this.$outer.org$locationtech$geomesa$index$index$Z2Index$$anonfun$$$outer().range(Bytes.concat((byte[][])new byte[][]{p, this.s$1}), Bytes.concat((byte[][])new byte[][]{p, this.e$1}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.s$1 = s$1;
                                    this.e$1 = e$1;
                                }
                            }, IndexedSeq$.MODULE$.canBuildFrom());
                            return indexedSeq;
                        }
                        throw new MatchError(tuple2);
                    }

                    public /* synthetic */ Z2Index org$locationtech$geomesa$index$index$Z2Index$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.prefixes$1 = prefixes$1;
                    }
                }).toSeq();
                tuple2 = new Tuple2((Object)ranges, (Object)new Some((Object)indexValues));
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 != null) {
                Tuple2 tuple23;
                Seq ranges = (Seq)tuple22._1();
                Option indexValues = (Option)tuple22._2();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)ranges, (Object)indexValues);
                Seq ranges2 = (Seq)tuple24._1();
                Option indexValues2 = (Option)tuple24._2();
                boolean looseBBox = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply(hints.get((Object)QueryHints$.MODULE$.LOOSE_BBOX())).map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Object x) {
                        return BoxesRunTime.unboxToBoolean((Object)x);
                    }
                }).getOrElse((Function0)new Serializable($this, ds){
                    public static final long serialVersionUID = 0L;
                    private final GeoMesaDataStore ds$1;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return this.ds$1.config().looseBBox();
                    }
                    {
                        this.ds$1 = ds$1;
                    }
                }));
                Option<Filter> ecql = looseBBox && Z2Index$class.simpleGeoms$1($this, indexValues2, simpleGeoms$lzy, bitmap$0) ? filter2.secondary() : filter2.filter();
                return $this.scanPlan(sft, ds, filter2, indexValues2, ranges2, ecql, hints);
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError(option);
    }

    private static final boolean simpleGeoms$lzycompute$1(Z2Index $this, Option indexValues$1, BooleanRef simpleGeoms$lzy$1, VolatileByteRef bitmap$0$1) {
        Z2Index z2Index = $this;
        synchronized (z2Index) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                simpleGeoms$lzy$1.elem = ((IterableLike)Option$.MODULE$.option2Iterable(indexValues$1).toSeq().flatMap((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Geometry> apply(Z2IndexValues x$3) {
                        return x$3.geometries().values();
                    }
                }, Seq$.MODULE$.canBuildFrom())).forall((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Geometry geometry) {
                        return GeometryUtils$.MODULE$.isRectangular(geometry);
                    }
                });
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return simpleGeoms$lzy$1.elem;
        }
    }

    private static final boolean simpleGeoms$1(Z2Index $this, Option indexValues$1, BooleanRef simpleGeoms$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? Z2Index$class.simpleGeoms$lzycompute$1($this, indexValues$1, simpleGeoms$lzy$1, bitmap$0$1) : simpleGeoms$lzy$1.elem;
    }

    public static void $init$(Z2Index $this) {
        $this.org$locationtech$geomesa$index$index$Z2Index$_setter_$name_$eq("z2");
        $this.org$locationtech$geomesa$index$index$Z2Index$_setter_$version_$eq(1);
    }
}

