/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.iterators;

import java.util.Arrays;
import org.geotools.factory.Hints;
import org.locationtech.geomesa.arrow.io.DeltaWriter$;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowIO$;
import org.locationtech.geomesa.arrow.package;
import org.locationtech.geomesa.arrow.package$;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary$;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.iterators.AggregatingScan$;
import org.locationtech.geomesa.index.iterators.ArrowScan;
import org.locationtech.geomesa.index.iterators.ArrowScan$Configuration$;
import org.locationtech.geomesa.index.iterators.ArrowScan$Configuration$Types$;
import org.locationtech.geomesa.index.stats.GeoMesaStats;
import org.locationtech.geomesa.utils.cache.SoftThreadLocalCache;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureOrdering$;
import org.locationtech.geomesa.utils.stats.EnumerationStat;
import org.locationtech.geomesa.utils.stats.Stat$;
import org.locationtech.geomesa.utils.stats.TopK;
import org.locationtech.geomesa.utils.text.StringSerialization$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.util.Either;

public final class ArrowScan$ {
    public static final ArrowScan$ MODULE$;
    private final GeoMesaSystemProperties.SystemProperty DictionaryTopK;
    private final Ordering<Object> DictionaryOrdering;
    private final SoftThreadLocalCache<String, ArrowScan.ArrowAggregate> org$locationtech$geomesa$index$iterators$ArrowScan$$aggregateCache;

    static {
        new ArrowScan$();
    }

    public GeoMesaSystemProperties.SystemProperty DictionaryTopK() {
        return this.DictionaryTopK;
    }

    public Ordering<Object> DictionaryOrdering() {
        return this.DictionaryOrdering;
    }

    public SoftThreadLocalCache<String, ArrowScan.ArrowAggregate> org$locationtech$geomesa$index$iterators$ArrowScan$$aggregateCache() {
        return this.org$locationtech$geomesa$index$iterators$ArrowScan$$aggregateCache;
    }

    public ArrowScan.ArrowScanConfig configure(SimpleFeatureType sft, GeoMesaFeatureIndex<?, ?, ?> index, GeoMesaStats stats, Option<Filter> filter2, Option<Filter> ecql, Hints hints) {
        ArrowScan.ArrowScanConfig arrowScanConfig;
        Map cachedDictionaries;
        Map map;
        SimpleFeatureType arrowSft = (SimpleFeatureType)QueryHints$.MODULE$.RichHints(hints).getTransformSchema().getOrElse((Function0)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$2;

            public final SimpleFeatureType apply() {
                return this.sft$2;
            }
            {
                this.sft$2 = sft$2;
            }
        });
        boolean includeFids = QueryHints$.MODULE$.RichHints(hints).isArrowIncludeFid();
        Option<Tuple2<String, Object>> sort = QueryHints$.MODULE$.RichHints(hints).getArrowSort();
        int batchSize = this.getBatchSize(hints);
        SimpleFeatureVector.SimpleFeatureEncoding encoding = SimpleFeatureVector.SimpleFeatureEncoding$.MODULE$.min(includeFids);
        Map<String, String> base = AggregatingScan$.MODULE$.configure(sft, index, ecql, QueryHints$.MODULE$.RichHints(hints).getTransform(), QueryHints$.MODULE$.RichHints(hints).getSampling());
        Map baseConfig = base.$plus$plus(AggregatingScan$.MODULE$.optionalMap((Seq<Tuple2<String, Either<String, Option<String>>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowScan$Configuration$.MODULE$.IncludeFidsKey()), AggregatingScan$.MODULE$.StringToConfig(((Object)BoxesRunTime.boxToBoolean((boolean)includeFids)).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowScan$Configuration$.MODULE$.SortKey()), AggregatingScan$.MODULE$.OptionToConfig((Option<String>)sort.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x$5) {
                return (String)x$5._1();
            }
        }))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowScan$Configuration$.MODULE$.SortReverseKey()), AggregatingScan$.MODULE$.OptionToConfig((Option<String>)sort.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x$6) {
                return ((Object)BoxesRunTime.boxToBoolean((boolean)x$6._2$mcZ$sp())).toString();
            }
        }))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowScan$Configuration$.MODULE$.BatchSizeKey()), AggregatingScan$.MODULE$.StringToConfig(((Object)BoxesRunTime.boxToInteger((int)batchSize)).toString()))})));
        Seq<String> dictionaryFields = QueryHints$.MODULE$.RichHints(hints).getArrowDictionaryFields();
        Map<String, Object[]> providedDictionaries = QueryHints$.MODULE$.RichHints(hints).getArrowDictionaryEncodedValues(sft);
        if (QueryHints$.MODULE$.RichHints(hints).isArrowCachedDictionaries()) {
            Seq toLookup = (Seq)dictionaryFields.filterNot((Function1)new Serializable(providedDictionaries){
                public static final long serialVersionUID = 0L;
                private final Map providedDictionaries$1;

                public final boolean apply(String key) {
                    return this.providedDictionaries$1.contains((Object)key);
                }
                {
                    this.providedDictionaries$1 = providedDictionaries$1;
                }
            });
            map = ((TraversableOnce)stats.getStats(sft, (Seq<String>)toLookup, stats.getStats$default$3(), ClassTag$.MODULE$.apply(TopK.class)).map((Function1)new Serializable(sft){
                public static final long serialVersionUID = 0L;
                private final SimpleFeatureType sft$2;

                public final Tuple2<String, TopK<Object>> apply(TopK<Object> k) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowScan$.MODULE$.org$locationtech$geomesa$index$iterators$ArrowScan$$name$1(k.attribute(), this.sft$2)), k);
                }
                {
                    this.sft$2 = sft$2;
                }
            }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        } else {
            map = cachedDictionaries = Predef$.MODULE$.Map().empty();
        }
        if (QueryHints$.MODULE$.RichHints(hints).isArrowDoublePass() || dictionaryFields.forall((Function1)new Serializable(providedDictionaries, cachedDictionaries){
            public static final long serialVersionUID = 0L;
            private final Map providedDictionaries$1;
            private final Map cachedDictionaries$1;

            public final boolean apply(String f) {
                return this.providedDictionaries$1.contains((Object)f) || this.cachedDictionaries$1.contains((Object)f);
            }
            {
                this.providedDictionaries$1 = providedDictionaries$1;
                this.cachedDictionaries$1 = cachedDictionaries$1;
            }
        })) {
            Map<String, ArrowDictionary> dictionaries = this.createDictionaries(stats, sft, filter2, dictionaryFields, providedDictionaries, (Map<String, TopK<Object>>)cachedDictionaries);
            Map config = baseConfig.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowScan$Configuration$.MODULE$.TypeKey()), (Object)ArrowScan$Configuration$Types$.MODULE$.BatchType()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowScan$Configuration$.MODULE$.DictionaryKey()), (Object)this.encodeDictionaries(dictionaries))})));
            Serializable reduce = new Serializable(arrowSft, sort, batchSize, encoding, dictionaries){
                public static final long serialVersionUID = 0L;
                private final SimpleFeatureType arrowSft$2;
                private final Option sort$2;
                private final int batchSize$1;
                private final SimpleFeatureVector.SimpleFeatureEncoding encoding$1;
                private final Map dictionaries$1;

                public final CloseableIterator<SimpleFeature> apply(CloseableIterator<SimpleFeature> iter) {
                    return ArrowScan$.MODULE$.mergeBatches(this.arrowSft$2, (Map<String, ArrowDictionary>)this.dictionaries$1, this.encoding$1, this.batchSize$1, (Option<Tuple2<String, Object>>)this.sort$2, iter);
                }
                {
                    this.arrowSft$2 = arrowSft$2;
                    this.sort$2 = sort$2;
                    this.batchSize$1 = batchSize$1;
                    this.encoding$1 = encoding$1;
                    this.dictionaries$1 = dictionaries$1;
                }
            };
            arrowScanConfig = new ArrowScan.ArrowScanConfig((Map<String, String>)config, (Function1<CloseableIterator<SimpleFeature>, CloseableIterator<SimpleFeature>>)reduce);
        } else if (QueryHints$.MODULE$.RichHints(hints).isArrowMultiFile()) {
            Map config = baseConfig.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowScan$Configuration$.MODULE$.TypeKey()), (Object)ArrowScan$Configuration$Types$.MODULE$.FileType()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowScan$Configuration$.MODULE$.DictionaryKey()), (Object)dictionaryFields.mkString(","))})));
            Serializable reduce = new Serializable(arrowSft, sort, encoding, dictionaryFields){
                public static final long serialVersionUID = 0L;
                private final SimpleFeatureType arrowSft$2;
                private final Option sort$2;
                private final SimpleFeatureVector.SimpleFeatureEncoding encoding$1;
                private final Seq dictionaryFields$1;

                public final CloseableIterator<SimpleFeature> apply(CloseableIterator<SimpleFeature> iter) {
                    return ArrowScan$.MODULE$.mergeFiles(this.arrowSft$2, (Seq<String>)this.dictionaryFields$1, this.encoding$1, (Option<Tuple2<String, Object>>)this.sort$2, iter);
                }
                {
                    this.arrowSft$2 = arrowSft$2;
                    this.sort$2 = sort$2;
                    this.encoding$1 = encoding$1;
                    this.dictionaryFields$1 = dictionaryFields$1;
                }
            };
            arrowScanConfig = new ArrowScan.ArrowScanConfig((Map<String, String>)config, (Function1<CloseableIterator<SimpleFeature>, CloseableIterator<SimpleFeature>>)reduce);
        } else {
            Map config = baseConfig.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowScan$Configuration$.MODULE$.TypeKey()), (Object)ArrowScan$Configuration$Types$.MODULE$.DeltaType()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowScan$Configuration$.MODULE$.DictionaryKey()), (Object)dictionaryFields.mkString(","))})));
            Serializable reduce = new Serializable(arrowSft, sort, batchSize, encoding, dictionaryFields){
                public static final long serialVersionUID = 0L;
                private final SimpleFeatureType arrowSft$2;
                private final Option sort$2;
                private final int batchSize$1;
                private final SimpleFeatureVector.SimpleFeatureEncoding encoding$1;
                private final Seq dictionaryFields$1;

                public final CloseableIterator<SimpleFeature> apply(CloseableIterator<SimpleFeature> iter) {
                    return ArrowScan$.MODULE$.mergeDeltas(this.arrowSft$2, (Seq<String>)this.dictionaryFields$1, this.encoding$1, this.batchSize$1, (Option<Tuple2<String, Object>>)this.sort$2, iter);
                }
                {
                    this.arrowSft$2 = arrowSft$2;
                    this.sort$2 = sort$2;
                    this.batchSize$1 = batchSize$1;
                    this.encoding$1 = encoding$1;
                    this.dictionaryFields$1 = dictionaryFields$1;
                }
            };
            arrowScanConfig = new ArrowScan.ArrowScanConfig((Map<String, String>)config, (Function1<CloseableIterator<SimpleFeature>, CloseableIterator<SimpleFeature>>)reduce);
        }
        return arrowScanConfig;
    }

    public int getBatchSize(Hints hints) {
        return BoxesRunTime.unboxToInt((Object)QueryHints$.MODULE$.RichHints(hints).getArrowBatchSize().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return new StringOps(Predef$.MODULE$.augmentString(package.ArrowProperties$.MODULE$.BatchSize().get())).toInt();
            }
        }));
    }

    public CloseableIterator<SimpleFeature> mergeFiles(SimpleFeatureType sft, Seq<String> dictionaryFields, SimpleFeatureVector.SimpleFeatureEncoding encoding, Option<Tuple2<String, Object>> sort, CloseableIterator<SimpleFeature> iter) {
        CloseableIterator bytes = iter.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(SimpleFeature x$7) {
                return (byte[])x$7.getAttribute(0);
            }
        });
        CloseableIterator result = SimpleFeatureArrowIO$.MODULE$.reduceFiles(sft, dictionaryFields, encoding, sort, bytes, package$.MODULE$.allocator());
        SimpleFeature sf = this.resultFeature();
        return result.map((Function1)new Serializable(sf){
            public static final long serialVersionUID = 0L;
            private final SimpleFeature sf$1;

            public final SimpleFeature apply(byte[] bytes) {
                this.sf$1.setAttribute(0, (Object)bytes);
                return this.sf$1;
            }
            {
                this.sf$1 = sf$1;
            }
        });
    }

    public CloseableIterator<SimpleFeature> mergeBatches(SimpleFeatureType sft, Map<String, ArrowDictionary> dictionaries, SimpleFeatureVector.SimpleFeatureEncoding encoding, int batchSize, Option<Tuple2<String, Object>> sort, CloseableIterator<SimpleFeature> iter) {
        CloseableIterator batches = iter.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(SimpleFeature x$8) {
                return (byte[])x$8.getAttribute(0);
            }
        });
        CloseableIterator result = SimpleFeatureArrowIO$.MODULE$.reduceBatches(sft, dictionaries, encoding, sort, batchSize, batches, package$.MODULE$.allocator());
        SimpleFeature sf = this.resultFeature();
        return result.map((Function1)new Serializable(sf){
            public static final long serialVersionUID = 0L;
            private final SimpleFeature sf$2;

            public final SimpleFeature apply(byte[] bytes) {
                this.sf$2.setAttribute(0, (Object)bytes);
                return this.sf$2;
            }
            {
                this.sf$2 = sf$2;
            }
        });
    }

    public CloseableIterator<SimpleFeature> mergeDeltas(SimpleFeatureType sft, Seq<String> dictionaryFields, SimpleFeatureVector.SimpleFeatureEncoding encoding, int batchSize, Option<Tuple2<String, Object>> sort, CloseableIterator<SimpleFeature> iter) {
        CloseableIterator files = iter.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(SimpleFeature x$9) {
                return (byte[])x$9.getAttribute(0);
            }
        });
        CloseableIterator result = DeltaWriter$.MODULE$.reduce(sft, dictionaryFields, encoding, sort, batchSize, files, package$.MODULE$.allocator());
        SimpleFeature sf = this.resultFeature();
        return result.map((Function1)new Serializable(sf){
            public static final long serialVersionUID = 0L;
            private final SimpleFeature sf$3;

            public final SimpleFeature apply(byte[] bytes) {
                this.sf$3.setAttribute(0, (Object)bytes);
                return this.sf$3;
            }
            {
                this.sf$3 = sf$3;
            }
        });
    }

    public Map<String, ArrowDictionary> createDictionaries(GeoMesaStats stats, SimpleFeatureType sft, Option<Filter> filter2, Seq<String> attributes, Map<String, Object[]> provided, Map<String, TopK<Object>> cached) {
        Map map;
        if (attributes.isEmpty()) {
            map = Predef$.MODULE$.Map().empty();
        } else {
            LongRef id = LongRef.create((long)-1L);
            Map providedDictionaries = (Map)provided.map((Function1)new Serializable(sft, id){
                public static final long serialVersionUID = 0L;
                private final SimpleFeatureType sft$3;
                private final LongRef id$1;

                public final Tuple2<String, ArrowDictionary> apply(Tuple2<String, Object[]> x0$1) {
                    Tuple2<String, Object[]> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        Object[] v = (Object[])tuple2._2();
                        ++this.id$1.elem;
                        ArrowScan$.MODULE$.org$locationtech$geomesa$index$iterators$ArrowScan$$sort$3(v);
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)ArrowDictionary$.MODULE$.create(this.id$1.elem, v, ClassTag$.MODULE$.apply(this.sft$3.getDescriptor(k).getType().getBinding())));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.sft$3 = sft$3;
                    this.id$1 = id$1;
                }
            }, Map$.MODULE$.canBuildFrom());
            Seq toLookup = (Seq)attributes.filterNot((Function1)new Serializable(provided){
                public static final long serialVersionUID = 0L;
                private final Map provided$1;

                public final boolean apply(String key) {
                    return this.provided$1.contains((Object)key);
                }
                {
                    this.provided$1 = provided$1;
                }
            });
            if (toLookup.isEmpty()) {
                map = providedDictionaries;
            } else {
                Map map2;
                if (toLookup.forall((Function1)new Serializable(cached){
                    public static final long serialVersionUID = 0L;
                    private final Map cached$1;

                    public final boolean apply(String key) {
                        return this.cached$1.contains((Object)key);
                    }
                    {
                        this.cached$1 = cached$1;
                    }
                })) {
                    map2 = (Map)cached.map((Function1)new Serializable(sft, id){
                        public static final long serialVersionUID = 0L;
                        private final SimpleFeatureType sft$3;
                        private final LongRef id$1;

                        public final Tuple2<String, ArrowDictionary> apply(Tuple2<String, TopK<Object>> x0$2) {
                            Tuple2<String, TopK<Object>> tuple2 = x0$2;
                            if (tuple2 != null) {
                                String name = (String)tuple2._1();
                                TopK k = (TopK)tuple2._2();
                                ++this.id$1.elem;
                                Object[] values = (Object[])k.topK(new StringOps(Predef$.MODULE$.augmentString(ArrowScan$.MODULE$.DictionaryTopK().get())).toInt()).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Object apply(Tuple2<Object, Object> x$10) {
                                        return x$10._1();
                                    }
                                }).toArray(ClassTag$.MODULE$.AnyRef());
                                ArrowScan$.MODULE$.org$locationtech$geomesa$index$iterators$ArrowScan$$sort$3(values);
                                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)ArrowDictionary$.MODULE$.create(this.id$1.elem, values, ClassTag$.MODULE$.apply(this.sft$3.getDescriptor(name).getType().getBinding())));
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.sft$3 = sft$3;
                            this.id$1 = id$1;
                        }
                    }, Map$.MODULE$.canBuildFrom());
                } else {
                    String query = Stat$.MODULE$.SeqStat((Seq)toLookup.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String attribute) {
                            return Stat$.MODULE$.Enumeration(attribute);
                        }
                    }, Seq$.MODULE$.canBuildFrom()));
                    Seq enumerations = stats.runStats(sft, query, (Filter)filter2.getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final IncludeFilter apply() {
                            return Filter.INCLUDE;
                        }
                    }));
                    Iterator nameIter = toLookup.iterator();
                    map2 = ((TraversableOnce)enumerations.map((Function1)new Serializable(sft, id, nameIter){
                        public static final long serialVersionUID = 0L;
                        private final SimpleFeatureType sft$3;
                        private final LongRef id$1;
                        private final Iterator nameIter$1;

                        public final Tuple2<String, ArrowDictionary> apply(EnumerationStat<String> e) {
                            ++this.id$1.elem;
                            String name = (String)this.nameIter$1.next();
                            Object[] values = (Object[])e.values().toArray(ClassTag$.MODULE$.AnyRef());
                            ArrowScan$.MODULE$.org$locationtech$geomesa$index$iterators$ArrowScan$$sort$3(values);
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)ArrowDictionary$.MODULE$.create(this.id$1.elem, values, ClassTag$.MODULE$.apply(this.sft$3.getDescriptor(name).getType().getBinding())));
                        }
                        {
                            this.sft$3 = sft$3;
                            this.id$1 = id$1;
                            this.nameIter$1 = nameIter$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                }
                Map queried = map2;
                map = queried.$plus$plus((GenTraversableOnce)providedDictionaries);
            }
        }
        return map;
    }

    public SimpleFeature resultFeature() {
        return new ScalaSimpleFeature(package$.MODULE$.ArrowEncodedSft(), "", new Object[]{null, GeometryUtils$.MODULE$.zeroPoint()}, ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4());
    }

    private String encodeDictionaries(Map<String, ArrowDictionary> dictionaries) {
        return StringSerialization$.MODULE$.encodeSeqMap((Map)dictionaries.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Seq<Object>> apply(Tuple2<String, ArrowDictionary> x0$3) {
                Tuple2<String, ArrowDictionary> tuple2 = x0$3;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    ArrowDictionary v = (ArrowDictionary)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.iterator().toSeq());
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom()));
    }

    public Map<String, ArrowDictionary> org$locationtech$geomesa$index$iterators$ArrowScan$$decodeDictionaries(SimpleFeatureType sft, String encoded) {
        LongRef id = LongRef.create((long)-1L);
        return (Map)StringSerialization$.MODULE$.decodeSeqMap(sft, encoded).map((Function1)new Serializable(sft, id){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;
            private final LongRef id$2;

            public final Tuple2<String, ArrowDictionary> apply(Tuple2<String, Object[]> x0$4) {
                Tuple2<String, Object[]> tuple2 = x0$4;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Object[] v = (Object[])tuple2._2();
                    ++this.id$2.elem;
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)ArrowDictionary$.MODULE$.create(this.id$2.elem, v, ClassTag$.MODULE$.apply(this.sft$1.getDescriptor(k).getType().getBinding())));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.sft$1 = sft$1;
                this.id$2 = id$2;
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    public final String org$locationtech$geomesa$index$iterators$ArrowScan$$name$1(int i, SimpleFeatureType sft$2) {
        return sft$2.getDescriptor(i).getLocalName();
    }

    public final void org$locationtech$geomesa$index$iterators$ArrowScan$$sort$3(Object[] values) {
        Arrays.sort(values, this.DictionaryOrdering());
    }

    private ArrowScan$() {
        MODULE$ = this;
        this.DictionaryTopK = new GeoMesaSystemProperties.SystemProperty("geomesa.arrow.dictionary.top", "1000");
        this.DictionaryOrdering = new Ordering<Object>(){

            public Some<Object> tryCompare(Object x, Object y) {
                return Ordering.class.tryCompare((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.class.lteq((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.class.gteq((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.class.lt((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.class.gt((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.class.equiv((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.class.max((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.class.min((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<Object> reverse() {
                return Ordering.class.reverse((Ordering)this);
            }

            public <U> Ordering<U> on(Function1<U, Object> f) {
                return Ordering.class.on((Ordering)this, f);
            }

            public Ordering.Ops mkOrderingOps(Object lhs) {
                return Ordering.class.mkOrderingOps((Ordering)this, (Object)lhs);
            }

            public int compare(Object x, Object y) {
                return SimpleFeatureOrdering$.MODULE$.nullCompare((Comparable)x, y);
            }
            {
                PartialOrdering.class.$init$((PartialOrdering)this);
                Ordering.class.$init$((Ordering)this);
            }
        };
        this.org$locationtech$geomesa$index$iterators$ArrowScan$$aggregateCache = new SoftThreadLocalCache();
    }
}

