/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.vector;

import java.util.Collections;
import java.util.List;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;

public class GeometryFields {
    public static ArrowType FLOAT_TYPE = new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
    public static ArrowType DOUBLE_TYPE = new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
    public static List<Field> XY_FLOAT = Collections.singletonList(new Field("$data$", FieldType.nullable((ArrowType)FLOAT_TYPE), null));
    public static List<Field> XY_DOUBLE = Collections.singletonList(new Field("$data$", FieldType.nullable((ArrowType)DOUBLE_TYPE), null));
    public static List<Field> XY_FLOAT_LIST = Collections.singletonList(new Field("$data$", FieldType.nullable((ArrowType)new ArrowType.FixedSizeList(2)), XY_FLOAT));
    public static List<Field> XY_DOUBLE_LIST = Collections.singletonList(new Field("$data$", FieldType.nullable((ArrowType)new ArrowType.FixedSizeList(2)), XY_DOUBLE));
    public static List<Field> XY_FLOAT_LIST_2 = Collections.singletonList(new Field("$data$", FieldType.nullable((ArrowType)ArrowType.List.INSTANCE), XY_FLOAT_LIST));
    public static List<Field> XY_DOUBLE_LIST_2 = Collections.singletonList(new Field("$data$", FieldType.nullable((ArrowType)ArrowType.List.INSTANCE), XY_DOUBLE_LIST));
    public static List<Field> XY_FLOAT_LIST_3 = Collections.singletonList(new Field("$data$", FieldType.nullable((ArrowType)ArrowType.List.INSTANCE), XY_FLOAT_LIST_2));
    public static List<Field> XY_DOUBLE_LIST_3 = Collections.singletonList(new Field("$data$", FieldType.nullable((ArrowType)ArrowType.List.INSTANCE), XY_DOUBLE_LIST_2));

    private GeometryFields() {
    }

    public static FloatingPointPrecision precisionFromField(Field field) {
        Field toCheck = field;
        while (true) {
            ArrowType type;
            if ((type = toCheck.getType()) instanceof ArrowType.FloatingPoint) {
                return ((ArrowType.FloatingPoint)type).getPrecision();
            }
            if (!(type instanceof ArrowType.FixedSizeList) && !(type instanceof ArrowType.List)) break;
            toCheck = (Field)field.getChildren().get(0);
        }
        return null;
    }
}

