/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.tube;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Date;
import java.util.List;
import org.geotools.data.Query;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.EmptyFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.CalcResult;
import org.locationtech.geomesa.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.process.GeoMesaProcessVisitor$class;
import org.locationtech.geomesa.process.tube.GapFill$;
import org.locationtech.geomesa.process.tube.InterpolatedGapFill;
import org.locationtech.geomesa.process.tube.LineGapFill;
import org.locationtech.geomesa.process.tube.NoGapFill;
import org.locationtech.geomesa.process.tube.TubeBuilder;
import org.locationtech.geomesa.process.tube.TubeResult;
import org.locationtech.geomesa.process.tube.TubeVisitor$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes;
import org.locationtech.geomesa.utils.io.WithClose$;
import org.locationtech.geomesa.utils.iterators.DeduplicatingSimpleFeatureIterator;
import org.locationtech.geomesa.utils.iterators.DeduplicatingSimpleFeatureIterator$;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.Intersects;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\u0001\u0003\u00015\u00111\u0002V;cKZK7/\u001b;pe*\u00111\u0001B\u0001\u0005iV\u0014WM\u0003\u0002\u0006\r\u00059\u0001O]8dKN\u001c(BA\u0004\t\u0003\u001d9Wm\\7fg\u0006T!!\u0003\u0006\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u00175A\u0011q\u0002F\u0007\u0002!)\u0011\u0011CE\u0001\u0005Y\u0006twMC\u0001\u0014\u0003\u0011Q\u0017M^1\n\u0005U\u0001\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001815\tA!\u0003\u0002\u001a\t\t)r)Z8NKN\f\u0007K]8dKN\u001ch+[:ji>\u0014\bCA\u000e#\u001b\u0005a\"BA\u000f\u001f\u00031\u00198-\u00197bY><w-\u001b8h\u0015\ty\u0002%\u0001\u0005usB,7/\u00194f\u0015\u0005\t\u0013aA2p[&\u00111\u0005\b\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw\r\u0003\u0005&\u0001\t\u0015\r\u0011\"\u0001'\u00031!XOY3GK\u0006$XO]3t+\u00059\u0003C\u0001\u00150\u001b\u0005I#B\u0001\u0016,\u0003\u0019\u0019\u0018.\u001c9mK*\u0011A&L\u0001\u0005I\u0006$\u0018M\u0003\u0002/\u0015\u0005Aq-Z8u_>d7/\u0003\u00021S\t92+[7qY\u00164U-\u0019;ve\u0016\u001cu\u000e\u001c7fGRLwN\u001c\u0005\te\u0001\u0011\t\u0011)A\u0005O\u0005iA/\u001e2f\r\u0016\fG/\u001e:fg\u0002B\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\tAJ\u0001\u0012M\u0016\fG/\u001e:f\u0007>dG.Z2uS>t\u0007\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002%\u0019,\u0017\r^;sK\u000e{G\u000e\\3di&|g\u000e\t\u0005\tq\u0001\u0011)\u0019!C\u0001s\u00051a-\u001b7uKJ,\u0012A\u000f\t\u0003w}j\u0011\u0001\u0010\u0006\u0003quR!A\u0010\u0006\u0002\u000f=\u0004XM\\4jg&\u0011\u0001\t\u0010\u0002\u0007\r&dG/\u001a:\t\u0011\t\u0003!\u0011!Q\u0001\ni\nqAZ5mi\u0016\u0014\b\u0005\u0003\u0005E\u0001\t\u0015\r\u0011\"\u0001F\u0003!i\u0017\r_*qK\u0016$W#\u0001$\u0011\u0005\u001dSU\"\u0001%\u000b\u0003%\u000bQa]2bY\u0006L!a\u0013%\u0003\t1{gn\u001a\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\r\u0006IQ.\u0019=Ta\u0016,G\r\t\u0005\t\u001f\u0002\u0011)\u0019!C\u0001\u000b\u00069Q.\u0019=US6,\u0007\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\u0002\u00115\f\u0007\u0010V5nK\u0002B\u0001b\u0015\u0001\u0003\u0006\u0004%\t\u0001V\u0001\u000bEV4g-\u001a:TSj,W#A+\u0011\u0005\u001d3\u0016BA,I\u0005\u0019!u.\u001e2mK\"A\u0011\f\u0001B\u0001B\u0003%Q+A\u0006ck\u001a4WM]*ju\u0016\u0004\u0003\u0002C.\u0001\u0005\u000b\u0007I\u0011\u0001/\u0002\u000f5\f\u0007PQ5ogV\tQ\f\u0005\u0002H=&\u0011q\f\u0013\u0002\u0004\u0013:$\b\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011B/\u0002\u00115\f\u0007PQ5og\u0002B\u0001b\u0019\u0001\u0003\u0006\u0004%\t\u0001Z\u0001\bO\u0006\u0004h)\u001b7m+\u0005)\u0007C\u00014k\u001d\t9\u0007.D\u0001\u0003\u0013\tI'!A\u0004HCB4\u0015\u000e\u001c7\n\u0005-d'aB$ba\u001aKG\u000e\u001c\u0006\u0003S\nA\u0001B\u001c\u0001\u0003\u0002\u0003\u0006I!Z\u0001\tO\u0006\u0004h)\u001b7mA!)\u0001\u000f\u0001C\u0001c\u00061A(\u001b8jiz\"\u0012B]:ukZ<\b0\u001f>\u0011\u0005\u001d\u0004\u0001\"B\u0013p\u0001\u00049\u0003\"\u0002\u001bp\u0001\u00049\u0003b\u0002\u001dp!\u0003\u0005\rA\u000f\u0005\u0006\t>\u0004\rA\u0012\u0005\u0006\u001f>\u0004\rA\u0012\u0005\u0006'>\u0004\r!\u0016\u0005\u00067>\u0004\r!\u0018\u0005\bG>\u0004\n\u00111\u0001f\u0011\u001da\b\u00011A\u0005\u0002u\f!B]3tk2$8)\u00197d+\u0005q\bCA4\u0000\u0013\r\t\tA\u0001\u0002\u000b)V\u0014WMU3tk2$\b\"CA\u0003\u0001\u0001\u0007I\u0011AA\u0004\u00039\u0011Xm];mi\u000e\u000bGnY0%KF$B!!\u0003\u0002\u0010A\u0019q)a\u0003\n\u0007\u00055\u0001J\u0001\u0003V]&$\b\"CA\t\u0003\u0007\t\t\u00111\u0001\u007f\u0003\rAH%\r\u0005\b\u0003+\u0001\u0001\u0015)\u0003\u007f\u0003-\u0011Xm];mi\u000e\u000bGn\u0019\u0011\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c\u0005)a/[:jiR!\u0011\u0011BA\u000f\u0011!\ty\"a\u0006A\u0002\u0005\u0005\u0012a\u00024fCR,(/\u001a\t\u0005\u0003G\t9#\u0004\u0002\u0002&)\u0019\u0011qD\u001f\n\t\u0005%\u0012Q\u0005\u0002\b\r\u0016\fG/\u001e:f\u0011\u001d\ti\u0003\u0001C!\u0003_\t\u0011bZ3u%\u0016\u001cX\u000f\u001c;\u0015\u0005\u0005E\u0002\u0003BA\u001a\u0003wi!!!\u000e\u000b\t\u0005]\u0012\u0011H\u0001\bm&\u001c\u0018\u000e^8s\u0015\r\ty\"L\u0005\u0005\u0003{\t)D\u0001\u0006DC2\u001c'+Z:vYRD\u0011\"!\u0011\u0001\u0005\u0004%\t!a\u0011\u0002\u0005\u00194WCAA#!\rY\u0014qI\u0005\u0004\u0003\u0013b$A\u0004$jYR,'OR1di>\u0014\u0018P\r\u0005\t\u0003\u001b\u0002\u0001\u0015!\u0003\u0002F\u0005\u0019aM\u001a\u0011\t\u0011\u0005E\u0003A1A\u0005\u0002Q\u000baBY;gM\u0016\u0014H)[:uC:\u001cW\rC\u0004\u0002V\u0001\u0001\u000b\u0011B+\u0002\u001f\t,hMZ3s\t&\u001cH/\u00198dK\u0002Bq!!\u0017\u0001\t\u0003\nY&A\u0004fq\u0016\u001cW\u000f^3\u0015\r\u0005%\u0011QLA4\u0011!\ty&a\u0016A\u0002\u0005\u0005\u0014AB:pkJ\u001cW\rE\u0002)\u0003GJ1!!\u001a*\u0005M\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKN{WO]2f\u0011!\tI'a\u0016A\u0002\u0005-\u0014!B9vKJL\b\u0003BA7\u0003_j\u0011aK\u0005\u0004\u0003cZ#!B)vKJLx!CA;\u0005\u0005\u0005\t\u0012AA<\u0003-!VOY3WSNLGo\u001c:\u0011\u0007\u001d\fIH\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AA>'\u0011\tI(! \u0011\u0007\u001d\u000by(C\u0002\u0002\u0002\"\u0013a!\u00118z%\u00164\u0007b\u00029\u0002z\u0011\u0005\u0011Q\u0011\u000b\u0003\u0003oB!\"!#\u0002zE\u0005I\u0011AAF\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u0012\u0016\u0004u\u0005=5FAAI!\u0011\t\u0019*!(\u000e\u0005\u0005U%\u0002BAL\u00033\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005m\u0005*\u0001\u0006b]:|G/\u0019;j_:LA!a(\u0002\u0016\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\u0005\r\u0016\u0011PI\u0001\n\u0003\t)+A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005O\u000b\u0003\u0003OS3!ZAH\u0001")
public class TubeVisitor
implements GeoMesaProcessVisitor,
LazyLogging {
    private final SimpleFeatureCollection tubeFeatures;
    private final SimpleFeatureCollection featureCollection;
    private final Filter filter;
    private final long maxSpeed;
    private final long maxTime;
    private final double bufferSize;
    private final int maxBins;
    private final Enumeration.Value gapFill;
    private TubeResult resultCalc;
    private final FilterFactory2 ff;
    private final double bufferDistance;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static Enumeration.Value $lessinit$greater$default$8() {
        return TubeVisitor$.MODULE$.$lessinit$greater$default$8();
    }

    public static Filter $lessinit$greater$default$3() {
        return TubeVisitor$.MODULE$.$lessinit$greater$default$3();
    }

    private Logger logger$lzycompute() {
        TubeVisitor tubeVisitor = this;
        synchronized (tubeVisitor) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public List<Expression> getExpressions() {
        return GeoMesaProcessVisitor$class.getExpressions(this);
    }

    public SimpleFeatureCollection tubeFeatures() {
        return this.tubeFeatures;
    }

    public SimpleFeatureCollection featureCollection() {
        return this.featureCollection;
    }

    public Filter filter() {
        return this.filter;
    }

    public long maxSpeed() {
        return this.maxSpeed;
    }

    public long maxTime() {
        return this.maxTime;
    }

    public double bufferSize() {
        return this.bufferSize;
    }

    public int maxBins() {
        return this.maxBins;
    }

    public Enumeration.Value gapFill() {
        return this.gapFill;
    }

    public TubeResult resultCalc() {
        return this.resultCalc;
    }

    public void resultCalc_$eq(TubeResult x$1) {
        this.resultCalc = x$1;
    }

    public void visit(Feature feature) {
    }

    public CalcResult getResult() {
        return this.resultCalc();
    }

    public FilterFactory2 ff() {
        return this.ff;
    }

    public double bufferDistance() {
        return this.bufferDistance;
    }

    @Override
    public void execute(SimpleFeatureSource source, Query query) {
        TubeBuilder tubeBuilder;
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder().append((Object)"Visiting source type: ").append((Object)source.getClass().getName()).toString());
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        PropertyName geomProperty = this.ff().property(source.getSchema().getGeometryDescriptor().getName());
        PropertyName dateProperty = this.ff().property((String)source.getSchema().getUserData().get(SimpleFeatureTypes.Configs$.MODULE$.DEFAULT_DATE_KEY()));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder().append((Object)"Querying with date property: ").append((Object)dateProperty).toString());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder().append((Object)"Querying with geometry property: ").append((Object)geomProperty).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Enumeration.Value value = this.gapFill();
        Enumeration.Value value2 = GapFill$.MODULE$.LINE();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            tubeBuilder = new LineGapFill(this.tubeFeatures(), this.bufferDistance(), this.maxBins());
        } else {
            Enumeration.Value value4 = GapFill$.MODULE$.INTERPOLATED();
            Enumeration.Value value5 = value;
            tubeBuilder = !(value4 != null ? !value4.equals(value5) : value5 != null) ? new InterpolatedGapFill(this.tubeFeatures(), this.bufferDistance(), this.maxBins()) : new NoGapFill(this.tubeFeatures(), this.bufferDistance(), this.maxBins());
        }
        LineGapFill tubeBuilder2 = tubeBuilder;
        Iterator<SimpleFeature> tube = ((TubeBuilder)tubeBuilder2).createTube();
        CloseableIterator queryResults = CloseableIterator$.MODULE$.apply(tube, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CloseableIterator$.MODULE$.apply$default$2();
            }
        }).flatMap((Function1)new Serializable(this, source, query, geomProperty, dateProperty, tubeBuilder2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TubeVisitor $outer;
            public final SimpleFeatureSource source$1;
            public final Query query$1;
            public final PropertyName geomProperty$1;
            private final PropertyName dateProperty$1;
            private final TubeBuilder tubeBuilder$1;

            public final CloseableIterator<SimpleFeature> apply(SimpleFeature sf) {
                long sfMin = this.tubeBuilder$1.getStartTime(sf).getTime();
                Date minDate = new Date(sfMin - this.$outer.maxTime() * 1000L);
                long sfMax = this.tubeBuilder$1.getEndTime(sf).getTime();
                Date maxDate = new Date(sfMax + this.$outer.maxTime() * 1000L);
                PropertyIsGreaterThan dtg1 = this.$outer.ff().greater((Expression)this.dateProperty$1, (Expression)this.$outer.ff().literal((Object)minDate));
                PropertyIsLessThan dtg2 = this.$outer.ff().less((Expression)this.dateProperty$1, (Expression)this.$outer.ff().literal((Object)maxDate));
                Geometry geom = (Geometry)sf.getDefaultGeometry();
                Iterator geoms = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), geom.getNumGeometries()).toIterator().map((Function1)new Serializable(this, geom){
                    public static final long serialVersionUID = 0L;
                    private final Geometry geom$1;

                    public final Geometry apply(int x$1) {
                        return this.geom$1.getGeometryN(x$1);
                    }
                    {
                        this.geom$1 = geom$1;
                    }
                });
                return SelfClosingIterator$.MODULE$.apply(geoms, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        SelfClosingIterator$.MODULE$.apply$default$2();
                    }
                }).flatMap((Function1)new Serializable(this, dtg1, dtg2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;
                    private final PropertyIsGreaterThan dtg1$1;
                    private final PropertyIsLessThan dtg2$1;

                    public final SelfClosingIterator<SimpleFeature> apply(Geometry g) {
                        Intersects geomFilter = this.$outer.org$locationtech$geomesa$process$tube$TubeVisitor$$anonfun$$$outer().ff().intersects((Expression)this.$outer.geomProperty$1, (Expression)this.$outer.org$locationtech$geomesa$process$tube$TubeVisitor$$anonfun$$$outer().ff().literal((Object)g));
                        And combinedFilter = this.$outer.org$locationtech$geomesa$process$tube$TubeVisitor$$anonfun$$$outer().ff().and(JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filter[]{this.$outer.query$1.getFilter(), geomFilter, this.dtg1$1, this.dtg2$1, this.$outer.org$locationtech$geomesa$process$tube$TubeVisitor$$anonfun$$$outer().filter()}))));
                        return SelfClosingIterator$.MODULE$.apply(this.$outer.source$1.getFeatures((Filter)combinedFilter).features());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dtg1$1 = dtg1$1;
                        this.dtg2$1 = dtg2$1;
                    }
                });
            }

            public /* synthetic */ TubeVisitor org$locationtech$geomesa$process$tube$TubeVisitor$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.source$1 = source$1;
                this.query$1 = query$1;
                this.geomProperty$1 = geomProperty$1;
                this.dateProperty$1 = dateProperty$1;
                this.tubeBuilder$1 = tubeBuilder$1;
            }
        });
        ListFeatureCollection collection = new ListFeatureCollection((SimpleFeatureType)source.getSchema());
        WithClose$.MODULE$.apply((Object)new DeduplicatingSimpleFeatureIterator(queryResults, DeduplicatingSimpleFeatureIterator$.MODULE$.$lessinit$greater$default$2()), (Function1)new Serializable(this, collection){
            public static final long serialVersionUID = 0L;
            public final ListFeatureCollection collection$1;

            public final void apply(DeduplicatingSimpleFeatureIterator x$1) {
                x$1.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$execute$1 $outer;

                    public final boolean apply(SimpleFeature x$1) {
                        return this.$outer.collection$1.add(x$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.collection$1 = collection$1;
            }
        });
        this.resultCalc_$eq(new TubeResult((SimpleFeatureCollection)collection));
    }

    public TubeVisitor(SimpleFeatureCollection tubeFeatures, SimpleFeatureCollection featureCollection, Filter filter, long maxSpeed, long maxTime, double bufferSize, int maxBins, Enumeration.Value gapFill) {
        this.tubeFeatures = tubeFeatures;
        this.featureCollection = featureCollection;
        this.filter = filter;
        this.maxSpeed = maxSpeed;
        this.maxTime = maxTime;
        this.bufferSize = bufferSize;
        this.maxBins = maxBins;
        this.gapFill = gapFill;
        GeoMesaProcessVisitor$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        this.resultCalc = new TubeResult((SimpleFeatureCollection)new EmptyFeatureCollection((SimpleFeatureType)featureCollection.getSchema()));
        this.ff = CommonFactoryFinder.getFilterFactory2();
        this.bufferDistance = bufferSize > 0.0 ? bufferSize : (double)(maxSpeed * maxTime);
    }
}

