/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.cassandra.index;

import com.datastax.driver.core.Row;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.geotools.factory.Hints;
import org.geotools.process.vector.TransformProcess;
import org.locationtech.geomesa.cassandra.data.CassandraDataStore;
import org.locationtech.geomesa.cassandra.data.CassandraFeature;
import org.locationtech.geomesa.cassandra.index.CassandraFeatureIndex;
import org.locationtech.geomesa.cassandra.index.CassandraFeatureIndex$class;
import org.locationtech.geomesa.cassandra.index.CassandraIndexAdapter;
import org.locationtech.geomesa.cassandra.index.CassandraIndexAdapter$class;
import org.locationtech.geomesa.cassandra.package;
import org.locationtech.geomesa.cassandra.package$NamedColumn$;
import org.locationtech.geomesa.index.api.FilterStrategy;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.index.AttributeIndex;
import org.locationtech.geomesa.index.index.AttributeIndex$;
import org.locationtech.geomesa.index.index.ClientSideFiltering;
import org.locationtech.geomesa.index.index.IndexAdapter;
import org.locationtech.geomesa.index.index.IndexKeySpace;
import org.locationtech.geomesa.index.stats.GeoMesaStats;
import org.locationtech.geomesa.index.strategies.AttributeFilterStrategy;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.index.utils.SplitArrays$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;

public final class CassandraAttributeIndex$
implements AttributeIndex<CassandraDataStore, CassandraFeature, Seq<package.RowValue>, Seq<package.RowRange>>,
CassandraFeatureIndex,
CassandraIndexAdapter<BoxedUnit>,
Product,
Serializable {
    public static final CassandraAttributeIndex$ MODULE$;
    private final int version;
    private final package.NamedColumn Index;
    private final package.NamedColumn Value;
    private final package.NamedColumn Secondary;
    private final package.NamedColumn FeatureId;
    private final Seq<package.NamedColumn> columns;
    private final package.NamedColumn org$locationtech$geomesa$cassandra$index$CassandraIndexAdapter$$FeatureColumn;
    private final ThreadLocal<SimpleFeatureType> sfts;
    private final String name;
    private final Logger logger;
    private final String identifier;
    private final String tableNameKey;
    private volatile byte bitmap$0;

    static {
        new CassandraAttributeIndex$();
    }

    @Override
    public package.NamedColumn org$locationtech$geomesa$cassandra$index$CassandraIndexAdapter$$FeatureColumn() {
        return this.org$locationtech$geomesa$cassandra$index$CassandraIndexAdapter$$FeatureColumn;
    }

    @Override
    public void org$locationtech$geomesa$cassandra$index$CassandraIndexAdapter$_setter_$org$locationtech$geomesa$cassandra$index$CassandraIndexAdapter$$FeatureColumn_$eq(package.NamedColumn x$1) {
        this.org$locationtech$geomesa$cassandra$index$CassandraIndexAdapter$$FeatureColumn = x$1;
    }

    @Override
    public Seq<package.RowValue> createInsert(byte[] row, CassandraFeature cf) {
        return CassandraIndexAdapter$class.createInsert(this, row, cf);
    }

    @Override
    public Seq<package.RowValue> createDelete(byte[] row, CassandraFeature cf) {
        return CassandraIndexAdapter$class.createDelete(this, row, cf);
    }

    @Override
    public QueryPlan<CassandraDataStore, CassandraFeature, Seq<package.RowValue>> scanPlan(SimpleFeatureType sft, CassandraDataStore ds, FilterStrategy<CassandraDataStore, CassandraFeature, Seq<package.RowValue>> filter, Option<BoxedUnit> indexValues, Seq<Seq<package.RowRange>> ranges, Option<Filter> ecql, Hints hints) {
        return CassandraIndexAdapter$class.scanPlan(this, sft, ds, filter, indexValues, ranges, ecql, hints);
    }

    @Override
    public Seq<package.RowRange> range(byte[] start, byte[] end) {
        return CassandraIndexAdapter$class.range(this, start, end);
    }

    @Override
    public Seq<package.RowRange> rangeExact(byte[] row) {
        return CassandraIndexAdapter$class.rangeExact(this, row);
    }

    @Override
    public ThreadLocal<SimpleFeatureType> sfts() {
        return this.sfts;
    }

    @Override
    public /* synthetic */ void org$locationtech$geomesa$cassandra$index$CassandraFeatureIndex$$super$configure(SimpleFeatureType sft, CassandraDataStore ds) {
        GeoMesaFeatureIndex.class.configure((GeoMesaFeatureIndex)this, (SimpleFeatureType)sft, (GeoMesaDataStore)ds);
    }

    @Override
    public /* synthetic */ QueryPlan org$locationtech$geomesa$cassandra$index$CassandraFeatureIndex$$super$getQueryPlan(SimpleFeatureType sft, CassandraDataStore ds, FilterStrategy filter, Hints hints, Explainer explain2) {
        return AttributeIndex.class.getQueryPlan((AttributeIndex)this, (SimpleFeatureType)sft, (GeoMesaDataStore)ds, (FilterStrategy)filter, (Hints)hints, (Explainer)explain2);
    }

    @Override
    public void org$locationtech$geomesa$cassandra$index$CassandraFeatureIndex$_setter_$sfts_$eq(ThreadLocal x$1) {
        this.sfts = x$1;
    }

    @Override
    public void configure(SimpleFeatureType sft, CassandraDataStore ds) {
        CassandraFeatureIndex$class.configure(this, sft, ds);
    }

    @Override
    public void delete(SimpleFeatureType sft, CassandraDataStore ds, boolean shared) {
        CassandraFeatureIndex$class.delete(this, sft, ds, shared);
    }

    @Override
    public QueryPlan<CassandraDataStore, CassandraFeature, Seq<package.RowValue>> getQueryPlan(SimpleFeatureType sft, CassandraDataStore ds, FilterStrategy<CassandraDataStore, CassandraFeature, Seq<package.RowValue>> filter, Hints hints, Explainer explain2) {
        return CassandraFeatureIndex$class.getQueryPlan(this, sft, ds, filter, hints, explain2);
    }

    @Override
    public ClientSideFiltering.RowAndValue rowAndValue(Row result) {
        return CassandraFeatureIndex$class.rowAndValue(this, result);
    }

    public Function1<Iterator<Row>, Iterator<SimpleFeature>> resultsToFeatures(SimpleFeatureType sft, Option<Filter> ecql, Option<Tuple2<String, SimpleFeatureType>> transform) {
        return ClientSideFiltering.class.resultsToFeatures((ClientSideFiltering)this, (SimpleFeatureType)sft, ecql, transform);
    }

    public Function1<Row, SimpleFeature> toFeaturesDirect(SimpleFeatureType sft) {
        return ClientSideFiltering.class.toFeaturesDirect((ClientSideFiltering)this, (SimpleFeatureType)sft);
    }

    public Function1<Row, Option<SimpleFeature>> toFeaturesWithFilter(SimpleFeatureType sft, Filter ecql) {
        return ClientSideFiltering.class.toFeaturesWithFilter((ClientSideFiltering)this, (SimpleFeatureType)sft, (Filter)ecql);
    }

    public Function1<Row, SimpleFeature> toFeaturesWithTransform(SimpleFeatureType sft, TransformProcess.Definition[] transforms, int[] indices, SimpleFeatureType transformSft) {
        return ClientSideFiltering.class.toFeaturesWithTransform((ClientSideFiltering)this, (SimpleFeatureType)sft, (TransformProcess.Definition[])transforms, (int[])indices, (SimpleFeatureType)transformSft);
    }

    public Function1<Row, Option<SimpleFeature>> toFeaturesWithFilterTransform(SimpleFeatureType sft, Filter ecql, TransformProcess.Definition[] transforms, int[] indices, SimpleFeatureType transformSft) {
        return ClientSideFiltering.class.toFeaturesWithFilterTransform((ClientSideFiltering)this, (SimpleFeatureType)sft, (Filter)ecql, (TransformProcess.Definition[])transforms, (int[])indices, (SimpleFeatureType)transformSft);
    }

    public String name() {
        return this.name;
    }

    public void org$locationtech$geomesa$index$index$AttributeIndex$_setter_$name_$eq(String x$1) {
        this.name = x$1;
    }

    public boolean supports(SimpleFeatureType sft) {
        return AttributeIndex.class.supports((AttributeIndex)this, (SimpleFeatureType)sft);
    }

    public Function1 writer(SimpleFeatureType sft, GeoMesaDataStore ds) {
        return AttributeIndex.class.writer((AttributeIndex)this, (SimpleFeatureType)sft, (GeoMesaDataStore)ds);
    }

    public Function1 remover(SimpleFeatureType sft, GeoMesaDataStore ds) {
        return AttributeIndex.class.remover((AttributeIndex)this, (SimpleFeatureType)sft, (GeoMesaDataStore)ds);
    }

    public Function3<byte[], Object, Object, String> getIdFromRow(SimpleFeatureType sft) {
        return AttributeIndex.class.getIdFromRow((AttributeIndex)this, (SimpleFeatureType)sft);
    }

    public Function3<byte[], Object, Object, Try<Object>> decodeRowValue(SimpleFeatureType sft, int index) {
        return AttributeIndex.class.decodeRowValue((AttributeIndex)this, (SimpleFeatureType)sft, (int)index);
    }

    public Seq<byte[]> getSplits(SimpleFeatureType sft) {
        return AttributeIndex.class.getSplits((AttributeIndex)this, (SimpleFeatureType)sft);
    }

    public Function1<CassandraFeature, Seq<Tuple2<Object, byte[]>>> getRowKeys(SimpleFeatureType sft) {
        return AttributeIndex.class.getRowKeys((AttributeIndex)this, (SimpleFeatureType)sft);
    }

    public Option<IndexKeySpace<?>> secondaryIndex(SimpleFeatureType sft) {
        return AttributeIndex.class.secondaryIndex((AttributeIndex)this, (SimpleFeatureType)sft);
    }

    public int getSecondaryIndexKeyLength(SimpleFeatureType sft) {
        return AttributeIndex.class.getSecondaryIndexKeyLength((AttributeIndex)this, (SimpleFeatureType)sft);
    }

    private Logger logger$lzycompute() {
        CassandraAttributeIndex$ cassandraAttributeIndex$ = this;
        synchronized (cassandraAttributeIndex$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public Seq<FilterStrategy<CassandraDataStore, CassandraFeature, Seq<package.RowValue>>> getFilterStrategy(SimpleFeatureType sft, Filter filter, Option<SimpleFeatureType> transform) {
        return AttributeFilterStrategy.class.getFilterStrategy((AttributeFilterStrategy)this, (SimpleFeatureType)sft, (Filter)filter, transform);
    }

    public long getCost(SimpleFeatureType sft, Option<GeoMesaStats> stats, FilterStrategy<CassandraDataStore, CassandraFeature, Seq<package.RowValue>> filter, Option<SimpleFeatureType> transform) {
        return AttributeFilterStrategy.class.getCost((AttributeFilterStrategy)this, (SimpleFeatureType)sft, stats, filter, transform);
    }

    public Object rangePrefix(byte[] prefix) {
        return IndexAdapter.class.rangePrefix((IndexAdapter)this, (byte[])prefix);
    }

    private String identifier$lzycompute() {
        CassandraAttributeIndex$ cassandraAttributeIndex$ = this;
        synchronized (cassandraAttributeIndex$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.identifier = GeoMesaFeatureIndex.class.identifier((GeoMesaFeatureIndex)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.identifier;
        }
    }

    public String identifier() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.identifier$lzycompute() : this.identifier;
    }

    private String tableNameKey$lzycompute() {
        CassandraAttributeIndex$ cassandraAttributeIndex$ = this;
        synchronized (cassandraAttributeIndex$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.tableNameKey = GeoMesaFeatureIndex.class.tableNameKey((GeoMesaFeatureIndex)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.tableNameKey;
        }
    }

    public String tableNameKey() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.tableNameKey$lzycompute() : this.tableNameKey;
    }

    public boolean serializedWithId() {
        return GeoMesaFeatureIndex.class.serializedWithId((GeoMesaFeatureIndex)this);
    }

    public String getTableName(String typeName, GeoMesaDataStore ds) {
        return GeoMesaFeatureIndex.class.getTableName((GeoMesaFeatureIndex)this, (String)typeName, (GeoMesaDataStore)ds);
    }

    public String generateTableName(SimpleFeatureType sft, GeoMesaDataStore ds) {
        return GeoMesaFeatureIndex.class.generateTableName((GeoMesaFeatureIndex)this, (SimpleFeatureType)sft, (GeoMesaDataStore)ds);
    }

    public Explainer getQueryPlan$default$5() {
        return GeoMesaFeatureIndex.class.getQueryPlan$default$5((GeoMesaFeatureIndex)this);
    }

    public int version() {
        return this.version;
    }

    public IndexedSeq<byte[]> getShards(SimpleFeatureType sft) {
        return SplitArrays$.MODULE$.EmptySplits();
    }

    private package.NamedColumn Index() {
        return this.Index;
    }

    private package.NamedColumn Value() {
        return this.Value;
    }

    private package.NamedColumn Secondary() {
        return this.Secondary;
    }

    private package.NamedColumn FeatureId() {
        return this.FeatureId;
    }

    @Override
    public Seq<package.NamedColumn> columns() {
        return this.columns;
    }

    @Override
    public Seq<package.RowValue> rowToColumns(SimpleFeatureType sft, byte[] row) {
        Short index = BoxesRunTime.boxToShort((short)AttributeIndex$.MODULE$.bytesToIndex(row[0], row[1]));
        int offset = 2;
        String lexicoded = null;
        ByteBuffer secondaryIndex = null;
        String featureId = null;
        if (offset < row.length) {
            int i = Predef$.MODULE$.byteArrayOps(row).indexOf((Object)BoxesRunTime.boxToByte((byte)AttributeIndex$.MODULE$.NullByte()), offset);
            int nullByte = i == -1 ? row.length : i;
            lexicoded = new String(row, offset, nullByte - offset, StandardCharsets.UTF_8);
            offset = nullByte + 1;
            int secondaryIndexLength = this.getSecondaryIndexKeyLength(sft);
            if (offset < row.length) {
                int length = package$.MODULE$.min(secondaryIndexLength, row.length - offset);
                secondaryIndex = ByteBuffer.wrap(row, offset, length);
                if ((offset += length) < row.length) {
                    featureId = new String(row, offset, row.length - offset, StandardCharsets.UTF_8);
                }
            }
        }
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.RowValue[]{new package.RowValue(this.Index(), index), new package.RowValue(this.Value(), lexicoded), new package.RowValue(this.Secondary(), secondaryIndex), new package.RowValue(this.FeatureId(), featureId)}));
    }

    @Override
    public byte[] columnsToRow(Seq<package.RowValue> columns) {
        byte[] attributeIndex = AttributeIndex$.MODULE$.indexToBytes((int)BoxesRunTime.unboxToShort((Object)((package.RowValue)columns.head()).value()));
        byte[] lexicodedValue = ((String)((package.RowValue)columns.apply(1)).value()).getBytes(StandardCharsets.UTF_8);
        ByteBuffer secondaryIndex = (ByteBuffer)((package.RowValue)columns.apply(2)).value();
        byte[] fid = ((String)((package.RowValue)columns.apply(3)).value()).getBytes(StandardCharsets.UTF_8);
        byte[] row = (byte[])Array$.MODULE$.ofDim(3 + lexicodedValue.length + secondaryIndex.remaining() + fid.length, ClassTag$.MODULE$.Byte());
        row[0] = attributeIndex[0];
        row[1] = attributeIndex[1];
        System.arraycopy(lexicodedValue, 0, row, 2, lexicodedValue.length);
        int offset = 2 + lexicodedValue.length;
        row[offset] = AttributeIndex$.MODULE$.NullByte();
        int secondaryIndexLength = secondaryIndex.limit();
        secondaryIndex.get(row, ++offset, secondaryIndexLength);
        System.arraycopy(fid, 0, row, offset += secondaryIndexLength, fid.length);
        return row;
    }

    public String productPrefix() {
        return "CassandraAttributeIndex";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CassandraAttributeIndex$;
    }

    public int hashCode() {
        return -840499362;
    }

    public String toString() {
        return "CassandraAttributeIndex";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CassandraAttributeIndex$() {
        MODULE$ = this;
        GeoMesaFeatureIndex.class.$init$((GeoMesaFeatureIndex)this);
        IndexAdapter.class.$init$((IndexAdapter)this);
        AttributeFilterStrategy.class.$init$((AttributeFilterStrategy)this);
        LazyLogging.class.$init$((LazyLogging)this);
        AttributeIndex.class.$init$((AttributeIndex)this);
        ClientSideFiltering.class.$init$((ClientSideFiltering)this);
        CassandraFeatureIndex$class.$init$(this);
        CassandraIndexAdapter$class.$init$(this);
        Product.class.$init$((Product)this);
        this.version = 1;
        this.Index = new package.NamedColumn("attrIdx", 0, "smallint", Short.TYPE, true);
        this.Value = new package.NamedColumn("attrVal", 1, "text", String.class, package$NamedColumn$.MODULE$.apply$default$5());
        this.Secondary = new package.NamedColumn("secondary", 2, "blob", ByteBuffer.class, package$NamedColumn$.MODULE$.apply$default$5());
        this.FeatureId = new package.NamedColumn("fid", 3, "text", String.class, package$NamedColumn$.MODULE$.apply$default$5());
        this.columns = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.NamedColumn[]{this.Index(), this.Value(), this.Secondary(), this.FeatureId()}));
    }
}

