/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.cassandra.index;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TableMetadata;
import java.nio.ByteBuffer;
import org.geotools.factory.Hints;
import org.locationtech.geomesa.cassandra.data.CassandraDataStore;
import org.locationtech.geomesa.cassandra.index.CassandraFeatureIndex;
import org.locationtech.geomesa.cassandra.package;
import org.locationtech.geomesa.index.api.FilterStrategy;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.index.index.ClientSideFiltering;
import org.locationtech.geomesa.index.utils.Explainer;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.NotImplementedError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public abstract class CassandraFeatureIndex$class {
    public static void configure(CassandraFeatureIndex $this, SimpleFeatureType sft, CassandraDataStore ds) {
        $this.org$locationtech$geomesa$cassandra$index$CassandraFeatureIndex$$super$configure(sft, ds);
        String tableName = $this.getTableName(sft.getTypeName(), ds);
        Cluster cluster = ds.session().getCluster();
        TableMetadata table = cluster.getMetadata().getKeyspace(ds.session().getLoggedKeyspace()).getTable(tableName);
        if (table == null) {
            Tuple2 tuple2 = $this.columns().partition((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(package.NamedColumn x$1) {
                    return x$1.partition();
                }
            });
            if (tuple2 != null) {
                BoxedUnit boxedUnit;
                Tuple2 tuple22;
                Seq partitions = (Seq)tuple2._1();
                Seq pks = (Seq)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)partitions, (Object)pks);
                Seq partitions2 = (Seq)tuple23._1();
                Seq pks2 = (Seq)tuple23._2();
                String create = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE ", " (", ", sf blob, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, ((TraversableOnce)$this.columns().map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(package.NamedColumn c) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c.name(), c.cType()}));
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(", ")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PRIMARY KEY (", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)partitions2.map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(package.NamedColumn x$3) {
                        return x$3.name();
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString("(", ", ", ")")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pks2.nonEmpty() ? ((TraversableOnce)pks2.map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(package.NamedColumn x$4) {
                        return x$4.name();
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(", ", ", ", "") : ""}))).toString();
                if ($this.logger().underlying().isInfoEnabled()) {
                    $this.logger().underlying().info(create);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                ds.session().execute(create);
            } else {
                throw new MatchError((Object)tuple2);
            }
        }
    }

    public static void delete(CassandraFeatureIndex $this, SimpleFeatureType sft, CassandraDataStore ds, boolean shared) {
        BoxedUnit boxedUnit;
        if (shared) {
            throw new NotImplementedError();
        }
        String tableName = $this.getTableName(sft.getTypeName(), ds);
        String delete2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop table if exists ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}));
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info(delete2);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ds.session().execute(delete2);
    }

    public static QueryPlan getQueryPlan(CassandraFeatureIndex $this, SimpleFeatureType sft, CassandraDataStore ds, FilterStrategy filter, Hints hints, Explainer explain2) {
        $this.sfts().set(sft);
        try {
            return $this.org$locationtech$geomesa$cassandra$index$CassandraFeatureIndex$$super$getQueryPlan(sft, ds, filter, hints, explain2);
        }
        finally {
            $this.sfts().remove();
        }
    }

    public static ClientSideFiltering.RowAndValue rowAndValue(CassandraFeatureIndex $this, Row result) {
        Seq values = (Seq)$this.columns().map((Function1)new Serializable($this, result){
            public static final long serialVersionUID = 0L;
            private final Row result$1;

            public final package.RowValue apply(package.NamedColumn c) {
                return new package.RowValue(c, this.result$1.get(c.i(), c.jType()));
            }
            {
                this.result$1 = result$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        ByteBuffer sf = result.getBytes("sf");
        byte[] row = $this.columnsToRow((Seq<package.RowValue>)values);
        byte[] value = (byte[])Array$.MODULE$.ofDim(sf.limit(), ClassTag$.MODULE$.Byte());
        sf.get(value);
        return new ClientSideFiltering.RowAndValue(row, 0, row.length, value, 0, value.length);
    }

    public static void $init$(CassandraFeatureIndex $this) {
        $this.org$locationtech$geomesa$cassandra$index$CassandraFeatureIndex$_setter_$sfts_$eq(new ThreadLocal());
    }
}

