/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.cassandra.index;

import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import java.nio.ByteBuffer;
import org.geotools.factory.Hints;
import org.locationtech.geomesa.cassandra.data.CassandraDataStore;
import org.locationtech.geomesa.cassandra.data.CassandraFeature;
import org.locationtech.geomesa.cassandra.data.CassandraQueryPlan;
import org.locationtech.geomesa.cassandra.data.EmptyPlan;
import org.locationtech.geomesa.cassandra.data.QueryPlan;
import org.locationtech.geomesa.cassandra.index.CassandraFeatureIndex;
import org.locationtech.geomesa.cassandra.index.CassandraIndexAdapter;
import org.locationtech.geomesa.cassandra.package;
import org.locationtech.geomesa.cassandra.package$NamedColumn$;
import org.locationtech.geomesa.index.api.FilterStrategy;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.index.ClientSideFiltering;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class CassandraIndexAdapter$class {
    public static Seq createInsert(CassandraIndexAdapter $this, byte[] row, CassandraFeature cf) {
        return (Seq)((CassandraFeatureIndex)((Object)$this)).rowToColumns(cf.feature().getFeatureType(), row).$colon$plus((Object)new package.RowValue($this.org$locationtech$geomesa$cassandra$index$CassandraIndexAdapter$$FeatureColumn(), ByteBuffer.wrap(cf.fullValue())), Seq$.MODULE$.canBuildFrom());
    }

    public static Seq createDelete(CassandraIndexAdapter $this, byte[] row, CassandraFeature cf) {
        return ((CassandraFeatureIndex)((Object)$this)).rowToColumns(cf.feature().getFeatureType(), row);
    }

    public static org.locationtech.geomesa.index.api.QueryPlan scanPlan(CassandraIndexAdapter $this, SimpleFeatureType sft, CassandraDataStore ds, FilterStrategy filter, Option indexValues, Seq ranges, Option ecql, Hints hints) {
        CassandraQueryPlan cassandraQueryPlan;
        if (ranges.isEmpty()) {
            cassandraQueryPlan = new EmptyPlan((FilterStrategy<CassandraDataStore, CassandraFeature, Seq<package.RowValue>>)filter);
        } else {
            String ks = ds.session().getLoggedKeyspace();
            String tableName = ((GeoMesaFeatureIndex)$this).getTableName(sft.getTypeName(), (GeoMesaDataStore)ds);
            Function1 toFeatures = ((ClientSideFiltering)$this).resultsToFeatures(sft, ecql, QueryHints$.MODULE$.RichHints(hints).getTransform());
            Seq statements = (Seq)ranges.map((Function1)new Serializable($this, ks, tableName){
                public static final long serialVersionUID = 0L;
                private final String ks$1;
                private final String tableName$1;

                /*
                 * WARNING - void declaration
                 */
                public final Select apply(Seq<package.RowRange> criteria) {
                    void var2_2;
                    Select select = QueryBuilder.select().all().from(this.ks$1, this.tableName$1);
                    criteria.foreach((Function1)new Serializable(this, select){
                        public static final long serialVersionUID = 0L;
                        private final Select select$1;

                        public final Object apply(package.RowRange c) {
                            Object object;
                            if (BoxesRunTime.equals((Object)c.start(), (Object)c.end())) {
                                object = c.start() == null ? BoxedUnit.UNIT : this.select$1.where(QueryBuilder.eq((String)c.column().name(), (Object)c.start()));
                            } else {
                                Object object2 = c.start() == null ? BoxedUnit.UNIT : this.select$1.where(QueryBuilder.gte((String)c.column().name(), (Object)c.start()));
                                object = c.end() == null ? BoxedUnit.UNIT : this.select$1.where(QueryBuilder.lt((String)c.column().name(), (Object)c.end()));
                            }
                            return object;
                        }
                        {
                            this.select$1 = select$1;
                        }
                    });
                    return var2_2;
                }
                {
                    void var3_3;
                    this.ks$1 = ks$1;
                    this.tableName$1 = var3_3;
                }
            }, Seq$.MODULE$.canBuildFrom());
            cassandraQueryPlan = new QueryPlan((FilterStrategy<CassandraDataStore, CassandraFeature, Seq<package.RowValue>>)filter, tableName, (Seq<Statement>)statements, ds.config().queryThreads(), (Option<Filter>)ecql, (Function1<Iterator<Row>, Iterator<SimpleFeature>>)toFeatures);
        }
        return cassandraQueryPlan;
    }

    public static Seq range(CassandraIndexAdapter $this, byte[] start, byte[] end) {
        SimpleFeatureType sft = ((CassandraFeatureIndex)((Object)$this)).sfts().get();
        Seq<package.RowValue> startValues = ((CassandraFeatureIndex)((Object)$this)).rowToColumns(sft, start);
        Seq<package.RowValue> endValues = ((CassandraFeatureIndex)((Object)$this)).rowToColumns(sft, end);
        return (Seq)((TraversableLike)startValues.zip(endValues, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final package.RowRange apply(Tuple2<package.RowValue, package.RowValue> x0$1) {
                Tuple2<package.RowValue, package.RowValue> tuple2 = x0$1;
                if (tuple2 != null) {
                    package.RowValue s = (package.RowValue)tuple2._1();
                    package.RowValue e = (package.RowValue)tuple2._2();
                    package.RowRange rowRange = new package.RowRange(s.column(), s.value(), e.value());
                    return rowRange;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static Seq rangeExact(CassandraIndexAdapter $this, byte[] row) {
        return (Seq)((CassandraFeatureIndex)((Object)$this)).rowToColumns(((CassandraFeatureIndex)((Object)$this)).sfts().get(), row).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final package.RowRange apply(package.RowValue x0$2) {
                package.RowValue rowValue = x0$2;
                if (rowValue != null) {
                    package.NamedColumn col = rowValue.column();
                    Object v = rowValue.value();
                    package.RowRange rowRange = new package.RowRange(col, v, v);
                    return rowRange;
                }
                throw new MatchError((Object)rowValue);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static void $init$(CassandraIndexAdapter $this) {
        $this.org$locationtech$geomesa$cassandra$index$CassandraIndexAdapter$_setter_$org$locationtech$geomesa$cassandra$index$CassandraIndexAdapter$$FeatureColumn_$eq(new package.NamedColumn("sf", -1, "blob", ByteBuffer.class, package$NamedColumn$.MODULE$.apply$default$5()));
    }
}

