/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.vector;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.NullableFloat8Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.AbstractContainerVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.types.pojo.Field;
import org.locationtech.geomesa.arrow.vector.GeometryFields;
import org.locationtech.geomesa.arrow.vector.impl.AbstractMultiLineStringVector;

public class MultiLineStringVector
extends AbstractMultiLineStringVector {
    public static final List<Field> fields = GeometryFields.XY_DOUBLE_LIST_2;

    public MultiLineStringVector(String name, BufferAllocator allocator, @Nullable Map<String, String> metadata) {
        super(name, allocator, metadata);
    }

    public MultiLineStringVector(String name, AbstractContainerVector container, @Nullable Map<String, String> metadata) {
        super(name, container, metadata);
    }

    public MultiLineStringVector(ListVector vector) {
        super(vector);
    }

    @Override
    protected List<Field> getFields() {
        return fields;
    }

    @Override
    protected AbstractMultiLineStringVector.MultiLineStringWriter createWriter(ListVector vector) {
        return new MultiLineStringDoubleWriter(vector);
    }

    @Override
    protected AbstractMultiLineStringVector.MultiLineStringReader createReader(ListVector vector) {
        return new MultiLineStringDoubleReader(vector);
    }

    public static class MultiLineStringDoubleReader
    extends AbstractMultiLineStringVector.MultiLineStringReader {
        private NullableFloat8Vector.Accessor accessor;

        public MultiLineStringDoubleReader(ListVector vector) {
            super(vector);
        }

        @Override
        protected void setOrdinalAccessor(ValueVector.Accessor accessor) {
            this.accessor = (NullableFloat8Vector.Accessor)accessor;
        }

        @Override
        protected double readOrdinal(int index) {
            return this.accessor.get(index);
        }
    }

    public static class MultiLineStringDoubleWriter
    extends AbstractMultiLineStringVector.MultiLineStringWriter {
        private NullableFloat8Vector.Mutator mutator;

        public MultiLineStringDoubleWriter(ListVector vector) {
            super(vector);
        }

        @Override
        protected void setOrdinalMutator(ValueVector.Mutator mutator) {
            this.mutator = (NullableFloat8Vector.Mutator)mutator;
        }

        @Override
        protected void writeOrdinal(int index, double ordinal) {
            this.mutator.setSafe(index, ordinal);
        }
    }
}

