/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.vector.impl;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.util.List;
import java.util.Map;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.complex.AbstractContainerVector;
import org.apache.arrow.vector.complex.BaseRepeatedValueVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.locationtech.geomesa.arrow.vector.GeometryVector;
import org.locationtech.geomesa.arrow.vector.impl.AbstractGeometryReader;
import org.locationtech.geomesa.arrow.vector.impl.AbstractGeometryWriter;

public abstract class AbstractMultiPolygonVector
implements GeometryVector<MultiPolygon, ListVector> {
    private final ListVector vector;
    private final MultiPolygonWriter writer;
    private final MultiPolygonReader reader;

    public static FieldType createFieldType(Map<String, String> metadata) {
        return new FieldType(true, (ArrowType)ArrowType.List.INSTANCE, null, metadata);
    }

    protected AbstractMultiPolygonVector(String name, BufferAllocator allocator, Map<String, String> metadata) {
        this(new ListVector(name, allocator, AbstractMultiPolygonVector.createFieldType(metadata), null));
    }

    protected AbstractMultiPolygonVector(String name, AbstractContainerVector container, Map<String, String> metadata) {
        this((ListVector)container.addOrGet(name, AbstractMultiPolygonVector.createFieldType(metadata), ListVector.class));
    }

    protected AbstractMultiPolygonVector(ListVector vector) {
        if (vector.getDataVector().equals(BaseRepeatedValueVector.DEFAULT_DATA_VECTOR)) {
            vector.initializeChildrenFromFields(this.getFields());
            vector.allocateNew();
        }
        this.vector = vector;
        this.writer = this.createWriter(vector);
        this.reader = this.createReader(vector);
    }

    protected abstract List<Field> getFields();

    protected abstract MultiPolygonWriter createWriter(ListVector var1);

    protected abstract MultiPolygonReader createReader(ListVector var1);

    public MultiPolygonWriter getWriter() {
        return this.writer;
    }

    public MultiPolygonReader getReader() {
        return this.reader;
    }

    @Override
    public ListVector getVector() {
        return this.vector;
    }

    @Override
    public void close() throws Exception {
        this.vector.close();
    }

    @Override
    public void transfer(int fromIndex, int toIndex, GeometryVector<MultiPolygon, ListVector> to) {
        to.getWriter().set(toIndex, this.reader.get(fromIndex));
    }

    public static abstract class MultiPolygonReader
    extends AbstractGeometryReader<MultiPolygon> {
        private final ListVector.Accessor accessor;
        private final UInt4Vector.Accessor outerOuterOffsets;
        private final UInt4Vector.Accessor outerOffsets;
        private final UInt4Vector.Accessor offsets;

        public MultiPolygonReader(ListVector vector) {
            this.accessor = vector.getAccessor();
            this.outerOuterOffsets = ((UInt4Vector)vector.getFieldInnerVectors().get(1)).getAccessor();
            FieldVector innerList = (FieldVector)vector.getChildrenFromFields().get(0);
            this.outerOffsets = ((UInt4Vector)innerList.getFieldInnerVectors().get(1)).getAccessor();
            FieldVector innerInnerList = (FieldVector)innerList.getChildrenFromFields().get(0);
            this.offsets = ((UInt4Vector)innerInnerList.getFieldInnerVectors().get(1)).getAccessor();
            this.setOrdinalAccessor(((FieldVector)((FieldVector)innerInnerList.getChildrenFromFields().get(0)).getChildrenFromFields().get(0)).getAccessor());
        }

        @Override
        public MultiPolygon get(int index) {
            if (this.accessor.isNull(index)) {
                return null;
            }
            int outerOuterOffsetStart = this.outerOuterOffsets.get(index);
            Polygon[] polygons = new Polygon[this.outerOuterOffsets.get(index + 1) - outerOuterOffsetStart];
            for (int k = 0; k < polygons.length; ++k) {
                int outerOffsetStart = this.outerOffsets.get(outerOuterOffsetStart + k);
                LinearRing shell = null;
                LinearRing[] holes = new LinearRing[this.outerOffsets.get(outerOuterOffsetStart + k + 1) - outerOffsetStart - 1];
                for (int j = 0; j < holes.length + 1; ++j) {
                    int offsetStart = this.offsets.get(outerOffsetStart + j);
                    Coordinate[] coordinates = new Coordinate[this.offsets.get(outerOffsetStart + j + 1) - offsetStart];
                    for (int i = 0; i < coordinates.length; ++i) {
                        double y = this.readOrdinal((offsetStart + i) * 2);
                        double x = this.readOrdinal((offsetStart + i) * 2 + 1);
                        coordinates[i] = new Coordinate(x, y);
                    }
                    LinearRing ring = GeometryVector.factory.createLinearRing(coordinates);
                    if (j == 0) {
                        shell = ring;
                        continue;
                    }
                    holes[j - 1] = ring;
                }
                polygons[k] = GeometryVector.factory.createPolygon(shell, holes);
            }
            return GeometryVector.factory.createMultiPolygon(polygons);
        }

        @Override
        public int getValueCount() {
            return this.accessor.getValueCount();
        }

        @Override
        public int getNullCount() {
            int count = this.accessor.getNullCount();
            if (count < 0) {
                return 0;
            }
            return count;
        }
    }

    public static abstract class MultiPolygonWriter
    extends AbstractGeometryWriter<MultiPolygon> {
        private final BitVector.Mutator nullSet;
        private final ListVector.Mutator mutator;
        private final ListVector.Mutator innerMutator;
        private final ListVector.Mutator innerInnerMutator;
        private final FixedSizeListVector.Mutator tupleMutator;

        protected MultiPolygonWriter(ListVector vector) {
            this.nullSet = ((BitVector)vector.getFieldInnerVectors().get(0)).getMutator();
            ListVector innerList = (ListVector)vector.getChildrenFromFields().get(0);
            ListVector innerInnerList = (ListVector)innerList.getChildrenFromFields().get(0);
            FixedSizeListVector tuples = (FixedSizeListVector)innerInnerList.getChildrenFromFields().get(0);
            this.mutator = vector.getMutator();
            this.innerMutator = innerList.getMutator();
            this.innerInnerMutator = innerInnerList.getMutator();
            this.tupleMutator = tuples.getMutator();
            this.setOrdinalMutator(((FieldVector)tuples.getChildrenFromFields().get(0)).getMutator());
        }

        @Override
        public void set(int index, MultiPolygon geom) {
            if (index == 0) {
                this.mutator.setLastSet(0);
                this.innerMutator.setLastSet(0);
                this.innerInnerMutator.setLastSet(0);
            }
            if (geom == null) {
                this.nullSet.setSafe(index, 0);
            } else {
                int innerIndex = this.mutator.startNewValue(index);
                for (int i = 0; i < geom.getNumGeometries(); ++i) {
                    Polygon poly = (Polygon)geom.getGeometryN(i);
                    int innerInnerIndex = this.innerMutator.startNewValue(innerIndex + i);
                    for (int j = 0; j < poly.getNumInteriorRing() + 1; ++j) {
                        LineString line = j == 0 ? poly.getExteriorRing() : poly.getInteriorRingN(j - 1);
                        int position = this.innerInnerMutator.startNewValue(innerInnerIndex + j);
                        for (int k = 0; k < line.getNumPoints(); ++k) {
                            Coordinate p = line.getCoordinateN(k);
                            this.tupleMutator.setNotNull(position + k);
                            this.writeOrdinal((position + k) * 2, p.y);
                            this.writeOrdinal((position + k) * 2 + 1, p.x);
                        }
                        this.innerInnerMutator.endValue(innerInnerIndex + j, line.getNumPoints());
                    }
                    this.innerMutator.endValue(innerIndex + i, poly.getNumInteriorRing() + 1);
                }
                this.mutator.endValue(index, geom.getNumGeometries());
            }
        }

        @Override
        public void setValueCount(int count) {
            this.mutator.setValueCount(count);
        }
    }
}

