/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.planning;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import com.vividsolutions.jts.geom.Geometry;
import java.util.List;
import org.geotools.data.Query;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.MathExpressionImpl;
import org.geotools.filter.expression.PropertyAccessors;
import org.geotools.process.vector.TransformProcess;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.index.conf.QueryHints$Internal$;
import org.locationtech.geomesa.utils.cache.SoftThreadLocal;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class QueryPlanner$
implements LazyLogging {
    public static final QueryPlanner$ MODULE$;
    private final SoftThreadLocal<Map<Object, Object>> threadedHints;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new QueryPlanner$();
    }

    private Logger logger$lzycompute() {
        QueryPlanner$ queryPlanner$ = this;
        synchronized (queryPlanner$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public SoftThreadLocal<Map<Object, Object>> threadedHints() {
        return this.threadedHints;
    }

    public void setPerThreadQueryHints(Map<Object, Object> hints) {
        this.threadedHints().put(hints);
    }

    public Option<Map<Object, Object>> getPerThreadQueryHints() {
        return this.threadedHints().get();
    }

    public void clearPerThreadQueryHints() {
        this.threadedHints().clear();
    }

    public void setQueryTransforms(Query query, SimpleFeatureType sft) {
        String[] properties = query.getPropertyNames();
        query.setProperties(Query.ALL_PROPERTIES);
        if (properties != null) {
            Seq seq = Predef$.MODULE$.refArrayOps((Object[])properties).toSeq();
            Object object = JavaConversions$.MODULE$.asScalaBuffer(sft.getAttributeDescriptors()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(AttributeDescriptor x$10) {
                    return x$10.getLocalName();
                }
            }, Buffer$.MODULE$.canBuildFrom());
            if (seq == null ? object != null : !seq.equals(object)) {
                Tuple2<String, SimpleFeatureType> tuple2 = this.buildTransformSFT(sft, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])properties));
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    String transforms = (String)tuple2._1();
                    SimpleFeatureType derivedSchema = (SimpleFeatureType)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)transforms, (Object)derivedSchema);
                    String transforms2 = (String)tuple23._1();
                    SimpleFeatureType derivedSchema2 = (SimpleFeatureType)tuple23._2();
                    query.getHints().put((Object)QueryHints$Internal$.MODULE$.TRANSFORMS(), (Object)transforms2);
                    query.getHints().put((Object)QueryHints$Internal$.MODULE$.TRANSFORM_SCHEMA(), (Object)derivedSchema2);
                } else {
                    throw new MatchError(tuple2);
                }
            }
        }
    }

    public Tuple2<String, SimpleFeatureType> buildTransformSFT(SimpleFeatureType sft, Seq<String> properties) {
        String transforms = ((TraversableOnce)properties.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String p) {
                return new StringOps(Predef$.MODULE$.augmentString(p)).contains((Object)BoxesRunTime.boxToCharacter((char)'=')) ? p : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p, p}));
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(";");
        List transformDefs = TransformProcess.toDefinition((String)transforms);
        SimpleFeatureType derivedSchema = this.computeSchema(sft, (Seq<TransformProcess.Definition>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(transformDefs).asScala()));
        return new Tuple2((Object)transforms, (Object)derivedSchema);
    }

    private SimpleFeatureType computeSchema(SimpleFeatureType origSFT, Seq<TransformProcess.Definition> transforms) {
        Seq descriptors = (Seq)transforms.map((Function1)new Serializable(origSFT){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType origSFT$1;

            public final AttributeDescriptor apply(TransformProcess.Definition definition) {
                Expression expression;
                block8: {
                    AttributeDescriptor attributeDescriptor;
                    block6: {
                        String name;
                        block7: {
                            block2: {
                                String prop;
                                block5: {
                                    GeometryDescriptor geometryDescriptor;
                                    block4: {
                                        block3: {
                                            name = definition.name;
                                            Expression cql = definition.expression;
                                            expression = cql;
                                            if (!(expression instanceof PropertyName)) break block2;
                                            PropertyName propertyName = (PropertyName)expression;
                                            prop = propertyName.getPropertyName();
                                            if (!JavaConversions$.MODULE$.asScalaBuffer(this.origSFT$1.getAttributeDescriptors()).exists((Function1)new Serializable(this, prop){
                                                public static final long serialVersionUID = 0L;
                                                private final String prop$1;

                                                public final boolean apply(AttributeDescriptor x$12) {
                                                    String string = x$12.getLocalName();
                                                    String string2 = this.prop$1;
                                                    return !(string != null ? !string.equals(string2) : string2 != null);
                                                }
                                                {
                                                    this.prop$1 = prop$1;
                                                }
                                            })) break block3;
                                            AttributeDescriptor origAttr = this.origSFT$1.getDescriptor(prop);
                                            AttributeTypeBuilder ab = new AttributeTypeBuilder();
                                            ab.init(origAttr);
                                            GeometryDescriptor descriptor = origAttr instanceof GeometryDescriptor ? ab.buildDescriptor(name, ab.buildGeometryType()) : ab.buildDescriptor(name, ab.buildType());
                                            descriptor.getUserData().putAll(origAttr.getUserData());
                                            geometryDescriptor = descriptor;
                                            break block4;
                                        }
                                        if (!JavaConversions$.MODULE$.asScalaBuffer(PropertyAccessors.findPropertyAccessors((Object)new ScalaSimpleFeature(this.origSFT$1, "", ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$3(), ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4()), (String)prop, null, null)).nonEmpty()) break block5;
                                        AttributeTypeBuilder ab = new AttributeTypeBuilder().binding(String.class);
                                        geometryDescriptor = ab.buildDescriptor(name, ab.buildType());
                                    }
                                    attributeDescriptor = geometryDescriptor;
                                    break block6;
                                }
                                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attribute '", "' does not exist in SFT '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prop, this.origSFT$1.getTypeName()})));
                            }
                            if (!(expression instanceof FunctionExpressionImpl)) break block7;
                            FunctionExpressionImpl functionExpressionImpl = (FunctionExpressionImpl)expression;
                            Class clazz = functionExpressionImpl.getFunctionName().getReturn().getType();
                            AttributeTypeBuilder ab = new AttributeTypeBuilder().binding(clazz);
                            attributeDescriptor = Geometry.class.isAssignableFrom(clazz) ? ab.buildDescriptor(name, ab.buildGeometryType()) : ab.buildDescriptor(name, ab.buildType());
                            break block6;
                        }
                        if (!(expression instanceof MathExpressionImpl)) break block8;
                        AttributeTypeBuilder ab = new AttributeTypeBuilder().binding(Double.class);
                        attributeDescriptor = ab.buildDescriptor(name, ab.buildType());
                    }
                    return attributeDescriptor;
                }
                throw new MatchError((Object)expression);
            }
            {
                this.origSFT$1 = origSFT$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq geomAttributes = (Seq)((TraversableLike)descriptors.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(AttributeDescriptor x$13) {
                return x$13 instanceof GeometryDescriptor;
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(AttributeDescriptor x$14) {
                return x$14.getLocalName();
            }
        }, Seq$.MODULE$.canBuildFrom());
        SimpleFeatureTypeBuilder sftBuilder = new SimpleFeatureTypeBuilder();
        sftBuilder.setName(origSFT.getName());
        sftBuilder.addAll((AttributeDescriptor[])descriptors.toArray(ClassTag$.MODULE$.apply(AttributeDescriptor.class)));
        if (geomAttributes.nonEmpty()) {
            String string;
            if (geomAttributes.size() == 1) {
                string = (String)geomAttributes.head();
            } else {
                String origDefaultGeom = origSFT.getGeometryDescriptor().getLocalName();
                string = (String)geomAttributes.find((Function1)new Serializable(origDefaultGeom){
                    public static final long serialVersionUID = 0L;
                    private final String origDefaultGeom$1;

                    public final boolean apply(String x$15) {
                        String string = x$15;
                        String string2 = this.origDefaultGeom$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.origDefaultGeom$1 = origDefaultGeom$1;
                    }
                }).getOrElse((Function0)new Serializable(geomAttributes){
                    public static final long serialVersionUID = 0L;
                    private final Seq geomAttributes$1;

                    public final String apply() {
                        return (String)this.geomAttributes$1.head();
                    }
                    {
                        this.geomAttributes$1 = geomAttributes$1;
                    }
                });
            }
            String defaultGeom = string;
            sftBuilder.setDefaultGeometry(defaultGeom);
        }
        SimpleFeatureType schema = sftBuilder.buildFeatureType();
        schema.getUserData().putAll(origSFT.getUserData());
        return schema;
    }

    private QueryPlanner$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.threadedHints = new SoftThreadLocal();
    }
}

