/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geojson.geom;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.geotools.geojson.DelegatingHandler;
import org.geotools.geojson.geom.GeometryHandlerBase;
import org.json.simple.parser.ParseException;

public class GeometryCollectionHandler
extends DelegatingHandler<GeometryCollection> {
    GeometryFactory factory;
    List<Geometry> geoms;
    GeometryCollection value;
    Class delegateClass;

    public GeometryCollectionHandler(GeometryFactory factory) {
        this.factory = factory;
    }

    @Override
    public boolean startObject() throws ParseException, IOException {
        if (this.geoms != null) {
            this.delegate = UNINITIALIZED;
        }
        return true;
    }

    @Override
    public boolean endObject() throws ParseException, IOException {
        if (this.delegate instanceof GeometryHandlerBase) {
            ((GeometryHandlerBase)this.delegate).endObject();
            this.geoms.add((Geometry)((GeometryHandlerBase)this.delegate).getValue());
            this.delegate = NULL;
        } else {
            Geometry[] geometries = this.geoms.toArray(new Geometry[this.geoms.size()]);
            this.value = this.factory.createGeometryCollection(geometries);
            this.geoms = null;
        }
        return true;
    }

    @Override
    public boolean startObjectEntry(String key) throws ParseException, IOException {
        if ("geometries".equals(key)) {
            this.geoms = new ArrayList<Geometry>();
        } else if (this.geoms != null) {
            super.startObjectEntry(key);
        }
        return true;
    }

    @Override
    public boolean endObjectEntry() throws ParseException, IOException {
        if (this.delegateClass != null) {
            this.delegate = this.createDelegate(this.delegateClass, new Object[]{this.factory});
            this.delegateClass = null;
        }
        return true;
    }

    @Override
    public boolean primitive(Object value) throws ParseException, IOException {
        if (this.geoms == null || this.delegate != UNINITIALIZED) {
            return super.primitive(value);
        }
        this.delegateClass = this.lookupDelegate(value.toString());
        return true;
    }

    @Override
    public GeometryCollection getValue() {
        return this.value;
    }
}

