/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.jobs.mapreduce;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Closeable;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.opengis.feature.simple.SimpleFeature;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00055e!B\u0001\u0003\u0003\u0003i!A\u0006$jY\u0016\u001cFO]3b[J+7m\u001c:e%\u0016\fG-\u001a:\u000b\u0005\r!\u0011!C7baJ,G-^2f\u0015\t)a!\u0001\u0003k_\n\u001c(BA\u0004\t\u0003\u001d9Wm\\7fg\u0006T!!\u0003\u0006\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b(!\u0011yQcF\u000f\u000e\u0003AQ!aA\t\u000b\u0005I\u0019\u0012A\u00025bI>|\u0007O\u0003\u0002\u0015\u0015\u00051\u0011\r]1dQ\u0016L!A\u0006\t\u0003\u0019I+7m\u001c:e%\u0016\fG-\u001a:\u0011\u0005aYR\"A\r\u000b\u0005i\t\u0012AA5p\u0013\ta\u0012D\u0001\u0007M_:<wK]5uC\ndW\r\u0005\u0002\u001fK5\tqD\u0003\u0002!C\u000511/[7qY\u0016T!AI\u0012\u0002\u000f\u0019,\u0017\r^;sK*\u0011AEC\u0001\b_B,gnZ5t\u0013\t1sDA\u0007TS6\u0004H.\u001a$fCR,(/\u001a\t\u0003Q=j\u0011!\u000b\u0006\u0003U-\nAb]2bY\u0006dwnZ4j]\u001eT!\u0001L\u0017\u0002\u0011QL\b/Z:bM\u0016T\u0011AL\u0001\u0004G>l\u0017B\u0001\u0019*\u0005-a\u0015M_=M_\u001e<\u0017N\\4\t\u000bI\u0002A\u0011A\u001a\u0002\rqJg.\u001b;?)\u0005!\u0004CA\u001b\u0001\u001b\u0005\u0011\u0001bB\u001c\u0001\u0001\u0004%I\u0001O\u0001\u0004I\u0016\u001cW#A\u001d\u0011\u0005ijT\"A\u001e\u000b\u0005qJ\u0012\u0001C2p[B\u0014Xm]:\n\u0005yZ$\u0001\u0004#fG>l\u0007O]3tg>\u0014\bb\u0002!\u0001\u0001\u0004%I!Q\u0001\bI\u0016\u001cw\fJ3r)\t\u0011\u0005\n\u0005\u0002D\r6\tAIC\u0001F\u0003\u0015\u00198-\u00197b\u0013\t9EI\u0001\u0003V]&$\bbB%@\u0003\u0003\u0005\r!O\u0001\u0004q\u0012\n\u0004BB&\u0001A\u0003&\u0011(\u0001\u0003eK\u000e\u0004\u0003bB'\u0001\u0001\u0004%IAT\u0001\u0007gR\u0014X-Y7\u0016\u0003=\u00132\u0001\u0015*Z\r\u0011\t\u0006\u0001A(\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\u0005M;V\"\u0001+\u000b\u0005i)&\"\u0001,\u0002\t)\fg/Y\u0005\u00031R\u00131\"\u00138qkR\u001cFO]3b[B\u0011!,X\u0007\u00027*\u0011A,E\u0001\u0003MNL!AX.\u0003\u0011M+Wm[1cY\u0016Dq\u0001\u0019\u0001A\u0002\u0013%\u0011-\u0001\u0006tiJ,\u0017-\\0%KF$\"A\u00112\t\u000f%{\u0016\u0011!a\u0001\u001f\"1A\r\u0001Q!\n=\u000bqa\u001d;sK\u0006l\u0007\u0005C\u0004g\u0001\u0001\u0007I\u0011B4\u0002\t%$XM]\u000b\u0002QJ\u0019\u0011N\u001b<\u0007\tE\u0003\u0001\u0001\u001b\t\u0004WNlbB\u00017r\u001d\ti\u0007/D\u0001o\u0015\tyG\"\u0001\u0004=e>|GOP\u0005\u0002\u000b&\u0011!\u000fR\u0001\ba\u0006\u001c7.Y4f\u0013\t!XO\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\t\u0011H\t\u0005\u0002To&\u0011\u0001\u0010\u0016\u0002\n\u00072|7/Z1cY\u0016DqA\u001f\u0001A\u0002\u0013%10\u0001\u0005ji\u0016\u0014x\fJ3r)\t\u0011E\u0010C\u0004Js\u0006\u0005\t\u0019\u00015\t\ry\u0004\u0001\u0015)\u0003i\u0003\u0015IG/\u001a:!\u0011%\t\t\u0001\u0001a\u0001\n\u0013\t\u0019!\u0001\u0004mK:<G\u000f[\u000b\u0003\u0003\u000b\u00012aQA\u0004\u0013\r\tI\u0001\u0012\u0002\u0006\r2|\u0017\r\u001e\u0005\n\u0003\u001b\u0001\u0001\u0019!C\u0005\u0003\u001f\t!\u0002\\3oORDw\fJ3r)\r\u0011\u0015\u0011\u0003\u0005\n\u0013\u0006-\u0011\u0011!a\u0001\u0003\u000bA\u0001\"!\u0006\u0001A\u0003&\u0011QA\u0001\bY\u0016tw\r\u001e5!\u0011%\tI\u0002\u0001b\u0001\n\u0013\tY\"\u0001\u0004dkJ\\U-_\u000b\u0002/!9\u0011q\u0004\u0001!\u0002\u00139\u0012aB2ve.+\u0017\u0010\t\u0005\n\u0003G\u0001\u0001\u0019!C\u0005\u0003K\t\u0001bY;s-\u0006dW/Z\u000b\u0002;!I\u0011\u0011\u0006\u0001A\u0002\u0013%\u00111F\u0001\rGV\u0014h+\u00197vK~#S-\u001d\u000b\u0004\u0005\u00065\u0002\u0002C%\u0002(\u0005\u0005\t\u0019A\u000f\t\u000f\u0005E\u0002\u0001)Q\u0005;\u0005I1-\u001e:WC2,X\r\t\u0005\b\u0003k\u0001a\u0011AA\u001c\u00039\u0019'/Z1uK&#XM]1u_J$\u0002\"!\u000f\u0002>\u0005\r\u0013Q\n\n\u0005\u0003wQgOB\u0003R\u0001\u0001\tI\u0004C\u0004N\u0003g\u0001\r!a\u0010\u0013\t\u0005\u0005#+\u0017\u0004\u0006#\u0002\u0001\u0011q\b\u0005\t\u0003\u000b\n\u0019\u00041\u0001\u0002H\u0005Aa-\u001b7f!\u0006$\b\u000eE\u0002[\u0003\u0013J1!a\u0013\\\u0005\u0011\u0001\u0016\r\u001e5\t\u0011\u0005=\u00131\u0007a\u0001\u0003#\nqaY8oi\u0016DH\u000fE\u0002\u0010\u0003'J1!!\u0016\u0011\u0005I!\u0016m]6BiR,W\u000e\u001d;D_:$X\r\u001f;\t\u000f\u0005e\u0003\u0001\"\u0011\u0002\\\u0005Yq-\u001a;Qe><'/Z:t)\t\t)\u0001C\u0004\u0002`\u0001!\t%!\u0019\u0002\u00199,\u0007\u0010^&fsZ\u000bG.^3\u0015\u0005\u0005\r\u0004cA\"\u0002f%\u0019\u0011q\r#\u0003\u000f\t{w\u000e\\3b]\"9\u00111\u000e\u0001\u0005B\u00055\u0014aD4fi\u000e+(O]3oiZ\u000bG.^3\u0015\u0003uAq!!\u001d\u0001\t\u0003\n\u0019(\u0001\u0006j]&$\u0018.\u00197ju\u0016$RAQA;\u0003\u007fB\u0001\"a\u001e\u0002p\u0001\u0007\u0011\u0011P\u0001\u0006gBd\u0017\u000e\u001e\t\u0004\u001f\u0005m\u0014bAA?!\tQ\u0011J\u001c9viN\u0003H.\u001b;\t\u0011\u0005=\u0013q\u000ea\u0001\u0003#Bq!a!\u0001\t\u0003\n))A\u0007hKR\u001cUO\u001d:f]R\\U-\u001f\u000b\u0002/!9\u0011\u0011\u0012\u0001\u0005B\u0005-\u0015!B2m_N,G#\u0001\"")
public abstract class FileStreamRecordReader
extends RecordReader<LongWritable, SimpleFeature>
implements LazyLogging {
    private Decompressor dec;
    private InputStream stream;
    private Iterator<SimpleFeature> iter;
    private float length;
    private final LongWritable curKey;
    private SimpleFeature curValue;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        FileStreamRecordReader fileStreamRecordReader = this;
        synchronized (fileStreamRecordReader) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private Decompressor dec() {
        return this.dec;
    }

    private void dec_$eq(Decompressor x$1) {
        this.dec = x$1;
    }

    private InputStream stream() {
        return this.stream;
    }

    private void stream_$eq(InputStream x$1) {
        this.stream = x$1;
    }

    private Iterator<SimpleFeature> iter() {
        return this.iter;
    }

    private void iter_$eq(Iterator<SimpleFeature> x$1) {
        this.iter = x$1;
    }

    private float length() {
        return this.length;
    }

    private void length_$eq(float x$1) {
        this.length = x$1;
    }

    private LongWritable curKey() {
        return this.curKey;
    }

    private SimpleFeature curValue() {
        return this.curValue;
    }

    private void curValue_$eq(SimpleFeature x$1) {
        this.curValue = x$1;
    }

    public abstract Iterator<SimpleFeature> createIterator(InputStream var1, Path var2, TaskAttemptContext var3);

    public float getProgress() {
        return this.length() == 0.0f ? 0.0f : package$.MODULE$.min(1.0f, (float)((double)((Seekable)this.stream()).getPos() / (double)this.length()));
    }

    public boolean nextKeyValue() {
        boolean bl;
        if (this.iter().hasNext()) {
            this.curKey().set(this.curKey().get() + 1L);
            this.curValue_$eq((SimpleFeature)this.iter().next());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public SimpleFeature getCurrentValue() {
        return this.curValue();
    }

    public void initialize(InputSplit split, TaskAttemptContext context) {
        BoxedUnit boxedUnit;
        FSDataInputStream fSDataInputStream;
        Configuration job = context.getConfiguration();
        Path path = ((FileSplit)split).getPath();
        CompressionCodec codec = new CompressionCodecFactory(job).getCodec(path);
        FileSystem fs = path.getFileSystem(job);
        this.length_$eq(split.getLength());
        if (codec == null) {
            fSDataInputStream = fs.open(path);
        } else {
            this.dec_$eq(CodecPool.getDecompressor((CompressionCodec)codec));
            fSDataInputStream = codec.createInputStream((InputStream)fs.open(path), this.dec());
        }
        this.stream_$eq((InputStream)fSDataInputStream);
        this.iter_$eq(this.createIterator(this.stream(), path, context));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initialized record reader on split ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path.toString()})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public LongWritable getCurrentKey() {
        return this.curKey();
    }

    public void close() {
        IOUtils.closeQuietly((Closeable)((Closeable)this.iter()));
        IOUtils.closeQuietly((InputStream)this.stream());
        if (this.dec() != null) {
            CodecPool.returnDecompressor((Decompressor)this.dec());
        }
    }

    public FileStreamRecordReader() {
        LazyLogging.class.$init$((LazyLogging)this);
        this.dec = null;
        this.stream = null;
        this.iter = null;
        this.length = 0.0f;
        this.curKey = new LongWritable(0L);
        this.curValue = null;
    }
}

