/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.curve;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.Weeks;
import org.joda.time.Years;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.TimePeriod$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class BinnedTime$
implements Serializable {
    public static final BinnedTime$ MODULE$;
    private final DateTime Epoch;
    private final DateTime ZMinDate;
    private final DateTime DaysMaxDate;
    private final DateTime WeeksMaxDate;
    private final DateTime MonthsMaxDate;
    private final DateTime YearsMaxDate;

    static {
        new BinnedTime$();
    }

    public DateTime Epoch() {
        return this.Epoch;
    }

    public DateTime ZMinDate() {
        return this.ZMinDate;
    }

    public DateTime DaysMaxDate() {
        return this.DaysMaxDate;
    }

    public DateTime WeeksMaxDate() {
        return this.WeeksMaxDate;
    }

    public DateTime MonthsMaxDate() {
        return this.MonthsMaxDate;
    }

    public DateTime YearsMaxDate() {
        return this.YearsMaxDate;
    }

    public Function1<Object, BinnedTime> timeToBinnedTime(Enumeration.Value period) {
        Enumeration.Value value;
        block6: {
            Object object;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            value = period;
                            Enumeration.Value value2 = TimePeriod$.MODULE$.Day();
                            Enumeration.Value value3 = value;
                            if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                            object = new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final BinnedTime apply(long time) {
                                    return BinnedTime$.MODULE$.org$locationtech$geomesa$curve$BinnedTime$$toDayAndMillis(time);
                                }
                            };
                            break block3;
                        }
                        Enumeration.Value value4 = TimePeriod$.MODULE$.Week();
                        Enumeration.Value value5 = value;
                        if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                        object = new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final BinnedTime apply(long time) {
                                return BinnedTime$.MODULE$.org$locationtech$geomesa$curve$BinnedTime$$toWeekAndSeconds(time);
                            }
                        };
                        break block3;
                    }
                    Enumeration.Value value6 = TimePeriod$.MODULE$.Month();
                    Enumeration.Value value7 = value;
                    if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                    object = new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final BinnedTime apply(long time) {
                            return BinnedTime$.MODULE$.org$locationtech$geomesa$curve$BinnedTime$$toMonthAndSeconds(time);
                        }
                    };
                    break block3;
                }
                Enumeration.Value value8 = TimePeriod$.MODULE$.Year();
                Enumeration.Value value9 = value;
                if (value8 != null ? !value8.equals(value9) : value9 != null) break block6;
                object = new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final BinnedTime apply(long time) {
                        return BinnedTime$.MODULE$.org$locationtech$geomesa$curve$BinnedTime$$toYearAndMinutes(time);
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    public Function1<DateTime, BinnedTime> dateToBinnedTime(Enumeration.Value period) {
        Enumeration.Value value;
        block6: {
            Object object;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            value = period;
                            Enumeration.Value value2 = TimePeriod$.MODULE$.Day();
                            Enumeration.Value value3 = value;
                            if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                            object = new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final BinnedTime apply(DateTime date) {
                                    return BinnedTime$.MODULE$.org$locationtech$geomesa$curve$BinnedTime$$toDayAndMillis(date);
                                }
                            };
                            break block3;
                        }
                        Enumeration.Value value4 = TimePeriod$.MODULE$.Week();
                        Enumeration.Value value5 = value;
                        if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                        object = new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final BinnedTime apply(DateTime date) {
                                return BinnedTime$.MODULE$.org$locationtech$geomesa$curve$BinnedTime$$toWeekAndSeconds(date);
                            }
                        };
                        break block3;
                    }
                    Enumeration.Value value6 = TimePeriod$.MODULE$.Month();
                    Enumeration.Value value7 = value;
                    if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                    object = new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final BinnedTime apply(DateTime date) {
                            return BinnedTime$.MODULE$.org$locationtech$geomesa$curve$BinnedTime$$toMonthAndSeconds(date);
                        }
                    };
                    break block3;
                }
                Enumeration.Value value8 = TimePeriod$.MODULE$.Year();
                Enumeration.Value value9 = value;
                if (value8 != null ? !value8.equals(value9) : value9 != null) break block6;
                object = new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final BinnedTime apply(DateTime date) {
                        return BinnedTime$.MODULE$.org$locationtech$geomesa$curve$BinnedTime$$toYearAndMinutes(date);
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    public Function1<BinnedTime, DateTime> binnedTimeToDate(Enumeration.Value period) {
        Enumeration.Value value;
        block6: {
            Object object;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            value = period;
                            Enumeration.Value value2 = TimePeriod$.MODULE$.Day();
                            Enumeration.Value value3 = value;
                            if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                            object = new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final DateTime apply(BinnedTime date) {
                                    return BinnedTime$.MODULE$.org$locationtech$geomesa$curve$BinnedTime$$fromDayAndMillis(date);
                                }
                            };
                            break block3;
                        }
                        Enumeration.Value value4 = TimePeriod$.MODULE$.Week();
                        Enumeration.Value value5 = value;
                        if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                        object = new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final DateTime apply(BinnedTime date) {
                                return BinnedTime$.MODULE$.org$locationtech$geomesa$curve$BinnedTime$$fromWeekAndSeconds(date);
                            }
                        };
                        break block3;
                    }
                    Enumeration.Value value6 = TimePeriod$.MODULE$.Month();
                    Enumeration.Value value7 = value;
                    if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                    object = new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final DateTime apply(BinnedTime date) {
                            return BinnedTime$.MODULE$.org$locationtech$geomesa$curve$BinnedTime$$fromMonthAndSeconds(date);
                        }
                    };
                    break block3;
                }
                Enumeration.Value value8 = TimePeriod$.MODULE$.Year();
                Enumeration.Value value9 = value;
                if (value8 != null ? !value8.equals(value9) : value9 != null) break block6;
                object = new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final DateTime apply(BinnedTime date) {
                        return BinnedTime$.MODULE$.org$locationtech$geomesa$curve$BinnedTime$$fromYearAndMinutes(date);
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    public long maxOffset(Enumeration.Value period) {
        Enumeration.Value value;
        block6: {
            long l;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            value = period;
                            Enumeration.Value value2 = TimePeriod$.MODULE$.Day();
                            Enumeration.Value value3 = value;
                            if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                            l = Days.ONE.toStandardDuration().getMillis();
                            break block3;
                        }
                        Enumeration.Value value4 = TimePeriod$.MODULE$.Week();
                        Enumeration.Value value5 = value;
                        if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                        l = Weeks.ONE.toStandardDuration().getMillis() / 1000L;
                        break block3;
                    }
                    Enumeration.Value value6 = TimePeriod$.MODULE$.Month();
                    Enumeration.Value value7 = value;
                    if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                    l = Days.ONE.toStandardDuration().getMillis() / 1000L * 31L;
                    break block3;
                }
                Enumeration.Value value8 = TimePeriod$.MODULE$.Year();
                Enumeration.Value value9 = value;
                if (value8 != null ? !value8.equals(value9) : value9 != null) break block6;
                l = Weeks.ONE.toStandardDuration().getMillis() / 60000L * 52L;
            }
            return l;
        }
        throw new MatchError((Object)value);
    }

    public DateTime maxDate(Enumeration.Value period) {
        Enumeration.Value value;
        block6: {
            DateTime dateTime;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            value = period;
                            Enumeration.Value value2 = TimePeriod$.MODULE$.Day();
                            Enumeration.Value value3 = value;
                            if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                            dateTime = this.DaysMaxDate();
                            break block3;
                        }
                        Enumeration.Value value4 = TimePeriod$.MODULE$.Week();
                        Enumeration.Value value5 = value;
                        if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                        dateTime = this.WeeksMaxDate();
                        break block3;
                    }
                    Enumeration.Value value6 = TimePeriod$.MODULE$.Month();
                    Enumeration.Value value7 = value;
                    if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                    dateTime = this.MonthsMaxDate();
                    break block3;
                }
                Enumeration.Value value8 = TimePeriod$.MODULE$.Year();
                Enumeration.Value value9 = value;
                if (value8 != null ? !value8.equals(value9) : value9 != null) break block6;
                dateTime = this.YearsMaxDate();
            }
            return dateTime;
        }
        throw new MatchError((Object)value);
    }

    public Function1<Tuple2<Option<DateTime>, Option<DateTime>>, Tuple2<DateTime, DateTime>> boundsToIndexableDates(Enumeration.Value period) {
        DateTime maxDateTime = this.maxDate(period).minus(1L);
        return new Serializable(maxDateTime){
            public static final long serialVersionUID = 0L;
            private final DateTime maxDateTime$1;

            public final Tuple2<DateTime, DateTime> apply(Tuple2<Option<DateTime>, Option<DateTime>> bounds) {
                Option option;
                block6: {
                    Option option2;
                    block11: {
                        DateTime dateTime;
                        DateTime lo;
                        block8: {
                            DateTime dt;
                            Some some;
                            boolean bl;
                            block10: {
                                DateTime dt2;
                                block9: {
                                    block7: {
                                        DateTime dateTime2;
                                        block3: {
                                            DateTime dt3;
                                            Some some2;
                                            boolean bl2;
                                            block5: {
                                                DateTime dt4;
                                                block4: {
                                                    block2: {
                                                        bl2 = false;
                                                        some2 = null;
                                                        option = (Option)bounds._1();
                                                        if (!None$.MODULE$.equals(option)) break block2;
                                                        dateTime2 = BinnedTime$.MODULE$.ZMinDate();
                                                        break block3;
                                                    }
                                                    if (!(option instanceof Some)) break block4;
                                                    bl2 = true;
                                                    some2 = (Some)option;
                                                    DateTime dt5 = (DateTime)some2.x();
                                                    if (!dt5.isBefore((ReadableInstant)BinnedTime$.MODULE$.ZMinDate())) break block4;
                                                    dateTime2 = BinnedTime$.MODULE$.ZMinDate();
                                                    break block3;
                                                }
                                                if (!bl2 || !(dt4 = (DateTime)some2.x()).isAfter((ReadableInstant)this.maxDateTime$1)) break block5;
                                                dateTime2 = this.maxDateTime$1;
                                                break block3;
                                            }
                                            if (!bl2) break block6;
                                            dateTime2 = dt3 = (DateTime)some2.x();
                                        }
                                        lo = dateTime2;
                                        bl = false;
                                        some = null;
                                        option2 = (Option)bounds._2();
                                        if (!None$.MODULE$.equals(option2)) break block7;
                                        dateTime = this.maxDateTime$1;
                                        break block8;
                                    }
                                    if (!(option2 instanceof Some)) break block9;
                                    bl = true;
                                    some = (Some)option2;
                                    DateTime dt6 = (DateTime)some.x();
                                    if (!dt6.isBefore((ReadableInstant)BinnedTime$.MODULE$.ZMinDate())) break block9;
                                    dateTime = BinnedTime$.MODULE$.ZMinDate();
                                    break block8;
                                }
                                if (!bl || !(dt2 = (DateTime)some.x()).isAfter((ReadableInstant)this.maxDateTime$1)) break block10;
                                dateTime = this.maxDateTime$1;
                                break block8;
                            }
                            if (!bl) break block11;
                            dateTime = dt = (DateTime)some.x();
                        }
                        DateTime hi = dateTime;
                        return new Tuple2((Object)lo, (Object)hi);
                    }
                    throw new MatchError((Object)option2);
                }
                throw new MatchError((Object)option);
            }
            {
                this.maxDateTime$1 = maxDateTime$1;
            }
        };
    }

    public BinnedTime org$locationtech$geomesa$curve$BinnedTime$$toDayAndMillis(long time) {
        return this.org$locationtech$geomesa$curve$BinnedTime$$toDayAndMillis(new DateTime(time, DateTimeZone.UTC));
    }

    public BinnedTime org$locationtech$geomesa$curve$BinnedTime$$toDayAndMillis(DateTime date) {
        Predef$.MODULE$.require(!date.isBefore((ReadableInstant)this.ZMinDate()), (Function0)new Serializable(date){
            public static final long serialVersionUID = 0L;
            private final DateTime date$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Date exceeds minimum indexable value (", "): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BinnedTime$.MODULE$.ZMinDate(), this.date$1}));
            }
            {
                this.date$1 = date$1;
            }
        });
        Predef$.MODULE$.require(this.DaysMaxDate().isAfter((ReadableInstant)date), (Function0)new Serializable(date){
            public static final long serialVersionUID = 0L;
            private final DateTime date$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Date exceeds maximum indexable value (", "): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BinnedTime$.MODULE$.DaysMaxDate(), this.date$1}));
            }
            {
                this.date$1 = date$1;
            }
        });
        Days days = Days.daysBetween((ReadableInstant)this.Epoch(), (ReadableInstant)date);
        long millisInDay = date.getMillis() - this.Epoch().plus((ReadablePeriod)days).getMillis();
        return new BinnedTime((short)days.getDays(), millisInDay);
    }

    public DateTime org$locationtech$geomesa$curve$BinnedTime$$fromDayAndMillis(BinnedTime date) {
        return this.Epoch().plusDays((int)date.bin()).plus(date.offset());
    }

    public BinnedTime org$locationtech$geomesa$curve$BinnedTime$$toWeekAndSeconds(long time) {
        return this.org$locationtech$geomesa$curve$BinnedTime$$toWeekAndSeconds(new DateTime(time, DateTimeZone.UTC));
    }

    public BinnedTime org$locationtech$geomesa$curve$BinnedTime$$toWeekAndSeconds(DateTime date) {
        Predef$.MODULE$.require(!date.isBefore((ReadableInstant)this.ZMinDate()), (Function0)new Serializable(date){
            public static final long serialVersionUID = 0L;
            private final DateTime date$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Date exceeds minimum indexable value (", "): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BinnedTime$.MODULE$.ZMinDate(), this.date$2}));
            }
            {
                this.date$2 = date$2;
            }
        });
        Predef$.MODULE$.require(this.WeeksMaxDate().isAfter((ReadableInstant)date), (Function0)new Serializable(date){
            public static final long serialVersionUID = 0L;
            private final DateTime date$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Date exceeds maximum indexable value (", "): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BinnedTime$.MODULE$.WeeksMaxDate(), this.date$2}));
            }
            {
                this.date$2 = date$2;
            }
        });
        Weeks weeks = Weeks.weeksBetween((ReadableInstant)this.Epoch(), (ReadableInstant)date);
        long secondsInWeek = (date.getMillis() - this.Epoch().plus((ReadablePeriod)weeks).getMillis()) / 1000L;
        return new BinnedTime((short)weeks.getWeeks(), secondsInWeek);
    }

    public DateTime org$locationtech$geomesa$curve$BinnedTime$$fromWeekAndSeconds(BinnedTime date) {
        return this.Epoch().plusWeeks((int)date.bin()).plus(date.offset() * 1000L);
    }

    public BinnedTime org$locationtech$geomesa$curve$BinnedTime$$toMonthAndSeconds(long time) {
        return this.org$locationtech$geomesa$curve$BinnedTime$$toMonthAndSeconds(new DateTime(time, DateTimeZone.UTC));
    }

    public BinnedTime org$locationtech$geomesa$curve$BinnedTime$$toMonthAndSeconds(DateTime date) {
        Predef$.MODULE$.require(!date.isBefore((ReadableInstant)this.ZMinDate()), (Function0)new Serializable(date){
            public static final long serialVersionUID = 0L;
            private final DateTime date$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Date exceeds minimum indexable value (", "): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BinnedTime$.MODULE$.ZMinDate(), this.date$3}));
            }
            {
                this.date$3 = date$3;
            }
        });
        Predef$.MODULE$.require(this.MonthsMaxDate().isAfter((ReadableInstant)date), (Function0)new Serializable(date){
            public static final long serialVersionUID = 0L;
            private final DateTime date$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Date exceeds maximum indexable value (", "): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BinnedTime$.MODULE$.MonthsMaxDate(), this.date$3}));
            }
            {
                this.date$3 = date$3;
            }
        });
        Months months = Months.monthsBetween((ReadableInstant)this.Epoch(), (ReadableInstant)date);
        long secondsInMonth = (date.getMillis() - this.Epoch().plus((ReadablePeriod)months).getMillis()) / 1000L;
        return new BinnedTime((short)months.getMonths(), secondsInMonth);
    }

    public DateTime org$locationtech$geomesa$curve$BinnedTime$$fromMonthAndSeconds(BinnedTime date) {
        return this.Epoch().plusMonths((int)date.bin()).plus(date.offset() * 1000L);
    }

    public BinnedTime org$locationtech$geomesa$curve$BinnedTime$$toYearAndMinutes(long time) {
        return this.org$locationtech$geomesa$curve$BinnedTime$$toYearAndMinutes(new DateTime(time, DateTimeZone.UTC));
    }

    public BinnedTime org$locationtech$geomesa$curve$BinnedTime$$toYearAndMinutes(DateTime date) {
        Predef$.MODULE$.require(!date.isBefore((ReadableInstant)this.ZMinDate()), (Function0)new Serializable(date){
            public static final long serialVersionUID = 0L;
            private final DateTime date$4;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Date exceeds minimum indexable value (", "): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BinnedTime$.MODULE$.ZMinDate(), this.date$4}));
            }
            {
                this.date$4 = date$4;
            }
        });
        Predef$.MODULE$.require(this.YearsMaxDate().isAfter((ReadableInstant)date), (Function0)new Serializable(date){
            public static final long serialVersionUID = 0L;
            private final DateTime date$4;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Date exceeds maximum indexable value (", "): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BinnedTime$.MODULE$.YearsMaxDate(), this.date$4}));
            }
            {
                this.date$4 = date$4;
            }
        });
        Years years = Years.yearsBetween((ReadableInstant)this.Epoch(), (ReadableInstant)date);
        long minutesInYear = (date.getMillis() - this.Epoch().plus((ReadablePeriod)years).getMillis()) / 60000L;
        return new BinnedTime((short)years.getYears(), minutesInYear);
    }

    public DateTime org$locationtech$geomesa$curve$BinnedTime$$fromYearAndMinutes(BinnedTime date) {
        return this.Epoch().plusYears((int)date.bin()).plus(date.offset() * 60000L);
    }

    public BinnedTime apply(short bin, long offset) {
        return new BinnedTime(bin, offset);
    }

    public Option<Tuple2<Object, Object>> unapply(BinnedTime x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)x$0.bin()), (Object)BoxesRunTime.boxToLong((long)x$0.offset())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BinnedTime$() {
        MODULE$ = this;
        this.Epoch = new DateTime(0L, DateTimeZone.UTC);
        this.ZMinDate = this.Epoch();
        this.DaysMaxDate = this.Epoch().plus((ReadablePeriod)Days.days((int)(Short.MAX_VALUE + 1)));
        this.WeeksMaxDate = this.Epoch().plus((ReadablePeriod)Weeks.weeks((int)(Short.MAX_VALUE + 1)));
        this.MonthsMaxDate = this.Epoch().plus((ReadablePeriod)Months.months((int)(Short.MAX_VALUE + 1)));
        this.YearsMaxDate = this.Epoch().plus((ReadablePeriod)Years.years((int)(Short.MAX_VALUE + 1)));
    }
}

