/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.query;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.util.NullProgressListener;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.query.RouteVisitor;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.util.ProgressListener;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@DescribeProcess(title="Route Search", description="Performs a search based on a route")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\u0001\u0003\u00015\u0011!CU8vi\u0016\u001cV-\u0019:dQB\u0013xnY3tg*\u00111\u0001B\u0001\u0006cV,'/\u001f\u0006\u0003\u000b\u0019\tq\u0001\u001d:pG\u0016\u001c8O\u0003\u0002\b\u0011\u00059q-Z8nKN\f'BA\u0005\u000b\u00031awnY1uS>tG/Z2i\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f-i\u0001\"a\u0004\u000b\u000e\u0003AQ!!\u0005\n\u0002\t1\fgn\u001a\u0006\u0002'\u0005!!.\u0019<b\u0013\t)\u0002C\u0001\u0004PE*,7\r\u001e\t\u0003/ai\u0011\u0001B\u0005\u00033\u0011\u0011abR3p\u001b\u0016\u001c\u0018\r\u0015:pG\u0016\u001c8\u000f\u0005\u0002\u001cE5\tAD\u0003\u0002\u001e=\u0005a1oY1mC2|wmZ5oO*\u0011q\u0004I\u0001\tif\u0004Xm]1gK*\t\u0011%A\u0002d_6L!a\t\u000f\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\u0006K\u0001!\tAJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d\u0002\"\u0001\u000b\u0001\u000e\u0003\tAQA\u000b\u0001\u0005\u0002-\nq!\u001a=fGV$X\rF\u0005-m\u0015[EK\u00177swB\u0011Q\u0006N\u0007\u0002])\u0011q\u0006M\u0001\u0007g&l\u0007\u000f\\3\u000b\u0005E\u0012\u0014\u0001\u00023bi\u0006T!a\r\u0006\u0002\u0011\u001d,w\u000e^8pYNL!!\u000e\u0018\u0003/MKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0007>dG.Z2uS>t\u0007\"B\u001c*\u0001\u0004a\u0013\u0001\u00034fCR,(/Z:)\rYJ\u0004)\u0011\"D!\tQd(D\u0001<\u0015\taT(A\u0004gC\u000e$xN]=\u000b\u0005\u0015\u0011\u0014BA <\u0005E!Um]2sS\n,\u0007+\u0019:b[\u0016$XM]\u0001\u0005]\u0006lW-I\u00018\u0003-!Wm]2sSB$\u0018n\u001c8\"\u0003\u0011\u000b!%\u00138qkR\u0004c-Z1ukJ,\u0007eY8mY\u0016\u001cG/[8oAQ|\u0007%];fef\u0004\u0003\"\u0002$*\u0001\u0004a\u0013A\u0002:pkR,7\u000f\u000b\u0004Fs\u0001C%)S\u0011\u0002\r\u0006\n!*A\"S_V$Xm\u001d\u0011u_\u0002\u001aX-\u0019:dQ\u0002\nGn\u001c8h]\u00012U-\u0019;ve\u0016\u001c\b%\\;ti\u0002B\u0017M^3!C\u0002:Wm\\7fiJL\be\u001c4!\u0019&tWm\u0015;sS:<\u0007\"\u0002'*\u0001\u0004i\u0015A\u00032vM\u001a,'oU5{KB\u0011qBT\u0005\u0003\u001fB\u0011a\u0001R8vE2,\u0007FB&:\u0001F\u0013%+I\u0001MC\u0005\u0019\u0016A\r\"vM\u001a,'\u000fI:ju\u0016\u0004\u0003&\u001b8![\u0016$XM]:*AQ|\u0007e]3be\u000eD\u0007%\u0019:pk:$\u0007\u0005\u001e5fAI|W\u000f^3\t\u000bUK\u0003\u0019A'\u0002!!,\u0017\rZ5oORC'/Z:i_2$\u0007F\u0002+:\u0001^\u0013\u0005,I\u0001VC\u0005I\u0016\u0001\f+ie\u0016\u001c\bn\u001c7eA\u0019|'\u000fI2p[B\f'/\u001b8hA!,\u0017\rZ5oONd\u0003%\u001b8!I\u0016<'/Z3t\u0011\u0015Y\u0016\u00061\u0001]\u00039\u0011x.\u001e;f\u000f\u0016|WNR5fY\u0012\u0004\"!X2\u000f\u0005y\u000bW\"A0\u000b\u0003\u0001\fQa]2bY\u0006L!AY0\u0002\rA\u0013X\rZ3g\u0013\t!WM\u0001\u0004TiJLgn\u001a\u0006\u0003E~C\u0003BW\u001dAO\nC'n[\u0011\u00027\u0006\n\u0011.A%BiR\u0014\u0018NY;uK\u0002\"\b.\u0019;!o&dG\u000e\t2fA\u0015D\u0018-\\5oK\u0012\u0004cm\u001c:!e>,H/Z:!i>\u0004S.\u0019;dQ:\u0002S*^:uA\t,\u0007%\u0019\u0011MS:,7\u000b\u001e:j]\u001e\f1!\\5o;\u0005\u0001\u0001\"B7*\u0001\u0004a\u0016!C4f_64\u0015.\u001a7eQ!a\u0017\bQ8Ca*\\\u0017%A7\"\u0003E\f\u0001*\u0011;ue&\u0014W\u000f^3!i\"\fG\u000fI<jY2\u0004#-\u001a\u0011fq\u0006l\u0017N\\3eA\u0019|'\u000f\t:pkR,\u0007%\\1uG\"Lgn\u001a\u0018!\u001bV\u001cH\u000f\t2fA\u0005\u0004C*\u001b8f'R\u0014\u0018N\\4\t\u000bML\u0003\u0019\u0001;\u0002\u001b\tLG-\u001b:fGRLwN\\1m!\tyQ/\u0003\u0002w!\t9!i\\8mK\u0006t\u0007\u0006\u0003::\u0001b\u0014\u0015P[6\"\u0003M\f\u0013A_\u00017\u001b\u0006$8\r\u001b\u0011uQ\u0016\u0004#o\\;uK\u0002\"\u0017N]3di&|g\u000eI8sA5\fGo\u00195!UV\u001cH\u000f\t;iK\u0002\u0012x.\u001e;fAA\fG\u000f\u001b\u0005\u0006y&\u0002\r\u0001X\u0001\rQ\u0016\fG-\u001b8h\r&,G\u000e\u001a\u0015\twf\u0002ePQ@kW\u0006\nA0\t\u0002\u0002\u0002\u0005\t\u0019!\u0011;ue&\u0014W\u000f^3!i\"\fG\u000fI<jY2\u0004#-\u001a\u0011fq\u0006l\u0017N\\3eA\u0019|'\u000f\t5fC\u0012Lgn\u001a\u0011j]\u0002\"\b.\u001a\u0011j]B,H\u000f\t4fCR,(/Z:/A%3\u0007E\\8uAA\u0014xN^5eK\u0012d\u0003%\u001b8qkR\u0004c-Z1ukJ,7\u000fI4f_6,GO]5fg\u0002jWo\u001d;!E\u0016\u0004C*\u001b8f'R\u0014\u0018N\\4tQ\u0019I\u0013Q\u0001\"\u0002\fA\u0019!(a\u0002\n\u0007\u0005%1H\u0001\bEKN\u001c'/\u001b2f%\u0016\u001cX\u000f\u001c;\"\u0005\u00055\u0011!G(viB,H\u000f\t4fCR,(/\u001a\u0011d_2dWm\u0019;j_:D#\u0002AA\t\u0003/\tIBQA\u000f!\rQ\u00141C\u0005\u0004\u0003+Y$a\u0004#fg\u000e\u0014\u0018NY3Qe>\u001cWm]:\u0002\u000bQLG\u000f\\3\"\u0005\u0005m\u0011\u0001\u0004*pkR,\u0007eU3be\u000eD\u0017EAA\u0010\u0003\t\u0002VM\u001d4pe6\u001c\b%\u0019\u0011tK\u0006\u00148\r\u001b\u0011cCN,G\rI8oA\u0005\u0004#o\\;uK\u0002")
public class RouteSearchProcess
implements GeoMesaProcess,
LazyLogging {
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        RouteSearchProcess routeSearchProcess = this;
        synchronized (routeSearchProcess) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    /*
     * WARNING - void declaration
     */
    @DescribeResult(description="Output feature collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="features", description="Input feature collection to query ") SimpleFeatureCollection features, @DescribeParameter(name="routes", description="Routes to search along. Features must have a geometry of LineString") SimpleFeatureCollection routes, @DescribeParameter(name="bufferSize", description="Buffer size (in meters) to search around the route") Double bufferSize, @DescribeParameter(name="headingThreshold", description="Threshold for comparing headings, in degrees") Double headingThreshold, @DescribeParameter(name="routeGeomField", description="Attribute that will be examined for routes to match. Must be a LineString", min=0) String routeGeomField, @DescribeParameter(name="geomField", description="Attribute that will be examined for route matching. Must be a LineString", min=0) String geomField, @DescribeParameter(name="bidirectional", description="Match the route direction or match just the route path", min=0) Boolean bidirectional, @DescribeParameter(name="headingField", description="Attribute that will be examined for heading in the input features. If not provided, input features geometries must be LineStrings", min=0) String headingField) {
        void var13_11;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Route searching on collection type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{features.getClass().getName()})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Boolean bi = (Boolean)Option$.MODULE$.apply((Object)bidirectional).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Boolean apply() {
                return Boolean.FALSE;
            }
        });
        SimpleFeatureType sft = (SimpleFeatureType)features.getSchema();
        String name = (String)Option$.MODULE$.apply((Object)geomField).getOrElse((Function0)new Serializable(this, sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final String apply() {
                return this.sft$1.getGeometryDescriptor().getLocalName();
            }
            {
                this.sft$1 = sft$1;
            }
        });
        AttributeDescriptor descriptor = sft.getDescriptor(name);
        if (descriptor == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Geometry field '", "' does not exist in input feature collection"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        }
        Class binding = descriptor.getType().getBinding();
        boolean isPoints = Point.class.isAssignableFrom(binding);
        if (isPoints || LineString.class.isAssignableFrom(binding)) {
            Tuple2 tuple2 = new Tuple2((Object)name, (Object)BoxesRunTime.boxToBoolean((boolean)isPoints));
            if (tuple2 != null) {
                void var24_23;
                String name2;
                Tuple2 tuple22;
                String geomAttribute = (String)tuple2._1();
                boolean isPoints2 = tuple2._2$mcZ$sp();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)geomAttribute, (Object)BoxesRunTime.boxToBoolean((boolean)isPoints2));
                String geomAttribute2 = (String)tuple23._1();
                boolean isPoints3 = tuple23._2$mcZ$sp();
                if (headingField == null && isPoints3) {
                    throw new IllegalArgumentException("Heading must be specified unless input feature collection geometry is a LineString");
                }
                if (headingField != null && sft.indexOf(headingField) == -1) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Heading field '", "' does not exist in input feature collection"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{headingField})));
                }
                SimpleFeatureType sft2 = (SimpleFeatureType)routes.getSchema();
                int index = sft2.indexOf(name2 = (String)Option$.MODULE$.apply((Object)routeGeomField).getOrElse((Function0)new Serializable(this, sft2){
                    public static final long serialVersionUID = 0L;
                    private final SimpleFeatureType sft$2;

                    public final String apply() {
                        return this.sft$2.getGeometryDescriptor().getLocalName();
                    }
                    {
                        this.sft$2 = sft$2;
                    }
                }));
                if (index == -1) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Geometry field '", "' does not exist in route feature collection"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name2})));
                }
                if (LineString.class.isAssignableFrom(sft2.getDescriptor(index).getType().getBinding())) {
                    Seq routeGeoms = SelfClosingIterator$.MODULE$.apply(routes).map((Function1)new Serializable(this, index){
                        public static final long serialVersionUID = 0L;
                        private final int index$1;

                        public final LineString apply(SimpleFeature x$2) {
                            return (LineString)x$2.getAttribute(this.index$1);
                        }
                        {
                            this.index$1 = index$1;
                        }
                    }).toSeq();
                    RouteVisitor visitor = new RouteVisitor((Seq<LineString>)routeGeoms, Predef$.MODULE$.Double2double(bufferSize), Predef$.MODULE$.Double2double(headingThreshold), Predef$.MODULE$.Boolean2boolean(bi), geomAttribute2, isPoints3, (Option<String>)Option$.MODULE$.apply((Object)headingField));
                    features.accepts((FeatureVisitor)visitor, (ProgressListener)new NullProgressListener());
                    return visitor.getResult().results();
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Route geometry field '", "' must be a LineString"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var24_23})));
            }
            throw new MatchError((Object)tuple2);
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Geometry field '", "' must be a Point or LineString"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var13_11})));
    }

    public RouteSearchProcess() {
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

