/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.transform;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileWriter;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileWriter$;
import org.locationtech.geomesa.arrow.package$;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary$;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.process.GeoMesaProcessVisitor$class;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureOrdering$;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.expression.Expression;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeqLike;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@DescribeProcess(title="Arrow Conversion", description="Converts a feature collection to arrow format")
@ScalaSignature(bytes="\u0006\u0001\u0011\u001da\u0001B\u0001\u0003\u00015\u0011a#\u0011:s_^\u001cuN\u001c<feNLwN\u001c)s_\u000e,7o\u001d\u0006\u0003\u0007\u0011\t\u0011\u0002\u001e:b]N4wN]7\u000b\u0005\u00151\u0011a\u00029s_\u000e,7o\u001d\u0006\u0003\u000f!\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\n\u0015\u0005aAn\\2bi&|g\u000e^3dQ*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dYQ\u0002CA\b\u0015\u001b\u0005\u0001\"BA\t\u0013\u0003\u0011a\u0017M\\4\u000b\u0003M\tAA[1wC&\u0011Q\u0003\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005]AR\"\u0001\u0003\n\u0005e!!AD$f_6+7/\u0019)s_\u000e,7o\u001d\t\u00037\tj\u0011\u0001\b\u0006\u0003;y\tAb]2bY\u0006dwnZ4j]\u001eT!a\b\u0011\u0002\u0011QL\b/Z:bM\u0016T\u0011!I\u0001\u0004G>l\u0017BA\u0012\u001d\u0005-a\u0015M_=M_\u001e<\u0017N\\4\t\u000b\u0015\u0002A\u0011\u0001\u0014\u0002\rqJg.\u001b;?)\u00059\u0003C\u0001\u0015\u0001\u001b\u0005\u0011\u0001\"\u0002\u0016\u0001\t\u0003Y\u0013aB3yK\u000e,H/\u001a\u000b\fYm\"vl]=\u0000\u0003\u0017\ti\u0002E\u0002.aIj\u0011A\f\u0006\u0003_I\tA!\u001e;jY&\u0011\u0011G\f\u0002\t\u0013R,'/\u0019;peB\u00191G\u000e\u001d\u000e\u0003QR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\u0012Q!\u0011:sCf\u0004\"aM\u001d\n\u0005i\"$\u0001\u0002\"zi\u0016DQ\u0001P\u0015A\u0002u\n\u0001BZ3biV\u0014Xm\u001d\t\u0003}\u0015k\u0011a\u0010\u0006\u0003\u0001\u0006\u000baa]5na2,'B\u0001\"D\u0003\u0011!\u0017\r^1\u000b\u0005\u0011S\u0011\u0001C4f_R|w\u000e\\:\n\u0005\u0019{$aF*j[BdWMR3biV\u0014XmQ8mY\u0016\u001cG/[8oQ\u0019Y\u0004j\u0014)R%B\u0011\u0011*T\u0007\u0002\u0015*\u00111\nT\u0001\bM\u0006\u001cGo\u001c:z\u0015\t)1)\u0003\u0002O\u0015\n\tB)Z:de&\u0014W\rU1sC6,G/\u001a:\u0002\t9\fW.Z\u0011\u0002y\u0005YA-Z:de&\u0004H/[8oC\u0005\u0019\u0016AI%oaV$\bEZ3biV\u0014X\rI2pY2,7\r^5p]\u0002\"x\u000eI3oG>$W\rC\u0003VS\u0001\u0007a+A\u0006j]\u000edW\u000fZ3GS\u0012\u001c\bCA\bX\u0013\tA\u0006CA\u0004C_>dW-\u00198)\u0011QCuJW)\\;z\u000b\u0013!V\u0011\u00029\u0006\t\u0013J\\2mk\u0012,\u0007EZ3biV\u0014X\rI%Eg\u0002Jg\u000eI1se><\bEZ5mK\u0006\u0019Q.\u001b8\u001e\u0003\u0001AQ\u0001Y\u0015A\u0002\u0005\f\u0001\u0003Z5di&|g.\u0019:z\r&,G\u000eZ:\u0011\u00075\u0012G-\u0003\u0002d]\t!A*[:u!\t)\u0007N\u0004\u00024M&\u0011q\rN\u0001\u0007!J,G-\u001a4\n\u0005%T'AB*ue&twM\u0003\u0002hi!bq\fS(m#6lfl\u001c9re\u0006\n\u0001-I\u0001o\u0003}\tE\u000f\u001e:jEV$Xm\u001d\u0011u_\u0002\"\u0017n\u0019;j_:\f'/\u001f\u0011f]\u000e|G-Z\u0001\u0004[\u0006DXD\u0001\u0001\u0001\u00049\u0019w\u000e\u001c7fGRLwN\u001c+za\u0016\u001c\u0013\u0001\u001a\u0005\u0006i&\u0002\rAV\u0001\u0016kN,7)Y2iK\u0012$\u0015n\u0019;j_:\f'/[3tQ!\u0019\bj\u0014<Rovs\u0016%\u0001;\"\u0003a\f\u0011,V:fA\r\f7\r[3eAQ|\u0007/L6!gR\fGo\u001d\u0011)S\u001a\u0004\u0013M^1jY\u0006\u0014G.Z\u0015-A=\u0014\bE];oA\u0005\u0004C-\u001f8b[&\u001c\u0007e\u001d;biN\u0004\u0013/^3ss\u0002\"x\u000e\t2vS2$\u0007\u0005Z5di&|g.\u0019:jKNDQA_\u0015A\u0002\u0011\f\u0011b]8si\u001aKW\r\u001c3)\u0011eDu\n`)~;z\u000b\u0013A_\u0011\u0002}\u0006!\u0012\t\u001e;sS\n,H/\u001a\u0011u_\u0002\u001axN\u001d;!EfDa!!\u0001*\u0001\u00041\u0016aC:peR\u0014VM^3sg\u0016D#b %P\u0003\u000b\t\u0016qA/_C\t\t\t!\t\u0002\u0002\n\u0005q\"+\u001a<feN,\u0007\u0005\u001e5fA\u0011,g-Y;mi\u0002\u001axN\u001d;!_J$WM\u001d\u0005\b\u0003\u001bI\u0003\u0019AA\b\u0003%\u0011\u0017\r^2i'&TX\rE\u0002\u0010\u0003#I1!a\u0005\u0011\u0005\u001dIe\u000e^3hKJD3\"a\u0003I\u001f\u0006]\u0011+!\u0007^=\u0006\u0012\u0011QB\u0011\u0003\u00037\t!GT;nE\u0016\u0014\be\u001c4!M\u0016\fG/\u001e:fg\u0002\"x\u000eI5oG2,H-\u001a\u0011j]\u0002*\u0017m\u00195!e\u0016\u001cwN\u001d3!E\u0006$8\r\u001b\u0005\u0007\u0003?I\u0003\u0019\u0001,\u0002\u0015\u0011|WO\u00197f!\u0006\u001c8\u000fK\u0006\u0002\u001e!{\u00151E)\u0002&us\u0016EAA\u0010C\t\t9#A Ck&dG\r\t3jGRLwN\\1sS\u0016\u001c\bEZ5sgRd\u0003\u0005\u001e5f]\u0002\nX/\u001a:zAI,7/\u001e7ug\u0002Jg\u000eI1!g\u0016\u0004\u0018M]1uK\u0002\u001a8-\u00198)\r%\nY#UA\u0019!\rI\u0015QF\u0005\u0004\u0003_Q%A\u0004#fg\u000e\u0014\u0018NY3SKN,H\u000e^\u0011\u0003\u0003g\t!$\u00128d_\u0012,G\r\t4fCR,(/\u001a\u0011d_2dWm\u0019;j_:D#\u0002AA\u001c\u0003{\ty$UA\"!\rI\u0015\u0011H\u0005\u0004\u0003wQ%a\u0004#fg\u000e\u0014\u0018NY3Qe>\u001cWm]:\u0002\u000bQLG\u000f\\3\"\u0005\u0005\u0005\u0013\u0001E!se><\beQ8om\u0016\u00148/[8oC\t\t)%A\u0017D_:4XM\u001d;tA\u0005\u0004c-Z1ukJ,\u0007eY8mY\u0016\u001cG/[8oAQ|\u0007%\u0019:s_^\u0004cm\u001c:nCR<q!!\u0013\u0003\u0011\u0003\tY%\u0001\fBeJ|woQ8om\u0016\u00148/[8o!J|7-Z:t!\rA\u0013Q\n\u0004\u0007\u0003\tA\t!a\u0014\u0014\t\u00055\u0013\u0011\u000b\t\u0004g\u0005M\u0013bAA+i\t1\u0011I\\=SK\u001aDq!JA'\t\u0003\tI\u0006\u0006\u0002\u0002L\u00199\u0011QLA'\u0001\u0005}#\u0001D!se><h+[:ji>\u00148CBA.\u001d\u0005\u0005$\u0004E\u0002\u0018\u0003GJ1!!\u001a\u0005\u0005U9Um\\'fg\u0006\u0004&o\\2fgN4\u0016n]5u_JD1\"!\u001b\u0002\\\t\u0005\t\u0015!\u0003\u0002l\u0005\u00191O\u001a;\u0011\t\u00055\u0014\u0011P\u0007\u0003\u0003_R1\u0001QA9\u0015\u0011\t\u0019(!\u001e\u0002\u000f\u0019,\u0017\r^;sK*\u0019\u0011q\u000f\u0006\u0002\u000f=\u0004XM\\4jg&!\u00111PA8\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/\u001a\u0005\f\u0003\u007f\nYF!A!\u0002\u0013\t\t)\u0001\u0005f]\u000e|G-\u001b8h!\u0011\t\u0019)a+\u000f\t\u0005\u0015\u0015Q\u0015\b\u0005\u0003\u000f\u000byJ\u0004\u0003\u0002\n\u0006me\u0002BAF\u00033sA!!$\u0002\u0018:!\u0011qRAK\u001b\t\t\tJC\u0002\u0002\u00142\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\r\tiJB\u0001\u0006CJ\u0014xn^\u0005\u0005\u0003C\u000b\u0019+\u0001\u0004wK\u000e$xN\u001d\u0006\u0004\u0003;3\u0011\u0002BAT\u0003S\u000b1cU5na2,g)Z1ukJ,g+Z2u_JTA!!)\u0002$&!\u0011QVAX\u0005U\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK\u0016s7m\u001c3j]\u001eTA!a*\u0002*\"Q\u0001-a\u0017\u0003\u0002\u0003\u0006I!a-\u0011\u000b\u0005U\u0016q\u00183\u000f\t\u0005]\u00161\u0018\b\u0005\u0003\u001f\u000bI,C\u00016\u0013\r\ti\fN\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t-a1\u0003\u0007M+\u0017OC\u0002\u0002>RB1\"a2\u0002\\\t\u0005\t\u0015!\u0003\u0002J\u0006\t2-Y2iK\u0012K7\r^5p]\u0006\u0014\u0018.Z:\u0011\u000bM\nY-a4\n\u0007\u00055GG\u0001\u0004PaRLwN\u001c\t\u0004g\u0005E\u0017B\u0001-5\u0011)Q\u00181\fB\u0001B\u0003%\u0011Q\u001b\t\u0005g\u0005-G\rC\u0006\u0002\u0002\u0005m#\u0011!Q\u0001\n\u0005%\u0007bCAn\u00037\u0012\t\u0011)A\u0005\u0003\u001f\f\u0011\u0002\u001d:f'>\u0014H/\u001a3\t\u0017\u00055\u00111\fB\u0001B\u0003%\u0011q\u001c\t\u0004g\u0005\u0005\u0018bAAri\t\u0019\u0011J\u001c;\t\u0017\u0005}\u00111\fB\u0001B\u0003%\u0011q\u001a\u0005\bK\u0005mC\u0011AAu)Q\tY/a<\u0002r\u0006M\u0018Q_A|\u0003s\fY0!@\u0002\u0000B!\u0011Q^A.\u001b\t\ti\u0005\u0003\u0005\u0002j\u0005\u001d\b\u0019AA6\u0011!\ty(a:A\u0002\u0005\u0005\u0005b\u00021\u0002h\u0002\u0007\u00111\u0017\u0005\t\u0003\u000f\f9\u000f1\u0001\u0002J\"9!0a:A\u0002\u0005U\u0007\u0002CA\u0001\u0003O\u0004\r!!3\t\u0011\u0005m\u0017q\u001da\u0001\u0003\u001fD\u0001\"!\u0004\u0002h\u0002\u0007\u0011q\u001c\u0005\t\u0003?\t9\u000f1\u0001\u0002P\"Y!1AA.\u0011\u000b\u0007I\u0011\u0002B\u0003\u00035i\u0017M\\;bYZK7/\u001b;peV\u0011!q\u0001\t\u0005\u0003[\u0014IA\u0002\u0006\u0003\f\u00055\u0003\u0013aI\u0001\u0005\u001b\u0011!#\u0011:s_^l\u0015M\\;bYZK7/\u001b;peN!!\u0011BA)\u0011!\u0011\tB!\u0003\u0007\u0002\tM\u0011!\u0002<jg&$H\u0003\u0002B\u000b\u00057\u00012a\rB\f\u0013\r\u0011I\u0002\u000e\u0002\u0005+:LG\u000f\u0003\u0005\u0002t\t=\u0001\u0019\u0001B\u000f!\u0011\tiGa\b\n\t\t\u0005\u0012q\u000e\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\t\u0011\t\u0015\"\u0011\u0002D\u0001\u0005O\tqA]3tk2$8/\u0006\u0002\u0003*A)\u0011Q\u0017B\u0016e%\u0019\u0011'a1\t\u0017\t=\u00121\fE\u0001B\u0003&!qA\u0001\u000f[\u0006tW/\u00197WSNLGo\u001c:!\u00111\u0011\u0019$a\u0017A\u0002\u0003\u0007I\u0011\u0002B\u0014\u0003\u0019\u0011Xm];mi\"a!qGA.\u0001\u0004\u0005\r\u0011\"\u0003\u0003:\u0005Q!/Z:vYR|F%Z9\u0015\t\tU!1\b\u0005\u000b\u0005{\u0011)$!AA\u0002\t%\u0012a\u0001=%c!I!\u0011IA.A\u0003&!\u0011F\u0001\be\u0016\u001cX\u000f\u001c;!\u0011!\u0011)%a\u0017\u0005B\t\u001d\u0013!C4fiJ+7/\u001e7u)\t\u0011I\u0005\u0005\u0003\u0002n\n-ca\u0002B'\u0003\u001b\u0002%q\n\u0002\f\u0003J\u0014xn\u001e*fgVdGo\u0005\u0005\u0003L\tE#q\fB3!\u0011\u0011\u0019Fa\u0017\u000e\u0005\tU#\u0002\u0002B,\u00053\nqA^5tSR|'OC\u0002\u0002t\rKAA!\u0018\u0003V\t\u0011\u0012IY:ue\u0006\u001cGoQ1mGJ+7/\u001e7u!\r\u0019$\u0011M\u0005\u0004\u0005G\"$a\u0002)s_\u0012,8\r\u001e\t\u0004g\t\u001d\u0014b\u0001B5i\ta1+\u001a:jC2L'0\u00192mK\"Y!Q\u0005B&\u0005+\u0007I\u0011\u0001B7+\u0005a\u0003B\u0003B9\u0005\u0017\u0012\t\u0012)A\u0005Y\u0005A!/Z:vYR\u001c\b\u0005C\u0004&\u0005\u0017\"\tA!\u001e\u0015\t\t%#q\u000f\u0005\b\u0005K\u0011\u0019\b1\u0001-\u0011!\u0011YHa\u0013\u0005B\tu\u0014\u0001C4fiZ\u000bG.^3\u0015\u0005\u0005E\u0003B\u0003BA\u0005\u0017\n\t\u0011\"\u0001\u0003\u0004\u0006!1m\u001c9z)\u0011\u0011IE!\"\t\u0013\t\u0015\"q\u0010I\u0001\u0002\u0004a\u0003B\u0003BE\u0005\u0017\n\n\u0011\"\u0001\u0003\f\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001BGU\ra#qR\u0016\u0003\u0005#\u0003BAa%\u0003\u001e6\u0011!Q\u0013\u0006\u0005\u0005/\u0013I*A\u0005v]\u000eDWmY6fI*\u0019!1\u0014\u001b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003 \nU%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q!1\u0015B&\u0003\u0003%\tE!*\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u00119\u000bE\u0002\u0010\u0005SK!!\u001b\t\t\u0015\t5&1JA\u0001\n\u0003\u0011y+\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002`\"Q!1\u0017B&\u0003\u0003%\tA!.\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!q\u0017B_!\r\u0019$\u0011X\u0005\u0004\u0005w#$aA!os\"Q!Q\bBY\u0003\u0003\u0005\r!a8\t\u0015\t\u0005'1JA\u0001\n\u0003\u0012\u0019-A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011)\r\u0005\u0004\u0003H\n5'qW\u0007\u0003\u0005\u0013T1Aa35\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0004c\t%\u0007B\u0003Bi\u0005\u0017\n\t\u0011\"\u0001\u0003T\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002P\nU\u0007B\u0003B\u001f\u0005\u001f\f\t\u00111\u0001\u00038\"Q!\u0011\u001cB&\u0003\u0003%\tEa7\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a8\t\u0015\t}'1JA\u0001\n\u0003\u0012\t/\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u001f\u0014\u0019\u000f\u0003\u0006\u0003>\tu\u0017\u0011!a\u0001\u0005oC\u0001B!\u0005\u0002\\\u0011\u0005#q\u001d\u000b\u0005\u0005+\u0011I\u000f\u0003\u0005\u0002t\t\u0015\b\u0019\u0001Bv!\u0011\u0011iOa<\u000e\u0005\u0005E\u0014\u0002\u0002By\u0003c\u0012qAR3biV\u0014X\rC\u0004+\u00037\"\tE!>\u0015\r\tU!q_B\u0001\u0011!\u0011IPa=A\u0002\tm\u0018AB:pkJ\u001cW\rE\u0002?\u0005{L1Aa@@\u0005M\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKN{WO]2f\u0011!\u0019\u0019Aa=A\u0002\r\u0015\u0011!B9vKJL\b\u0003BB\u0004\u0007\u0013i\u0011!Q\u0005\u0004\u0007\u0017\t%!B)vKJLhaBB\b\u0003\u001b\"1\u0011\u0003\u0002\u0019'&l\u0007\u000f\\3BeJ|w/T1ok\u0006dg+[:ji>\u00148CBB\u0007\u0003#\u00129\u0001C\u0006\u0002j\r5!\u0011!Q\u0001\n\u0005-\u0004bCA@\u0007\u001b\u0011\t\u0011)A\u0005\u0003\u0003C1b!\u0007\u0004\u000e\t\u0005\t\u0015!\u0003\u0004\u001c\u0005!1o\u001c:u!\u0015\u0019\u00141ZB\u000f!\u0019\u00194q\u00043\u0002P&\u00191\u0011\u0005\u001b\u0003\rQ+\b\u000f\\33\u0011-\tia!\u0004\u0003\u0002\u0003\u0006I!a8\t\u000f\u0015\u001ai\u0001\"\u0001\u0004(QQ1\u0011FB\u0016\u0007[\u0019yc!\r\u0011\t\u000558Q\u0002\u0005\t\u0003S\u001a)\u00031\u0001\u0002l!A\u0011qPB\u0013\u0001\u0004\t\t\t\u0003\u0005\u0004\u001a\r\u0015\u0002\u0019AB\u000e\u0011!\tia!\nA\u0002\u0005}\u0007BCB\u001b\u0007\u001b\u0011\r\u0011\"\u0003\u00048\u0005\u0019q.\u001e;\u0016\u0005\re\u0002\u0003BB\u001e\u0007\u0003j!a!\u0010\u000b\u0007\r}\"#\u0001\u0002j_&!11IB\u001f\u0005U\u0011\u0015\u0010^3BeJ\f\u0017pT;uaV$8\u000b\u001e:fC6D\u0011ba\u0012\u0004\u000e\u0001\u0006Ia!\u000f\u0002\t=,H\u000f\t\u0005\u000b\u0007\u0017\u001aiA1A\u0005\n\r5\u0013!\u00022zi\u0016\u001cXCAB(!\u0015\u0019\tfa\u00163\u001b\t\u0019\u0019F\u0003\u0003\u0004V\t%\u0017aB7vi\u0006\u0014G.Z\u0005\u0005\u00073\u001a\u0019F\u0001\u0006MSN$()\u001e4gKJD\u0011b!\u0018\u0004\u000e\u0001\u0006Iaa\u0014\u0002\r\tLH/Z:!\u0011)\u0019\tg!\u0004A\u0002\u0013%11M\u0001\u0006G>,h\u000e^\u000b\u0003\u0007K\u00022aMB4\u0013\r\u0019I\u0007\u000e\u0002\u0005\u0019>tw\r\u0003\u0006\u0004n\r5\u0001\u0019!C\u0005\u0007_\n\u0011bY8v]R|F%Z9\u0015\t\tU1\u0011\u000f\u0005\u000b\u0005{\u0019Y'!AA\u0002\r\u0015\u0004\"CB;\u0007\u001b\u0001\u000b\u0015BB3\u0003\u0019\u0019w.\u001e8uA!Q1\u0011PB\u0007\u0005\u0004%Iaa\u001f\u0002\r]\u0014\u0018\u000e^3s+\t\u0019i\b\u0005\u0003\u0004\u0000\r\rUBABA\u0015\u0011\u0019y$a)\n\t\r\u00155\u0011\u0011\u0002\u001d'&l\u0007\u000f\\3GK\u0006$XO]3BeJ|wOR5mK^\u0013\u0018\u000e^3s\u0011%\u0019Ii!\u0004!\u0002\u0013\u0019i(A\u0004xe&$XM\u001d\u0011\t\u0011\tE1Q\u0002C!\u0007\u001b#BA!\u0006\u0004\u0010\"A\u00111OBF\u0001\u0004\u0011i\u0002\u0003\u0005\u0003&\r5A\u0011\tB\u0014\r\u001d\u0019)*!\u0014\u0005\u0007/\u0013\u0011dQ8na2,\u00070\u0011:s_^l\u0015M\\;bYZK7/\u001b;peN111SA)\u0005\u000fA1\"!\u001b\u0004\u0014\n\u0005\t\u0015!\u0003\u0002l!Y\u0011qPBJ\u0005\u0003\u0005\u000b\u0011BAA\u0011)\u000171\u0013B\u0001B\u0003%\u00111\u0017\u0005\f\u00073\u0019\u0019J!A!\u0002\u0013\u0019Y\u0002C\u0006\u0002\\\u000eM%\u0011!Q\u0001\n\u0005=\u0007bCA\u0007\u0007'\u0013\t\u0011)A\u0005\u0003?Dq!JBJ\t\u0003\u00199\u000b\u0006\b\u0004*\u000e-6QVBX\u0007c\u001b\u0019l!.\u0011\t\u0005581\u0013\u0005\t\u0003S\u001a)\u000b1\u0001\u0002l!A\u0011qPBS\u0001\u0004\t\t\tC\u0004a\u0007K\u0003\r!a-\t\u0011\re1Q\u0015a\u0001\u00077A\u0001\"a7\u0004&\u0002\u0007\u0011q\u001a\u0005\t\u0003\u001b\u0019)\u000b1\u0001\u0002`\"IAha%C\u0002\u0013%1\u0011X\u000b\u0003\u0007w\u0003ba!\u0015\u0004>\nu\u0011\u0002BB`\u0007'\u00121\"\u0011:sCf\u0014UO\u001a4fe\"I11YBJA\u0003%11X\u0001\nM\u0016\fG/\u001e:fg\u0002B\u0001B!\u0005\u0004\u0014\u0012\u00053q\u0019\u000b\u0005\u0005+\u0019I\r\u0003\u0005\u0002t\r\u0015\u0007\u0019\u0001B\u000f\u0011!\u0011)ca%\u0005B\t\u001drACBh\u0003\u001b\n\t\u0011#\u0001\u0004R\u0006Y\u0011I\u001d:poJ+7/\u001e7u!\u0011\tioa5\u0007\u0015\t5\u0013QJA\u0001\u0012\u0003\u0019)n\u0005\u0004\u0004T\u000e]'Q\r\t\b\u00073\u001cy\u000e\fB%\u001b\t\u0019YNC\u0002\u0004^R\nqA];oi&lW-\u0003\u0003\u0004b\u000em'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oc!9Qea5\u0005\u0002\r\u0015HCABi\u0011)\u0019Ioa5\u0002\u0002\u0013\u001531^\u0001\ti>\u001cFO]5oOR\u0011!q\u0015\u0005\u000b\u0007_\u001c\u0019.!A\u0005\u0002\u000eE\u0018!B1qa2LH\u0003\u0002B%\u0007gDqA!\n\u0004n\u0002\u0007A\u0006\u0003\u0006\u0004x\u000eM\u0017\u0011!CA\u0007s\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004|\u000eu\b\u0003B\u001a\u0002L2B!ba@\u0004v\u0006\u0005\t\u0019\u0001B%\u0003\rAH\u0005\r\u0005\u000b\t\u0007\u0019\u0019.!A\u0005\n\u0011\u0015\u0011a\u0003:fC\u0012\u0014Vm]8mm\u0016$\u0012A\u0004")
public class ArrowConversionProcess
implements GeoMesaProcess,
LazyLogging {
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        ArrowConversionProcess arrowConversionProcess = this;
        synchronized (arrowConversionProcess) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @DescribeResult(description="Encoded feature collection")
    public java.util.Iterator<byte[]> execute(@DescribeParameter(name="features", description="Input feature collection to encode") SimpleFeatureCollection features, @DescribeParameter(name="includeFids", description="Include feature IDs in arrow file", min=0) Boolean includeFids, @DescribeParameter(name="dictionaryFields", description="Attributes to dictionary encode", min=0, max=128, collectionType=String.class) java.util.List<String> dictionaryFields, @DescribeParameter(name="useCachedDictionaries", description="Use cached top-k stats (if available), or run a dynamic stats query to build dictionaries", min=0) Boolean useCachedDictionaries, @DescribeParameter(name="sortField", description="Attribute to sort by", min=0) String sortField, @DescribeParameter(name="sortReverse", description="Reverse the default sort order", min=0) Boolean sortReverse, @DescribeParameter(name="batchSize", description="Number of features to include in each record batch", min=0) Integer batchSize, @DescribeParameter(name="doublePass", description="Build dictionaries first, then query results in a separate scan", min=0) Boolean doublePass) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running arrow encoding for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{features.getClass().getName()})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        SimpleFeatureType sft = (SimpleFeatureType)features.getSchema();
        Seq toEncode = (Seq)Option$.MODULE$.apply(dictionaryFields).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(java.util.List<String> x$1) {
                return JavaConversions$.MODULE$.asScalaBuffer(x$1).toSeq();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
        toEncode.foreach((Function1)new Serializable(this, sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final void apply(String attribute) {
                if (this.sft$1.indexOf(attribute) == -1) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attribute ", " doesn't exist in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attribute, this.sft$1})));
                }
            }
            {
                this.sft$1 = sft$1;
            }
        });
        Option cacheDictionaries = Option$.MODULE$.apply((Object)useCachedDictionaries).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Boolean x$2) {
                return x$2;
            }
        });
        SimpleFeatureVector.SimpleFeatureEncoding encoding = SimpleFeatureVector.SimpleFeatureEncoding$.MODULE$.min(Option$.MODULE$.apply((Object)includeFids).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Boolean x$3) {
                return x$3;
            }
        }));
        Option reverse = Option$.MODULE$.apply((Object)sortReverse).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Boolean x$4) {
                return x$4;
            }
        });
        int batch = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)batchSize).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Integer x$5) {
                return x$5;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 100000;
            }
        }));
        boolean bl = Option$.MODULE$.apply((Object)doublePass).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Boolean x$6) {
                return x$6;
            }
        });
        ArrowVisitor visitor = new ArrowVisitor(sft, encoding, (Seq<String>)toEncode, (Option<Object>)cacheDictionaries, (Option<String>)Option$.MODULE$.apply((Object)sortField), (Option<Object>)reverse, false, batch, bl);
        features.accepts((FeatureVisitor)visitor, null);
        return visitor.getResult().results();
    }

    public ArrowConversionProcess() {
        LazyLogging.class.$init$((LazyLogging)this);
    }

    public static class ArrowResult
    extends AbstractCalcResult
    implements Product,
    Serializable {
        private final java.util.Iterator<byte[]> results;

        public java.util.Iterator<byte[]> results() {
            return this.results;
        }

        public Object getValue() {
            return this.results();
        }

        public ArrowResult copy(java.util.Iterator<byte[]> results) {
            return new ArrowResult(results);
        }

        public java.util.Iterator<byte[]> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "ArrowResult";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 0: 
            }
            return this.results();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ArrowResult;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ArrowResult)) return false;
            boolean bl = true;
            if (!bl) return false;
            ArrowResult arrowResult = (ArrowResult)((Object)x$1);
            java.util.Iterator<byte[]> iterator = this.results();
            java.util.Iterator<byte[]> iterator2 = arrowResult.results();
            if (iterator == null) {
                if (iterator2 != null) {
                    return false;
                }
            } else if (!iterator.equals(iterator2)) return false;
            if (!arrowResult.canEqual((Object)this)) return false;
            return true;
        }

        public ArrowResult(java.util.Iterator<byte[]> results) {
            this.results = results;
            Product.class.$init$((Product)this);
        }
    }

    public static class ArrowVisitor
    implements GeoMesaProcessVisitor,
    LazyLogging {
        private final SimpleFeatureType sft;
        private final SimpleFeatureVector.SimpleFeatureEncoding encoding;
        private final Seq<String> dictionaryFields;
        private final Option<Object> cacheDictionaries;
        private final Option<String> sortField;
        public final Option<Object> org$locationtech$geomesa$process$transform$ArrowConversionProcess$ArrowVisitor$$sortReverse;
        private final boolean preSorted;
        private final int batchSize;
        private final boolean doublePass;
        private ArrowManualVisitor manualVisitor;
        private Iterator<byte[]> result;
        private final Logger logger;
        private volatile byte bitmap$0;

        private ArrowManualVisitor manualVisitor$lzycompute() {
            ArrowVisitor arrowVisitor = this;
            synchronized (arrowVisitor) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    Option sort = this.sortField.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ArrowVisitor $outer;

                        public final Tuple2<String, Object> apply(String s) {
                            return new Tuple2((Object)s, this.$outer.org$locationtech$geomesa$process$transform$ArrowConversionProcess$ArrowVisitor$$sortReverse.getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply() {
                                    return this.apply$mcZ$sp();
                                }

                                public boolean apply$mcZ$sp() {
                                    return false;
                                }
                            }));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.manualVisitor = this.dictionaryFields.isEmpty() && (this.sortField.isEmpty() || this.preSorted) ? new SimpleArrowManualVisitor(this.sft, this.encoding, (Option<Tuple2<String, Object>>)sort, this.batchSize) : new ComplexArrowManualVisitor(this.sft, this.encoding, this.dictionaryFields, (Option<Tuple2<String, Object>>)sort, this.preSorted, this.batchSize);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
                return this.manualVisitor;
            }
        }

        private Logger logger$lzycompute() {
            ArrowVisitor arrowVisitor = this;
            synchronized (arrowVisitor) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.logger = LazyLogging.class.logger((LazyLogging)this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
                return this.logger;
            }
        }

        public Logger logger() {
            return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
        }

        @Override
        public java.util.List<Expression> getExpressions() {
            return GeoMesaProcessVisitor$class.getExpressions(this);
        }

        private ArrowManualVisitor manualVisitor() {
            return (byte)(this.bitmap$0 & 1) == 0 ? this.manualVisitor$lzycompute() : this.manualVisitor;
        }

        private Iterator<byte[]> result() {
            return this.result;
        }

        private void result_$eq(Iterator<byte[]> x$1) {
            this.result = x$1;
        }

        public ArrowResult getResult() {
            return this.result() == null ? new ArrowResult(JavaConversions$.MODULE$.asJavaIterator(this.manualVisitor().results())) : new ArrowResult(JavaConversions$.MODULE$.asJavaIterator(this.result()));
        }

        public void visit(Feature feature) {
            this.manualVisitor().visit((SimpleFeature)feature);
        }

        @Override
        public void execute(SimpleFeatureSource source, Query query) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Visiting source type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{source.getClass().getName()})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_ENCODE(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_DICTIONARY_FIELDS(), (Object)this.dictionaryFields.mkString(","));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_INCLUDE_FID(), (Object)BoxesRunTime.boxToBoolean((boolean)this.encoding.fids()));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_BATCH_SIZE(), (Object)BoxesRunTime.boxToInteger((int)this.batchSize));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_DOUBLE_PASS(), (Object)BoxesRunTime.boxToBoolean((boolean)this.doublePass));
            this.cacheDictionaries.foreach((Function1)new Serializable(this, query){
                public static final long serialVersionUID = 0L;
                private final Query query$1;

                public final Object apply(boolean x$7) {
                    return this.query$1.getHints().put((Object)QueryHints$.MODULE$.ARROW_DICTIONARY_CACHED(), (Object)BoxesRunTime.boxToBoolean((boolean)x$7));
                }
                {
                    this.query$1 = query$1;
                }
            });
            this.sortField.foreach((Function1)new Serializable(this, query){
                public static final long serialVersionUID = 0L;
                private final Query query$1;

                public final Object apply(String x$8) {
                    return this.query$1.getHints().put((Object)QueryHints$.MODULE$.ARROW_SORT_FIELD(), (Object)x$8);
                }
                {
                    this.query$1 = query$1;
                }
            });
            this.org$locationtech$geomesa$process$transform$ArrowConversionProcess$ArrowVisitor$$sortReverse.foreach((Function1)new Serializable(this, query){
                public static final long serialVersionUID = 0L;
                private final Query query$1;

                public final Object apply(boolean x$9) {
                    return this.query$1.getHints().put((Object)QueryHints$.MODULE$.ARROW_SORT_REVERSE(), (Object)BoxesRunTime.boxToBoolean((boolean)x$9));
                }
                {
                    this.query$1 = query$1;
                }
            });
            SelfClosingIterator features = SelfClosingIterator$.MODULE$.apply(source.getFeatures(query));
            this.result_$eq((Iterator<byte[]>)features.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte[] apply(SimpleFeature x$10) {
                    return (byte[])x$10.getAttribute(0);
                }
            }));
        }

        public ArrowVisitor(SimpleFeatureType sft, SimpleFeatureVector.SimpleFeatureEncoding encoding, Seq<String> dictionaryFields, Option<Object> cacheDictionaries, Option<String> sortField, Option<Object> sortReverse, boolean preSorted, int batchSize, boolean doublePass) {
            this.sft = sft;
            this.encoding = encoding;
            this.dictionaryFields = dictionaryFields;
            this.cacheDictionaries = cacheDictionaries;
            this.sortField = sortField;
            this.org$locationtech$geomesa$process$transform$ArrowConversionProcess$ArrowVisitor$$sortReverse = sortReverse;
            this.preSorted = preSorted;
            this.batchSize = batchSize;
            this.doublePass = doublePass;
            GeoMesaProcessVisitor$class.$init$(this);
            LazyLogging.class.$init$((LazyLogging)this);
        }
    }

    public static interface ArrowManualVisitor {
        public void visit(SimpleFeature var1);

        public Iterator<byte[]> results();
    }

    public static class SimpleArrowManualVisitor
    implements ArrowManualVisitor {
        private final int batchSize;
        private final ByteArrayOutputStream out;
        private final ListBuffer<byte[]> bytes;
        private long count;
        private final SimpleFeatureArrowFileWriter writer;

        private ByteArrayOutputStream out() {
            return this.out;
        }

        private ListBuffer<byte[]> bytes() {
            return this.bytes;
        }

        private long count() {
            return this.count;
        }

        private void count_$eq(long x$1) {
            this.count = x$1;
        }

        private SimpleFeatureArrowFileWriter writer() {
            return this.writer;
        }

        @Override
        public void visit(SimpleFeature feature) {
            this.writer().add(feature);
            this.count_$eq(this.count() + 1L);
            if (this.count() % (long)this.batchSize == 0L) {
                this.writer().flush();
                this.bytes().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.out().toByteArray()}));
                this.out().reset();
            }
        }

        @Override
        public Iterator<byte[]> results() {
            this.writer().close();
            this.bytes().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.out().toByteArray()}));
            return this.bytes().iterator();
        }

        public SimpleArrowManualVisitor(SimpleFeatureType sft, SimpleFeatureVector.SimpleFeatureEncoding encoding, Option<Tuple2<String, Object>> sort, int batchSize) {
            this.batchSize = batchSize;
            this.out = new ByteArrayOutputStream();
            this.bytes = (ListBuffer)ListBuffer$.MODULE$.empty();
            this.count = 0L;
            this.writer = SimpleFeatureArrowFileWriter$.MODULE$.apply(sft, (OutputStream)this.out(), Predef$.MODULE$.Map().empty(), encoding, sort, package$.MODULE$.allocator());
        }
    }

    public static class ComplexArrowManualVisitor
    implements ArrowManualVisitor {
        public final SimpleFeatureType org$locationtech$geomesa$process$transform$ArrowConversionProcess$ComplexArrowManualVisitor$$sft;
        private final SimpleFeatureVector.SimpleFeatureEncoding encoding;
        private final Seq<String> dictionaryFields;
        private final Option<Tuple2<String, Object>> sort;
        private final boolean preSorted;
        public final int org$locationtech$geomesa$process$transform$ArrowConversionProcess$ComplexArrowManualVisitor$$batchSize;
        private final ArrayBuffer<SimpleFeature> features;

        private ArrayBuffer<SimpleFeature> features() {
            return this.features;
        }

        @Override
        public void visit(SimpleFeature feature) {
            this.features().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleFeature[]{ScalaSimpleFeature$.MODULE$.copy(feature)}));
        }

        @Override
        public Iterator<byte[]> results() {
            None$ none$;
            block7: {
                Iterator iterator;
                Map dictionaries;
                block6: {
                    block5: {
                        None$ ordering;
                        Map map;
                        if (this.dictionaryFields.isEmpty()) {
                            map = Predef$.MODULE$.Map().empty();
                        } else {
                            Seq indicesAndValues = (Seq)this.dictionaryFields.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ ComplexArrowManualVisitor $outer;

                                public final Tuple3<String, Object, HashSet<Object>> apply(String field) {
                                    return new Tuple3((Object)field, (Object)BoxesRunTime.boxToInteger((int)this.$outer.org$locationtech$geomesa$process$transform$ArrowConversionProcess$ComplexArrowManualVisitor$$sft.indexOf(field)), (Object)HashSet$.MODULE$.empty());
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                            this.features().foreach((Function1)new Serializable(this, indicesAndValues){
                                public static final long serialVersionUID = 0L;
                                private final Seq indicesAndValues$1;

                                public final void apply(SimpleFeature f) {
                                    this.indicesAndValues$1.foreach((Function1)new Serializable(this, f){
                                        public static final long serialVersionUID = 0L;
                                        private final SimpleFeature f$1;

                                        public final boolean apply(Tuple3<String, Object, HashSet<Object>> x0$1) {
                                            Tuple3<String, Object, HashSet<Object>> tuple3 = x0$1;
                                            if (tuple3 != null) {
                                                int i = BoxesRunTime.unboxToInt((Object)tuple3._2());
                                                HashSet v = (HashSet)tuple3._3();
                                                boolean bl = v.add(this.f$1.getAttribute(i));
                                                return bl;
                                            }
                                            throw new MatchError(tuple3);
                                        }
                                        {
                                            this.f$1 = f$1;
                                        }
                                    });
                                }
                                {
                                    this.indicesAndValues$1 = indicesAndValues$1;
                                }
                            });
                            map = ((TraversableOnce)indicesAndValues.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ ComplexArrowManualVisitor $outer;

                                public final Tuple2<String, ArrowDictionary> apply(Tuple3<String, Object, HashSet<Object>> x0$2) {
                                    Tuple3<String, Object, HashSet<Object>> tuple3 = x0$2;
                                    if (tuple3 != null) {
                                        String n = (String)tuple3._1();
                                        int i = BoxesRunTime.unboxToInt((Object)tuple3._2());
                                        HashSet v = (HashSet)tuple3._3();
                                        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)n), (Object)ArrowDictionary$.MODULE$.create((long)i, (Object[])v.toArray(ClassTag$.MODULE$.AnyRef()), ClassTag$.MODULE$.apply(this.$outer.org$locationtech$geomesa$process$transform$ArrowConversionProcess$ComplexArrowManualVisitor$$sft.getDescriptor(i).getType().getBinding())));
                                        return tuple2;
                                    }
                                    throw new MatchError(tuple3);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                        }
                        dictionaries = map;
                        none$ = ordering = this.preSorted ? None$.MODULE$ : this.sort.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ComplexArrowManualVisitor $outer;

                            public final Ordering<SimpleFeature> apply(Tuple2<String, Object> x0$3) {
                                Tuple2<String, Object> tuple2 = x0$3;
                                if (tuple2 != null) {
                                    String field = (String)tuple2._1();
                                    boolean reverse = tuple2._2$mcZ$sp();
                                    Ordering o = SimpleFeatureOrdering$.MODULE$.apply(this.$outer.org$locationtech$geomesa$process$transform$ArrowConversionProcess$ComplexArrowManualVisitor$$sft.indexOf(field));
                                    Ordering ordering = reverse ? o.reverse() : o;
                                    return ordering;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        if (!None$.MODULE$.equals(none$)) break block5;
                        iterator = this.features().iterator();
                        break block6;
                    }
                    if (!(none$ instanceof Some)) break block7;
                    Some some = (Some)none$;
                    Ordering o = (Ordering)some.x();
                    iterator = ((IndexedSeqLike)this.features().sorted(o)).iterator();
                }
                Iterator sorted = iterator;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                SimpleFeatureArrowFileWriter writer = SimpleFeatureArrowFileWriter$.MODULE$.apply(this.org$locationtech$geomesa$process$transform$ArrowConversionProcess$ComplexArrowManualVisitor$$sft, (OutputStream)out, dictionaries, this.encoding, this.sort, package$.MODULE$.allocator());
                return new Iterator<byte[]>(this, sorted, out, writer){
                    private final /* synthetic */ ComplexArrowManualVisitor $outer;
                    private final Iterator sorted$1;
                    private final ByteArrayOutputStream out$1;
                    private final SimpleFeatureArrowFileWriter writer$1;

                    public Iterator<byte[]> seq() {
                        return Iterator.class.seq((Iterator)this);
                    }

                    public boolean isEmpty() {
                        return Iterator.class.isEmpty((Iterator)this);
                    }

                    public boolean isTraversableAgain() {
                        return Iterator.class.isTraversableAgain((Iterator)this);
                    }

                    public boolean hasDefiniteSize() {
                        return Iterator.class.hasDefiniteSize((Iterator)this);
                    }

                    public Iterator<byte[]> take(int n) {
                        return Iterator.class.take((Iterator)this, (int)n);
                    }

                    public Iterator<byte[]> drop(int n) {
                        return Iterator.class.drop((Iterator)this, (int)n);
                    }

                    public Iterator<byte[]> slice(int from, int until) {
                        return Iterator.class.slice((Iterator)this, (int)from, (int)until);
                    }

                    public <B> Iterator<B> map(Function1<byte[], B> f) {
                        return Iterator.class.map((Iterator)this, f);
                    }

                    public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                        return Iterator.class.$plus$plus((Iterator)this, that);
                    }

                    public <B> Iterator<B> flatMap(Function1<byte[], GenTraversableOnce<B>> f) {
                        return Iterator.class.flatMap((Iterator)this, f);
                    }

                    public Iterator<byte[]> filter(Function1<byte[], Object> p) {
                        return Iterator.class.filter((Iterator)this, p);
                    }

                    public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<byte[], B, Object> p) {
                        return Iterator.class.corresponds((Iterator)this, that, p);
                    }

                    public Iterator<byte[]> withFilter(Function1<byte[], Object> p) {
                        return Iterator.class.withFilter((Iterator)this, p);
                    }

                    public Iterator<byte[]> filterNot(Function1<byte[], Object> p) {
                        return Iterator.class.filterNot((Iterator)this, p);
                    }

                    public <B> Iterator<B> collect(PartialFunction<byte[], B> pf) {
                        return Iterator.class.collect((Iterator)this, pf);
                    }

                    public <B> Iterator<B> scanLeft(B z, Function2<B, byte[], B> op) {
                        return Iterator.class.scanLeft((Iterator)this, z, op);
                    }

                    public <B> Iterator<B> scanRight(B z, Function2<byte[], B, B> op) {
                        return Iterator.class.scanRight((Iterator)this, z, op);
                    }

                    public Iterator<byte[]> takeWhile(Function1<byte[], Object> p) {
                        return Iterator.class.takeWhile((Iterator)this, p);
                    }

                    public Tuple2<Iterator<byte[]>, Iterator<byte[]>> partition(Function1<byte[], Object> p) {
                        return Iterator.class.partition((Iterator)this, p);
                    }

                    public Tuple2<Iterator<byte[]>, Iterator<byte[]>> span(Function1<byte[], Object> p) {
                        return Iterator.class.span((Iterator)this, p);
                    }

                    public Iterator<byte[]> dropWhile(Function1<byte[], Object> p) {
                        return Iterator.class.dropWhile((Iterator)this, p);
                    }

                    public <B> Iterator<Tuple2<byte[], B>> zip(Iterator<B> that) {
                        return Iterator.class.zip((Iterator)this, that);
                    }

                    public <A1> Iterator<A1> padTo(int len, A1 elem) {
                        return Iterator.class.padTo((Iterator)this, (int)len, elem);
                    }

                    public Iterator<Tuple2<byte[], Object>> zipWithIndex() {
                        return Iterator.class.zipWithIndex((Iterator)this);
                    }

                    public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                        return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
                    }

                    public <U> void foreach(Function1<byte[], U> f) {
                        Iterator.class.foreach((Iterator)this, f);
                    }

                    public boolean forall(Function1<byte[], Object> p) {
                        return Iterator.class.forall((Iterator)this, p);
                    }

                    public boolean exists(Function1<byte[], Object> p) {
                        return Iterator.class.exists((Iterator)this, p);
                    }

                    public boolean contains(Object elem) {
                        return Iterator.class.contains((Iterator)this, (Object)elem);
                    }

                    public Option<byte[]> find(Function1<byte[], Object> p) {
                        return Iterator.class.find((Iterator)this, p);
                    }

                    public int indexWhere(Function1<byte[], Object> p) {
                        return Iterator.class.indexWhere((Iterator)this, p);
                    }

                    public <B> int indexOf(B elem) {
                        return Iterator.class.indexOf((Iterator)this, elem);
                    }

                    public BufferedIterator<byte[]> buffered() {
                        return Iterator.class.buffered((Iterator)this);
                    }

                    public <B> Iterator.GroupedIterator<B> grouped(int size) {
                        return Iterator.class.grouped((Iterator)this, (int)size);
                    }

                    public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                        return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
                    }

                    public int length() {
                        return Iterator.class.length((Iterator)this);
                    }

                    public Tuple2<Iterator<byte[]>, Iterator<byte[]>> duplicate() {
                        return Iterator.class.duplicate((Iterator)this);
                    }

                    public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                        return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
                    }

                    public <B> void copyToArray(Object xs, int start, int len) {
                        Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
                    }

                    public boolean sameElements(Iterator<?> that) {
                        return Iterator.class.sameElements((Iterator)this, that);
                    }

                    public Traversable<byte[]> toTraversable() {
                        return Iterator.class.toTraversable((Iterator)this);
                    }

                    public Iterator<byte[]> toIterator() {
                        return Iterator.class.toIterator((Iterator)this);
                    }

                    public Stream<byte[]> toStream() {
                        return Iterator.class.toStream((Iterator)this);
                    }

                    public String toString() {
                        return Iterator.class.toString((Iterator)this);
                    }

                    public <B> int sliding$default$2() {
                        return Iterator.class.sliding$default$2((Iterator)this);
                    }

                    public List<byte[]> reversed() {
                        return TraversableOnce.class.reversed((TraversableOnce)this);
                    }

                    public int size() {
                        return TraversableOnce.class.size((TraversableOnce)this);
                    }

                    public boolean nonEmpty() {
                        return TraversableOnce.class.nonEmpty((TraversableOnce)this);
                    }

                    public int count(Function1<byte[], Object> p) {
                        return TraversableOnce.class.count((TraversableOnce)this, p);
                    }

                    public <B> Option<B> collectFirst(PartialFunction<byte[], B> pf) {
                        return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
                    }

                    public <B> B $div$colon(B z, Function2<B, byte[], B> op) {
                        return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
                    }

                    public <B> B $colon$bslash(B z, Function2<byte[], B, B> op) {
                        return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
                    }

                    public <B> B foldLeft(B z, Function2<B, byte[], B> op) {
                        return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
                    }

                    public <B> B foldRight(B z, Function2<byte[], B, B> op) {
                        return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
                    }

                    public <B> B reduceLeft(Function2<B, byte[], B> op) {
                        return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
                    }

                    public <B> B reduceRight(Function2<byte[], B, B> op) {
                        return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceLeftOption(Function2<B, byte[], B> op) {
                        return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceRightOption(Function2<byte[], B, B> op) {
                        return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
                    }

                    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
                    }

                    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                        return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
                    }

                    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
                    }

                    public <B> B aggregate(Function0<B> z, Function2<B, byte[], B> seqop, Function2<B, B, B> combop) {
                        return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
                    }

                    public <B> B sum(Numeric<B> num) {
                        return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
                    }

                    public <B> B product(Numeric<B> num) {
                        return (B)TraversableOnce.class.product((TraversableOnce)this, num);
                    }

                    public Object min(Ordering cmp) {
                        return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object max(Ordering cmp) {
                        return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object maxBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public Object minBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public <B> void copyToBuffer(Buffer<B> dest) {
                        TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
                    }

                    public <B> void copyToArray(Object xs, int start) {
                        TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
                    }

                    public <B> void copyToArray(Object xs) {
                        TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
                    }

                    public <B> Object toArray(ClassTag<B> evidence$1) {
                        return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
                    }

                    public List<byte[]> toList() {
                        return TraversableOnce.class.toList((TraversableOnce)this);
                    }

                    public Iterable<byte[]> toIterable() {
                        return TraversableOnce.class.toIterable((TraversableOnce)this);
                    }

                    public Seq<byte[]> toSeq() {
                        return TraversableOnce.class.toSeq((TraversableOnce)this);
                    }

                    public IndexedSeq<byte[]> toIndexedSeq() {
                        return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
                    }

                    public <B> Buffer<B> toBuffer() {
                        return TraversableOnce.class.toBuffer((TraversableOnce)this);
                    }

                    public <B> Set<B> toSet() {
                        return TraversableOnce.class.toSet((TraversableOnce)this);
                    }

                    public Vector<byte[]> toVector() {
                        return TraversableOnce.class.toVector((TraversableOnce)this);
                    }

                    public <Col> Col to(CanBuildFrom<Nothing$, byte[], Col> cbf) {
                        return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
                    }

                    public <T, U> Map<T, U> toMap(Predef.$less$colon$less<byte[], Tuple2<T, U>> ev) {
                        return TraversableOnce.class.toMap((TraversableOnce)this, ev);
                    }

                    public String mkString(String start, String sep, String end) {
                        return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
                    }

                    public String mkString(String sep) {
                        return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
                    }

                    public String mkString() {
                        return TraversableOnce.class.mkString((TraversableOnce)this);
                    }

                    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                    }

                    public StringBuilder addString(StringBuilder b, String sep) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
                    }

                    public StringBuilder addString(StringBuilder b) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
                    }

                    public boolean hasNext() {
                        return this.sorted$1.hasNext();
                    }

                    public byte[] next() {
                        this.out$1.reset();
                        for (int i = 0; i < this.$outer.org$locationtech$geomesa$process$transform$ArrowConversionProcess$ComplexArrowManualVisitor$$batchSize && this.sorted$1.hasNext(); ++i) {
                            this.writer$1.add((SimpleFeature)this.sorted$1.next());
                        }
                        if (this.sorted$1.hasNext()) {
                            this.writer$1.flush();
                        } else {
                            this.writer$1.close();
                        }
                        return this.out$1.toByteArray();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.sorted$1 = sorted$1;
                        this.out$1 = out$1;
                        this.writer$1 = writer$1;
                        TraversableOnce.class.$init$((TraversableOnce)this);
                        Iterator.class.$init$((Iterator)this);
                    }
                };
            }
            throw new MatchError((Object)none$);
        }

        public ComplexArrowManualVisitor(SimpleFeatureType sft, SimpleFeatureVector.SimpleFeatureEncoding encoding, Seq<String> dictionaryFields, Option<Tuple2<String, Object>> sort, boolean preSorted, int batchSize) {
            this.org$locationtech$geomesa$process$transform$ArrowConversionProcess$ComplexArrowManualVisitor$$sft = sft;
            this.encoding = encoding;
            this.dictionaryFields = dictionaryFields;
            this.sort = sort;
            this.preSorted = preSorted;
            this.org$locationtech$geomesa$process$transform$ArrowConversionProcess$ComplexArrowManualVisitor$$batchSize = batchSize;
            this.features = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        }
    }
}

