/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index.attribute;

import java.nio.charset.StandardCharsets;
import org.geotools.factory.Hints;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.index.index.IndexKeySpace;
import org.locationtech.geomesa.index.index.IndexKeySpace$TieredByteRange$;
import org.locationtech.geomesa.index.index.attribute.AttributeIndexKey;
import org.locationtech.geomesa.index.index.attribute.AttributeIndexKey$;
import org.locationtech.geomesa.index.index.attribute.AttributeIndexKeySpace;
import org.locationtech.geomesa.index.index.attribute.AttributeIndexKeySpace$$anonfun$toIndexKeyBytes$1$;
import org.locationtech.geomesa.index.index.attribute.AttributeIndexValues;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public abstract class AttributeIndexKeySpace$class {
    public static boolean supports(AttributeIndexKeySpace $this, SimpleFeatureType sft) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).exists((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(AttributeDescriptor x$1) {
                return RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isIndexed$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(x$1));
            }
        });
    }

    public static int indexKeyByteLength(AttributeIndexKeySpace $this) {
        throw new IllegalArgumentException("Attribute key space has variable length index keys");
    }

    public static Function1 toIndexKey(AttributeIndexKeySpace $this, SimpleFeatureType sft, boolean lenient) {
        Seq indexedAttributes = (Seq)SimpleFeatureTypes$.MODULE$.getSecondaryIndexedAttributes(sft).map((Function1)new Serializable($this, sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final Tuple2<Object, Object> apply(AttributeDescriptor d) {
                return new Tuple2.mcIZ.sp(this.sft$1.indexOf(d.getName()), RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isList$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(d)));
            }
            {
                this.sft$1 = sft$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new Serializable($this, indexedAttributes){
            public static final long serialVersionUID = 0L;
            private final Seq indexedAttributes$1;

            public final Seq<AttributeIndexKey> apply(SimpleFeature feature) {
                return (Seq)this.indexedAttributes$1.flatMap((Function1)new Serializable(this, feature){
                    public static final long serialVersionUID = 0L;
                    private final SimpleFeature feature$1;

                    public final Seq<AttributeIndexKey> apply(Tuple2<Object, Object> x0$1) {
                        Tuple2<Object, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            int i = tuple2._1$mcI$sp();
                            boolean list = tuple2._2$mcZ$sp();
                            Seq seq = (Seq)AttributeIndexKey$.MODULE$.encodeForIndex(this.feature$1.getAttribute(i), list).map((Function1)new Serializable(this, i){
                                public static final long serialVersionUID = 0L;
                                private final int i$1;

                                public final AttributeIndexKey apply(String v) {
                                    return new AttributeIndexKey((short)this.i$1, v, AttributeIndexKey$.MODULE$.apply$default$3());
                                }
                                {
                                    this.i$1 = i$1;
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                            return seq;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.feature$1 = feature$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.indexedAttributes$1 = indexedAttributes$1;
            }
        };
    }

    public static Function3 toIndexKeyBytes(AttributeIndexKeySpace $this, SimpleFeatureType sft, boolean lenient) {
        Seq indexedAttributes = (Seq)SimpleFeatureTypes$.MODULE$.getSecondaryIndexedAttributes(sft).map((Function1)new Serializable($this, sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$2;

            public final Tuple3<Object, byte[], Object> apply(AttributeDescriptor d) {
                int i = this.sft$2.indexOf(d.getName());
                return new Tuple3((Object)BoxesRunTime.boxToInteger((int)i), (Object)AttributeIndexKey$.MODULE$.indexToBytes(i), (Object)BoxesRunTime.boxToBoolean((boolean)RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isList$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(d))));
            }
            {
                this.sft$2 = sft$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new Serializable($this, indexedAttributes){
            public static final long serialVersionUID = 0L;
            private final Seq indexedAttributes$2;

            public final Seq<byte[]> apply(Seq<byte[]> prefix, SimpleFeature feature, byte[] suffix) {
                int baseLength = BoxesRunTime.unboxToInt((Object)((TraversableOnce)prefix.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(byte[] x$2) {
                        return x$2.length;
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + suffix.length + 3;
                return (Seq)this.indexedAttributes$2.flatMap((Function1)new Serializable(this, baseLength, prefix, feature, suffix){
                    public static final long serialVersionUID = 0L;
                    public final int baseLength$1;
                    public final Seq prefix$1;
                    private final SimpleFeature feature$2;
                    public final byte[] suffix$1;

                    public final Seq<byte[]> apply(Tuple3<Object, byte[], Object> x0$2) {
                        Tuple3<Object, byte[], Object> tuple3 = x0$2;
                        if (tuple3 != null) {
                            int idx = BoxesRunTime.unboxToInt((Object)tuple3._1());
                            byte[] idxBytes = (byte[])tuple3._2();
                            boolean list = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                            Seq seq = (Seq)AttributeIndexKey$.MODULE$.encodeForIndex(this.feature$2.getAttribute(idx), list).map((Function1)new Serializable(this, idxBytes){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ AttributeIndexKeySpace$$anonfun$toIndexKeyBytes$1$.anonfun.apply.3 $outer;
                                private final byte[] idxBytes$1;

                                /*
                                 * WARNING - void declaration
                                 */
                                public final byte[] apply(String encoded) {
                                    void var3_3;
                                    byte[] value = encoded.getBytes(StandardCharsets.UTF_8);
                                    byte[] bytes = (byte[])Array$.MODULE$.ofDim(this.$outer.baseLength$1 + value.length, ClassTag$.MODULE$.Byte());
                                    IntRef i = IntRef.create((int)0);
                                    this.$outer.prefix$1.foreach((Function1)new Serializable(this, bytes, i){
                                        public static final long serialVersionUID = 0L;
                                        private final byte[] bytes$1;
                                        private final IntRef i$2;

                                        public final void apply(byte[] p) {
                                            System.arraycopy(p, 0, this.bytes$1, this.i$2.elem, p.length);
                                            this.i$2.elem += p.length;
                                        }
                                        {
                                            this.bytes$1 = bytes$1;
                                            this.i$2 = i$2;
                                        }
                                    });
                                    bytes[i.elem] = this.idxBytes$1[0];
                                    ++i.elem;
                                    bytes[i.elem] = this.idxBytes$1[1];
                                    ++i.elem;
                                    System.arraycopy(value, 0, bytes, i.elem, value.length);
                                    i.elem += value.length;
                                    bytes[i.elem] = ByteArrays$.MODULE$.ZeroByte();
                                    System.arraycopy(this.$outer.suffix$1, 0, bytes, i.elem + 1, this.$outer.suffix$1.length);
                                    return var3_3;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.idxBytes$1 = idxBytes$1;
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                            return seq;
                        }
                        throw new MatchError(tuple3);
                    }
                    {
                        this.baseLength$1 = baseLength$1;
                        this.prefix$1 = prefix$1;
                        this.feature$2 = feature$2;
                        this.suffix$1 = suffix$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.indexedAttributes$2 = indexedAttributes$2;
            }
        };
    }

    public static AttributeIndexValues getIndexValues(AttributeIndexKeySpace $this, SimpleFeatureType sft, Filter filter2, Explainer explain) {
        BoxedUnit boxedUnit;
        Seq names = FilterHelper$.MODULE$.propertyNames(filter2, sft);
        Predef$.MODULE$.require(names.lengthCompare(1) == 0, (Function0)new Serializable($this, filter2){
            public static final long serialVersionUID = 0L;
            private final Filter filter$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't extract single attribute name from filter '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{org.locationtech.geomesa.filter.package$.MODULE$.filterToString(this.filter$1)}));
            }
            {
                this.filter$1 = filter$1;
            }
        });
        String attribute = (String)names.head();
        int i = sft.indexOf(attribute);
        Predef$.MODULE$.require(i != -1, (Function0)new Serializable($this, attribute, sft, filter2){
            public static final long serialVersionUID = 0L;
            private final String attribute$1;
            private final SimpleFeatureType sft$3;
            private final Filter filter$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attribute '", "' from filter '", "' does not exist in '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.attribute$1, org.locationtech.geomesa.filter.package$.MODULE$.filterToString(this.filter$1), this.sft$3}));
            }
            {
                this.attribute$1 = attribute$1;
                this.sft$3 = sft$3;
                this.filter$1 = filter$1;
            }
        });
        AttributeDescriptor descriptor = sft.getDescriptor(i);
        Class binding = RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isList$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor)) ? RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.getListType$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor)) : descriptor.getType().getBinding();
        FilterValues bounds = FilterHelper$.MODULE$.extractAttributeBounds(filter2, attribute, binding);
        if (bounds.isEmpty()) {
            if ($this.logger().underlying().isWarnEnabled()) {
                $this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to extract any attribute bounds from: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{org.locationtech.geomesa.filter.package$.MODULE$.filterToString(filter2)})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new AttributeIndexValues(attribute, i, bounds, binding);
    }

    public static Iterator getRanges(AttributeIndexKeySpace $this, AttributeIndexValues values) {
        AttributeIndexValues attributeIndexValues = values;
        if (attributeIndexValues != null) {
            Tuple3 tuple3;
            int i = attributeIndexValues.i();
            FilterValues fb = attributeIndexValues.values();
            Class binding = attributeIndexValues.binding();
            Tuple3 tuple32 = tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)i), fb, binding);
            int i2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
            FilterValues fb2 = (FilterValues)tuple32._2();
            Class binding2 = (Class)tuple32._3();
            return fb2.isEmpty() ? package$.MODULE$.Iterator().single(new IndexKeySpace.UnboundedRange<AttributeIndexKey>(new AttributeIndexKey((short)i2, null, false))) : fb2.values().iterator().flatMap((Function1)new Serializable($this, i2, binding2){
                public static final long serialVersionUID = 0L;
                private final int i$3;
                private final Class binding$1;

                public final GenTraversableOnce<IndexKeySpace.ScanRange<AttributeIndexKey>> apply(Bounds<Object> bounds) {
                    Tuple2 tuple2;
                    block11: {
                        Iterator iterator;
                        block8: {
                            Iterator iterator2;
                            block10: {
                                block9: {
                                    block7: {
                                        tuple2 = bounds.bounds();
                                        if (tuple2 == null) break block7;
                                        Option option = (Option)tuple2._1();
                                        Option option2 = (Option)tuple2._2();
                                        if (!None$.MODULE$.equals(option) || !None$.MODULE$.equals(option2)) break block7;
                                        iterator = package$.MODULE$.Iterator().single(new IndexKeySpace.UnboundedRange<AttributeIndexKey>(new AttributeIndexKey((short)this.i$3, null, false)));
                                        break block8;
                                    }
                                    if (tuple2 == null) break block9;
                                    Option option = (Option)tuple2._1();
                                    Option option3 = (Option)tuple2._2();
                                    if (!(option instanceof Some)) break block9;
                                    Some some = (Some)option;
                                    Object lower = some.x();
                                    if (!None$.MODULE$.equals(option3)) break block9;
                                    AttributeIndexKey start = new AttributeIndexKey((short)this.i$3, AttributeIndexKey$.MODULE$.encodeForQuery(lower, this.binding$1), bounds.lower().inclusive());
                                    iterator = package$.MODULE$.Iterator().single(new IndexKeySpace.LowerBoundedRange<AttributeIndexKey>(start));
                                    break block8;
                                }
                                if (tuple2 == null) break block10;
                                Option option = (Option)tuple2._1();
                                Option option4 = (Option)tuple2._2();
                                if (!None$.MODULE$.equals(option) || !(option4 instanceof Some)) break block10;
                                Some some = (Some)option4;
                                Object upper = some.x();
                                AttributeIndexKey end = new AttributeIndexKey((short)this.i$3, AttributeIndexKey$.MODULE$.encodeForQuery(upper, this.binding$1), bounds.upper().inclusive());
                                iterator = package$.MODULE$.Iterator().single(new IndexKeySpace.UpperBoundedRange<AttributeIndexKey>(end));
                                break block8;
                            }
                            if (tuple2 == null) break block11;
                            Option option = (Option)tuple2._1();
                            Option option5 = (Option)tuple2._2();
                            if (!(option instanceof Some)) break block11;
                            Some some = (Some)option;
                            Object lower = some.x();
                            if (!(option5 instanceof Some)) break block11;
                            Some some2 = (Some)option5;
                            Object upper = some2.x();
                            if (BoxesRunTime.equals((Object)lower, (Object)upper)) {
                                AttributeIndexKey row = new AttributeIndexKey((short)this.i$3, AttributeIndexKey$.MODULE$.encodeForQuery(lower, this.binding$1), true);
                                iterator2 = package$.MODULE$.Iterator().single(new IndexKeySpace.SingleRowRange<AttributeIndexKey>(row));
                            } else {
                                String string = Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(lower), org.locationtech.geomesa.filter.package$.MODULE$.WILDCARD_SUFFIX());
                                Object object = upper;
                                if (!(string != null ? !string.equals(object) : object != null)) {
                                    AttributeIndexKey row = new AttributeIndexKey((short)this.i$3, AttributeIndexKey$.MODULE$.encodeForQuery(lower, this.binding$1), true);
                                    iterator2 = package$.MODULE$.Iterator().single(new IndexKeySpace.PrefixRange<AttributeIndexKey>(row));
                                } else {
                                    AttributeIndexKey start = new AttributeIndexKey((short)this.i$3, AttributeIndexKey$.MODULE$.encodeForQuery(lower, this.binding$1), bounds.lower().inclusive());
                                    AttributeIndexKey end = new AttributeIndexKey((short)this.i$3, AttributeIndexKey$.MODULE$.encodeForQuery(upper, this.binding$1), bounds.upper().inclusive());
                                    iterator2 = package$.MODULE$.Iterator().single(new IndexKeySpace.BoundedRange<AttributeIndexKey>(start, end));
                                }
                            }
                            iterator = iterator2;
                        }
                        return iterator;
                    }
                    throw new MatchError((Object)tuple2);
                }
                {
                    this.i$3 = i$3;
                    this.binding$1 = binding$1;
                }
            });
        }
        throw new MatchError((Object)attributeIndexValues);
    }

    public static Iterator getRangeBytes(AttributeIndexKeySpace $this, Iterator ranges, Seq prefixes, boolean tier) {
        return tier ? AttributeIndexKeySpace$class.getTieredRangeBytes($this, ranges, prefixes) : AttributeIndexKeySpace$class.getStandardRangeBytes($this, ranges, prefixes);
    }

    public static boolean useFullFilter(AttributeIndexKeySpace $this, Option values, Option config, Hints hints) {
        return values.forall((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(AttributeIndexValues<Object> v) {
                return v.values().isEmpty() || !v.values().precise();
            }
        });
    }

    private static Iterator getTieredRangeBytes(AttributeIndexKeySpace $this, Iterator ranges, Seq prefixes) {
        Iterator bytes = ranges.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AttributeIndexKeySpace $outer;

            public final Product apply(IndexKeySpace.ScanRange<AttributeIndexKey> x0$3) {
                IndexKeySpace.ScanRange<AttributeIndexKey> scanRange;
                block14: {
                    Product product;
                    block3: {
                        block10: {
                            Option option;
                            block13: {
                                IndexKeySpace.TieredByteRange tieredByteRange;
                                block12: {
                                    AttributeIndexKey hi;
                                    block11: {
                                        block9: {
                                            block8: {
                                                block4: {
                                                    Option option2;
                                                    block7: {
                                                        Product product2;
                                                        block6: {
                                                            AttributeIndexKey lo;
                                                            block5: {
                                                                block2: {
                                                                    scanRange = x0$3;
                                                                    if (!(scanRange instanceof IndexKeySpace.SingleRowRange)) break block2;
                                                                    IndexKeySpace.SingleRowRange singleRowRange = (IndexKeySpace.SingleRowRange)scanRange;
                                                                    AttributeIndexKey row = (AttributeIndexKey)singleRowRange.row();
                                                                    product = new IndexKeySpace.SingleRowByteRange(AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$lower(this.$outer, row, AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$lower$default$2(this.$outer)));
                                                                    break block3;
                                                                }
                                                                if (!(scanRange instanceof IndexKeySpace.BoundedRange)) break block4;
                                                                IndexKeySpace.BoundedRange boundedRange = (IndexKeySpace.BoundedRange)scanRange;
                                                                lo = (AttributeIndexKey)boundedRange.lower();
                                                                AttributeIndexKey hi2 = (AttributeIndexKey)boundedRange.upper();
                                                                option2 = AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$tieredUpper(this.$outer, hi2);
                                                                if (!None$.MODULE$.equals(option2)) break block5;
                                                                product2 = new IndexKeySpace.TieredByteRange(AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$lower(this.$outer, lo, AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$lower$default$2(this.$outer)), AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$upper(this.$outer, hi2, AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$upper$default$2(this.$outer)), true, IndexKeySpace$TieredByteRange$.MODULE$.apply$default$4());
                                                                break block6;
                                                            }
                                                            if (!(option2 instanceof Some)) break block7;
                                                            Some some = (Some)option2;
                                                            byte[] up = (byte[])some.x();
                                                            product2 = new IndexKeySpace.BoundedByteRange(AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$lower(this.$outer, lo, AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$lower$default$2(this.$outer)), up);
                                                        }
                                                        product = product2;
                                                        break block3;
                                                    }
                                                    throw new MatchError((Object)option2);
                                                }
                                                if (!(scanRange instanceof IndexKeySpace.PrefixRange)) break block8;
                                                IndexKeySpace.PrefixRange prefixRange = (IndexKeySpace.PrefixRange)scanRange;
                                                AttributeIndexKey prefix = (AttributeIndexKey)prefixRange.prefix();
                                                product = new IndexKeySpace.TieredByteRange(AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$lower(this.$outer, prefix, true), AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$upper(this.$outer, prefix, true), IndexKeySpace$TieredByteRange$.MODULE$.apply$default$3(), IndexKeySpace$TieredByteRange$.MODULE$.apply$default$4());
                                                break block3;
                                            }
                                            if (!(scanRange instanceof IndexKeySpace.LowerBoundedRange)) break block9;
                                            IndexKeySpace.LowerBoundedRange lowerBoundedRange = (IndexKeySpace.LowerBoundedRange)scanRange;
                                            AttributeIndexKey lo = (AttributeIndexKey)lowerBoundedRange.lower();
                                            product = new IndexKeySpace.TieredByteRange(AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$lower(this.$outer, lo, AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$lower$default$2(this.$outer)), AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$upper(this.$outer, new AttributeIndexKey(lo.i(), null, AttributeIndexKey$.MODULE$.apply$default$3()), AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$upper$default$2(this.$outer)), true, IndexKeySpace$TieredByteRange$.MODULE$.apply$default$4());
                                            break block3;
                                        }
                                        if (!(scanRange instanceof IndexKeySpace.UpperBoundedRange)) break block10;
                                        IndexKeySpace.UpperBoundedRange upperBoundedRange = (IndexKeySpace.UpperBoundedRange)scanRange;
                                        hi = (AttributeIndexKey)upperBoundedRange.upper();
                                        option = AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$tieredUpper(this.$outer, hi);
                                        if (!None$.MODULE$.equals(option)) break block11;
                                        tieredByteRange = new IndexKeySpace.TieredByteRange(AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$lower(this.$outer, new AttributeIndexKey(hi.i(), null, AttributeIndexKey$.MODULE$.apply$default$3()), AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$lower$default$2(this.$outer)), AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$upper(this.$outer, hi, AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$upper$default$2(this.$outer)), IndexKeySpace$TieredByteRange$.MODULE$.apply$default$3(), IndexKeySpace$TieredByteRange$.MODULE$.apply$default$4());
                                        break block12;
                                    }
                                    if (!(option instanceof Some)) break block13;
                                    Some some = (Some)option;
                                    byte[] up = (byte[])some.x();
                                    byte[] x$4 = AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$lower(this.$outer, new AttributeIndexKey(hi.i(), null, AttributeIndexKey$.MODULE$.apply$default$3()), AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$lower$default$2(this.$outer));
                                    byte[] x$5 = up;
                                    boolean x$6 = true;
                                    boolean x$7 = IndexKeySpace$TieredByteRange$.MODULE$.apply$default$3();
                                    tieredByteRange = new IndexKeySpace.TieredByteRange(x$4, x$5, x$7, x$6);
                                }
                                product = tieredByteRange;
                                break block3;
                            }
                            throw new MatchError((Object)option);
                        }
                        if (!(scanRange instanceof IndexKeySpace.UnboundedRange)) break block14;
                        IndexKeySpace.UnboundedRange unboundedRange = (IndexKeySpace.UnboundedRange)scanRange;
                        AttributeIndexKey empty = (AttributeIndexKey)unboundedRange.empty();
                        product = new IndexKeySpace.TieredByteRange(AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$lower(this.$outer, empty, AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$lower$default$2(this.$outer)), AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$upper(this.$outer, empty, AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$upper$default$2(this.$outer)), IndexKeySpace$TieredByteRange$.MODULE$.apply$default$3(), IndexKeySpace$TieredByteRange$.MODULE$.apply$default$4());
                    }
                    return product;
                }
                throw new MatchError(scanRange);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return prefixes.isEmpty() ? bytes : bytes.flatMap((Function1)new Serializable($this, prefixes){
            public static final long serialVersionUID = 0L;
            private final Seq prefixes$1;

            public final GenTraversableOnce<IndexKeySpace.ByteRange> apply(Product x0$4) {
                Product product;
                block5: {
                    GenTraversableOnce genTraversableOnce;
                    block3: {
                        block4: {
                            block2: {
                                product = x0$4;
                                if (!(product instanceof IndexKeySpace.SingleRowByteRange)) break block2;
                                IndexKeySpace.SingleRowByteRange singleRowByteRange = (IndexKeySpace.SingleRowByteRange)product;
                                byte[] row = singleRowByteRange.row();
                                genTraversableOnce = (GenTraversableOnce)this.prefixes$1.map((Function1)new Serializable(this, row){
                                    public static final long serialVersionUID = 0L;
                                    private final byte[] row$1;

                                    public final IndexKeySpace.SingleRowByteRange apply(byte[] p) {
                                        return new IndexKeySpace.SingleRowByteRange(ByteArrays$.MODULE$.concat(p, this.row$1));
                                    }
                                    {
                                        this.row$1 = row$1;
                                    }
                                }, Seq$.MODULE$.canBuildFrom());
                                break block3;
                            }
                            if (!(product instanceof IndexKeySpace.BoundedByteRange)) break block4;
                            IndexKeySpace.BoundedByteRange boundedByteRange = (IndexKeySpace.BoundedByteRange)product;
                            byte[] lo = boundedByteRange.lower();
                            byte[] hi = boundedByteRange.upper();
                            genTraversableOnce = (GenTraversableOnce)this.prefixes$1.map((Function1)new Serializable(this, lo, hi){
                                public static final long serialVersionUID = 0L;
                                private final byte[] lo$1;
                                private final byte[] hi$1;

                                public final IndexKeySpace.BoundedByteRange apply(byte[] p) {
                                    return new IndexKeySpace.BoundedByteRange(ByteArrays$.MODULE$.concat(p, this.lo$1), ByteArrays$.MODULE$.concat(p, this.hi$1));
                                }
                                {
                                    this.lo$1 = lo$1;
                                    this.hi$1 = hi$1;
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                            break block3;
                        }
                        if (!(product instanceof IndexKeySpace.TieredByteRange)) break block5;
                        IndexKeySpace.TieredByteRange tieredByteRange = (IndexKeySpace.TieredByteRange)product;
                        genTraversableOnce = (GenTraversableOnce)this.prefixes$1.map((Function1)new Serializable(this, tieredByteRange){
                            public static final long serialVersionUID = 0L;
                            private final IndexKeySpace.TieredByteRange x4$1;

                            public final IndexKeySpace.TieredByteRange apply(byte[] p) {
                                return this.x4$1.copy(ByteArrays$.MODULE$.concat(p, this.x4$1.lower()), ByteArrays$.MODULE$.concat(p, this.x4$1.upper()), this.x4$1.copy$default$3(), this.x4$1.copy$default$4());
                            }
                            {
                                this.x4$1 = x4$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                    }
                    return genTraversableOnce;
                }
                throw new MatchError((Object)product);
            }
            {
                this.prefixes$1 = prefixes$1;
            }
        });
    }

    private static Iterator getStandardRangeBytes(AttributeIndexKeySpace $this, Iterator ranges, Seq prefixes) {
        Iterator bytes = ranges.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AttributeIndexKeySpace $outer;

            public final Product apply(IndexKeySpace.ScanRange<AttributeIndexKey> x0$5) {
                IndexKeySpace.ScanRange<AttributeIndexKey> scanRange;
                block8: {
                    Product product;
                    block3: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            scanRange = x0$5;
                                            if (!(scanRange instanceof IndexKeySpace.SingleRowRange)) break block2;
                                            IndexKeySpace.SingleRowRange singleRowRange = (IndexKeySpace.SingleRowRange)scanRange;
                                            AttributeIndexKey row = (AttributeIndexKey)singleRowRange.row();
                                            product = new IndexKeySpace.SingleRowByteRange(AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$lower(this.$outer, row, AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$lower$default$2(this.$outer)));
                                            break block3;
                                        }
                                        if (!(scanRange instanceof IndexKeySpace.BoundedRange)) break block4;
                                        IndexKeySpace.BoundedRange boundedRange = (IndexKeySpace.BoundedRange)scanRange;
                                        AttributeIndexKey lo = (AttributeIndexKey)boundedRange.lower();
                                        AttributeIndexKey hi = (AttributeIndexKey)boundedRange.upper();
                                        product = new IndexKeySpace.BoundedByteRange(AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$lower(this.$outer, lo, AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$lower$default$2(this.$outer)), AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$upper(this.$outer, hi, AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$upper$default$2(this.$outer)));
                                        break block3;
                                    }
                                    if (!(scanRange instanceof IndexKeySpace.PrefixRange)) break block5;
                                    IndexKeySpace.PrefixRange prefixRange = (IndexKeySpace.PrefixRange)scanRange;
                                    AttributeIndexKey prefix = (AttributeIndexKey)prefixRange.prefix();
                                    product = new IndexKeySpace.BoundedByteRange(AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$lower(this.$outer, prefix, true), AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$upper(this.$outer, prefix, true));
                                    break block3;
                                }
                                if (!(scanRange instanceof IndexKeySpace.LowerBoundedRange)) break block6;
                                IndexKeySpace.LowerBoundedRange lowerBoundedRange = (IndexKeySpace.LowerBoundedRange)scanRange;
                                AttributeIndexKey lo = (AttributeIndexKey)lowerBoundedRange.lower();
                                product = new IndexKeySpace.BoundedByteRange(AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$lower(this.$outer, lo, AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$lower$default$2(this.$outer)), AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$upper(this.$outer, new AttributeIndexKey(lo.i(), null, AttributeIndexKey$.MODULE$.apply$default$3()), AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$upper$default$2(this.$outer)));
                                break block3;
                            }
                            if (!(scanRange instanceof IndexKeySpace.UpperBoundedRange)) break block7;
                            IndexKeySpace.UpperBoundedRange upperBoundedRange = (IndexKeySpace.UpperBoundedRange)scanRange;
                            AttributeIndexKey hi = (AttributeIndexKey)upperBoundedRange.upper();
                            product = new IndexKeySpace.BoundedByteRange(AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$lower(this.$outer, new AttributeIndexKey(hi.i(), null, AttributeIndexKey$.MODULE$.apply$default$3()), AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$lower$default$2(this.$outer)), AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$upper(this.$outer, hi, AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$upper$default$2(this.$outer)));
                            break block3;
                        }
                        if (!(scanRange instanceof IndexKeySpace.UnboundedRange)) break block8;
                        IndexKeySpace.UnboundedRange unboundedRange = (IndexKeySpace.UnboundedRange)scanRange;
                        AttributeIndexKey empty = (AttributeIndexKey)unboundedRange.empty();
                        product = new IndexKeySpace.BoundedByteRange(AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$lower(this.$outer, empty, AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$lower$default$2(this.$outer)), AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$upper(this.$outer, empty, AttributeIndexKeySpace$class.org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$upper$default$2(this.$outer)));
                    }
                    return product;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected range type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scanRange})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return prefixes.isEmpty() ? bytes : bytes.flatMap((Function1)new Serializable($this, prefixes){
            public static final long serialVersionUID = 0L;
            private final Seq prefixes$2;

            public final GenTraversableOnce<IndexKeySpace.ByteRange> apply(Product x0$6) {
                Product product;
                block4: {
                    GenTraversableOnce genTraversableOnce;
                    block3: {
                        block2: {
                            product = x0$6;
                            if (!(product instanceof IndexKeySpace.SingleRowByteRange)) break block2;
                            IndexKeySpace.SingleRowByteRange singleRowByteRange = (IndexKeySpace.SingleRowByteRange)product;
                            byte[] row = singleRowByteRange.row();
                            genTraversableOnce = (GenTraversableOnce)this.prefixes$2.map((Function1)new Serializable(this, row){
                                public static final long serialVersionUID = 0L;
                                private final byte[] row$2;

                                public final IndexKeySpace.SingleRowByteRange apply(byte[] p) {
                                    return new IndexKeySpace.SingleRowByteRange(ByteArrays$.MODULE$.concat(p, this.row$2));
                                }
                                {
                                    this.row$2 = row$2;
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                            break block3;
                        }
                        if (!(product instanceof IndexKeySpace.BoundedByteRange)) break block4;
                        IndexKeySpace.BoundedByteRange boundedByteRange = (IndexKeySpace.BoundedByteRange)product;
                        byte[] lo = boundedByteRange.lower();
                        byte[] hi = boundedByteRange.upper();
                        genTraversableOnce = (GenTraversableOnce)this.prefixes$2.map((Function1)new Serializable(this, lo, hi){
                            public static final long serialVersionUID = 0L;
                            private final byte[] lo$2;
                            private final byte[] hi$2;

                            public final IndexKeySpace.BoundedByteRange apply(byte[] p) {
                                return new IndexKeySpace.BoundedByteRange(ByteArrays$.MODULE$.concat(p, this.lo$2), ByteArrays$.MODULE$.concat(p, this.hi$2));
                            }
                            {
                                this.lo$2 = lo$2;
                                this.hi$2 = hi$2;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                    }
                    return genTraversableOnce;
                }
                throw new MatchError((Object)product);
            }
            {
                this.prefixes$2 = prefixes$2;
            }
        });
    }

    public static byte[] org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$lower(AttributeIndexKeySpace $this, AttributeIndexKey key, boolean prefix) {
        byte[] index = AttributeIndexKey$.MODULE$.indexToBytes(key.i());
        return key.value() == null ? index : (prefix ? ByteArrays$.MODULE$.concat(index, key.value().getBytes(StandardCharsets.UTF_8)) : (key.inclusive() ? ByteArrays$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{index, key.value().getBytes(StandardCharsets.UTF_8), ByteArrays$.MODULE$.ZeroByteArray()})) : ByteArrays$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{index, key.value().getBytes(StandardCharsets.UTF_8), ByteArrays$.MODULE$.OneByteArray()}))));
    }

    public static boolean org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$lower$default$2(AttributeIndexKeySpace $this) {
        return false;
    }

    public static byte[] org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$upper(AttributeIndexKeySpace $this, AttributeIndexKey key, boolean prefix) {
        byte[] index = AttributeIndexKey$.MODULE$.indexToBytes(key.i());
        return key.value() == null ? ByteArrays$.MODULE$.rowFollowingPrefix(index) : (prefix ? ByteArrays$.MODULE$.rowFollowingPrefix(ByteArrays$.MODULE$.concat(index, key.value().getBytes(StandardCharsets.UTF_8))) : (key.inclusive() ? ByteArrays$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{index, key.value().getBytes(StandardCharsets.UTF_8), ByteArrays$.MODULE$.OneByteArray()})) : ByteArrays$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{index, key.value().getBytes(StandardCharsets.UTF_8), ByteArrays$.MODULE$.ZeroByteArray()}))));
    }

    public static boolean org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$upper$default$2(AttributeIndexKeySpace $this) {
        return false;
    }

    public static Option org$locationtech$geomesa$index$index$attribute$AttributeIndexKeySpace$$tieredUpper(AttributeIndexKeySpace $this, AttributeIndexKey key) {
        None$ none$;
        if (key.value() != null && key.inclusive()) {
            byte[] index = AttributeIndexKey$.MODULE$.indexToBytes(key.i());
            none$ = new Some((Object)ByteArrays$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{index, key.value().getBytes(StandardCharsets.UTF_8), ByteArrays$.MODULE$.ZeroByteArray()})));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static void $init$(AttributeIndexKeySpace $this) {
    }
}

