/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index.z2;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import org.geotools.factory.Hints;
import org.locationtech.geomesa.curve.XZ2SFC;
import org.locationtech.geomesa.curve.XZ2SFC$;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.FilterValues$;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.index.IndexKeySpace;
import org.locationtech.geomesa.index.index.IndexKeySpace$BoundedRange$mcJ$sp;
import org.locationtech.geomesa.index.index.z2.XZ2IndexKeySpace;
import org.locationtech.geomesa.index.index.z2.XZ2IndexValues;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.package$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.sfcurve.IndexRange;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.control.NonFatal$;

public abstract class XZ2IndexKeySpace$class {
    public static boolean supports(XZ2IndexKeySpace $this, SimpleFeatureType sft) {
        return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.nonPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
    }

    public static Function1 toIndexKey(XZ2IndexKeySpace $this, SimpleFeatureType sft, boolean lenient) {
        XZ2SFC sfc = XZ2SFC$.MODULE$.apply(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getXZPrecision$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        int geomIndex = sft.indexOf(sft.getGeometryDescriptor().getLocalName());
        return new Serializable($this, sfc, geomIndex, lenient){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ XZ2IndexKeySpace $outer;
            private final XZ2SFC sfc$1;
            private final int geomIndex$1;
            private final boolean lenient$1;

            public final Seq<Object> apply(SimpleFeature feature) {
                return XZ2IndexKeySpace$class.org$locationtech$geomesa$index$index$z2$XZ2IndexKeySpace$$getXZValue(this.$outer, this.sfc$1, this.geomIndex$1, this.lenient$1, feature);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sfc$1 = sfc$1;
                this.geomIndex$1 = geomIndex$1;
                this.lenient$1 = lenient$1;
            }
        };
    }

    public static Function3 toIndexKeyBytes(XZ2IndexKeySpace $this, SimpleFeatureType sft, boolean lenient) {
        XZ2SFC sfc = XZ2SFC$.MODULE$.apply(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getXZPrecision$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        int geomIndex = sft.indexOf(sft.getGeometryDescriptor().getLocalName());
        return new Serializable($this, sfc, geomIndex, lenient){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ XZ2IndexKeySpace $outer;
            private final XZ2SFC sfc$2;
            private final int geomIndex$2;
            private final boolean lenient$2;

            public final Seq<byte[]> apply(Seq<byte[]> prefix, SimpleFeature feature, byte[] suffix) {
                return XZ2IndexKeySpace$class.org$locationtech$geomesa$index$index$z2$XZ2IndexKeySpace$$getXZValueBytes(this.$outer, this.sfc$2, this.geomIndex$2, this.lenient$2, prefix, feature, suffix);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sfc$2 = sfc$2;
                this.geomIndex$2 = geomIndex$2;
                this.lenient$2 = lenient$2;
            }
        };
    }

    public static XZ2IndexValues getIndexValues(XZ2IndexKeySpace $this, SimpleFeatureType sft, Filter filter2, Explainer explain) {
        FilterValues extracted = FilterHelper$.MODULE$.extractGeometries(filter2, RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)), RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        FilterValues geometries = extracted.nonEmpty() ? extracted : new FilterValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Polygon[]{package$.MODULE$.WholeWorldPolygon()})), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
        explain.apply((Function0<String>)new Serializable($this, geometries){
            public static final long serialVersionUID = 0L;
            private final FilterValues geometries$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Geometries: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.geometries$1}));
            }
            {
                this.geometries$1 = geometries$1;
            }
        });
        XZ2SFC sfc = XZ2SFC$.MODULE$.apply(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getXZPrecision$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        Seq xy = (Seq)geometries.values().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple4<Object, Object, Object, Object> apply(Geometry geometry) {
                return GeometryUtils$.MODULE$.bounds(geometry);
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new XZ2IndexValues(sfc, (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)xy);
    }

    public static Iterator getRanges(XZ2IndexKeySpace $this, XZ2IndexValues values) {
        XZ2IndexValues xZ2IndexValues = values;
        if (xZ2IndexValues != null) {
            Tuple2 tuple2;
            XZ2SFC sfc = xZ2IndexValues.sfc();
            Seq<Tuple4<Object, Object, Object, Object>> xy = xZ2IndexValues.bounds();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)sfc, xy);
            XZ2SFC sfc2 = (XZ2SFC)tuple22._1();
            Seq xy2 = (Seq)tuple22._2();
            Seq zs = sfc2.ranges(xy2, QueryProperties$.MODULE$.ScanRangesTarget().option().map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final int apply(String x$2) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
                }
            }));
            return zs.iterator().map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final IndexKeySpace.BoundedRange<Object> apply(IndexRange r) {
                    return new IndexKeySpace$BoundedRange$mcJ$sp(r.lower(), r.upper());
                }
            });
        }
        throw new MatchError((Object)xZ2IndexValues);
    }

    public static Iterator getRangeBytes(XZ2IndexKeySpace $this, Iterator ranges, Seq prefixes, boolean tier) {
        return prefixes.isEmpty() ? ranges.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final IndexKeySpace.ByteRange apply(IndexKeySpace.ScanRange<Object> x0$1) {
                IndexKeySpace.ScanRange<Object> scanRange = x0$1;
                if (scanRange instanceof IndexKeySpace.BoundedRange) {
                    IndexKeySpace.BoundedRange boundedRange = (IndexKeySpace.BoundedRange)scanRange;
                    long lo = boundedRange.lower$mcJ$sp();
                    long hi = boundedRange.upper$mcJ$sp();
                    IndexKeySpace.BoundedByteRange boundedByteRange = new IndexKeySpace.BoundedByteRange(ByteArrays$.MODULE$.toBytes(lo), ByteArrays$.MODULE$.toBytesFollowingPrefix(hi));
                    return boundedByteRange;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected range type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scanRange})));
            }
        }) : ranges.flatMap((Function1)new Serializable($this, prefixes){
            public static final long serialVersionUID = 0L;
            private final Seq prefixes$1;

            public final GenTraversableOnce<IndexKeySpace.ByteRange> apply(IndexKeySpace.ScanRange<Object> x0$2) {
                IndexKeySpace.ScanRange<Object> scanRange = x0$2;
                if (scanRange instanceof IndexKeySpace.BoundedRange) {
                    IndexKeySpace.BoundedRange boundedRange = (IndexKeySpace.BoundedRange)scanRange;
                    long lo = boundedRange.lower$mcJ$sp();
                    long hi = boundedRange.upper$mcJ$sp();
                    byte[] lower = ByteArrays$.MODULE$.toBytes(lo);
                    byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi);
                    GenTraversableOnce genTraversableOnce = (GenTraversableOnce)this.prefixes$1.map((Function1)new Serializable(this, lower, upper){
                        public static final long serialVersionUID = 0L;
                        private final byte[] lower$1;
                        private final byte[] upper$1;

                        public final IndexKeySpace.BoundedByteRange apply(byte[] p) {
                            return new IndexKeySpace.BoundedByteRange(ByteArrays$.MODULE$.concat(p, this.lower$1), ByteArrays$.MODULE$.concat(p, this.upper$1));
                        }
                        {
                            this.lower$1 = lower$1;
                            this.upper$1 = upper$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    return genTraversableOnce;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected range type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scanRange})));
            }
            {
                this.prefixes$1 = prefixes$1;
            }
        });
    }

    public static boolean useFullFilter(XZ2IndexKeySpace $this, Option values, Option config, Hints hints) {
        return true;
    }

    public static Seq org$locationtech$geomesa$index$index$z2$XZ2IndexKeySpace$$getXZValue(XZ2IndexKeySpace $this, XZ2SFC sfc, int geomIndex, boolean lenient, SimpleFeature feature) {
        Geometry geom = (Geometry)feature.getAttribute(geomIndex);
        if (geom == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Null geometry in feature ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{feature.getID()})));
        }
        Envelope envelope = geom.getEnvelopeInternal();
        try {
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{sfc.index(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), lenient)}));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid xz value from geometry: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{geom})), e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Seq org$locationtech$geomesa$index$index$z2$XZ2IndexKeySpace$$getXZValueBytes(XZ2IndexKeySpace $this, XZ2SFC sfc, int geomIndex, boolean lenient, Seq prefix, SimpleFeature feature, byte[] suffix) {
        long xz;
        Geometry geom = (Geometry)feature.getAttribute(geomIndex);
        if (geom == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Null geometry in feature ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{feature.getID()})));
        }
        Envelope envelope = geom.getEnvelopeInternal();
        try {
            xz = sfc.index(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), lenient);
        }
        catch (Throwable throwable) {
            void var7_7;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid xz value from geometry: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var7_7})), e);
        }
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(BoxesRunTime.unboxToInt((Object)((TraversableOnce)prefix.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(byte[] x$3) {
                return x$3.length;
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 8 + suffix.length, ClassTag$.MODULE$.Byte());
        IntRef i = IntRef.create((int)0);
        prefix.foreach((Function1)new Serializable($this, bytes, i){
            public static final long serialVersionUID = 0L;
            private final byte[] bytes$1;
            private final IntRef i$1;

            public final void apply(byte[] p) {
                System.arraycopy(p, 0, this.bytes$1, this.i$1.elem, p.length);
                this.i$1.elem += p.length;
            }
            {
                this.bytes$1 = bytes$1;
                this.i$1 = i$1;
            }
        });
        ByteArrays$.MODULE$.writeLong(xz, bytes, i.elem);
        System.arraycopy(suffix, 0, bytes, i.elem + 8, suffix.length);
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{bytes}));
    }

    public static void $init$(XZ2IndexKeySpace $this) {
        $this.org$locationtech$geomesa$index$index$z2$XZ2IndexKeySpace$_setter_$indexKeyByteLength_$eq(8);
    }
}

