/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.query;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.List;
import org.geotools.data.Query;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.process.FeatureResult;
import org.locationtech.geomesa.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.process.GeoMesaProcessVisitor$class;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.Conversions;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.DWithin;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001B\u0001\u0003\u00015\u0011\u0001\u0003\u0015:pq&l\u0017\u000e^=WSNLGo\u001c:\u000b\u0005\r!\u0011!B9vKJL(BA\u0003\u0007\u0003\u001d\u0001(o\\2fgNT!a\u0002\u0005\u0002\u000f\u001d,w.\\3tC*\u0011\u0011BC\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\f\u001b!\tyA#D\u0001\u0011\u0015\t\t\"#\u0001\u0003mC:<'\"A\n\u0002\t)\fg/Y\u0005\u0003+A\u0011aa\u00142kK\u000e$\bCA\f\u0019\u001b\u0005!\u0011BA\r\u0005\u0005U9Um\\'fg\u0006\u0004&o\\2fgN4\u0016n]5u_J\u0004\"a\u0007\u0012\u000e\u0003qQ!!\b\u0010\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005}\u0001\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\u0005\n1aY8n\u0013\t\u0019CDA\u0006MCjLHj\\4hS:<\u0007\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\u0002\u001b%t\u0007/\u001e;GK\u0006$XO]3t!\t9c&D\u0001)\u0015\tI#&\u0001\u0004tS6\u0004H.\u001a\u0006\u0003W1\nA\u0001Z1uC*\u0011QFC\u0001\tO\u0016|Go\\8mg&\u0011q\u0006\u000b\u0002\u0018'&l\u0007\u000f\\3GK\u0006$XO]3D_2dWm\u0019;j_:D\u0001\"\r\u0001\u0003\u0002\u0003\u0006IAJ\u0001\rI\u0006$\u0018MR3biV\u0014Xm\u001d\u0005\tg\u0001\u0011\t\u0011)A\u0005i\u0005q!-\u001e4gKJLe.T3uKJ\u001c\bCA\u001b9\u001b\u00051$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2$A\u0002#pk\ndW\rC\u0003<\u0001\u0011\u0005A(\u0001\u0004=S:LGO\u0010\u000b\u0005{}\u0002\u0015\t\u0005\u0002?\u00015\t!\u0001C\u0003&u\u0001\u0007a\u0005C\u00032u\u0001\u0007a\u0005C\u00034u\u0001\u0007A\u0007\u0003\u0005D\u0001!\u0015\r\u0011\"\u0003E\u00031i\u0017M\\;bY\u001aKG\u000e^3s+\u0005)\u0005C\u0001$L\u001b\u00059%B\u0001%J\u0003\u00191\u0017\u000e\u001c;fe*\u0011!JC\u0001\b_B,gnZ5t\u0013\tauI\u0001\u0004GS2$XM\u001d\u0005\t\u001d\u0002A\t\u0011)Q\u0005\u000b\u0006iQ.\u00198vC24\u0015\u000e\u001c;fe\u0002Bq\u0001\u0015\u0001C\u0002\u0013%\u0011+\u0001\nnC:,\u0018\r\u001c,jg&$(+Z:vYR\u001cX#\u0001*\u0011\u0005M3V\"\u0001+\u000b\u0005US\u0013AC2pY2,7\r^5p]&\u0011q\u000b\u0016\u0002\u0016\u0019&\u001cHOR3biV\u0014XmQ8mY\u0016\u001cG/[8o\u0011\u0019I\u0006\u0001)A\u0005%\u0006\u0019R.\u00198vC24\u0016n]5u%\u0016\u001cX\u000f\u001c;tA!91\f\u0001a\u0001\n\u0013a\u0016A\u0003:fgVdGoQ1mGV\tQ\f\u0005\u0002\u0018=&\u0011q\f\u0002\u0002\u000e\r\u0016\fG/\u001e:f%\u0016\u001cX\u000f\u001c;\t\u000f\u0005\u0004\u0001\u0019!C\u0005E\u0006q!/Z:vYR\u001c\u0015\r\\2`I\u0015\fHCA2g!\t)D-\u0003\u0002fm\t!QK\\5u\u0011\u001d9\u0007-!AA\u0002u\u000b1\u0001\u001f\u00132\u0011\u0019I\u0007\u0001)Q\u0005;\u0006Y!/Z:vYR\u001c\u0015\r\\2!\u0011\u0015Y\u0007\u0001\"\u0011m\u0003\u00151\u0018n]5u)\t\u0019W\u000eC\u0003oU\u0002\u0007q.A\u0004gK\u0006$XO]3\u0011\u0005A\u0014X\"A9\u000b\u00059L\u0015BA:r\u0005\u001d1U-\u0019;ve\u0016DQ!\u001e\u0001\u0005BY\f\u0011bZ3u%\u0016\u001cX\u000f\u001c;\u0015\u0003uCQ\u0001\u001f\u0001\u0005Be\fq!\u001a=fGV$X\rF\u0002du~DQa_<A\u0002q\faa]8ve\u000e,\u0007CA\u0014~\u0013\tq\bFA\nTS6\u0004H.\u001a$fCR,(/Z*pkJ\u001cW\r\u0003\u0004\u0004o\u0002\u0007\u0011\u0011\u0001\t\u0005\u0003\u0007\t)!D\u0001+\u0013\r\t9A\u000b\u0002\u0006#V,'/\u001f\u0005\b\u0003\u0017\u0001A\u0011BA\u0007\u00039!w/\u001b;iS:4\u0015\u000e\u001c;feN$2!RA\b\u0011!\t\t\"!\u0003A\u0002\u0005M\u0011\u0001E2p]Z,'\u000f\u001e+p\t\u0016<'/Z3t!\r)\u0014QC\u0005\u0004\u0003/1$a\u0002\"p_2,\u0017M\u001c")
public class ProximityVisitor
implements GeoMesaProcessVisitor,
LazyLogging {
    private final SimpleFeatureCollection inputFeatures;
    private final SimpleFeatureCollection dataFeatures;
    public final double org$locationtech$geomesa$process$query$ProximityVisitor$$bufferInMeters;
    private Filter manualFilter;
    private final ListFeatureCollection manualVisitResults;
    private FeatureResult resultCalc;
    private final Logger logger;
    private volatile byte bitmap$0;

    private Filter manualFilter$lzycompute() {
        ProximityVisitor proximityVisitor = this;
        synchronized (proximityVisitor) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.manualFilter = this.dwithinFilters(true);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.manualFilter;
        }
    }

    private Logger logger$lzycompute() {
        ProximityVisitor proximityVisitor = this;
        synchronized (proximityVisitor) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public List<Expression> getExpressions() {
        return GeoMesaProcessVisitor$class.getExpressions(this);
    }

    private Filter manualFilter() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.manualFilter$lzycompute() : this.manualFilter;
    }

    private ListFeatureCollection manualVisitResults() {
        return this.manualVisitResults;
    }

    private FeatureResult resultCalc() {
        return this.resultCalc;
    }

    private void resultCalc_$eq(FeatureResult x$1) {
        this.resultCalc = x$1;
    }

    public void visit(Feature feature) {
        SimpleFeature sf = (SimpleFeature)feature;
        if (this.manualFilter().evaluate((Object)sf)) {
            this.manualVisitResults().add(sf);
        }
    }

    public FeatureResult getResult() {
        return this.resultCalc();
    }

    @Override
    public void execute(SimpleFeatureSource source, Query query) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running Geomesa Proximity Search on source type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{source.getClass().getName()})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Filter combinedFilter = package$.MODULE$.mergeFilters(query.getFilter(), this.dwithinFilters(false));
        this.resultCalc_$eq(new FeatureResult(source.getFeatures(combinedFilter)));
    }

    private Filter dwithinFilters(boolean convertToDegrees) {
        PropertyName geomProperty = package$.MODULE$.ff().property(this.dataFeatures.getSchema().getGeometryDescriptor().getName());
        CloseableIterator geomFilters = SelfClosingIterator$.MODULE$.apply(this.inputFeatures.features()).map((Function1)new Serializable(this, convertToDegrees, geomProperty){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProximityVisitor $outer;
            private final boolean convertToDegrees$1;
            private final PropertyName geomProperty$1;

            public final DWithin apply(SimpleFeature sf) {
                double dist = this.convertToDegrees$1 ? Conversions.RichGeometry$.MODULE$.distanceDegrees$extension(Conversions$.MODULE$.RichGeometry(Conversions.RichSimpleFeature$.MODULE$.geometry$extension(Conversions$.MODULE$.RichSimpleFeature(sf))), this.$outer.org$locationtech$geomesa$process$query$ProximityVisitor$$bufferInMeters) : this.$outer.org$locationtech$geomesa$process$query$ProximityVisitor$$bufferInMeters;
                return package$.MODULE$.ff().dwithin((Expression)this.geomProperty$1, (Expression)package$.MODULE$.ff().literal((Object)Conversions.RichSimpleFeature$.MODULE$.geometry$extension(Conversions$.MODULE$.RichSimpleFeature(sf))), dist, "meters");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.convertToDegrees$1 = convertToDegrees$1;
                this.geomProperty$1 = geomProperty$1;
            }
        });
        return package$.MODULE$.ff().or(JavaConversions$.MODULE$.seqAsJavaList(geomFilters.toSeq()));
    }

    public ProximityVisitor(SimpleFeatureCollection inputFeatures, SimpleFeatureCollection dataFeatures, double bufferInMeters) {
        this.inputFeatures = inputFeatures;
        this.dataFeatures = dataFeatures;
        this.org$locationtech$geomesa$process$query$ProximityVisitor$$bufferInMeters = bufferInMeters;
        GeoMesaProcessVisitor$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        this.manualVisitResults = new ListFeatureCollection((SimpleFeatureType)dataFeatures.getSchema());
        this.resultCalc = new FeatureResult((SimpleFeatureCollection)this.manualVisitResults());
    }
}

