/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.vector;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.NullableFloat8Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.AbstractContainerVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.types.pojo.Field;
import org.locationtech.geomesa.arrow.vector.GeometryFields;
import org.locationtech.geomesa.arrow.vector.impl.AbstractPolygonVector;

public class PolygonVector
extends AbstractPolygonVector {
    public static final List<Field> fields = GeometryFields.XY_DOUBLE_LIST_2;

    public PolygonVector(String name, BufferAllocator allocator, @Nullable Map<String, String> metadata) {
        super(name, allocator, metadata);
    }

    public PolygonVector(String name, AbstractContainerVector container, @Nullable Map<String, String> metadata) {
        super(name, container, metadata);
    }

    public PolygonVector(ListVector vector) {
        super(vector);
    }

    @Override
    protected List<Field> getFields() {
        return fields;
    }

    @Override
    protected AbstractPolygonVector.PolygonWriter createWriter(ListVector vector) {
        return new PolygonDoubleWriter(vector);
    }

    @Override
    protected AbstractPolygonVector.PolygonReader createReader(ListVector vector) {
        return new PolygonDoubleReader(vector);
    }

    public static class PolygonDoubleReader
    extends AbstractPolygonVector.PolygonReader {
        private NullableFloat8Vector.Accessor accessor;

        public PolygonDoubleReader(ListVector vector) {
            super(vector);
        }

        @Override
        protected void setOrdinalAccessor(ValueVector.Accessor accessor) {
            this.accessor = (NullableFloat8Vector.Accessor)accessor;
        }

        @Override
        protected double readOrdinal(int index) {
            return this.accessor.get(index);
        }
    }

    public static class PolygonDoubleWriter
    extends AbstractPolygonVector.PolygonWriter {
        private NullableFloat8Vector.Mutator mutator;

        public PolygonDoubleWriter(ListVector vector) {
            super(vector);
        }

        @Override
        protected void setOrdinalMutator(ValueVector.Mutator mutator) {
            this.mutator = (NullableFloat8Vector.Mutator)mutator;
        }

        @Override
        protected void writeOrdinal(int index, double ordinal) {
            this.mutator.setSafe(index, ordinal);
        }
    }
}

