/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.features.kryo.json;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.nio.charset.StandardCharsets;
import org.json4s.JsonAST;
import org.json4s.native.JsonMethods$;
import org.json4s.package$;
import org.locationtech.geomesa.features.kryo.json.JsonPathParser;
import org.locationtech.geomesa.features.kryo.json.JsonPathParser$JsonPathFunction$;
import org.locationtech.geomesa.features.kryo.json.JsonPathParser$PathAttributeWildCard$;
import org.locationtech.geomesa.features.kryo.json.JsonPathParser$PathDeepScan$;
import org.locationtech.geomesa.features.kryo.json.JsonPathParser$PathIndexWildCard$;
import org.locationtech.geomesa.features.kryo.json.KryoJsonSerialization;
import org.locationtech.geomesa.features.kryo.json.KryoJsonSerialization$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.control.NonFatal$;

public final class KryoJsonSerialization$
implements LazyLogging {
    public static final KryoJsonSerialization$ MODULE$;
    private final byte org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$TerminalByte;
    private final byte org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DoubleByte;
    private final byte org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$StringByte;
    private final byte org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DocByte;
    private final byte org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$ArrayByte;
    private final byte org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$BooleanByte;
    private final byte org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$NullByte;
    private final byte org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$IntByte;
    private final byte org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$LongByte;
    private final byte BooleanFalse;
    private final byte BooleanTrue;
    private final ThreadLocal<byte[]> org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$nameBuffers;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new KryoJsonSerialization$();
    }

    private Logger logger$lzycompute() {
        KryoJsonSerialization$ kryoJsonSerialization$ = this;
        synchronized (kryoJsonSerialization$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public byte org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$TerminalByte() {
        return this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$TerminalByte;
    }

    public byte org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DoubleByte() {
        return this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DoubleByte;
    }

    public byte org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$StringByte() {
        return this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$StringByte;
    }

    public byte org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DocByte() {
        return this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DocByte;
    }

    public byte org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$ArrayByte() {
        return this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$ArrayByte;
    }

    public byte org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$BooleanByte() {
        return this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$BooleanByte;
    }

    public byte org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$NullByte() {
        return this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$NullByte;
    }

    public byte org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$IntByte() {
        return this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$IntByte;
    }

    public byte org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$LongByte() {
        return this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$LongByte;
    }

    private byte BooleanFalse() {
        return this.BooleanFalse;
    }

    private byte BooleanTrue() {
        return this.BooleanTrue;
    }

    public ThreadLocal<byte[]> org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$nameBuffers() {
        return this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$nameBuffers;
    }

    public void serialize(Output out, String json) {
        JsonAST.JObject jObject;
        if (json == null) {
            jObject = null;
        } else {
            try {
                jObject = (JsonAST.JObject)JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(json), JsonMethods$.MODULE$.parse$default$2());
            }
            catch (Throwable throwable) {
                BoxedUnit boxedUnit;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error parsing json:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{json})), e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Object var8_7 = null;
                jObject = var8_7;
            }
        }
        JsonAST.JObject obj = jObject;
        this.serialize(out, obj);
    }

    public void serialize(Output out, JsonAST.JObject json) {
        if (json == null) {
            out.write((int)this.BooleanFalse());
        } else {
            out.write((int)this.BooleanTrue());
            this.writeDocument(out, json);
        }
    }

    public String deserializeAndRender(Input in) {
        JsonAST.JObject json = this.deserialize(in);
        return json == null ? null : JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)json));
    }

    public JsonAST.JObject deserialize(Input in) {
        return in.readByte() == this.BooleanFalse() ? null : this.readDocument(in);
    }

    public Object deserialize(Input in, Seq<JsonPathParser.PathElement> path) {
        None$ none$;
        block16: {
            Object object;
            block12: {
                Seq seq;
                Seq values;
                block15: {
                    block14: {
                        block13: {
                            block11: {
                                if (!path.isEmpty()) break block11;
                                object = this.deserializeAndRender(in);
                                break block12;
                            }
                            if (in.readByte() != this.BooleanFalse()) break block13;
                            object = null;
                            break block12;
                        }
                        Seq<Tuple2<Object, Object>> matches = (Seq<Tuple2<Object, Object>>)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToByte((byte)this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DocByte()), (Object)BoxesRunTime.boxToInteger((int)in.position()))}));
                        None$ function = None$.MODULE$;
                        Iterator paths = path.iterator();
                        while (paths.hasNext() && matches.nonEmpty()) {
                            JsonPathParser.PathIndices pathIndices;
                            Seq<Object> indices;
                            BoxedUnit boxedUnit;
                            JsonPathParser.PathAttribute pathAttribute;
                            String name;
                            JsonPathParser.PathElement pathElement = (JsonPathParser.PathElement)paths.next();
                            if (pathElement instanceof JsonPathParser.PathAttribute && (name = (pathAttribute = (JsonPathParser.PathAttribute)pathElement).name()) != null) {
                                String string = name;
                                matches = this.matchPathAttribute(in, matches, (Option<String>)new Some((Object)string));
                                boxedUnit = BoxedUnit.UNIT;
                                continue;
                            }
                            if (JsonPathParser$PathAttributeWildCard$.MODULE$.equals(pathElement)) {
                                matches = this.matchPathAttribute(in, matches, (Option<String>)None$.MODULE$);
                                boxedUnit = BoxedUnit.UNIT;
                                continue;
                            }
                            if (pathElement instanceof JsonPathParser.PathIndex) {
                                int index;
                                JsonPathParser.PathIndex pathIndex = (JsonPathParser.PathIndex)pathElement;
                                int n = index = pathIndex.index();
                                matches = this.matchPathIndex(in, matches, (Option<Seq<Object>>)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{n}))));
                                boxedUnit = BoxedUnit.UNIT;
                                continue;
                            }
                            if (pathElement instanceof JsonPathParser.PathIndices && (indices = (pathIndices = (JsonPathParser.PathIndices)pathElement).indices()) != null) {
                                Seq<Object> seq2 = indices;
                                matches = this.matchPathIndex(in, matches, (Option<Seq<Object>>)new Some(seq2));
                                boxedUnit = BoxedUnit.UNIT;
                                continue;
                            }
                            if (JsonPathParser$PathIndexWildCard$.MODULE$.equals(pathElement)) {
                                matches = this.matchPathIndex(in, matches, (Option<Seq<Object>>)None$.MODULE$);
                                boxedUnit = BoxedUnit.UNIT;
                                continue;
                            }
                            if (JsonPathParser$PathDeepScan$.MODULE$.equals(pathElement)) {
                                matches = this.matchDeep(in, matches);
                                boxedUnit = BoxedUnit.UNIT;
                                continue;
                            }
                            if (pathElement instanceof JsonPathParser.PathFunction) {
                                JsonPathParser.PathFunction pathFunction = (JsonPathParser.PathFunction)pathElement;
                                Enumeration.Value f = pathFunction.function();
                                function = new Some((Object)f);
                                boxedUnit = BoxedUnit.UNIT;
                                continue;
                            }
                            throw new MatchError((Object)pathElement);
                        }
                        values = (Seq)matches.map((Function1)new Serializable(in){
                            public static final long serialVersionUID = 0L;
                            private final Input in$1;

                            public final Object apply(Tuple2<Object, Object> x0$1) {
                                Tuple2<Object, Object> tuple2 = x0$1;
                                if (tuple2 != null) {
                                    byte t = BoxesRunTime.unboxToByte((Object)tuple2._1());
                                    int p = tuple2._2$mcI$sp();
                                    Object object = KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$readPathValue(this.in$1, t, p);
                                    return object;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.in$1 = in$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        none$ = function;
                        if (!None$.MODULE$.equals(none$)) break block14;
                        seq = values;
                        break block15;
                    }
                    if (!(none$ instanceof Some)) break block16;
                    Some some = (Some)none$;
                    Enumeration.Value f = (Enumeration.Value)some.x();
                    seq = (Seq)values.map((Function1)new Serializable(f){
                        public static final long serialVersionUID = 0L;
                        private final Enumeration.Value f$1;

                        public final Object apply(Object x$1) {
                            return KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$applyPathFunction(this.f$1, x$1);
                        }
                        {
                            this.f$1 = f$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                }
                Seq mapped = seq;
                object = mapped.isEmpty() ? null : (values.length() == 1 ? mapped.head() : mapped);
            }
            return object;
        }
        throw new MatchError((Object)none$);
    }

    public void org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$writeDocument(Output out, String name, JsonAST.JObject value) {
        out.writeByte(this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DocByte());
        this.RichOutput(out).writeName(name);
        this.writeDocument(out, value);
    }

    private void writeDocument(Output out, JsonAST.JObject value) {
        int start = out.position();
        out.writeInt(0);
        value.obj().foreach((Function1)new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final Output out$1;

            public final void apply(Tuple2<String, JsonAST.JValue> x0$2) {
                Tuple2<String, JsonAST.JValue> tuple2;
                block2: {
                    JsonAST.JValue jValue;
                    block11: {
                        block4: {
                            String name;
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                block5: {
                                                    block3: {
                                                        tuple2 = x0$2;
                                                        if (tuple2 == null) break block2;
                                                        name = (String)tuple2._1();
                                                        JsonAST.JValue elem = (JsonAST.JValue)tuple2._2();
                                                        jValue = elem;
                                                        if (!(jValue instanceof JsonAST.JString)) break block3;
                                                        JsonAST.JString jString = (JsonAST.JString)jValue;
                                                        KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$writeString(this.out$1, name, jString);
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        break block4;
                                                    }
                                                    if (!(jValue instanceof JsonAST.JObject)) break block5;
                                                    JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                                                    KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$writeDocument(this.out$1, name, jObject);
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    break block4;
                                                }
                                                if (!(jValue instanceof JsonAST.JArray)) break block6;
                                                JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                                                KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$writeArray(this.out$1, name, jArray);
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block4;
                                            }
                                            if (!(jValue instanceof JsonAST.JDouble)) break block7;
                                            JsonAST.JDouble jDouble = (JsonAST.JDouble)jValue;
                                            KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$writeDouble(this.out$1, name, jDouble);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block4;
                                        }
                                        if (!(jValue instanceof JsonAST.JInt)) break block8;
                                        JsonAST.JInt jInt = (JsonAST.JInt)jValue;
                                        KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$writeInt(this.out$1, name, jInt);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block4;
                                    }
                                    if (!JsonAST.JNull$.MODULE$.equals(jValue)) break block9;
                                    KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$writeNull(this.out$1, name);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block4;
                                }
                                if (!(jValue instanceof JsonAST.JBool)) break block10;
                                JsonAST.JBool jBool = (JsonAST.JBool)jValue;
                                KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$writeBoolean(this.out$1, name, jBool);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block4;
                            }
                            if (!(jValue instanceof JsonAST.JDecimal)) break block11;
                            JsonAST.JDecimal jDecimal = (JsonAST.JDecimal)jValue;
                            KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$writeDecimal(this.out$1, name, jDecimal);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError((Object)jValue);
                }
                throw new MatchError(tuple2);
            }
            {
                this.out$1 = out$1;
            }
        });
        out.writeByte(this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$TerminalByte());
        int end = out.position();
        out.setPosition(start);
        out.writeInt(end - start);
        out.setPosition(end);
    }

    public void org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$writeArray(Output out, String name, JsonAST.JArray value) {
        out.writeByte(this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$ArrayByte());
        this.RichOutput(out).writeName(name);
        IntRef i = IntRef.create((int)-1);
        List withKeys = (List)value.arr().map((Function1)new Serializable(i){
            public static final long serialVersionUID = 0L;
            private final IntRef i$1;

            public final Tuple2<String, JsonAST.JValue> apply(JsonAST.JValue element) {
                ++this.i$1.elem;
                return new Tuple2((Object)((Object)BoxesRunTime.boxToInteger((int)this.i$1.elem)).toString(), (Object)element);
            }
            {
                this.i$1 = i$1;
            }
        }, List$.MODULE$.canBuildFrom());
        this.writeDocument(out, new JsonAST.JObject(withKeys));
    }

    public void org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$writeString(Output out, String name, JsonAST.JString value) {
        out.writeByte(this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$StringByte());
        this.RichOutput(out).writeName(name);
        byte[] bytes = value.values().getBytes(StandardCharsets.UTF_8);
        out.writeInt(bytes.length);
        out.write(bytes);
        out.writeByte(this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$TerminalByte());
    }

    public void org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$writeDecimal(Output out, String name, JsonAST.JDecimal value) {
        out.writeByte(this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DoubleByte());
        this.RichOutput(out).writeName(name);
        out.writeDouble(value.values().toDouble());
    }

    public void org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$writeDouble(Output out, String name, JsonAST.JDouble value) {
        out.writeByte(this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DoubleByte());
        this.RichOutput(out).writeName(name);
        out.writeDouble(value.values());
    }

    public void org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$writeInt(Output out, String name, JsonAST.JInt value) {
        BoxedUnit boxedUnit;
        if (value.values().isValidInt()) {
            out.writeByte(this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$IntByte());
            this.RichOutput(out).writeName(name);
            out.writeInt(value.values().intValue());
        } else if (value.values().isValidLong()) {
            out.writeByte(this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$LongByte());
            this.RichOutput(out).writeName(name);
            out.writeLong(value.values().longValue());
        } else if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Skipping int value that does not fit in a long: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$writeBoolean(Output out, String name, JsonAST.JBool v) {
        out.writeByte(this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$BooleanByte());
        this.RichOutput(out).writeName(name);
        out.writeByte(v.values() ? this.BooleanTrue() : this.BooleanFalse());
    }

    public void org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$writeNull(Output out, String name) {
        out.writeByte(this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$NullByte());
        this.RichOutput(out).writeName(name);
    }

    private JsonAST.JObject readDocument(Input in) {
        int end = in.position() + in.readInt() - 1;
        ArrayBuffer elements = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (in.position() < end) {
            byte by;
            block11: {
                JsonAST.JString jString;
                String name;
                block4: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block6: {
                                        block5: {
                                            block3: {
                                                byte by2 = in.readByte();
                                                name = this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$RichInput(in).readName();
                                                by = by2;
                                                if (this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$StringByte() != by) break block3;
                                                jString = new JsonAST.JString(this.readString(in));
                                                break block4;
                                            }
                                            if (this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DocByte() != by) break block5;
                                            jString = this.readDocument(in);
                                            break block4;
                                        }
                                        if (this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$ArrayByte() != by) break block6;
                                        jString = this.readArray(in);
                                        break block4;
                                    }
                                    if (this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DoubleByte() != by) break block7;
                                    jString = new JsonAST.JDouble(in.readDouble());
                                    break block4;
                                }
                                if (this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$IntByte() != by) break block8;
                                jString = new JsonAST.JInt(BigInt$.MODULE$.int2bigInt(in.readInt()));
                                break block4;
                            }
                            if (this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$LongByte() != by) break block9;
                            jString = new JsonAST.JInt(BigInt$.MODULE$.long2bigInt(in.readLong()));
                            break block4;
                        }
                        if (this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$NullByte() != by) break block10;
                        jString = JsonAST.JNull$.MODULE$;
                        break block4;
                    }
                    if (this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$BooleanByte() != by) break block11;
                    jString = new JsonAST.JBool(this.readBoolean(in));
                }
                JsonAST.JString value = jString;
                elements.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{JsonAST.JField$.MODULE$.apply(name, (JsonAST.JValue)value)}));
                continue;
            }
            throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
        }
        in.skip(1);
        return new JsonAST.JObject(elements.toList());
    }

    private JsonAST.JArray readArray(Input in) {
        return new JsonAST.JArray((List)this.readDocument(in).obj().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(Tuple2<String, JsonAST.JValue> x$2) {
                return (JsonAST.JValue)x$2._2();
            }
        }, List$.MODULE$.canBuildFrom()));
    }

    public void org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$skipDocument(Input in) {
        in.skip(in.readInt() - 4);
    }

    private String readString(Input in) {
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(in.readInt(), ClassTag$.MODULE$.Byte());
        in.read(bytes);
        in.skip(1);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public void org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$skipString(Input in) {
        in.skip(in.readInt() + 1);
    }

    private boolean readBoolean(Input in) {
        return in.readByte() == this.BooleanTrue();
    }

    public void org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$skipBoolean(Input in) {
        in.skip(1);
    }

    private Seq<Tuple2<Object, Object>> matchPathAttribute(Input in, Seq<Tuple2<Object, Object>> positions, Option<String> name) {
        Seq docs = (Seq)positions.collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    byte t = BoxesRunTime.unboxToByte((Object)A1._1());
                    int p = A1._2$mcI$sp();
                    if (t == KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DocByte()) {
                        object = BoxesRunTime.boxToInteger((int)p);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, Object> x1) {
                byte t;
                Tuple2<Object, Object> tuple2 = x1;
                boolean bl = tuple2 != null && (t = BoxesRunTime.unboxToByte((Object)tuple2._1())) == KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DocByte();
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Serializable predicate = new Serializable(in, name){
            public static final long serialVersionUID = 0L;
            public final Input in$2;
            private final Option name$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return BoxesRunTime.unboxToBoolean((Object)this.name$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.1 $outer;

                    public final boolean apply(String x$3) {
                        String string = x$3;
                        String string2 = KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$RichInput(this.$outer.in$2).readName();
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.1 $outer;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$RichInput(this.$outer.in$2).skipName();
                        return true;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.in$2 = in$2;
                this.name$1 = name$1;
            }
        };
        return this.matchObjectPath(in, (Seq<Object>)docs, (Function0<Object>)predicate);
    }

    private Seq<Tuple2<Object, Object>> matchPathIndex(Input in, Seq<Tuple2<Object, Object>> positions, Option<Seq<Object>> indices) {
        Seq arrays = (Seq)positions.collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 != null) {
                    byte t = BoxesRunTime.unboxToByte((Object)A1._1());
                    int p = A1._2$mcI$sp();
                    if (t == KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$ArrayByte()) {
                        object = BoxesRunTime.boxToInteger((int)p);
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, Object> x2) {
                byte t;
                Tuple2<Object, Object> tuple2 = x2;
                boolean bl = tuple2 != null && (t = BoxesRunTime.unboxToByte((Object)tuple2._1())) == KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$ArrayByte();
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Serializable predicate = new Serializable(in, indices){
            public static final long serialVersionUID = 0L;
            public final Input in$3;
            private final Option indices$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return BoxesRunTime.unboxToBoolean((Object)this.indices$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.2 $outer;

                    public final boolean apply(Seq<Object> x$4) {
                        return x$4.contains((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$RichInput(this.$outer.in$3).readName())).toInt()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.2 $outer;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$RichInput(this.$outer.in$3).skipName();
                        return true;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.in$3 = in$3;
                this.indices$1 = indices$1;
            }
        };
        return this.matchObjectPath(in, (Seq<Object>)arrays, (Function0<Object>)predicate);
    }

    private Seq<Tuple2<Object, Object>> matchObjectPath(Input in, Seq<Object> positions, Function0<Object> nameConsumingPredicate) {
        ArrayBuffer elements = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        positions.foreach((Function1)new Serializable(in, nameConsumingPredicate, elements){
            public static final long serialVersionUID = 0L;
            private final Input in$5;
            private final Function0 nameConsumingPredicate$1;
            private final ArrayBuffer elements$1;

            public final void apply(int position) {
                this.apply$mcVI$sp(position);
            }

            public void apply$mcVI$sp(int position) {
                this.in$5.setPosition(position);
                int end = position + this.in$5.readInt() - 1;
                while (this.in$5.position() < end) {
                    BoxedUnit boxedUnit;
                    byte by = this.in$5.readByte();
                    if (this.nameConsumingPredicate$1.apply$mcZ$sp()) {
                        this.elements$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToByte((byte)by), (Object)BoxesRunTime.boxToInteger((int)this.in$5.position()))}));
                    }
                    byte by2 = by;
                    if (KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$StringByte() == by2) {
                        KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$skipString(this.in$5);
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DocByte() == by2) {
                        KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$skipDocument(this.in$5);
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$ArrayByte() == by2) {
                        KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$skipDocument(this.in$5);
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DoubleByte() == by2) {
                        this.in$5.skip(8);
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$IntByte() == by2) {
                        this.in$5.skip(4);
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$LongByte() == by2) {
                        this.in$5.skip(8);
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$NullByte() == by2) {
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$BooleanByte() == by2) {
                        KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$skipBoolean(this.in$5);
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by2));
                }
            }
            {
                this.in$5 = in$5;
                this.nameConsumingPredicate$1 = nameConsumingPredicate$1;
                this.elements$1 = elements$1;
            }
        });
        return elements;
    }

    private Seq<Tuple2<Object, Object>> matchDeep(Input in, Seq<Tuple2<Object, Object>> positions) {
        Queue toSearch = (Queue)Queue$.MODULE$.apply(positions);
        ArrayBuffer elements = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (toSearch.nonEmpty()) {
            Tuple2 tuple2 = (Tuple2)toSearch.dequeue();
            if (tuple2 != null) {
                BoxedUnit boxedUnit;
                Tuple2 tuple22;
                byte typ = BoxesRunTime.unboxToByte((Object)tuple2._1());
                int position = tuple2._2$mcI$sp();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToByte((byte)typ), (Object)BoxesRunTime.boxToInteger((int)position));
                byte typ2 = BoxesRunTime.unboxToByte((Object)tuple23._1());
                int position2 = tuple23._2$mcI$sp();
                elements.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToByte((byte)typ2), (Object)BoxesRunTime.boxToInteger((int)position2))}));
                in.setPosition(position2);
                byte by = typ2;
                boolean bl = this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DocByte() == by ? true : this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$ArrayByte() == by;
                if (bl) {
                    toSearch.enqueue(this.matchObjectPath(in, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{position2}))), (Function0<Object>)new Serializable(in){
                        public static final long serialVersionUID = 0L;
                        private final Input in$4;

                        public final boolean apply() {
                            return this.apply$mcZ$sp();
                        }

                        public boolean apply$mcZ$sp() {
                            return KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$predicate$1(this.in$4);
                        }
                        {
                            this.in$4 = in$4;
                        }
                    }));
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                boolean bl2 = this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$StringByte() == by ? true : (this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DoubleByte() == by ? true : (this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$IntByte() == by ? true : (this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$LongByte() == by ? true : (this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$NullByte() == by ? true : this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$BooleanByte() == by))));
                if (bl2) {
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
            }
            throw new MatchError((Object)tuple2);
        }
        return elements;
    }

    public Object org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$readPathValue(Input in, byte typed, int position) {
        byte by;
        block10: {
            Object object;
            block3: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            in.setPosition(position);
                                            by = typed;
                                            if (this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$StringByte() != by) break block2;
                                            object = this.readString(in);
                                            break block3;
                                        }
                                        if (this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DocByte() != by) break block4;
                                        object = JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)this.readDocument(in)));
                                        break block3;
                                    }
                                    if (this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$ArrayByte() != by) break block5;
                                    object = this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$unwrapArray(this.readArray(in));
                                    break block3;
                                }
                                if (this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DoubleByte() != by) break block6;
                                object = BoxesRunTime.boxToDouble((double)in.readDouble());
                                break block3;
                            }
                            if (this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$IntByte() != by) break block7;
                            object = BoxesRunTime.boxToInteger((int)in.readInt());
                            break block3;
                        }
                        if (this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$LongByte() != by) break block8;
                        object = BoxesRunTime.boxToLong((long)in.readLong());
                        break block3;
                    }
                    if (this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$NullByte() != by) break block9;
                    object = null;
                    break block3;
                }
                if (this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$BooleanByte() != by) break block10;
                object = BoxesRunTime.boxToBoolean((boolean)this.readBoolean(in));
            }
            return object;
        }
        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
    }

    public Seq<Object> org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$unwrapArray(JsonAST.JArray array) {
        return (Seq)array.arr().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(JsonAST.JValue x0$3) {
                JsonAST.JValue jValue;
                block9: {
                    Object object;
                    block3: {
                        block8: {
                            block7: {
                                block6: {
                                    block5: {
                                        block4: {
                                            block2: {
                                                Seq<Object> s;
                                                jValue = x0$3;
                                                if (!(jValue instanceof JsonAST.JString)) break block2;
                                                JsonAST.JString jString = (JsonAST.JString)jValue;
                                                object = s = jString.s();
                                                break block3;
                                            }
                                            if (!(jValue instanceof JsonAST.JObject)) break block4;
                                            JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                                            object = JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)jObject));
                                            break block3;
                                        }
                                        if (!(jValue instanceof JsonAST.JArray)) break block5;
                                        JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                                        object = KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$unwrapArray(jArray);
                                        break block3;
                                    }
                                    if (!(jValue instanceof JsonAST.JDouble)) break block6;
                                    JsonAST.JDouble jDouble = (JsonAST.JDouble)jValue;
                                    double d = jDouble.num();
                                    object = BoxesRunTime.boxToDouble((double)d);
                                    break block3;
                                }
                                if (!(jValue instanceof JsonAST.JInt)) break block7;
                                JsonAST.JInt jInt = (JsonAST.JInt)jValue;
                                BigInt i = jInt.num();
                                object = i.isValidInt() ? BoxesRunTime.boxToLong((long)i.toInt()) : BoxesRunTime.boxToLong((long)i.toLong());
                                break block3;
                            }
                            if (!JsonAST.JNull$.MODULE$.equals(jValue)) break block8;
                            object = null;
                            break block3;
                        }
                        if (!(jValue instanceof JsonAST.JBool)) break block9;
                        JsonAST.JBool jBool = (JsonAST.JBool)jValue;
                        boolean b = jBool.value();
                        object = BoxesRunTime.boxToBoolean((boolean)b);
                    }
                    return object;
                }
                throw new MatchError((Object)jValue);
            }
        }, List$.MODULE$.canBuildFrom());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$applyPathFunction(Enumeration.Value function, Object value) {
        Object object = value;
        if (object instanceof Seq) {
            Object object2;
            Seq seq = (Seq)object;
            Enumeration.Value value2 = function;
            Enumeration.Value value3 = JsonPathParser$JsonPathFunction$.MODULE$.length();
            Enumeration.Value value4 = value2;
            if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                object2 = BoxesRunTime.boxToInteger((int)seq.length());
                return object2;
            }
            Enumeration.Value value5 = JsonPathParser$JsonPathFunction$.MODULE$.avg();
            Enumeration.Value value6 = value2;
            if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
                object2 = BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)((TraversableOnce)seq.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Object v) {
                        return KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$toNum$1(v);
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)seq.length()));
                return object2;
            }
            Enumeration.Value value7 = JsonPathParser$JsonPathFunction$.MODULE$.min();
            Enumeration.Value value8 = value2;
            if (!(value7 != null ? !value7.equals(value8) : value8 != null)) {
                object2 = ((TraversableOnce)seq.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Object v) {
                        return KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$toNum$1(v);
                    }
                }, Seq$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Double$.MODULE$);
                return object2;
            }
            Enumeration.Value value9 = JsonPathParser$JsonPathFunction$.MODULE$.max();
            Enumeration.Value value10 = value2;
            if (value9 == null) {
                if (value10 != null) {
                    throw new MatchError((Object)value2);
                }
            } else if (!value9.equals(value10)) throw new MatchError((Object)value2);
            object2 = ((TraversableOnce)seq.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(Object v) {
                    return KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$toNum$1(v);
                }
            }, Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$);
            return object2;
        }
        if (!(object instanceof String)) return null;
        String string = (String)object;
        Enumeration.Value value11 = function;
        Enumeration.Value value12 = JsonPathParser$JsonPathFunction$.MODULE$.length();
        if (value11 != null) {
            if (!value11.equals(value12)) return null;
            return BoxesRunTime.boxToInteger((int)string.length());
        }
        if (value12 == null) return BoxesRunTime.boxToInteger((int)string.length());
        return null;
    }

    private KryoJsonSerialization.RichOutput RichOutput(Output out) {
        return new KryoJsonSerialization.RichOutput(out);
    }

    public KryoJsonSerialization.RichInput org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$RichInput(Input in) {
        return new KryoJsonSerialization.RichInput(in);
    }

    public final boolean org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$predicate$1(Input in$4) {
        this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$RichInput(in$4).skipName();
        return true;
    }

    public final double org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$toNum$1(Object v) {
        double d;
        Object object = v;
        if (object instanceof Number) {
            Number number = (Number)object;
            d = number.doubleValue();
        } else {
            d = object == null ? 0.0 : new StringOps(Predef$.MODULE$.augmentString(object.toString())).toDouble();
        }
        return d;
    }

    private KryoJsonSerialization$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$TerminalByte = 0;
        this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DoubleByte = 1;
        this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$StringByte = (byte)2;
        this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DocByte = (byte)3;
        this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$ArrayByte = (byte)4;
        this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$BooleanByte = (byte)8;
        this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$NullByte = (byte)10;
        this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$IntByte = (byte)16;
        this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$LongByte = (byte)18;
        this.BooleanFalse = 0;
        this.BooleanTrue = 1;
        this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$nameBuffers = new ThreadLocal<byte[]>(){

            public byte[] initialValue() {
                return (byte[])Array$.MODULE$.ofDim(32, ClassTag$.MODULE$.Byte());
            }
        };
    }
}

