/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.cassandra.data;

import com.datastax.driver.core.GettableByNameData;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.google.common.primitives.Bytes;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.locationtech.geomesa.cassandra.data.CassandraMetadataAdapter;
import org.locationtech.geomesa.index.metadata.CachedLazyMetadata;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class CassandraMetadataAdapter$class {
    public static byte typeNameSeparatorByte(CassandraMetadataAdapter $this) {
        byte[] bytes = ((Object)BoxesRunTime.boxToCharacter((char)((CachedLazyMetadata)$this).typeNameSeparator())).toString().getBytes(StandardCharsets.UTF_8);
        Predef$.MODULE$.require(bytes.length == 1, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected single byte for type name separator";
            }
        });
        return BoxesRunTime.unboxToByte((Object)Predef$.MODULE$.byteArrayOps(bytes).head());
    }

    public static boolean checkIfTableExists(CassandraMetadataAdapter $this) {
        Metadata m = $this.session().getCluster().getMetadata();
        KeyspaceMetadata km = m.getKeyspace($this.session().getLoggedKeyspace());
        return km.getTable($this.catalog()) != null;
    }

    public static void createTable(CassandraMetadataAdapter $this) {
        $this.session().execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE IF NOT EXISTS ", " (sft text, key text, value text, PRIMARY KEY ((sft), key))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.catalog()})));
    }

    public static void write(CassandraMetadataAdapter $this, Seq rows) {
        rows.foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraMetadataAdapter $outer;

            public final ResultSet apply(Tuple2<byte[], byte[]> x0$1) {
                Tuple2<byte[], byte[]> tuple2 = x0$1;
                if (tuple2 != null) {
                    byte[] key = (byte[])tuple2._1();
                    byte[] value = (byte[])tuple2._2();
                    Tuple2 tuple22 = CassandraMetadataAdapter$class.org$locationtech$geomesa$cassandra$data$CassandraMetadataAdapter$$split(this.$outer, key);
                    if (tuple22 != null) {
                        Tuple2 tuple23;
                        String sft = (String)tuple22._1();
                        String k = (String)tuple22._2();
                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)sft, (Object)k);
                        String sft2 = (String)tuple24._1();
                        String k2 = (String)tuple24._2();
                        ResultSet resultSet = this.$outer.session().execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", " (sft, key, value) VALUES (?, ?, ?)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.catalog()})), new Object[]{sft2, k2, new String(value, StandardCharsets.UTF_8)});
                        return resultSet;
                    }
                    throw new MatchError((Object)tuple22);
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static void delete(CassandraMetadataAdapter $this, byte[] row) {
        Tuple2 tuple2 = CassandraMetadataAdapter$class.org$locationtech$geomesa$cassandra$data$CassandraMetadataAdapter$$split($this, row);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String sft = (String)tuple2._1();
            String key = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)sft, (Object)key);
            String sft2 = (String)tuple23._1();
            String key2 = (String)tuple23._2();
            Delete.Where query = QueryBuilder.delete().from($this.catalog()).where(QueryBuilder.eq((String)"sft", (Object)sft2)).and(QueryBuilder.eq((String)"key", (Object)key2));
            $this.session().execute((Statement)query);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static void delete(CassandraMetadataAdapter $this, Seq rows) {
        rows.foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraMetadataAdapter $outer;

            public final void apply(byte[] row) {
                this.$outer.delete(row);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static Option scanValue(CassandraMetadataAdapter $this, byte[] row) {
        Tuple2 tuple2 = CassandraMetadataAdapter$class.org$locationtech$geomesa$cassandra$data$CassandraMetadataAdapter$$split($this, row);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String sft = (String)tuple2._1();
            String key = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)sft, (Object)key);
            String sft2 = (String)tuple23._1();
            String key2 = (String)tuple23._2();
            Select query = QueryBuilder.select((String[])new String[]{"value"}).from($this.catalog());
            query.where(QueryBuilder.eq((String)"sft", (Object)sft2)).and(QueryBuilder.eq((String)"key", (Object)key2));
            List rows = $this.session().execute((Statement)query).all();
            return JavaConversions$.MODULE$.asScalaBuffer(rows).length() < 1 ? None$.MODULE$ : new Some((Object)((GettableByNameData)JavaConversions$.MODULE$.asScalaBuffer(rows).head()).getString("value").getBytes(StandardCharsets.UTF_8));
        }
        throw new MatchError((Object)tuple2);
    }

    public static CloseableIterator scanRows(CassandraMetadataAdapter $this, Option prefix) {
        Select query = QueryBuilder.select((String[])new String[]{"sft", "key"}).from($this.catalog());
        prefix.foreach((Function1)new Serializable($this, query){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraMetadataAdapter $outer;
            private final Select query$1;

            public final Object apply(byte[] p) {
                Tuple2 tuple2 = CassandraMetadataAdapter$class.org$locationtech$geomesa$cassandra$data$CassandraMetadataAdapter$$split(this.$outer, p);
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    Tuple2 tuple22;
                    String sft = (String)tuple2._1();
                    String key = (String)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)sft, (Object)key);
                    String sft2 = (String)tuple23._1();
                    String key2 = (String)tuple23._2();
                    this.query$1.where(QueryBuilder.eq((String)"sft", (Object)sft2));
                    if (key2 != null && key2.length() > 0) {
                        String end = new String(ByteArrays$.MODULE$.rowFollowingPrefix(key2.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
                        boxedUnit = this.query$1.where(QueryBuilder.gte((String)"key", (Object)key2)).and(QueryBuilder.lt((String)"key", (Object)end));
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.query$1 = query$1;
            }
        });
        Buffer bytes = (Buffer)JavaConversions$.MODULE$.asScalaBuffer($this.session().execute((Statement)query).all()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraMetadataAdapter $outer;

            public final byte[] apply(Row row) {
                byte[] sft = row.getString("sft").getBytes(StandardCharsets.UTF_8);
                byte[] key = row.getString("key").getBytes(StandardCharsets.UTF_8);
                return Bytes.concat((byte[][])new byte[][]{sft, {this.$outer.typeNameSeparatorByte()}, key});
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        return CloseableIterator$.MODULE$.apply(bytes.iterator(), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CloseableIterator$.MODULE$.apply$default$2();
            }
        });
    }

    public static void close(CassandraMetadataAdapter $this) {
    }

    public static Tuple2 org$locationtech$geomesa$cassandra$data$CassandraMetadataAdapter$$split(CassandraMetadataAdapter $this, byte[] row) {
        int i = Predef$.MODULE$.byteArrayOps(row).indexOf((Object)BoxesRunTime.boxToByte((byte)$this.typeNameSeparatorByte()));
        return i == -1 ? new Tuple2((Object)new String(row, StandardCharsets.UTF_8), null) : new Tuple2((Object)new String(row, 0, i, StandardCharsets.UTF_8), (Object)new String(row, i + 1, row.length - (i + 1), StandardCharsets.UTF_8));
    }

    public static void $init$(CassandraMetadataAdapter $this) {
    }
}

