/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.stats;

import java.time.ZonedDateTime;
import java.util.Date;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.Bounds$;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.index.stats.GeoMesaStats$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.package$;

public final class CountEstimator$ {
    public static final CountEstimator$ MODULE$;
    private final int ZHistogramPrecision;
    private final Seq<Object> ErrorThresholds;

    static {
        new CountEstimator$();
    }

    public int ZHistogramPrecision() {
        return this.ZHistogramPrecision;
    }

    public Seq<Object> ErrorThresholds() {
        return this.ErrorThresholds;
    }

    public Option<Bounds<Date>> extractDates(SimpleFeatureType sft, Filter filter2) {
        Option option;
        block7: {
            Some some;
            block6: {
                None$ none$;
                block5: {
                    option = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
                    if (!None$.MODULE$.equals(option)) break block5;
                    some = new Some((Object)Bounds$.MODULE$.everything());
                    break block6;
                }
                if (!(option instanceof Some)) break block7;
                Some some2 = (Some)option;
                String dtg = (String)some2.x();
                FilterValues intervals = FilterHelper$.MODULE$.extractIntervals(filter2, dtg, FilterHelper$.MODULE$.extractIntervals$default$3(), FilterHelper$.MODULE$.extractIntervals$default$4());
                if (intervals.disjoint()) {
                    none$ = None$.MODULE$;
                } else {
                    Option dateTimes = intervals.values().reduceOption((Function2)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Bounds<ZonedDateTime> apply(Bounds<ZonedDateTime> x0$6, Bounds<ZonedDateTime> x1$1) {
                            Tuple2 tuple2 = new Tuple2(x0$6, x1$1);
                            if (tuple2 != null) {
                                Bounds left = (Bounds)tuple2._1();
                                Bounds right = (Bounds)tuple2._2();
                                Bounds.Bound lower = Bounds$.MODULE$.smallerLowerBound(left.lower(), right.lower());
                                Bounds.Bound upper = Bounds$.MODULE$.largerUpperBound(left.upper(), right.upper());
                                Bounds bounds = new Bounds(lower, upper);
                                return bounds;
                            }
                            throw new MatchError((Object)tuple2);
                        }
                    });
                    Option lower = dateTimes.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Bounds.Bound<Date> apply(Bounds<ZonedDateTime> d) {
                            return new Bounds.Bound(d.lower().value().map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Date apply(ZonedDateTime i) {
                                    return Date.from(i.toInstant());
                                }
                            }), d.lower().inclusive());
                        }
                    });
                    Option upper = dateTimes.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Bounds.Bound<Date> apply(Bounds<ZonedDateTime> d) {
                            return new Bounds.Bound(d.upper().value().map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Date apply(ZonedDateTime i) {
                                    return Date.from(i.toInstant());
                                }
                            }), d.upper().inclusive());
                        }
                    });
                    none$ = new Some((Object)new Bounds((Bounds.Bound)lower.getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Bounds.Bound<Date> apply() {
                            return Bounds.Bound$.MODULE$.unbounded();
                        }
                    }), (Bounds.Bound)upper.getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Bounds.Bound<Date> apply() {
                            return Bounds.Bound$.MODULE$.unbounded();
                        }
                    })));
                }
                some = none$;
            }
            return some;
        }
        throw new MatchError((Object)option);
    }

    private CountEstimator$() {
        MODULE$ = this;
        this.ZHistogramPrecision = (int)package$.MODULE$.ceil(package$.MODULE$.log((double)GeoMesaStats$.MODULE$.MaxHistogramSize()) / package$.MODULE$.log(2.0)) + 2;
        this.ErrorThresholds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.1, 0.3, 0.5, 0.7, 0.9, 1.0}));
    }
}

