/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.cassandra.index;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.querybuilder.Select;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.geotools.factory.Hints;
import org.locationtech.geomesa.cassandra.data.CassandraDataStore;
import org.locationtech.geomesa.cassandra.data.CassandraFeature;
import org.locationtech.geomesa.cassandra.data.CassandraQueryPlan;
import org.locationtech.geomesa.cassandra.data.EmptyPlan;
import org.locationtech.geomesa.cassandra.data.StatementPlan;
import org.locationtech.geomesa.cassandra.index.CassandraFeatureIndex;
import org.locationtech.geomesa.cassandra.index.CassandraFeatureIndex$;
import org.locationtech.geomesa.cassandra.package;
import org.locationtech.geomesa.index.api.FilterStrategy;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.index.ClientSideFiltering;
import org.locationtech.geomesa.index.index.IndexKeySpace;
import org.locationtech.geomesa.index.index.ShardStrategy;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.EmptyMethodCache;
import scala.runtime.MethodCache;
import scala.runtime.ScalaRunTime$;

public abstract class CassandraFeatureIndex$class {
    private static Class[] reflParams$Cache1 = new Class[]{String.class, Filter.class};
    private static volatile SoftReference reflPoly$Cache1 = new SoftReference<EmptyMethodCache>(new EmptyMethodCache());

    public static Method reflMethod$Method1(Class x$1) {
        Method method1;
        MethodCache methodCache1 = (MethodCache)reflPoly$Cache1.get();
        if (methodCache1 == null) {
            methodCache1 = new EmptyMethodCache();
            reflPoly$Cache1 = new SoftReference<MethodCache>(methodCache1);
        }
        if ((method1 = methodCache1.find(x$1)) != null) {
            return method1;
        }
        method1 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("onFullTableScan", reflParams$Cache1));
        reflPoly$Cache1 = new SoftReference<MethodCache>(methodCache1.add(x$1, method1));
        return method1;
    }

    public static boolean supports(CassandraFeatureIndex $this, SimpleFeatureType sft) {
        return $this.keySpace().supports(sft);
    }

    public static void configure(CassandraFeatureIndex $this, SimpleFeatureType sft, CassandraDataStore ds) {
        $this.org$locationtech$geomesa$cassandra$index$CassandraFeatureIndex$$super$configure(sft, ds);
        String tableName = $this.getTableName(sft.getTypeName(), ds);
        Cluster cluster = ds.session().getCluster();
        TableMetadata table = cluster.getMetadata().getKeyspace(ds.session().getLoggedKeyspace()).getTable(tableName);
        if (table == null) {
            Tuple2 tuple2 = $this.columns().partition((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(package.NamedColumn x$1) {
                    return x$1.partition();
                }
            });
            if (tuple2 != null) {
                BoxedUnit boxedUnit;
                Tuple2 tuple22;
                Seq partitions = (Seq)tuple2._1();
                Seq pks = (Seq)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)partitions, (Object)pks);
                Seq partitions2 = (Seq)tuple23._1();
                Seq pks2 = (Seq)tuple23._2();
                String create = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE ", " (", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, ((TraversableOnce)$this.columns().map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(package.NamedColumn c) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c.name(), c.cType()}));
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(", ")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PRIMARY KEY (", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)partitions2.map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(package.NamedColumn x$3) {
                        return x$3.name();
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString("(", ", ", ")")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pks2.nonEmpty() ? ((TraversableOnce)pks2.map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(package.NamedColumn x$4) {
                        return x$4.name();
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(", ", ", ", "") : ""}))).toString();
                if ($this.logger().underlying().isDebugEnabled()) {
                    $this.logger().underlying().debug(create);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                ds.session().execute(create);
            } else {
                throw new MatchError((Object)tuple2);
            }
        }
    }

    public static Function1 writer(CassandraFeatureIndex $this, SimpleFeatureType sft, CassandraDataStore ds) {
        ShardStrategy shards = $this.shardStrategy(sft);
        IndexKeySpace qual$1 = $this.keySpace();
        SimpleFeatureType x$8 = sft;
        boolean x$9 = qual$1.toIndexKey$default$2();
        Function1 toIndexKey = qual$1.toIndexKey(x$8, x$9);
        return new Serializable($this, shards, toIndexKey){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraFeatureIndex $outer;
            private final ShardStrategy shards$1;
            private final Function1 toIndexKey$1;

            public final Seq<Seq<package.RowValue>> apply(CassandraFeature cf) {
                return this.$outer.createValues(this.shards$1, this.toIndexKey$1, true, cf);
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.shards$1 = shards$1;
                this.toIndexKey$1 = var3_3;
            }
        };
    }

    public static Function1 remover(CassandraFeatureIndex $this, SimpleFeatureType sft, CassandraDataStore ds) {
        ShardStrategy shards = $this.shardStrategy(sft);
        Function1 toIndexKey = $this.keySpace().toIndexKey(sft, true);
        return new Serializable($this, shards, toIndexKey){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraFeatureIndex $outer;
            private final ShardStrategy shards$2;
            private final Function1 toIndexKey$2;

            public final Seq<Seq<package.RowValue>> apply(CassandraFeature cf) {
                return this.$outer.createValues(this.shards$2, this.toIndexKey$2, false, cf);
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.shards$2 = shards$2;
                this.toIndexKey$2 = var3_3;
            }
        };
    }

    public static Function4 getIdFromRow(CassandraFeatureIndex $this, SimpleFeatureType sft) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraFeatureIndex $outer;

            public final String apply(byte[] row, int offset, int length, SimpleFeature feature) {
                return CassandraFeatureIndex$class.org$locationtech$geomesa$cassandra$index$CassandraFeatureIndex$$bytesToString(this.$outer, row, offset, length, feature);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public static String org$locationtech$geomesa$cassandra$index$CassandraFeatureIndex$$bytesToString(CassandraFeatureIndex $this, byte[] row, int offset, int length, SimpleFeature feature) {
        return new String(row, offset, length, StandardCharsets.UTF_8);
    }

    public static Seq getSplits(CassandraFeatureIndex $this, SimpleFeatureType sft) {
        throw new NotImplementedError("Cassandra does not support splits");
    }

    public static void removeAll(CassandraFeatureIndex $this, SimpleFeatureType sft, CassandraDataStore ds) {
        BoxedUnit boxedUnit;
        String tableName = $this.getTableName(sft.getTypeName(), ds);
        String truncate = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TRUNCATE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}));
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(truncate);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ds.session().execute(truncate);
    }

    public static void delete(CassandraFeatureIndex $this, SimpleFeatureType sft, CassandraDataStore ds, boolean shared) {
        BoxedUnit boxedUnit;
        if (shared) {
            throw new NotImplementedError("Cassandra tables are never shared");
        }
        String tableName = $this.getTableName(sft.getTypeName(), ds);
        String delete2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP TABLE IF EXISTS ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}));
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(delete2);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ds.session().execute(delete2);
    }

    public static QueryPlan getQueryPlan(CassandraFeatureIndex $this, SimpleFeatureType sft, CassandraDataStore ds, FilterStrategy filter, Hints hints, Explainer explain2) {
        Option option;
        block9: {
            CassandraQueryPlan cassandraQueryPlan;
            Iterator iterator;
            Option indexValues;
            block8: {
                block7: {
                    indexValues = filter.primary().map((Function1)new Serializable($this, sft, explain2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ CassandraFeatureIndex $outer;
                        private final SimpleFeatureType sft$1;
                        private final Explainer explain$1;

                        public final T apply(Filter x$5) {
                            return (T)this.$outer.keySpace().getIndexValues(this.sft$1, x$5, this.explain$1);
                        }
                        {
                            void var3_3;
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.sft$1 = sft$1;
                            this.explain$1 = var3_3;
                        }
                    });
                    option = indexValues;
                    if (!None$.MODULE$.equals(option)) break block7;
                    GeoMesaSystemProperties.SystemProperty qual1 = QueryProperties$.MODULE$.BlockFullTableScans();
                    try {
                        CassandraFeatureIndex$class.reflMethod$Method1(qual1.getClass()).invoke((Object)qual1, sft.getTypeName(), filter.filter().getOrElse((Function0)new Serializable($this){
                            public static final long serialVersionUID = 0L;

                            public final IncludeFilter apply() {
                                return Filter.INCLUDE;
                            }
                        }));
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw invocationTargetException.getCause();
                    }
                    filter.secondary().foreach((Function1)new Serializable($this, sft){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ CassandraFeatureIndex $outer;
                        private final SimpleFeatureType sft$1;

                        public final void apply(Filter f) {
                            BoxedUnit boxedUnit;
                            if (this.$outer.logger().underlying().isWarnEnabled()) {
                                this.$outer.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running full table scan on ", " index for schema ", " with filter ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.name(), this.sft$1.getTypeName(), org.locationtech.geomesa.filter.package$.MODULE$.filterToString(f)})));
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.sft$1 = sft$1;
                        }
                    });
                    iterator = package$.MODULE$.Iterator().single((Object)Seq$.MODULE$.empty());
                    break block8;
                }
                if (!(option instanceof Some)) break block9;
                Some some = (Some)option;
                Object values = some.x();
                Iterator ranges = $this.keySpace().getRanges(values);
                Seq splits = (Seq)$this.shardStrategy(sft).shards().map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final package.RowRange apply(byte[] b) {
                        return new package.RowRange(CassandraFeatureIndex$.MODULE$.ShardColumn(), BoxesRunTime.boxToByte((byte)b[0]), BoxesRunTime.boxToByte((byte)b[0]));
                    }
                }, Seq$.MODULE$.canBuildFrom());
                iterator = splits.isEmpty() ? ranges.map((Function1)new Serializable($this, sft){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ CassandraFeatureIndex $outer;
                    private final SimpleFeatureType sft$1;

                    public final Seq<package.RowRange> apply(IndexKeySpace.ScanRange<U> x$6) {
                        return this.$outer.toRowRanges(this.sft$1, x$6);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.sft$1 = sft$1;
                    }
                }) : ranges.flatMap((Function1)new Serializable($this, splits, sft){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ CassandraFeatureIndex $outer;
                    private final Seq splits$1;
                    private final SimpleFeatureType sft$1;

                    public final GenTraversableOnce<Seq<package.RowRange>> apply(IndexKeySpace.ScanRange<U> r) {
                        Seq<package.RowRange> rows = this.$outer.toRowRanges(this.sft$1, r);
                        return (GenTraversableOnce)this.splits$1.map((Function1)new Serializable(this, rows){
                            public static final long serialVersionUID = 0L;
                            private final Seq rows$1;

                            public final Seq<package.RowRange> apply(package.RowRange split) {
                                return (Seq)this.rows$1.$plus$colon((Object)split, Seq$.MODULE$.canBuildFrom());
                            }
                            {
                                this.rows$1 = rows$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                    }
                    {
                        void var3_3;
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.splits$1 = splits$1;
                        this.sft$1 = var3_3;
                    }
                });
            }
            Iterator ranges = iterator;
            if (ranges.isEmpty()) {
                cassandraQueryPlan = new EmptyPlan((FilterStrategy<CassandraDataStore, CassandraFeature, Seq<package.RowValue>>)filter);
            } else {
                String ks = ds.session().getLoggedKeyspace();
                String tableName = $this.getTableName(sft.getTypeName(), ds);
                Iterator statements = ranges.map((Function1)new Serializable($this, ks, tableName){
                    public static final long serialVersionUID = 0L;
                    private final String ks$1;
                    private final String tableName$1;

                    public final Select apply(Seq<package.RowRange> x$7) {
                        return CassandraFeatureIndex$.MODULE$.statement(this.ks$1, this.tableName$1, x$7);
                    }
                    {
                        void var3_3;
                        this.ks$1 = ks$1;
                        this.tableName$1 = var3_3;
                    }
                });
                boolean useFullFilter = $this.keySpace().useFullFilter(indexValues, (Option)new Some((Object)ds.config()), hints);
                Option ecql = useFullFilter ? filter.filter() : filter.secondary();
                Function1 toFeatures = $this.resultsToFeatures(sft, ecql, QueryHints$.MODULE$.RichHints(hints).getTransform());
                cassandraQueryPlan = new StatementPlan((FilterStrategy<CassandraDataStore, CassandraFeature, Seq<package.RowValue>>)filter, tableName, (Seq<Statement>)statements.toSeq(), ds.config().queryThreads(), (Option<Filter>)ecql, (Function1<Iterator<Row>, Iterator<SimpleFeature>>)toFeatures);
            }
            return cassandraQueryPlan;
        }
        throw new MatchError((Object)option);
    }

    public static ClientSideFiltering.RowAndValue rowAndValue(CassandraFeatureIndex $this, Row result) {
        byte[] fid = ((String)result.get(CassandraFeatureIndex$.MODULE$.FeatureIdColumnName(), String.class)).getBytes(StandardCharsets.UTF_8);
        ByteBuffer sf = result.getBytes("sf");
        byte[] value = (byte[])Array$.MODULE$.ofDim(sf.limit(), ClassTag$.MODULE$.Byte());
        sf.get(value);
        return new ClientSideFiltering.RowAndValue(fid, 0, fid.length, value, 0, value.length);
    }

    public static void $init$(CassandraFeatureIndex $this) {
    }
}

