/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export.formats;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import org.locationtech.geomesa.tools.export.formats.LeafletMapExporter;
import org.locationtech.geomesa.tools.export.formats.LeafletMapExporter$SimpleCoordinate$mcD$sp;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class LeafletMapExporter$ {
    public static final LeafletMapExporter$ MODULE$;

    static {
        new LeafletMapExporter$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File getDestination(File file) {
        public class Org_locationtech_geomesa_tools_export_formats_LeafletMapExporter$WritableFile$2 {
            private final File file;

            public File ensureWritable() {
                if (this.file.canWrite()) {
                    return this.file;
                }
                throw new SecurityException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to create output destination ", ", check permissions."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file.toString()})));
            }

            public Org_locationtech_geomesa_tools_export_formats_LeafletMapExporter$WritableFile$2(File file) {
                this.file = file;
            }
        }
        File file2;
        if (file.exists()) {
            if (file.isDirectory()) {
                file2 = this.WritableFile$1(new File(file, "index.html")).ensureWritable();
                return file2;
            } else {
                if (!file.toString().endsWith(".html")) throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Destination file ", " must end with '.html'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.toString()})));
                file2 = this.WritableFile$1(file).ensureWritable();
            }
            return file2;
        } else {
            file.mkdirs();
            file2 = this.WritableFile$1(new File(file, "index.html")).ensureWritable();
        }
        return file2;
    }

    public String getFeatureInfo(SimpleFeatureType sft) {
        Option option;
        block4: {
            StringBuilder str;
            block3: {
                String string;
                block2: {
                    str = new StringBuilder();
                    str.append("    function onEachFeature(feature, layer) {\n");
                    option = Option$.MODULE$.apply((Object)sft);
                    if (!None$.MODULE$.equals(option)) break block2;
                    string = str.append("\n    };\n\n").toString();
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                str.append("        layer.bindPopup(\"ID: \" + feature.id + \"<br>\" + ");
                str.append("\"GEOM: \" + feature.geometry.type + \"[\" + feature.geometry.coordinates + \"]<br>\" + ");
                string = str.append(((TraversableOnce)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(sft.getAttributeDescriptors()).filter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(AttributeDescriptor x$2) {
                        String string = x$2.getLocalName();
                        String string2 = "geom";
                        return string != null ? !string.equals(string2) : string2 != null;
                    }
                })).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(AttributeDescriptor attr) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"", ": \" + feature.properties.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attr.getLocalName(), attr.getLocalName()}));
                    }
                }, Buffer$.MODULE$.canBuildFrom())).mkString(" + \"<br>\" + "));
            }
            str.append(");\n    }\n\n");
            return str.toString();
        }
        throw new MatchError((Object)option);
    }

    public void storeFeature(SimpleFeature feature, Map<LeafletMapExporter.SimpleCoordinate<Object>, Object> coordMap) {
        Coordinate[] coordinateArray;
        Object object = feature.getDefaultGeometry();
        if (object instanceof Geometry) {
            Geometry geometry = (Geometry)object;
            coordinateArray = geometry.getCoordinates();
        } else {
            coordinateArray = (Coordinate[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Coordinate.class));
        }
        Coordinate[] coords = coordinateArray;
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])coords).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LeafletMapExporter.SimpleCoordinate<Object> apply(Coordinate c) {
                return new LeafletMapExporter$SimpleCoordinate$mcD$sp(c.x, c.y);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LeafletMapExporter.SimpleCoordinate.class)))).foreach((Function1)new Serializable(coordMap){
            public static final long serialVersionUID = 0L;
            private final Map coordMap$1;

            public final Object apply(LeafletMapExporter.SimpleCoordinate<Object> sc) {
                Option option;
                block4: {
                    BoxedUnit boxedUnit;
                    block3: {
                        block2: {
                            option = this.coordMap$1.put(sc, (Object)BoxesRunTime.boxToInteger((int)1));
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            int count = BoxesRunTime.unboxToInt((Object)some.x());
                            boxedUnit = this.coordMap$1.put(sc, (Object)BoxesRunTime.boxToInteger((int)(count + 1)));
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                }
                throw new MatchError((Object)option);
            }
            {
                this.coordMap$1 = coordMap$1;
            }
        });
    }

    public scala.collection.immutable.Map<LeafletMapExporter.SimpleCoordinate<Object>, Object> normalizeValues(Map<LeafletMapExporter.SimpleCoordinate<Object>, Object> coordMap) {
        scala.collection.immutable.Map map;
        if (coordMap.nonEmpty()) {
            float max = ((Tuple2)coordMap.maxBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<LeafletMapExporter.SimpleCoordinate<Object>, Object> x$3) {
                    return x$3._2$mcI$sp();
                }
            }, (Ordering)Ordering.Int$.MODULE$))._2$mcI$sp();
            map = ((TraversableOnce)coordMap.map((Function1)new Serializable(max){
                public static final long serialVersionUID = 0L;
                private final float max$1;

                public final Tuple2<LeafletMapExporter.SimpleCoordinate<Object>, Object> apply(Tuple2<LeafletMapExporter.SimpleCoordinate<Object>, Object> c) {
                    return new Tuple2(c._1(), (Object)BoxesRunTime.boxToFloat((float)((float)c._2$mcI$sp() / this.max$1)));
                }
                {
                    this.max$1 = max$1;
                }
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        } else {
            map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        }
        return map;
    }

    private final LeafletMapExporter.WritableFile.2 WritableFile$1(File file) {
        return new Org_locationtech_geomesa_tools_export_formats_LeafletMapExporter$WritableFile$2(file);
    }

    private LeafletMapExporter$() {
        MODULE$ = this;
    }
}

