/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.CGAlgorithmsDD;
import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RayCrossingCounter;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.math.MathUtil;

public class CGAlgorithms {
    public static final int CLOCKWISE = -1;
    public static final int RIGHT = -1;
    public static final int COUNTERCLOCKWISE = 1;
    public static final int LEFT = 1;
    public static final int COLLINEAR = 0;
    public static final int STRAIGHT = 0;

    public static int orientationIndex(Coordinate p1, Coordinate p2, Coordinate q) {
        return CGAlgorithmsDD.orientationIndex(p1, p2, q);
    }

    public static boolean isPointInRing(Coordinate p, Coordinate[] ring) {
        return CGAlgorithms.locatePointInRing(p, ring) != 2;
    }

    public static int locatePointInRing(Coordinate p, Coordinate[] ring) {
        return RayCrossingCounter.locatePointInRing(p, ring);
    }

    public static boolean isOnLine(Coordinate p, Coordinate[] pt) {
        RobustLineIntersector lineIntersector = new RobustLineIntersector();
        int i = 1;
        while (i < pt.length) {
            Coordinate p0 = pt[i - 1];
            Coordinate p1 = pt[i];
            ((LineIntersector)lineIntersector).computeIntersection(p, p0, p1);
            if (lineIntersector.hasIntersection()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isCCW(Coordinate[] ring) {
        int nPts = ring.length - 1;
        if (nPts < 3) {
            throw new IllegalArgumentException("Ring has fewer than 4 points, so orientation cannot be determined");
        }
        Coordinate hiPt = ring[0];
        int hiIndex = 0;
        int i = 1;
        while (i <= nPts) {
            Coordinate p = ring[i];
            if (p.y > hiPt.y) {
                hiPt = p;
                hiIndex = i;
            }
            ++i;
        }
        int iPrev = hiIndex;
        do {
            if (--iPrev >= 0) continue;
            iPrev = nPts;
        } while (ring[iPrev].equals2D(hiPt) && iPrev != hiIndex);
        int iNext = hiIndex;
        while (ring[iNext = (iNext + 1) % nPts].equals2D(hiPt) && iNext != hiIndex) {
        }
        Coordinate prev = ring[iPrev];
        Coordinate next = ring[iNext];
        if (prev.equals2D(hiPt) || next.equals2D(hiPt) || prev.equals2D(next)) {
            return false;
        }
        int disc = CGAlgorithms.computeOrientation(prev, hiPt, next);
        boolean isCCW = false;
        isCCW = disc == 0 ? prev.x > next.x : disc > 0;
        return isCCW;
    }

    public static int computeOrientation(Coordinate p1, Coordinate p2, Coordinate q) {
        return CGAlgorithms.orientationIndex(p1, p2, q);
    }

    public static double distancePointLine(Coordinate p, Coordinate A, Coordinate B) {
        if (A.x == B.x && A.y == B.y) {
            return p.distance(A);
        }
        double len2 = (B.x - A.x) * (B.x - A.x) + (B.y - A.y) * (B.y - A.y);
        double r = ((p.x - A.x) * (B.x - A.x) + (p.y - A.y) * (B.y - A.y)) / len2;
        if (r <= 0.0) {
            return p.distance(A);
        }
        if (r >= 1.0) {
            return p.distance(B);
        }
        double s = ((A.y - p.y) * (B.x - A.x) - (A.x - p.x) * (B.y - A.y)) / len2;
        return Math.abs(s) * Math.sqrt(len2);
    }

    public static double distancePointLinePerpendicular(Coordinate p, Coordinate A, Coordinate B) {
        double len2 = (B.x - A.x) * (B.x - A.x) + (B.y - A.y) * (B.y - A.y);
        double s = ((A.y - p.y) * (B.x - A.x) - (A.x - p.x) * (B.y - A.y)) / len2;
        return Math.abs(s) * Math.sqrt(len2);
    }

    public static double distancePointLine(Coordinate p, Coordinate[] line) {
        if (line.length == 0) {
            throw new IllegalArgumentException("Line array must contain at least one vertex");
        }
        double minDistance = p.distance(line[0]);
        int i = 0;
        while (i < line.length - 1) {
            double dist = CGAlgorithms.distancePointLine(p, line[i], line[i + 1]);
            if (dist < minDistance) {
                minDistance = dist;
            }
            ++i;
        }
        return minDistance;
    }

    public static double distanceLineLine(Coordinate A, Coordinate B, Coordinate C, Coordinate D) {
        if (A.equals(B)) {
            return CGAlgorithms.distancePointLine(A, C, D);
        }
        if (C.equals(D)) {
            return CGAlgorithms.distancePointLine(D, A, B);
        }
        boolean noIntersection = false;
        if (!Envelope.intersects(A, B, C, D)) {
            noIntersection = true;
        } else {
            double denom = (B.x - A.x) * (D.y - C.y) - (B.y - A.y) * (D.x - C.x);
            if (denom == 0.0) {
                noIntersection = true;
            } else {
                double r_num = (A.y - C.y) * (D.x - C.x) - (A.x - C.x) * (D.y - C.y);
                double s_num = (A.y - C.y) * (B.x - A.x) - (A.x - C.x) * (B.y - A.y);
                double s = s_num / denom;
                double r = r_num / denom;
                if (r < 0.0 || r > 1.0 || s < 0.0 || s > 1.0) {
                    noIntersection = true;
                }
            }
        }
        if (noIntersection) {
            return MathUtil.min(CGAlgorithms.distancePointLine(A, C, D), CGAlgorithms.distancePointLine(B, C, D), CGAlgorithms.distancePointLine(C, A, B), CGAlgorithms.distancePointLine(D, A, B));
        }
        return 0.0;
    }

    public static double signedArea(Coordinate[] ring) {
        if (ring.length < 3) {
            return 0.0;
        }
        double sum = 0.0;
        double x0 = ring[0].x;
        int i = 1;
        while (i < ring.length - 1) {
            double x = ring[i].x - x0;
            double y1 = ring[i + 1].y;
            double y2 = ring[i - 1].y;
            sum += x * (y2 - y1);
            ++i;
        }
        return sum / 2.0;
    }

    public static double signedArea(CoordinateSequence ring) {
        int n = ring.size();
        if (n < 3) {
            return 0.0;
        }
        Coordinate p0 = new Coordinate();
        Coordinate p1 = new Coordinate();
        Coordinate p2 = new Coordinate();
        ring.getCoordinate(0, p1);
        ring.getCoordinate(1, p2);
        double x0 = p1.x;
        p2.x -= x0;
        double sum = 0.0;
        int i = 1;
        while (i < n - 1) {
            p0.y = p1.y;
            p1.x = p2.x;
            p1.y = p2.y;
            ring.getCoordinate(i + 1, p2);
            p2.x -= x0;
            sum += p1.x * (p0.y - p2.y);
            ++i;
        }
        return sum / 2.0;
    }

    public static double length(CoordinateSequence pts) {
        int n = pts.size();
        if (n <= 1) {
            return 0.0;
        }
        double len = 0.0;
        Coordinate p = new Coordinate();
        pts.getCoordinate(0, p);
        double x0 = p.x;
        double y0 = p.y;
        int i = 1;
        while (i < n) {
            pts.getCoordinate(i, p);
            double x1 = p.x;
            double y1 = p.y;
            double dx = x1 - x0;
            double dy = y1 - y0;
            len += Math.sqrt(dx * dx + dy * dy);
            x0 = x1;
            y0 = y1;
            ++i;
        }
        return len;
    }
}

