/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.jobs.mapreduce;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureWriter;
import org.geotools.filter.identity.FeatureIdImpl;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.GeoMesaIndexManager;
import org.locationtech.geomesa.index.api.WrappedFeature;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureWriter;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaOutputFormat$Counters$;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.locationtech.geomesa.utils.index.IndexMode$;
import org.locationtech.geomesa.utils.io.CloseQuietly$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\u0001\u0003\u00015\u00111cR3p\u001b\u0016\u001c\u0018MU3d_J$wK]5uKJT!a\u0001\u0003\u0002\u00135\f\u0007O]3ek\u000e,'BA\u0003\u0007\u0003\u0011QwNY:\u000b\u0005\u001dA\u0011aB4f_6,7/\u0019\u0006\u0003\u0013)\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011aC\u0001\u0004_J<7\u0001A\u000b\u0005\u001dykwoE\u0002\u0001\u001f!\u0002B\u0001\u0005\f\u0019=5\t\u0011C\u0003\u0002\u0004%)\u00111\u0003F\u0001\u0007Q\u0006$wn\u001c9\u000b\u0005UQ\u0011AB1qC\u000eDW-\u0003\u0002\u0018#\ta!+Z2pe\u0012<&/\u001b;feB\u0011\u0011\u0004H\u0007\u00025)\u00111DE\u0001\u0003S>L!!\b\u000e\u0003\tQ+\u0007\u0010\u001e\t\u0003?\u0019j\u0011\u0001\t\u0006\u0003C\t\naa]5na2,'BA\u0012%\u0003\u001d1W-\u0019;ve\u0016T!!\n\u0006\u0002\u000f=\u0004XM\\4jg&\u0011q\u0005\t\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\u0011\u0005%\u0002T\"\u0001\u0016\u000b\u0005-b\u0013\u0001D:dC2\fGn\\4hS:<'BA\u0017/\u0003!!\u0018\u0010]3tC\u001a,'\"A\u0018\u0002\u0007\r|W.\u0003\u00022U\tYA*\u0019>z\u0019><w-\u001b8h\u0011!\u0019\u0004A!A!\u0002\u0013!\u0014A\u00029be\u0006l7\u000f\u0005\u00036wyrdB\u0001\u001c:\u001b\u00059$\"\u0001\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005i:\u0014A\u0002)sK\u0012,g-\u0003\u0002={\t\u0019Q*\u00199\u000b\u0005i:\u0004CA\u001b@\u0013\t\u0001UH\u0001\u0004TiJLgn\u001a\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\u00069\u0011N\u001c3jG\u0016\u001c\bc\u0001\u001cE\r&\u0011Qi\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007\u001d{eH\u0004\u0002I\u001b:\u0011\u0011\nT\u0007\u0002\u0015*\u00111\nD\u0001\u0007yI|w\u000e\u001e \n\u0003aJ!AT\u001c\u0002\u000fA\f7m[1hK&\u0011\u0001+\u0015\u0002\u0004'\u0016\f(B\u0001(8\u0011!\u0019\u0006A!A!\u0002\u0013!\u0016aB2p]R,\u0007\u0010\u001e\t\u0003!UK!AV\t\u0003%Q\u000b7o[!ui\u0016l\u0007\u000f^\"p]R,\u0007\u0010\u001e\u0005\u00061\u0002!\t!W\u0001\u0007y%t\u0017\u000e\u001e \u0015\tikhp \t\u00067\u0002aFN^\u0007\u0002\u0005A\u0011QL\u0018\u0007\u0001\t\u0015y\u0006A1\u0001a\u0005\t!5+\u0005\u0002bIB\u0011aGY\u0005\u0003G^\u0012qAT8uQ&tw\rE\u0003fUrcg/D\u0001g\u0015\t9\u0007.\u0001\u0005hK>$xn\u001c7t\u0015\tIg!A\u0003j]\u0012,\u00070\u0003\u0002lM\n\u0001r)Z8NKN\fG)\u0019;b'R|'/\u001a\t\u0003;6$QA\u001c\u0001C\u0002=\u0014\u0011AR\t\u0003CB\u0004\"!\u001d;\u000e\u0003IT!a\u001d5\u0002\u0007\u0005\u0004\u0018.\u0003\u0002ve\nqqK]1qa\u0016$g)Z1ukJ,\u0007CA/x\t\u0015A\bA1\u0001z\u0005\u00059\u0016CA1{!\t140\u0003\u0002}o\t\u0019\u0011I\\=\t\u000bM:\u0006\u0019\u0001\u001b\t\u000b\t;\u0006\u0019A\"\t\u000bM;\u0006\u0019\u0001+\t\u0013\u0005\r\u0001A1A\u0005\u0002\u0005\u0015\u0011A\u00013t+\u0005!\u0007bBA\u0005\u0001\u0001\u0006I\u0001Z\u0001\u0004IN\u0004\u0003\"CA\u0007\u0001\t\u0007I\u0011AA\b\u0003!\u0019h\r^\"bG\",WCAA\t!\u001d\t\u0019\"!\b?\u0003?i!!!\u0006\u000b\t\u0005]\u0011\u0011D\u0001\b[V$\u0018M\u00197f\u0015\r\tYbN\u0001\u000bG>dG.Z2uS>t\u0017b\u0001\u001f\u0002\u0016A\u0019q$!\t\n\u0007\u0005\r\u0002EA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016D\u0001\"a\n\u0001A\u0003%\u0011\u0011C\u0001\ng\u001a$8)Y2iK\u0002B\u0011\"a\u000b\u0001\u0005\u0004%\t!!\f\u0002\u0017]\u0014\u0018\u000e^3s\u0007\u0006\u001c\u0007.Z\u000b\u0003\u0003_\u0001r!a\u0005\u0002\u001ey\n\t\u0004\u0005\u0003\u00024\u0005uRBAA\u001b\u0015\r\t\u0013q\u0007\u0006\u0005\u0003s\tY$\u0001\u0003eCR\f'BA4\u000b\u0013\u0011\ty$!\u000e\u0003'MKW\u000e\u001d7f\r\u0016\fG/\u001e:f/JLG/\u001a:\t\u0011\u0005\r\u0003\u0001)A\u0005\u0003_\tAb\u001e:ji\u0016\u00148)Y2iK\u0002B\u0011\"a\u0012\u0001\u0005\u0004%\t!!\u0013\u0002\u000f]\u0014\u0018\u000e\u001e;f]V\u0011\u00111\n\t\u0004!\u00055\u0013bAA(#\t91i\\;oi\u0016\u0014\b\u0002CA*\u0001\u0001\u0006I!a\u0013\u0002\u0011]\u0014\u0018\u000e\u001e;f]\u0002B\u0011\"a\u0016\u0001\u0005\u0004%\t!!\u0013\u0002\r\u0019\f\u0017\u000e\\3e\u0011!\tY\u0006\u0001Q\u0001\n\u0005-\u0013a\u00024bS2,G\r\t\u0005\b\u0003?\u0002A\u0011IA1\u0003\u00159(/\u001b;f)\u0019\t\u0019'!\u001b\u0002nA\u0019a'!\u001a\n\u0007\u0005\u001dtG\u0001\u0003V]&$\bbBA6\u0003;\u0002\r\u0001G\u0001\u0004W\u0016L\bbBA8\u0003;\u0002\rAH\u0001\u0006m\u0006dW/\u001a\u0005\b\u0003g\u0002A\u0011IA;\u0003\u0015\u0019Gn\\:f)\u0011\t\u0019'a\u001e\t\rM\u000b\t\b1\u0001U\u0001")
public class GeoMesaRecordWriter<DS extends GeoMesaDataStore<DS, F, W>, F extends WrappedFeature, W>
extends RecordWriter<Text, SimpleFeature>
implements LazyLogging {
    public final Option<Seq<String>> org$locationtech$geomesa$jobs$mapreduce$GeoMesaRecordWriter$$indices;
    private final GeoMesaDataStore<DS, F, W> ds;
    private final Map<String, SimpleFeatureType> sftCache;
    private final Map<String, SimpleFeatureWriter> writerCache;
    private final Counter written;
    private final Counter failed;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        GeoMesaRecordWriter geoMesaRecordWriter = this;
        synchronized (geoMesaRecordWriter) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public GeoMesaDataStore<DS, F, W> ds() {
        return this.ds;
    }

    public Map<String, SimpleFeatureType> sftCache() {
        return this.sftCache;
    }

    public Map<String, SimpleFeatureWriter> writerCache() {
        return this.writerCache;
    }

    public Counter written() {
        return this.written;
    }

    public Counter failed() {
        return this.failed;
    }

    public void write(Text key, SimpleFeature value) {
        String sftName = value.getFeatureType().getTypeName();
        SimpleFeatureType sft = (SimpleFeatureType)this.sftCache().getOrElseUpdate((Object)sftName, (Function0)new Serializable(this, value, sftName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoMesaRecordWriter $outer;
            private final SimpleFeature value$1;
            private final String sftName$1;

            public final SimpleFeatureType apply() {
                SimpleFeatureType simpleFeatureType;
                SimpleFeatureType existing = this.$outer.ds().getSchema(this.sftName$1);
                if (existing == null) {
                    this.$outer.ds().createSchema(this.value$1.getFeatureType());
                    simpleFeatureType = this.$outer.ds().getSchema(this.sftName$1);
                } else {
                    simpleFeatureType = existing;
                }
                return simpleFeatureType;
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.value$1 = value$1;
                this.sftName$1 = var3_3;
            }
        });
        SimpleFeatureWriter writer = (SimpleFeatureWriter)this.writerCache().getOrElseUpdate((Object)sftName, (Function0)new Serializable(this, sftName, sft){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoMesaRecordWriter $outer;
            private final String sftName$1;
            private final SimpleFeatureType sft$1;

            public final GeoMesaFeatureWriter.FlushableFeatureWriter apply() {
                Option<Seq<String>> option;
                block4: {
                    Seq seq;
                    block3: {
                        block2: {
                            option = this.$outer.org$locationtech$geomesa$jobs$mapreduce$GeoMesaRecordWriter$$indices;
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            Seq names = (Seq)some.x();
                            GeoMesaIndexManager geoMesaIndexManager = this.$outer.ds().manager();
                            seq = (Seq)names.map((Function1)new Serializable(this, geoMesaIndexManager){
                                public static final long serialVersionUID = 0L;
                                private final GeoMesaIndexManager eta$0$1$1;

                                public final GeoMesaFeatureIndex<DS, F, W> apply(String identifier) {
                                    return this.eta$0$1$1.index(identifier);
                                }
                                {
                                    this.eta$0$1$1 = eta$0$1$1;
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        GeoMesaIndexManager qual$1 = this.$outer.ds().manager();
                        SimpleFeatureType x$2 = this.sft$1;
                        IndexMode.IndexMode x$3 = IndexMode$.MODULE$.Write();
                        Option x$4 = qual$1.indices$default$2();
                        seq = qual$1.indices(x$2, x$4, x$3);
                    }
                    Seq i = seq;
                    return this.$outer.ds().getIndexWriterAppend(this.sftName$1, i);
                }
                throw new MatchError(option);
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sftName$1 = sftName$1;
                this.sft$1 = var3_3;
            }
        });
        try {
            SimpleFeature next = (SimpleFeature)writer.next();
            ((FeatureIdImpl)next.getIdentifier()).setID(value.getID());
            next.setAttributes(value.getAttributes());
            next.getUserData().putAll(value.getUserData());
            writer.write();
            this.written().increment(1L);
        }
        catch (Exception exception) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error writing feature '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataUtilities.encodeFeature((SimpleFeature)value)})), (Throwable)exception);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.failed().increment(1L);
        }
    }

    public void close(TaskAttemptContext context) {
        this.writerCache().values().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<Throwable> apply(SimpleFeatureWriter v) {
                return CloseQuietly$.MODULE$.apply((Object)v);
            }
        });
        this.ds().dispose();
    }

    public GeoMesaRecordWriter(scala.collection.immutable.Map<String, String> params, Option<Seq<String>> indices, TaskAttemptContext context) {
        this.org$locationtech$geomesa$jobs$mapreduce$GeoMesaRecordWriter$$indices = indices;
        LazyLogging.class.$init$((LazyLogging)this);
        this.ds = (GeoMesaDataStore)DataStoreFinder.getDataStore((java.util.Map)JavaConversions$.MODULE$.mapAsJavaMap(params));
        this.sftCache = Map$.MODULE$.empty();
        this.writerCache = Map$.MODULE$.empty();
        this.written = context.getCounter(GeoMesaOutputFormat$Counters$.MODULE$.Group(), GeoMesaOutputFormat$Counters$.MODULE$.Written());
        this.failed = context.getCounter(GeoMesaOutputFormat$Counters$.MODULE$.Group(), GeoMesaOutputFormat$Counters$.MODULE$.Failed());
    }
}

