/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.object;

import org.geotools.temporal.object.DefaultTemporalObject;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Period;
import org.opengis.temporal.RelativePosition;
import org.opengis.temporal.TemporalOrder;
import org.opengis.temporal.TemporalPrimitive;

public abstract class DefaultTemporalPrimitive
extends DefaultTemporalObject
implements TemporalPrimitive,
TemporalOrder,
Comparable<TemporalPrimitive> {
    @Override
    public int compareTo(TemporalPrimitive that) {
        if (that == null) {
            throw new IllegalArgumentException("Provided temporal object is null");
        }
        RelativePosition pos = this.relativePosition(that);
        if (pos == null) {
            throw new ClassCastException("The provided object cannot be compared to this one");
        }
        if (pos == RelativePosition.BEFORE) {
            return -1;
        }
        if (pos == RelativePosition.AFTER) {
            return 1;
        }
        if (pos == RelativePosition.EQUALS) {
            return 0;
        }
        if ((this instanceof Period && that instanceof Instant || this instanceof Instant && that instanceof Period) && (pos == RelativePosition.ENDED_BY || pos == RelativePosition.BEGUN_BY || pos == RelativePosition.CONTAINS)) {
            return 0;
        }
        if (this instanceof Period && that instanceof Period) {
            if (pos == RelativePosition.MEETS) {
                return -1;
            }
            if (pos == RelativePosition.BEGINS) {
                return -1;
            }
            if (pos == RelativePosition.BEGUN_BY) {
                return 1;
            }
            if (pos == RelativePosition.ENDS) {
                return 1;
            }
            if (pos == RelativePosition.ENDED_BY) {
                return -1;
            }
            if (pos == RelativePosition.OVERLAPS) {
                return -1;
            }
            if (pos == RelativePosition.OVERLAPPED_BY) {
                return 1;
            }
            if (pos == RelativePosition.DURING || pos == RelativePosition.CONTAINS || pos == RelativePosition.EQUALS) {
                return 0;
            }
        }
        throw new IllegalStateException("Unable to compare the provided object with this one");
    }

    public RelativePosition relativePosition(TemporalPrimitive other) {
        if (this instanceof Instant && other instanceof Instant) {
            Instant timeobject = (Instant)this;
            Instant instantOther = (Instant)other;
            if (timeobject.getPosition().getDate().before(instantOther.getPosition().getDate())) {
                return RelativePosition.BEFORE;
            }
            return timeobject.getPosition().getDate().compareTo(instantOther.getPosition().getDate()) == 0 ? RelativePosition.EQUALS : RelativePosition.AFTER;
        }
        if (this instanceof Period && other instanceof Instant) {
            Period timeobject = (Period)this;
            Instant instantarg = (Instant)other;
            if (timeobject.getEnding().getPosition().getDate().before(instantarg.getPosition().getDate())) {
                return RelativePosition.BEFORE;
            }
            if (timeobject.getEnding().getPosition().getDate().compareTo(instantarg.getPosition().getDate()) == 0) {
                return RelativePosition.ENDED_BY;
            }
            if (timeobject.getBeginning().getPosition().getDate().before(instantarg.getPosition().getDate()) && timeobject.getEnding().getPosition().getDate().after(instantarg.getPosition().getDate())) {
                return RelativePosition.CONTAINS;
            }
            return timeobject.getBeginning().getPosition().getDate().compareTo(instantarg.getPosition().getDate()) == 0 ? RelativePosition.BEGUN_BY : RelativePosition.AFTER;
        }
        if (this instanceof Instant && other instanceof Period) {
            Instant timeobject = (Instant)this;
            Period instantarg = (Period)other;
            if (instantarg.getEnding().getPosition().getDate().before(timeobject.getPosition().getDate())) {
                return RelativePosition.AFTER;
            }
            if (instantarg.getEnding().getPosition().getDate().compareTo(timeobject.getPosition().getDate()) == 0) {
                return RelativePosition.ENDS;
            }
            if (instantarg.getBeginning().getPosition().getDate().before(timeobject.getPosition().getDate()) && instantarg.getEnding().getPosition().getDate().after(timeobject.getPosition().getDate())) {
                return RelativePosition.DURING;
            }
            return instantarg.getBeginning().getPosition().getDate().compareTo(timeobject.getPosition().getDate()) == 0 ? RelativePosition.BEGINS : RelativePosition.BEFORE;
        }
        if (this instanceof Period && other instanceof Period) {
            Period timeobject = (Period)this;
            Period instantarg = (Period)other;
            if (timeobject.getEnding().getPosition().getDate().before(instantarg.getBeginning().getPosition().getDate())) {
                return RelativePosition.BEFORE;
            }
            if (timeobject.getEnding().getPosition().getDate().compareTo(instantarg.getBeginning().getPosition().getDate()) == 0) {
                return RelativePosition.MEETS;
            }
            if (timeobject.getBeginning().getPosition().getDate().before(instantarg.getBeginning().getPosition().getDate()) && timeobject.getEnding().getPosition().getDate().after(instantarg.getBeginning().getPosition().getDate()) && timeobject.getEnding().getPosition().getDate().before(instantarg.getEnding().getPosition().getDate())) {
                return RelativePosition.OVERLAPS;
            }
            if (timeobject.getBeginning().getPosition().getDate().compareTo(instantarg.getBeginning().getPosition().getDate()) == 0 && timeobject.getEnding().getPosition().getDate().before(instantarg.getEnding().getPosition().getDate())) {
                return RelativePosition.BEGINS;
            }
            if (timeobject.getBeginning().getPosition().getDate().compareTo(instantarg.getBeginning().getPosition().getDate()) == 0 && timeobject.getEnding().getPosition().getDate().after(instantarg.getEnding().getPosition().getDate())) {
                return RelativePosition.BEGUN_BY;
            }
            if (timeobject.getBeginning().getPosition().getDate().after(instantarg.getBeginning().getPosition().getDate()) && timeobject.getEnding().getPosition().getDate().before(instantarg.getEnding().getPosition().getDate())) {
                return RelativePosition.DURING;
            }
            if (timeobject.getBeginning().getPosition().getDate().before(instantarg.getBeginning().getPosition().getDate()) && timeobject.getEnding().getPosition().getDate().after(instantarg.getEnding().getPosition().getDate())) {
                return RelativePosition.CONTAINS;
            }
            if (timeobject.getBeginning().getPosition().getDate().compareTo(instantarg.getBeginning().getPosition().getDate()) == 0 && timeobject.getEnding().getPosition().getDate().compareTo(instantarg.getEnding().getPosition().getDate()) == 0) {
                return RelativePosition.EQUALS;
            }
            if (timeobject.getBeginning().getPosition().getDate().after(instantarg.getBeginning().getPosition().getDate()) && timeobject.getBeginning().getPosition().getDate().before(instantarg.getEnding().getPosition().getDate()) && timeobject.getEnding().getPosition().getDate().after(instantarg.getEnding().getPosition().getDate())) {
                return RelativePosition.OVERLAPPED_BY;
            }
            if (timeobject.getBeginning().getPosition().getDate().after(instantarg.getBeginning().getPosition().getDate()) && timeobject.getEnding().getPosition().getDate().compareTo(instantarg.getEnding().getPosition().getDate()) == 0) {
                return RelativePosition.ENDS;
            }
            if (timeobject.getBeginning().getPosition().getDate().before(instantarg.getBeginning().getPosition().getDate()) && timeobject.getEnding().getPosition().getDate().compareTo(instantarg.getEnding().getPosition().getDate()) == 0) {
                return RelativePosition.ENDED_BY;
            }
            return timeobject.getBeginning().getPosition().getDate().compareTo(instantarg.getEnding().getPosition().getDate()) == 0 ? RelativePosition.MET_BY : RelativePosition.AFTER;
        }
        return null;
    }
}

