/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.stats;

import com.clearspring.analytics.stream.frequency.IFrequency;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.util.Date;
import java.util.Locale;
import org.locationtech.geomesa.curve.Z2SFC$;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.Conversions$RichGeometry$;
import org.locationtech.geomesa.utils.stats.Frequency$;
import org.locationtech.sfcurve.IndexRange;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class Frequency$ {
    public static final Frequency$ MODULE$;
    private final int Seed;
    private final short DefaultTimeBin;

    static {
        new Frequency$();
    }

    public int Seed() {
        return this.Seed;
    }

    public short DefaultTimeBin() {
        return this.DefaultTimeBin;
    }

    public Iterator<Object> enumerate(Seq<IndexRange> ranges, long precision) {
        long shift2 = 64L - precision;
        return ranges.toIterator().flatMap((Function1)new Serializable(shift2){
            public static final long serialVersionUID = 0L;
            public final long shift$1;

            public final Object apply(IndexRange r) {
                long c = (r.upper() >> (int)this.shift$1) - (r.lower() >> (int)this.shift$1);
                return new Iterator<Object>(this, c, r){
                    private long i;
                    private final /* synthetic */ anonfun.enumerate.1 $outer;
                    private final long c$1;
                    private final IndexRange r$1;

                    public Iterator<Object> seq() {
                        return Iterator.class.seq((Iterator)this);
                    }

                    public boolean isEmpty() {
                        return Iterator.class.isEmpty((Iterator)this);
                    }

                    public boolean isTraversableAgain() {
                        return Iterator.class.isTraversableAgain((Iterator)this);
                    }

                    public boolean hasDefiniteSize() {
                        return Iterator.class.hasDefiniteSize((Iterator)this);
                    }

                    public Iterator<Object> take(int n) {
                        return Iterator.class.take((Iterator)this, (int)n);
                    }

                    public Iterator<Object> drop(int n) {
                        return Iterator.class.drop((Iterator)this, (int)n);
                    }

                    public Iterator<Object> slice(int from, int until) {
                        return Iterator.class.slice((Iterator)this, (int)from, (int)until);
                    }

                    public <B> Iterator<B> map(Function1<Object, B> f) {
                        return Iterator.class.map((Iterator)this, f);
                    }

                    public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                        return Iterator.class.$plus$plus((Iterator)this, that);
                    }

                    public <B> Iterator<B> flatMap(Function1<Object, GenTraversableOnce<B>> f) {
                        return Iterator.class.flatMap((Iterator)this, f);
                    }

                    public Iterator<Object> filter(Function1<Object, Object> p) {
                        return Iterator.class.filter((Iterator)this, p);
                    }

                    public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Object, B, Object> p) {
                        return Iterator.class.corresponds((Iterator)this, that, p);
                    }

                    public Iterator<Object> withFilter(Function1<Object, Object> p) {
                        return Iterator.class.withFilter((Iterator)this, p);
                    }

                    public Iterator<Object> filterNot(Function1<Object, Object> p) {
                        return Iterator.class.filterNot((Iterator)this, p);
                    }

                    public <B> Iterator<B> collect(PartialFunction<Object, B> pf) {
                        return Iterator.class.collect((Iterator)this, pf);
                    }

                    public <B> Iterator<B> scanLeft(B z, Function2<B, Object, B> op) {
                        return Iterator.class.scanLeft((Iterator)this, z, op);
                    }

                    public <B> Iterator<B> scanRight(B z, Function2<Object, B, B> op) {
                        return Iterator.class.scanRight((Iterator)this, z, op);
                    }

                    public Iterator<Object> takeWhile(Function1<Object, Object> p) {
                        return Iterator.class.takeWhile((Iterator)this, p);
                    }

                    public Tuple2<Iterator<Object>, Iterator<Object>> partition(Function1<Object, Object> p) {
                        return Iterator.class.partition((Iterator)this, p);
                    }

                    public Tuple2<Iterator<Object>, Iterator<Object>> span(Function1<Object, Object> p) {
                        return Iterator.class.span((Iterator)this, p);
                    }

                    public Iterator<Object> dropWhile(Function1<Object, Object> p) {
                        return Iterator.class.dropWhile((Iterator)this, p);
                    }

                    public <B> Iterator<Tuple2<Object, B>> zip(Iterator<B> that) {
                        return Iterator.class.zip((Iterator)this, that);
                    }

                    public <A1> Iterator<A1> padTo(int len, A1 elem) {
                        return Iterator.class.padTo((Iterator)this, (int)len, elem);
                    }

                    public Iterator<Tuple2<Object, Object>> zipWithIndex() {
                        return Iterator.class.zipWithIndex((Iterator)this);
                    }

                    public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                        return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
                    }

                    public <U> void foreach(Function1<Object, U> f) {
                        Iterator.class.foreach((Iterator)this, f);
                    }

                    public boolean forall(Function1<Object, Object> p) {
                        return Iterator.class.forall((Iterator)this, p);
                    }

                    public boolean exists(Function1<Object, Object> p) {
                        return Iterator.class.exists((Iterator)this, p);
                    }

                    public boolean contains(Object elem) {
                        return Iterator.class.contains((Iterator)this, (Object)elem);
                    }

                    public Option<Object> find(Function1<Object, Object> p) {
                        return Iterator.class.find((Iterator)this, p);
                    }

                    public int indexWhere(Function1<Object, Object> p) {
                        return Iterator.class.indexWhere((Iterator)this, p);
                    }

                    public <B> int indexOf(B elem) {
                        return Iterator.class.indexOf((Iterator)this, elem);
                    }

                    public BufferedIterator<Object> buffered() {
                        return Iterator.class.buffered((Iterator)this);
                    }

                    public <B> Iterator.GroupedIterator<B> grouped(int size2) {
                        return Iterator.class.grouped((Iterator)this, (int)size2);
                    }

                    public <B> Iterator.GroupedIterator<B> sliding(int size2, int step) {
                        return Iterator.class.sliding((Iterator)this, (int)size2, (int)step);
                    }

                    public int length() {
                        return Iterator.class.length((Iterator)this);
                    }

                    public Tuple2<Iterator<Object>, Iterator<Object>> duplicate() {
                        return Iterator.class.duplicate((Iterator)this);
                    }

                    public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                        return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
                    }

                    public <B> void copyToArray(Object xs, int start, int len) {
                        Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
                    }

                    public boolean sameElements(Iterator<?> that) {
                        return Iterator.class.sameElements((Iterator)this, that);
                    }

                    public Traversable<Object> toTraversable() {
                        return Iterator.class.toTraversable((Iterator)this);
                    }

                    public Iterator<Object> toIterator() {
                        return Iterator.class.toIterator((Iterator)this);
                    }

                    public Stream<Object> toStream() {
                        return Iterator.class.toStream((Iterator)this);
                    }

                    public String toString() {
                        return Iterator.class.toString((Iterator)this);
                    }

                    public <B> int sliding$default$2() {
                        return Iterator.class.sliding$default$2((Iterator)this);
                    }

                    public List<Object> reversed() {
                        return TraversableOnce.class.reversed((TraversableOnce)this);
                    }

                    public int size() {
                        return TraversableOnce.class.size((TraversableOnce)this);
                    }

                    public boolean nonEmpty() {
                        return TraversableOnce.class.nonEmpty((TraversableOnce)this);
                    }

                    public int count(Function1<Object, Object> p) {
                        return TraversableOnce.class.count((TraversableOnce)this, p);
                    }

                    public <B> Option<B> collectFirst(PartialFunction<Object, B> pf) {
                        return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
                    }

                    public <B> B $div$colon(B z, Function2<B, Object, B> op) {
                        return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
                    }

                    public <B> B $colon$bslash(B z, Function2<Object, B, B> op) {
                        return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
                    }

                    public <B> B foldLeft(B z, Function2<B, Object, B> op) {
                        return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
                    }

                    public <B> B foldRight(B z, Function2<Object, B, B> op) {
                        return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
                    }

                    public <B> B reduceLeft(Function2<B, Object, B> op) {
                        return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
                    }

                    public <B> B reduceRight(Function2<Object, B, B> op) {
                        return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceLeftOption(Function2<B, Object, B> op) {
                        return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceRightOption(Function2<Object, B, B> op) {
                        return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
                    }

                    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
                    }

                    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                        return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
                    }

                    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
                    }

                    public <B> B aggregate(Function0<B> z, Function2<B, Object, B> seqop, Function2<B, B, B> combop) {
                        return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
                    }

                    public <B> B sum(Numeric<B> num) {
                        return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
                    }

                    public <B> B product(Numeric<B> num) {
                        return (B)TraversableOnce.class.product((TraversableOnce)this, num);
                    }

                    public Object min(Ordering cmp) {
                        return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object max(Ordering cmp) {
                        return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object maxBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public Object minBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public <B> void copyToBuffer(Buffer<B> dest) {
                        TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
                    }

                    public <B> void copyToArray(Object xs, int start) {
                        TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
                    }

                    public <B> void copyToArray(Object xs) {
                        TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
                    }

                    public <B> Object toArray(ClassTag<B> evidence$1) {
                        return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
                    }

                    public List<Object> toList() {
                        return TraversableOnce.class.toList((TraversableOnce)this);
                    }

                    public Iterable<Object> toIterable() {
                        return TraversableOnce.class.toIterable((TraversableOnce)this);
                    }

                    public Seq<Object> toSeq() {
                        return TraversableOnce.class.toSeq((TraversableOnce)this);
                    }

                    public IndexedSeq<Object> toIndexedSeq() {
                        return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
                    }

                    public <B> Buffer<B> toBuffer() {
                        return TraversableOnce.class.toBuffer((TraversableOnce)this);
                    }

                    public <B> Set<B> toSet() {
                        return TraversableOnce.class.toSet((TraversableOnce)this);
                    }

                    public Vector<Object> toVector() {
                        return TraversableOnce.class.toVector((TraversableOnce)this);
                    }

                    public <Col> Col to(CanBuildFrom<Nothing$, Object, Col> cbf) {
                        return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
                    }

                    public <T, U> Map<T, U> toMap(Predef.$less$colon$less<Object, Tuple2<T, U>> ev) {
                        return TraversableOnce.class.toMap((TraversableOnce)this, ev);
                    }

                    public String mkString(String start, String sep, String end) {
                        return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
                    }

                    public String mkString(String sep) {
                        return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
                    }

                    public String mkString() {
                        return TraversableOnce.class.mkString((TraversableOnce)this);
                    }

                    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                    }

                    public StringBuilder addString(StringBuilder b, String sep) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
                    }

                    public StringBuilder addString(StringBuilder b) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
                    }

                    private long i() {
                        return this.i;
                    }

                    private void i_$eq(long x$1) {
                        this.i = x$1;
                    }

                    public boolean hasNext() {
                        return this.i() <= this.c$1;
                    }

                    public long next() {
                        try {
                            return this.r$1.lower() + (this.i() << (int)this.$outer.shift$1);
                        }
                        finally {
                            this.i_$eq(this.i() + 1L);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.c$1 = c$1;
                        this.r$1 = r$1;
                        TraversableOnce.class.$init$((TraversableOnce)this);
                        Iterator.class.$init$((Iterator)this);
                        this.i = 0L;
                    }
                };
            }
            {
                this.shift$1 = shift$1;
            }
        });
    }

    public <T> Function2<IFrequency, T, BoxedUnit> org$locationtech$geomesa$utils$stats$Frequency$$add(Class<T> clas, int precision) {
        block9: {
            Object object;
            block3: {
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        if (!Geometry.class.isAssignableFrom(clas)) break block2;
                                        long mask = this.getMask(precision);
                                        object = new Serializable(mask){
                                            public static final long serialVersionUID = 0L;
                                            private final long mask$1;

                                            public final void apply(IFrequency sketch, T value2) {
                                                sketch.add(Frequency$.MODULE$.geomToKey((Geometry)value2, this.mask$1), 1L);
                                            }
                                            {
                                                this.mask$1 = mask$1;
                                            }
                                        };
                                        break block3;
                                    }
                                    if (!Date.class.isAssignableFrom(clas)) break block4;
                                    object = new Serializable(precision){
                                        public static final long serialVersionUID = 0L;
                                        private final int precision$1;

                                        public final void apply(IFrequency sketch, T value2) {
                                            sketch.add(Frequency$.MODULE$.dateToKey((Date)value2, this.precision$1), 1L);
                                        }
                                        {
                                            this.precision$1 = precision$1;
                                        }
                                    };
                                    break block3;
                                }
                                Class<T> clazz = clas;
                                Class<String> clazz2 = String.class;
                                if (clazz != null ? !clazz.equals(clazz2) : clazz2 != null) break block5;
                                object = new Serializable(precision){
                                    public static final long serialVersionUID = 0L;
                                    private final int precision$1;

                                    public final void apply(IFrequency sketch, T value2) {
                                        sketch.add(Frequency$.MODULE$.stringToKey((String)value2, this.precision$1), 1L);
                                    }
                                    {
                                        this.precision$1 = precision$1;
                                    }
                                };
                                break block3;
                            }
                            Class<T> clazz = clas;
                            Class<Long> clazz3 = Long.class;
                            if (clazz != null ? !clazz.equals(clazz3) : clazz3 != null) break block6;
                            object = new Serializable(precision){
                                public static final long serialVersionUID = 0L;
                                private final int precision$1;

                                public final void apply(IFrequency sketch, T value2) {
                                    sketch.add(Frequency$.MODULE$.longToKey(BoxesRunTime.unboxToLong(value2), this.precision$1), 1L);
                                }
                                {
                                    this.precision$1 = precision$1;
                                }
                            };
                            break block3;
                        }
                        Class<T> clazz = clas;
                        Class<Integer> clazz4 = Integer.class;
                        if (clazz != null ? !clazz.equals(clazz4) : clazz4 != null) break block7;
                        object = new Serializable(precision){
                            public static final long serialVersionUID = 0L;
                            private final int precision$1;

                            public final void apply(IFrequency sketch, T value2) {
                                sketch.add(Frequency$.MODULE$.intToKey(BoxesRunTime.unboxToInt(value2), this.precision$1), 1L);
                            }
                            {
                                this.precision$1 = precision$1;
                            }
                        };
                        break block3;
                    }
                    Class<T> clazz = clas;
                    Class<Float> clazz5 = Float.class;
                    if (clazz != null ? !clazz.equals(clazz5) : clazz5 != null) break block8;
                    object = new Serializable(precision){
                        public static final long serialVersionUID = 0L;
                        private final int precision$1;

                        public final void apply(IFrequency sketch, T value2) {
                            sketch.add(Frequency$.MODULE$.floatToKey(BoxesRunTime.unboxToFloat(value2), this.precision$1), 1L);
                        }
                        {
                            this.precision$1 = precision$1;
                        }
                    };
                    break block3;
                }
                Class<T> clazz = clas;
                Class<Double> clazz6 = Double.class;
                if (clazz != null ? !clazz.equals(clazz6) : clazz6 != null) break block9;
                object = new Serializable(precision){
                    public static final long serialVersionUID = 0L;
                    private final int precision$1;

                    public final void apply(IFrequency sketch, T value2) {
                        sketch.add(Frequency$.MODULE$.doubleToKey(BoxesRunTime.unboxToDouble(value2), this.precision$1), 1L);
                    }
                    {
                        this.precision$1 = precision$1;
                    }
                };
            }
            return object;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No CountMinSketch implementation for class binding ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clas.getName()})));
    }

    public <T> Function2<IFrequency, T, Object> org$locationtech$geomesa$utils$stats$Frequency$$count(Class<T> clas, int precision) {
        block9: {
            Object object;
            block3: {
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        if (!Geometry.class.isAssignableFrom(clas)) break block2;
                                        long mask = this.getMask(precision);
                                        object = new Serializable(mask){
                                            public static final long serialVersionUID = 0L;
                                            private final long mask$2;

                                            public final long apply(IFrequency sketch, T value2) {
                                                return sketch.estimateCount(Frequency$.MODULE$.geomToKey((Geometry)value2, this.mask$2));
                                            }
                                            {
                                                this.mask$2 = mask$2;
                                            }
                                        };
                                        break block3;
                                    }
                                    if (!Date.class.isAssignableFrom(clas)) break block4;
                                    object = new Serializable(precision){
                                        public static final long serialVersionUID = 0L;
                                        private final int precision$2;

                                        public final long apply(IFrequency sketch, T value2) {
                                            return sketch.estimateCount(Frequency$.MODULE$.dateToKey((Date)value2, this.precision$2));
                                        }
                                        {
                                            this.precision$2 = precision$2;
                                        }
                                    };
                                    break block3;
                                }
                                Class<T> clazz = clas;
                                Class<String> clazz2 = String.class;
                                if (clazz != null ? !clazz.equals(clazz2) : clazz2 != null) break block5;
                                object = new Serializable(precision){
                                    public static final long serialVersionUID = 0L;
                                    private final int precision$2;

                                    public final long apply(IFrequency sketch, T value2) {
                                        return sketch.estimateCount(Frequency$.MODULE$.stringToKey((String)value2, this.precision$2));
                                    }
                                    {
                                        this.precision$2 = precision$2;
                                    }
                                };
                                break block3;
                            }
                            Class<T> clazz = clas;
                            Class<Long> clazz3 = Long.class;
                            if (clazz != null ? !clazz.equals(clazz3) : clazz3 != null) break block6;
                            object = new Serializable(precision){
                                public static final long serialVersionUID = 0L;
                                private final int precision$2;

                                public final long apply(IFrequency sketch, T value2) {
                                    return sketch.estimateCount(Frequency$.MODULE$.longToKey(BoxesRunTime.unboxToLong(value2), this.precision$2));
                                }
                                {
                                    this.precision$2 = precision$2;
                                }
                            };
                            break block3;
                        }
                        Class<T> clazz = clas;
                        Class<Integer> clazz4 = Integer.class;
                        if (clazz != null ? !clazz.equals(clazz4) : clazz4 != null) break block7;
                        object = new Serializable(precision){
                            public static final long serialVersionUID = 0L;
                            private final int precision$2;

                            public final long apply(IFrequency sketch, T value2) {
                                return sketch.estimateCount(Frequency$.MODULE$.intToKey(BoxesRunTime.unboxToInt(value2), this.precision$2));
                            }
                            {
                                this.precision$2 = precision$2;
                            }
                        };
                        break block3;
                    }
                    Class<T> clazz = clas;
                    Class<Float> clazz5 = Float.class;
                    if (clazz != null ? !clazz.equals(clazz5) : clazz5 != null) break block8;
                    object = new Serializable(precision){
                        public static final long serialVersionUID = 0L;
                        private final int precision$2;

                        public final long apply(IFrequency sketch, T value2) {
                            return sketch.estimateCount(Frequency$.MODULE$.floatToKey(BoxesRunTime.unboxToFloat(value2), this.precision$2));
                        }
                        {
                            this.precision$2 = precision$2;
                        }
                    };
                    break block3;
                }
                Class<T> clazz = clas;
                Class<Double> clazz6 = Double.class;
                if (clazz != null ? !clazz.equals(clazz6) : clazz6 != null) break block9;
                object = new Serializable(precision){
                    public static final long serialVersionUID = 0L;
                    private final int precision$2;

                    public final long apply(IFrequency sketch, T value2) {
                        return sketch.estimateCount(Frequency$.MODULE$.doubleToKey(BoxesRunTime.unboxToDouble(value2), this.precision$2));
                    }
                    {
                        this.precision$2 = precision$2;
                    }
                };
            }
            return object;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No CountMinSketch implementation for class binding ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clas.getName()})));
    }

    public long getMask(int precision) {
        Predef$.MODULE$.require(precision >= 0 && precision <= 64, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Precision must be in the range [0, 64]";
            }
        });
        return Long.MAX_VALUE << 64 - precision;
    }

    public long geomToKey(Geometry value2, long mask) {
        Point centroid = Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(value2));
        return Z2SFC$.MODULE$.index(centroid.getX(), centroid.getY(), Z2SFC$.MODULE$.index$default$3()) & mask;
    }

    public String stringToKey(String value2, int precision) {
        return value2.length() > precision ? value2.substring(0, precision).toLowerCase(Locale.US) : value2.toLowerCase(Locale.US);
    }

    public long dateToKey(Date value2, int precision) {
        return value2.getTime() / (long)precision;
    }

    public long longToKey(long value2, int precision) {
        return value2 / (long)precision;
    }

    public long intToKey(int value2, int precision) {
        return value2 / precision;
    }

    public long floatToKey(float value2, int precision) {
        return package$.MODULE$.round(value2 * (float)precision);
    }

    public long doubleToKey(double value2, int precision) {
        return package$.MODULE$.round(value2 * (double)precision);
    }

    public <T> double $lessinit$greater$default$5() {
        return 0.005;
    }

    public <T> double $lessinit$greater$default$6() {
        return 0.95;
    }

    private Frequency$() {
        MODULE$ = this;
        this.Seed = -27;
        this.DefaultTimeBin = 0;
    }
}

