/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert;

import com.typesafe.config.Config;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.ServiceLoader;
import org.locationtech.geomesa.convert.ConverterConfigLoader$;
import org.locationtech.geomesa.convert.SimpleFeatureConverter;
import org.locationtech.geomesa.convert.SimpleFeatureConverterFactory;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypeLoader$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class SimpleFeatureConverters$
implements LazyLogging {
    public static final SimpleFeatureConverters$ MODULE$;
    private final List<SimpleFeatureConverterFactory<?>> providers;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new SimpleFeatureConverters$();
    }

    private Logger logger$lzycompute() {
        SimpleFeatureConverters$ simpleFeatureConverters$ = this;
        synchronized (simpleFeatureConverters$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public List<SimpleFeatureConverterFactory<?>> providers() {
        return this.providers;
    }

    public <I> SimpleFeatureConverter<I> build(String typeName, String converterName) {
        SimpleFeatureType sft = (SimpleFeatureType)SimpleFeatureTypeLoader$.MODULE$.sftForName(typeName).getOrElse((Function0)new Serializable(typeName){
            public static final long serialVersionUID = 0L;
            private final String typeName$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to load SFT for typeName ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.typeName$1})));
            }
            {
                this.typeName$1 = typeName$1;
            }
        });
        return this.build(sft, converterName);
    }

    public <I> SimpleFeatureConverter<I> build(SimpleFeatureType sft, String converterName) {
        return (SimpleFeatureConverter)ConverterConfigLoader$.MODULE$.configForName(converterName).map((Function1)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$2;

            public final SimpleFeatureConverter<I> apply(Config x$2) {
                return SimpleFeatureConverters$.MODULE$.build(this.sft$2, x$2);
            }
            {
                this.sft$2 = sft$2;
            }
        }).getOrElse((Function0)new Serializable(converterName){
            public static final long serialVersionUID = 0L;
            private final String converterName$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find converter config for converterName ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.converterName$1})));
            }
            {
                this.converterName$1 = converterName$1;
            }
        });
    }

    public <I> SimpleFeatureConverter<I> build(SimpleFeatureType sft, Config converterConf) {
        return (SimpleFeatureConverter)this.providers().find((Function1)new Serializable(converterConf){
            public static final long serialVersionUID = 0L;
            private final Config converterConf$1;

            public final boolean apply(SimpleFeatureConverterFactory<?> x$3) {
                return x$3.canProcess(this.converterConf$1);
            }
            {
                this.converterConf$1 = converterConf$1;
            }
        }).map((Function1)new Serializable(sft, converterConf){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;
            private final Config converterConf$1;

            public final SimpleFeatureConverter<I> apply(SimpleFeatureConverterFactory<?> x$4) {
                return x$4.buildConverter(this.sft$1, this.converterConf$1);
            }
            {
                this.sft$1 = sft$1;
                this.converterConf$1 = converterConf$1;
            }
        }).getOrElse((Function0)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find factory for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sft$1.getTypeName()})));
            }
            {
                this.sft$1 = sft$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private SimpleFeatureConverters$() {
        void var1_1;
        BoxedUnit boxedUnit;
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        List pList = JavaConversions$.MODULE$.iterableAsScalaIterable(ServiceLoader.load(SimpleFeatureConverterFactory.class)).toList();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " SPI providers for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)pList.size()), SimpleFeatureConverterFactory.class.getName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)pList.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(SimpleFeatureConverterFactory<?> x$1) {
                    return x$1.getClass().getName();
                }
            }, List$.MODULE$.canBuildFrom())).mkString(", ")}))).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.providers = var1_1;
    }
}

