/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.analytic;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.image.WritableRaster;
import javax.media.jai.RasterFactory;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.vector.BBOXExpandingFilterVisitor;
import org.geotools.process.vector.HeatmapSurface;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.iterators.DensityScan$;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.analytic.DensityProcess$;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.util.ProgressListener;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@DescribeProcess(title="Density Map", description="Computes a density map over a set of features stored in Geomesa")
@ScalaSignature(bytes="\u0006\u0001\u0005%g\u0001B\u0001\u0003\u00015\u0011a\u0002R3og&$\u0018\u0010\u0015:pG\u0016\u001c8O\u0003\u0002\u0004\t\u0005A\u0011M\\1msRL7M\u0003\u0002\u0006\r\u00059\u0001O]8dKN\u001c(BA\u0004\t\u0003\u001d9Wm\\7fg\u0006T!!\u0003\u0006\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0017!\tyA#D\u0001\u0011\u0015\t\t\"#\u0001\u0003mC:<'\"A\n\u0002\t)\fg/Y\u0005\u0003+A\u0011aa\u00142kK\u000e$\bCA\f\u0019\u001b\u0005!\u0011BA\r\u0005\u000599Um\\'fg\u0006\u0004&o\\2fgNDQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000b\u0001\u0002A\u0011A\u0011\u0002\u000f\u0015DXmY;uKRA!\u0005L\"NEFDx\u0010\u0005\u0002$U5\tAE\u0003\u0002&M\u0005!qM]5e\u0015\t9\u0003&\u0001\u0005d_Z,'/Y4f\u0015\tI#\"\u0001\u0005hK>$xn\u001c7t\u0013\tYCE\u0001\bHe&$7i\u001c<fe\u0006<WM\r#\t\u000b5z\u0002\u0019\u0001\u0018\u0002\u0017=\u00147OR3biV\u0014Xm\u001d\t\u0003_Qj\u0011\u0001\r\u0006\u0003cI\naa]5na2,'BA\u001a)\u0003\u0011!\u0017\r^1\n\u0005U\u0002$aF*j[BdWMR3biV\u0014XmQ8mY\u0016\u001cG/[8oQ\u0019asGP A\u0003B\u0011\u0001\bP\u0007\u0002s)\u0011!hO\u0001\bM\u0006\u001cGo\u001c:z\u0015\t)\u0001&\u0003\u0002>s\t\tB)Z:de&\u0014W\rU1sC6,G/\u001a:\u0002\t9\fW.Z\u0011\u0002g\u0005YA-Z:de&\u0004H/[8oC\u0005\u0011\u0015AD%oaV$\bEZ3biV\u0014Xm\u001d\u0005\u0006\t~\u0001\r!R\u0001\u0010CJ<'+\u00193jkN\u0004\u0016\u000e_3mgB\u0011qBR\u0005\u0003\u000fB\u0011q!\u00138uK\u001e,'\u000f\u000b\u0004DoyJ\u0005iS\u0011\u0002\u0015\u0006a!/\u00193jkN\u0004\u0016\u000e_3mg\u0006\nA*\u0001\u0014SC\u0012LWo\u001d\u0011pM\u0002\"\b.\u001a\u0011eK:\u001c\u0018\u000e^=!W\u0016\u0014h.\u001a7!S:\u0004\u0003/\u001b=fYNDQAT\u0010A\u0002=\u000bQ\"\u0019:h/\u0016Lw\r\u001b;BiR\u0014\bC\u0001)W\u001d\t\tF+D\u0001S\u0015\u0005\u0019\u0016!B:dC2\f\u0017BA+S\u0003\u0019\u0001&/\u001a3fM&\u0011q\u000b\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005U\u0013\u0006FC'8}i\u0003ELX0aC\u0006\n1,\u0001\u0006xK&<\u0007\u000e^!uiJ\f\u0013!X\u00013\u001d\u0006lW\rI8gAQDW\rI1uiJL'-\u001e;fAQ|\u0007%^:fA\u0019|'\u000f\t3bi\u0006\u0004\u0003o\\5oi\u0002:X-[4ii\u0006\u0019Q.\u001b8\u001e\u0003\u0001\t1!\\1y;\u0005\t\u0001\"B2 \u0001\u0004!\u0017\u0001D1sO>+H\u000f];u\u000b:4\bCA3k\u001b\u00051'BA4i\u0003\rQGo\u001d\u0006\u0003S\"\n\u0001bZ3p[\u0016$(/_\u0005\u0003W\u001a\u0014!CU3gKJ,gnY3e\u000b:4X\r\\8qK\"2!m\u000e n\u0001>\f\u0013A\\\u0001\u000b_V$\b/\u001e;C\u0005>C\u0016%\u00019\u00025\t{WO\u001c3j]\u001e\u0004#m\u001c=!_\u001a\u0004C\u000f[3!_V$\b/\u001e;\t\u000bI|\u0002\u0019A#\u0002\u001d\u0005\u0014xmT;uaV$x+\u001b3uQ\"2\u0011o\u000e u\u0001Z\f\u0013!^\u0001\f_V$\b/\u001e;XS\u0012$\b.I\u0001x\u0003\u0001:\u0016\u000e\u001a;iA=4\u0007e\\;uaV$\bE]1ti\u0016\u0014\b%\u001b8!a&DX\r\\:\t\u000be|\u0002\u0019A#\u0002\u001f\u0005\u0014xmT;uaV$\b*Z5hQRDc\u0001_\u001c?w\u0002k\u0018%\u0001?\u0002\u0019=,H\u000f];u\u0011\u0016Lw\r\u001b;\"\u0003y\f\u0011\u0005S3jO\"$\be\u001c4!_V$\b/\u001e;!e\u0006\u001cH/\u001a:!S:\u0004\u0003/\u001b=fYNDq!!\u0001 \u0001\u0004\t\u0019!A\u0004n_:LGo\u001c:\u0011\t\u0005\u0015\u0011qB\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u0005!Q\u000f^5m\u0015\r\tiAC\u0001\b_B,gnZ5t\u0013\u0011\t\t\"a\u0002\u0003!A\u0013xn\u001a:fgNd\u0015n\u001d;f]\u0016\u0014\b&C\u0010\u0002\u0016y\nY\u0002QA\u0010!\rA\u0014qC\u0005\u0004\u00033I$A\u0004#fg\u000e\u0014\u0018NY3SKN,H\u000e^\u0011\u0003\u0003;\taA]3tk2$\u0018EAA\u0011\u00035yU\u000f\u001e9vi\u0002\u0012\u0018m\u001d;fe\"*q$!\n\u00024A)\u0011+a\n\u0002,%\u0019\u0011\u0011\u0006*\u0003\rQD'o\\<t!\u0011\ti#a\f\u000e\u0003mJ1!!\r<\u0005A\u0001&o\\2fgN,\u0005pY3qi&|gn\t\u0002\u0002,!9\u0011q\u0007\u0001\u0005\u0002\u0005e\u0012aC5om\u0016\u0014H/U;fef$\u0002#a\u000f\u0002D\u0005-\u0013qJA,\u0003?\n9'a\u001b\u0011\t\u0005u\u0012qH\u0007\u0002e%\u0019\u0011\u0011\t\u001a\u0003\u000bE+XM]=\t\r\u0011\u000b)\u00041\u0001FQ1\t\u0019e\u000e J\u0001\u0006\u001dcl\u00181bC\t\tI%\u0001\u000fSC\u0012LWo\u001d\u0011u_\u0002*8/\u001a\u0011g_J\u0004C\u000f[3!W\u0016\u0014h.\u001a7\t\r9\u000b)\u00041\u0001PQ-\tYe\u000e [\u0001rsv\fY1\t\r\r\f)\u00041\u0001eQ!\tye\u000e n\u0001\u0006M\u0013EAA+\u0003!:Um\u001c:fM\u0016\u0014XM\\2fI\u0002\u0012w.\u001e8eS:<\u0007EY8yA=4\u0007\u0005\u001e5fA=,H\u000f];u\u0011\u0019\u0011\u0018Q\u0007a\u0001\u000b\"B\u0011qK\u001c?i\u0002\u000bY&\t\u0002\u0002^\u0005Qr+\u001b3uQ\u0002zg\r\t;iK\u0002zW\u000f\u001e9vi\u0002\u0012\u0018m\u001d;fe\"1\u00110!\u000eA\u0002\u0015C\u0003\"a\u00188}m\u0004\u00151M\u0011\u0003\u0003K\n1\u0004S3jO\"$\be\u001c4!i\",\u0007e\\;uaV$\bE]1ti\u0016\u0014\b\u0002CA5\u0003k\u0001\r!a\u000f\u0002\u0017Q\f'oZ3u#V,'/\u001f\u0005\t\u0003[\n)\u00041\u0001\u0002p\u0005\u0011B/\u0019:hKR<%/\u001b3HK>lW\r\u001e:z!\u0011\t\t(a\u001e\u000e\u0005\u0005M$bA\u0013\u0002v)\u0019q%a\u0003\n\t\u0005e\u00141\u000f\u0002\r\u000fJLGmR3p[\u0016$(/\u001f\u0015\u0007\u0003k\t)#a\r)\u0015\u0001\ty(!\"\u0002\b\u0002\u000bY\tE\u00029\u0003\u0003K1!a!:\u0005=!Um]2sS\n,\u0007K]8dKN\u001c\u0018!\u0002;ji2,\u0017EAAE\u0003-!UM\\:jif\u0004S*\u00199\"\u0005\u00055\u0015aP\"p[B,H/Z:!C\u0002\"WM\\:jif\u0004S.\u00199!_Z,'\u000fI1!g\u0016$\be\u001c4!M\u0016\fG/\u001e:fg\u0002\u001aHo\u001c:fI\u0002Jg\u000eI$f_6,7/Y\u0004\b\u0003#\u0013\u0001\u0012AAJ\u00039!UM\\:jif\u0004&o\\2fgN\u00042AHAK\r\u0019\t!\u0001#\u0001\u0002\u0018N!\u0011QSAM!\r\t\u00161T\u0005\u0004\u0003;\u0013&AB!osJ+g\rC\u0004\u001c\u0003+#\t!!)\u0015\u0005\u0005M\u0005BCAS\u0003+\u0013\r\u0011\"\u0001\u0002(\u0006\u0019B)\u001a4bk2$(+\u00193jkN\u0004\u0016\u000e_3mgV\u0011\u0011\u0011\u0016\t\u0004#\u0006-\u0016bAAW%\n\u0019\u0011J\u001c;\t\u0013\u0005E\u0016Q\u0013Q\u0001\n\u0005%\u0016\u0001\u0006#fM\u0006,H\u000e\u001e*bI&,8\u000fU5yK2\u001c\b\u0005\u0003\u0005\u00026\u0006UE\u0011AA\\\u0003\u00191G.\u001b9Y3R!\u0011\u0011XAd!\u0015\t\u00161XA`\u0013\r\tiL\u0015\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0006#\u0006m\u0016\u0011\u0019\t\u0004#\u0006\r\u0017bAAc%\n)a\t\\8bi\"9Q%a-A\u0002\u0005e\u0006")
public class DensityProcess
implements GeoMesaProcess {
    public static float[][] flipXY(float[][] fArray) {
        return DensityProcess$.MODULE$.flipXY(fArray);
    }

    public static int DefaultRadiusPixels() {
        return DensityProcess$.MODULE$.DefaultRadiusPixels();
    }

    @DescribeResult(name="result", description="Output raster")
    public GridCoverage2D execute(@DescribeParameter(name="data", description="Input features") SimpleFeatureCollection obsFeatures, @DescribeParameter(name="radiusPixels", description="Radius of the density kernel in pixels") Integer argRadiusPixels, @DescribeParameter(name="weightAttr", description="Name of the attribute to use for data point weight", min=0, max=1) String argWeightAttr, @DescribeParameter(name="outputBBOX", description="Bounding box of the output") ReferencedEnvelope argOutputEnv, @DescribeParameter(name="outputWidth", description="Width of output raster in pixels") Integer argOutputWidth, @DescribeParameter(name="outputHeight", description="Height of output raster in pixels") Integer argOutputHeight, ProgressListener monitor) throws ProcessException {
        float[][] heatMapGrid;
        int pixels = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)argRadiusPixels).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Integer x$1) {
                return x$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return DensityProcess$.MODULE$.DefaultRadiusPixels();
            }
        }));
        int outputWidth = Predef$.MODULE$.Integer2int(argOutputWidth) + 2 * pixels;
        int outputHeight = Predef$.MODULE$.Integer2int(argOutputHeight) + 2 * pixels;
        double bufferWidth = (double)pixels * argOutputEnv.getWidth() / (double)Predef$.MODULE$.Integer2int(argOutputWidth);
        double bufferHeight = (double)pixels * argOutputEnv.getHeight() / (double)Predef$.MODULE$.Integer2int(argOutputHeight);
        ReferencedEnvelope envelope = new ReferencedEnvelope(argOutputEnv);
        envelope.expandBy(bufferWidth, bufferHeight);
        Function1 decode = DensityScan$.MODULE$.decodeResult((Envelope)envelope, outputWidth, outputHeight);
        HeatmapSurface heatMap = new HeatmapSurface(pixels, (Envelope)envelope, outputWidth, outputHeight);
        try {
            SimpleFeatureIterator features = obsFeatures.features();
            while (features.hasNext()) {
                Iterator pts = (Iterator)decode.apply((Object)features.next());
                while (pts.hasNext()) {
                    Tuple3 tuple3 = (Tuple3)pts.next();
                    if (tuple3 != null) {
                        Tuple3 tuple32;
                        double x = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                        double y = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                        double weight = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                        Tuple3 tuple33 = tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)x), (Object)BoxesRunTime.boxToDouble((double)y), (Object)BoxesRunTime.boxToDouble((double)weight));
                        double x2 = BoxesRunTime.unboxToDouble((Object)tuple33._1());
                        double y2 = BoxesRunTime.unboxToDouble((Object)tuple33._2());
                        double weight2 = BoxesRunTime.unboxToDouble((Object)tuple33._3());
                        heatMap.addPoint(x2, y2, weight2);
                        continue;
                    }
                    throw new MatchError((Object)tuple3);
                }
            }
            features.close();
            heatMapGrid = DensityProcess$.MODULE$.flipXY(heatMap.computeSurface());
        }
        catch (Exception exception) {
            throw new ProcessException("Error processing heatmap", (Throwable)exception);
        }
        WritableRaster raster = RasterFactory.createBandedRaster((int)4, (int)Predef$.MODULE$.Integer2int(argOutputWidth), (int)Predef$.MODULE$.Integer2int(argOutputHeight), (int)1, null);
        int i = pixels;
        for (int j = pixels; j < heatMapGrid.length - pixels; ++j) {
            float[] row = heatMapGrid[j];
            while (i < row.length - pixels) {
                raster.setSample(i - pixels, j - pixels, 0, row[i]);
                ++i;
            }
            i = pixels;
        }
        GridCoverageFactory gcf = CoverageFactoryFinder.getGridCoverageFactory((Hints)GeoTools.getDefaultHints());
        return gcf.create((CharSequence)"Process Results", raster, (org.opengis.geometry.Envelope)argOutputEnv);
    }

    public Query invertQuery(@DescribeParameter(name="radiusPixels", description="Radius to use for the kernel", min=0, max=1) Integer argRadiusPixels, @DescribeParameter(name="weightAttr", description="Name of the attribute to use for data point weight", min=0, max=1) String argWeightAttr, @DescribeParameter(name="outputBBOX", description="Georeferenced bounding box of the output") ReferencedEnvelope argOutputEnv, @DescribeParameter(name="outputWidth", description="Width of the output raster") Integer argOutputWidth, @DescribeParameter(name="outputHeight", description="Height of the output raster") Integer argOutputHeight, Query targetQuery, GridGeometry targetGridGeometry) throws ProcessException {
        if (argOutputWidth == null || argOutputHeight == null) {
            throw new IllegalArgumentException("outputWidth and/or outputHeight not specified");
        }
        if (Predef$.MODULE$.Integer2int(argOutputWidth) < 0 || Predef$.MODULE$.Integer2int(argOutputHeight) < 0) {
            throw new IllegalArgumentException("outputWidth and outputHeight must both be positive");
        }
        int pixels = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)argRadiusPixels).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Integer x$3) {
                return x$3;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return DensityProcess$.MODULE$.DefaultRadiusPixels();
            }
        }));
        int outputWidth = Predef$.MODULE$.Integer2int(argOutputWidth) + 2 * pixels;
        int outputHeight = Predef$.MODULE$.Integer2int(argOutputHeight) + 2 * pixels;
        double bufferWidth = (double)pixels * argOutputEnv.getWidth() / (double)Predef$.MODULE$.Integer2int(argOutputWidth);
        double bufferHeight = (double)pixels * argOutputEnv.getHeight() / (double)Predef$.MODULE$.Integer2int(argOutputHeight);
        ReferencedEnvelope envelope = new ReferencedEnvelope(argOutputEnv);
        envelope.expandBy(bufferWidth, bufferHeight);
        double buf = package$.MODULE$.max(bufferWidth, bufferHeight);
        Filter filter = (Filter)targetQuery.getFilter().accept((FilterVisitor)new BBOXExpandingFilterVisitor(buf, buf, buf, buf), null);
        Query invertedQuery = new Query(targetQuery);
        invertedQuery.setFilter(filter);
        invertedQuery.setProperties(null);
        invertedQuery.getHints().put((Object)QueryHints$.MODULE$.DENSITY_BBOX(), (Object)envelope);
        invertedQuery.getHints().put((Object)QueryHints$.MODULE$.DENSITY_WIDTH(), (Object)BoxesRunTime.boxToInteger((int)outputWidth));
        invertedQuery.getHints().put((Object)QueryHints$.MODULE$.DENSITY_HEIGHT(), (Object)BoxesRunTime.boxToInteger((int)outputHeight));
        Object object = argWeightAttr == null ? BoxedUnit.UNIT : invertedQuery.getHints().put((Object)QueryHints$.MODULE$.DENSITY_WEIGHT(), (Object)argWeightAttr);
        return invertedQuery;
    }
}

