/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.knn;

import com.vividsolutions.jts.geom.Coordinate;
import org.locationtech.geomesa.utils.geohash.GeoHash;
import org.locationtech.geomesa.utils.geohash.GeoHash$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble;
import scala.runtime.RichDouble$;

public final class TouchingGeoHashes$ {
    public static final TouchingGeoHashes$ MODULE$;
    private final Set<Coordinate> shiftPattern;

    static {
        new TouchingGeoHashes$();
    }

    public Set<Coordinate> shiftPattern() {
        return this.shiftPattern;
    }

    public Set<GeoHash> touching(GeoHash gh) {
        Coordinate thisLocVector = gh.getPoint().getCoordinate();
        int thisPrec = gh.prec();
        Coordinate thisPrecVector = new Coordinate(GeoHash$.MODULE$.longitudeDeltaForPrecision(thisPrec), GeoHash$.MODULE$.latitudeDeltaForPrecision(thisPrec));
        Set newCoords = (Set)((SetLike)this.shiftPattern().map((Function1)new Serializable(thisLocVector, thisPrecVector){
            public static final long serialVersionUID = 0L;
            private final Coordinate thisLocVector$1;
            private final Coordinate thisPrecVector$1;

            public final Tuple3<Coordinate, Object, Object> apply(Coordinate jumpUnitVector) {
                double newX = this.thisLocVector$1.x + jumpUnitVector.x * this.thisPrecVector$1.x;
                double newY = this.thisLocVector$1.y + jumpUnitVector.y * this.thisPrecVector$1.y;
                return new Tuple3((Object)jumpUnitVector, (Object)BoxesRunTime.boxToDouble((double)newX), (Object)BoxesRunTime.boxToDouble((double)newY));
            }
            {
                this.thisLocVector$1 = thisLocVector$1;
                this.thisPrecVector$1 = thisPrecVector$1;
            }
        }, Set$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Coordinate apply(Tuple3<Coordinate, Object, Object> x$1) {
                Tuple3<Coordinate, Object, Object> tuple3 = x$1;
                if (tuple3 != null) {
                    double newX = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                    double newY = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                    Coordinate coordinate = new Coordinate(newX, newY);
                    return coordinate;
                }
                throw new MatchError(tuple3);
            }
        }, Set$.MODULE$.canBuildFrom());
        Set safeCoords = (Set)((TraversableLike)newCoords.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Set<Coordinate> apply(Coordinate xyPair) {
                return TouchingGeoHashes$.MODULE$.generateIDLSafeCoordinates(xyPair);
            }
        }, Set$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(thisLocVector, thisPrecVector){
            public static final long serialVersionUID = 0L;
            private final Coordinate thisLocVector$1;
            private final Coordinate thisPrecVector$1;

            public final Set<Coordinate> apply(Coordinate x$2) {
                return TouchingGeoHashes$.MODULE$.generatePolarSafeCoordinates(x$2, this.thisPrecVector$1, this.thisLocVector$1);
            }
            {
                this.thisLocVector$1 = thisLocVector$1;
                this.thisPrecVector$1 = thisPrecVector$1;
            }
        }, Set$.MODULE$.canBuildFrom());
        return (Set)((TraversableLike)safeCoords.map((Function1)new Serializable(thisPrec){
            public static final long serialVersionUID = 0L;
            private final int thisPrec$1;

            public final GeoHash apply(Coordinate coord) {
                return GeoHash$.MODULE$.apply(coord.x, coord.y, this.thisPrec$1);
            }
            {
                this.thisPrec$1 = thisPrec$1;
            }
        }, Set$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(gh){
            public static final long serialVersionUID = 0L;
            private final GeoHash gh$1;

            public final boolean apply(GeoHash x$3) {
                GeoHash geoHash = x$3;
                GeoHash geoHash2 = this.gh$1;
                return geoHash != null ? !geoHash.equals(geoHash2) : geoHash2 != null;
            }
            {
                this.gh$1 = gh$1;
            }
        });
    }

    public Set<Coordinate> generateIDLSafeCoordinates(Coordinate xyPair) {
        return package$.MODULE$.abs(xyPair.x) > 180.0 ? this.generateIDLMirrorPair(xyPair) : (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Coordinate[]{xyPair}));
    }

    public Set<Coordinate> generateIDLMirrorPair(Coordinate xyPair) {
        double newLat = xyPair.y;
        double newLon = xyPair.x + this.degreesLonTranslation(xyPair.x);
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Coordinate[]{new Coordinate(newLon, newLat)}));
    }

    public double degreesLonTranslation(double lon) {
        return (int)(RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper((lon + (double)180) / 360.0)) * (double)-360);
    }

    public Set<Coordinate> generatePolarSafeCoordinates(Coordinate xyPair, Coordinate precVector, Coordinate startingPair) {
        return package$.MODULE$.abs(xyPair.y) > 90.0 ? this.polarCap(xyPair, precVector, startingPair) : (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Coordinate[]{xyPair}));
    }

    public Set<Coordinate> polarCap(Coordinate xyPair, Coordinate precVector, Coordinate startingPair) {
        double newLat = startingPair.y;
        double begin = -180.0 + 0.5 * precVector.x;
        double end = 180.0 - 0.5 * precVector.x;
        double step = precVector.x;
        NumericRange.Inclusive newLons = new RichDouble(Predef$.MODULE$.doubleWrapper(begin)).to((Object)BoxesRunTime.boxToDouble((double)end), (Object)BoxesRunTime.boxToDouble((double)step));
        return ((TraversableOnce)newLons.map((Function1)new Serializable(newLat){
            public static final long serialVersionUID = 0L;
            private final double newLat$1;

            public final Coordinate apply(double newLon) {
                return new Coordinate(newLon, this.newLat$1);
            }
            {
                this.newLat$1 = newLat$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSet();
    }

    private TouchingGeoHashes$() {
        MODULE$ = this;
        this.shiftPattern = (Set)((TraversableLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-1, 0, 1}))).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Set<Coordinate> apply(int i) {
                return (Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-1, 0, 1}))).map((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final int i$1;

                    public final Coordinate apply(int j) {
                        return new Coordinate((double)this.i$1, (double)j);
                    }
                    {
                        this.i$1 = i$1;
                    }
                }, Set$.MODULE$.canBuildFrom());
            }
        }, Set$.MODULE$.canBuildFrom());
    }
}

