/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext;

import it.geosolutions.jaiext.ConcurrentOperationRegistry;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationRegistry;
import javax.media.jai.RegistryElementDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAIExt {
    private static final JAI DEFAULT_INSTANCE = JAI.getDefaultInstance();
    public static final String OPERATION_CONST_NAME = "operationConst";
    public static final String ALGEBRIC_NAME = "algebric";
    public static final String STATS_NAME = "Stats";
    private ReadWriteLock lock;
    private static JAIExt jaiext;
    private ConcurrentOperationRegistry registry;
    private static final Logger LOGGER;
    static final HashMap<String, Set<String>> NAME_MAPPING;
    private static final boolean mediaLibAvailable;

    public static synchronized void initJAIEXT() {
        JAIExt.initJAIEXT(true);
    }

    public static synchronized void initJAIEXT(boolean useJaiExtOps) {
        JAIExt.initJAIEXT(useJaiExtOps, false);
    }

    public static synchronized void initJAIEXT(boolean useJaiExtOps, boolean forceReInit) {
        if (jaiext == null || forceReInit) {
            jaiext = JAIExt.getJAIEXT(useJaiExtOps, forceReInit);
        }
    }

    private static synchronized JAIExt getJAIEXT() {
        return JAIExt.getJAIEXT(true, false);
    }

    private static synchronized JAIExt getJAIEXT(boolean useJaiExtOps, boolean forceReInit) {
        if (jaiext == null || forceReInit) {
            ConcurrentOperationRegistry initializeRegistry = (ConcurrentOperationRegistry)ConcurrentOperationRegistry.initializeRegistry(useJaiExtOps);
            jaiext = new JAIExt(initializeRegistry);
            DEFAULT_INSTANCE.setOperationRegistry((OperationRegistry)initializeRegistry);
        }
        return jaiext;
    }

    public static void registerAllOperations(boolean jaiextOperations) {
        JAIExt je = JAIExt.getJAIEXT();
        if (jaiextOperations) {
            List<ConcurrentOperationRegistry.OperationItem> jaiextOps = JAIExt.getJAIEXTOperations();
            for (ConcurrentOperationRegistry.OperationItem item : jaiextOps) {
                String jaiExtName;
                String itemName = item.getName();
                if (itemName != (jaiExtName = JAIExt.getOperationName(itemName))) {
                    ConcurrentOperationRegistry.OperationItem itemJE = JAIExt.getRegistry().getOperationCollection().get(jaiExtName);
                    if (itemJE != null) continue;
                    itemJE = JAIExt.searchForOperation(jaiExtName, true);
                    je.registerOperation(itemJE);
                    continue;
                }
                JAIExt.registerJAIEXTDescriptor(itemName);
            }
        } else {
            List<ConcurrentOperationRegistry.OperationItem> jaiOps = JAIExt.getJAIOperations();
            for (ConcurrentOperationRegistry.OperationItem item : jaiOps) {
                String jaiExtName;
                String itemName = item.getName();
                if (itemName != (jaiExtName = JAIExt.getJAIExtName(itemName))) {
                    ConcurrentOperationRegistry.OperationItem itemJE = JAIExt.getRegistry().getOperationCollection().get(jaiExtName);
                    if (itemJE == null) continue;
                    je.unregisterOperation(itemJE);
                    continue;
                }
                JAIExt.registerJAIDescriptor(itemName);
            }
        }
    }

    private static ConcurrentOperationRegistry.OperationItem searchForOperation(String jaiExtName, boolean jaiext) {
        JAIExt je = JAIExt.getJAIEXT();
        List<ConcurrentOperationRegistry.OperationItem> operations = jaiext ? JAIExt.getJAIEXTOperations() : je.getJAIAvailableOps();
        for (ConcurrentOperationRegistry.OperationItem it : operations) {
            if (!it.getName().equalsIgnoreCase(jaiExtName)) continue;
            return it;
        }
        return null;
    }

    public static void registerOperations(Set<String> operations, boolean jaiext) {
        JAIExt je = JAIExt.getJAIEXT();
        for (String opName : operations) {
            String jaiextName = JAIExt.getJAIExtName(opName);
            if (jaiext) {
                if (JAIExt.isJAIExtOperation(jaiextName)) continue;
                JAIExt.registerJAIEXTDescriptor(jaiextName);
                continue;
            }
            if (jaiextName.equalsIgnoreCase(opName) && JAIExt.isJAIExtOperation(opName) && !NAME_MAPPING.containsKey(jaiextName)) {
                JAIExt.registerJAIDescriptor(opName);
                continue;
            }
            if (jaiextName.equalsIgnoreCase(opName) && !NAME_MAPPING.containsKey(jaiextName)) continue;
            ConcurrentOperationRegistry.OperationItem it = JAIExt.searchForOperation(jaiextName, true);
            je.unregisterOperation(it);
        }
    }

    public static void registerJAIEXTDescriptor(String descriptorName) {
        JAIExt.getJAIEXT().registerOp(descriptorName, true);
    }

    public static void registerJAIDescriptor(String descriptorName) {
        JAIExt.getJAIEXT().registerOp(descriptorName, false);
    }

    public static void setJAIAcceleration(String descriptorName, boolean accelerated) {
        JAIExt.getJAIEXT().setAcceleration(descriptorName, accelerated);
    }

    public static List<ConcurrentOperationRegistry.OperationItem> getOperations() {
        return JAIExt.getJAIEXT().getItems();
    }

    public static List<ConcurrentOperationRegistry.OperationItem> getJAIEXTOperations() {
        return JAIExt.getJAIEXT().getJAIEXTAvailableOps();
    }

    public static List<ConcurrentOperationRegistry.OperationItem> getJAIOperations() {
        return JAIExt.getJAIEXT().getJAIAvailableOps();
    }

    public static ConcurrentOperationRegistry getRegistry() {
        return JAIExt.getJAIEXT().registry;
    }

    public static String getOperationName(String name) {
        if (JAIExt.isJAIExtOperation(STATS_NAME) && NAME_MAPPING.get(STATS_NAME).contains(name)) {
            return STATS_NAME;
        }
        if (JAIExt.isJAIExtOperation(ALGEBRIC_NAME) && NAME_MAPPING.get(ALGEBRIC_NAME).contains(name)) {
            return ALGEBRIC_NAME;
        }
        if (JAIExt.isJAIExtOperation(OPERATION_CONST_NAME) && NAME_MAPPING.get(OPERATION_CONST_NAME).contains(name)) {
            return OPERATION_CONST_NAME;
        }
        return name;
    }

    public static String getJAIExtName(String name) {
        if (NAME_MAPPING.get(STATS_NAME).contains(name)) {
            return STATS_NAME;
        }
        if (NAME_MAPPING.get(ALGEBRIC_NAME).contains(name)) {
            return ALGEBRIC_NAME;
        }
        if (NAME_MAPPING.get(OPERATION_CONST_NAME).contains(name)) {
            return OPERATION_CONST_NAME;
        }
        return name;
    }

    public static List<String> getJAINames(String name) {
        ArrayList<String> names = new ArrayList<String>();
        if (NAME_MAPPING.containsKey(name)) {
            names.addAll((Collection)NAME_MAPPING.get(name));
        } else {
            names.add(name);
        }
        return names;
    }

    public static boolean isJAIExtOperation(String descriptorName) {
        return JAIExt.getJAIEXT().isJAIExtOp(descriptorName);
    }

    public static boolean isJAIAPI(String descriptorName) {
        return JAIExt.getJAIEXT().isJAIAvailableOperation(descriptorName);
    }

    private JAIExt(ConcurrentOperationRegistry registry) {
        this.registry = registry;
        this.lock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerOp(String descriptorName, boolean fromJAI) {
        Lock writeLock = this.lock.writeLock();
        try {
            String outVendor;
            writeLock.lock();
            String vendor = fromJAI ? (descriptorName.equalsIgnoreCase("Null") ? "javax.media.jai" : "com.sun.media.jai") : "it.geosolutions.jaiext";
            OperationDescriptor op = (OperationDescriptor)this.registry.getDescriptor("rendered", descriptorName);
            boolean registered = false;
            String inVendor = fromJAI ? "JAI" : "JAI-EXT";
            String string = outVendor = fromJAI ? "JAI-EXT" : "JAI";
            if (op != null && op.getResourceBundle(null).getString("Vendor").equalsIgnoreCase(vendor) || op == null) {
                ConcurrentOperationRegistry.OperationCollection collection = this.registry.getOperationCollection();
                ConcurrentOperationRegistry.OperationItem oldItem = collection.get(descriptorName);
                ConcurrentOperationRegistry.OperationItem newItem = this.registry.getOperationMap(!fromJAI).get(descriptorName);
                if (newItem != null) {
                    Object newFactory;
                    if (op != null) {
                        if (oldItem != null && oldItem.getCurrentFactory() != null && LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.log(Level.FINEST, "Unregistered Factory for the operation: " + descriptorName);
                        }
                        this.registry.unregisterDescriptor((RegistryElementDescriptor)op);
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.log(Level.FINEST, "Unregistered " + inVendor + " descriptor for the operation: " + descriptorName);
                        }
                    }
                    this.registry.registerDescriptor((RegistryElementDescriptor)newItem.getDescriptor());
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Registered " + outVendor + " descriptor for the operation: " + descriptorName);
                    }
                    if ((newFactory = newItem.getCurrentFactory()) != null && this.registry.getFactory("rendered", newItem.getDescriptor().getName()) == null) {
                        this.registry.registerFactory("rendered", descriptorName, newItem.getVendor(), newFactory);
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.log(Level.FINEST, "Registered Factory for the operation: " + descriptorName);
                        }
                    }
                    registered = true;
                }
            }
            if (!registered) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Unable to register the descriptor related to the following operation: " + descriptorName);
                }
            } else if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Registered operation: " + descriptorName);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAcceleration(String descriptorName, boolean accelerated) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            ConcurrentOperationRegistry.OperationCollection collection = this.registry.getOperationCollection();
            ConcurrentOperationRegistry.OperationItem item = collection.get(descriptorName);
            ConcurrentOperationRegistry.OperationItem jaiItem = this.registry.getOperationMap(true).get(descriptorName);
            if (item != null && item.getVendor().equalsIgnoreCase("com.sun.media.jai") && jaiItem.getFactory() != null && jaiItem.getMlibFactory() != null) {
                Object oldFactory = null;
                Object newFactory = null;
                String acc1 = null;
                String acc2 = null;
                if (accelerated) {
                    oldFactory = jaiItem.getFactory();
                    newFactory = jaiItem.getMlibFactory();
                    acc1 = " Accelerated";
                    acc2 = "";
                } else {
                    newFactory = jaiItem.getFactory();
                    oldFactory = jaiItem.getMlibFactory();
                    acc1 = "";
                    acc2 = " Accelerated";
                }
                List orderedFactoryList = this.registry.getOrderedFactoryList("rendered", descriptorName, "com.sun.media.jai");
                if (orderedFactoryList != null && orderedFactoryList.contains(oldFactory)) {
                    this.registry.unregisterDescriptor((RegistryElementDescriptor)jaiItem.getDescriptor());
                    this.registry.registerDescriptor((RegistryElementDescriptor)jaiItem.getDescriptor());
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Unregistered" + acc1 + " Factory for the operation: " + descriptorName);
                    }
                }
                if ((orderedFactoryList = this.registry.getOrderedFactoryList("rendered", descriptorName, "com.sun.media.jai")) == null || !orderedFactoryList.contains(newFactory)) {
                    this.registry.registerFactory("rendered", descriptorName, "com.sun.media.jai", newFactory);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Registered" + acc2 + " Factory for the operation: " + descriptorName);
                    }
                }
            } else if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Unable to set acceleration for following operation: " + descriptorName);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ConcurrentOperationRegistry.OperationItem> getItems() {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            Collection<ConcurrentOperationRegistry.OperationItem> items = this.registry.getOperations();
            ArrayList<ConcurrentOperationRegistry.OperationItem> ops = new ArrayList<ConcurrentOperationRegistry.OperationItem>(items.size());
            ops.addAll(items);
            ArrayList<ConcurrentOperationRegistry.OperationItem> arrayList = ops;
            return arrayList;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ConcurrentOperationRegistry.OperationItem> getJAIEXTAvailableOps() {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            Map<String, ConcurrentOperationRegistry.OperationItem> operationMap = this.registry.getOperationMap(false);
            ArrayList<ConcurrentOperationRegistry.OperationItem> ops = new ArrayList<ConcurrentOperationRegistry.OperationItem>(operationMap.size());
            ops.addAll(operationMap.values());
            ArrayList<ConcurrentOperationRegistry.OperationItem> arrayList = ops;
            return arrayList;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ConcurrentOperationRegistry.OperationItem> getJAIAvailableOps() {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            Map<String, ConcurrentOperationRegistry.OperationItem> operationMap = this.registry.getOperationMap(true);
            ArrayList<ConcurrentOperationRegistry.OperationItem> ops = new ArrayList<ConcurrentOperationRegistry.OperationItem>(operationMap.size());
            ops.addAll(operationMap.values());
            ArrayList<ConcurrentOperationRegistry.OperationItem> arrayList = ops;
            return arrayList;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isJAIExtOp(String descriptorName) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            ConcurrentOperationRegistry.OperationCollection items = this.registry.getOperationCollection();
            ConcurrentOperationRegistry.OperationItem operationItem = items.get(descriptorName);
            if (operationItem == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = operationItem.getVendor().equalsIgnoreCase("it.geosolutions.jaiext");
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isJAIAvailableOperation(String descriptorName) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            String jaiextName = JAIExt.getJAIExtName(descriptorName);
            if (!jaiextName.equalsIgnoreCase(descriptorName)) {
                boolean bl = true;
                return bl;
            }
            List<ConcurrentOperationRegistry.OperationItem> ops = this.getJAIAvailableOps();
            for (ConcurrentOperationRegistry.OperationItem item : ops) {
                String vendor = item.getVendor();
                if (!vendor.equalsIgnoreCase("com.sun.media.jai") && !vendor.equalsIgnoreCase("javax.media.jai") || !item.getName().equalsIgnoreCase(descriptorName)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterOperation(ConcurrentOperationRegistry.OperationItem op) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            if (op == null) {
                return;
            }
            OperationDescriptor descriptor = op.getDescriptor();
            this.registry.unregisterDescriptor((RegistryElementDescriptor)descriptor);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerOperation(ConcurrentOperationRegistry.OperationItem op) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            if (op == null) {
                return;
            }
            Object factory = op.getFactory();
            OperationDescriptor descriptor = op.getDescriptor();
            this.registry.registerDescriptor((RegistryElementDescriptor)descriptor);
            this.registry.registerFactory("rendered", op.getName(), op.getVendor(), factory);
        }
        finally {
            writeLock.unlock();
        }
    }

    public static boolean isMedialibavailable() {
        return mediaLibAvailable;
    }

    static {
        LOGGER = Logger.getLogger(JAIExt.class.toString());
        NAME_MAPPING = new HashMap();
        TreeSet<String> stats = new TreeSet<String>();
        stats.add("Extrema");
        stats.add("Histogram");
        stats.add("Mean");
        NAME_MAPPING.put(STATS_NAME, stats);
        TreeSet<String> opConst = new TreeSet<String>();
        opConst.add("AddConst");
        opConst.add("DivideByConst");
        opConst.add("MultiplyConst");
        opConst.add("SubtractConst");
        opConst.add("SubtractFromConst");
        opConst.add("AndConst");
        opConst.add("OrConst");
        opConst.add("XorConst");
        NAME_MAPPING.put(OPERATION_CONST_NAME, opConst);
        TreeSet<String> algebric22 = new TreeSet<String>();
        algebric22.add("Add");
        algebric22.add("Divide");
        algebric22.add("Multiply");
        algebric22.add("Subtract");
        algebric22.add("Absolute");
        algebric22.add("And");
        algebric22.add("Or");
        algebric22.add("Xor");
        algebric22.add("Exp");
        algebric22.add("Log");
        algebric22.add("Invert");
        algebric22.add("SubtractFrom");
        algebric22.add("DivideInto");
        NAME_MAPPING.put(ALGEBRIC_NAME, algebric22);
        boolean mediaLib = false;
        Class<?> mediaLibImage = null;
        try {
            mediaLibImage = Class.forName("com.sun.medialib.mlib.Image");
        }
        catch (ClassNotFoundException algebric22) {
            // empty catch block
        }
        boolean bl = mediaLib = mediaLibImage != null;
        if (mediaLib) {
            try {
                boolean bl2 = mediaLib = !Boolean.getBoolean("com.sun.media.jai.disableMediaLib");
                if (mediaLib) {
                    final Class<?> mImage = mediaLibImage;
                    mediaLib = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                        @Override
                        public Boolean run() {
                            try {
                                Class[] params = new Class[]{};
                                Method method = mImage.getDeclaredMethod("isAvailable", params);
                                Object[] paramsObj = new Object[]{};
                                Object o = mImage.newInstance();
                                return (Boolean)method.invoke(o, paramsObj);
                            }
                            catch (Throwable e) {
                                return false;
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                mediaLib = false;
            }
        }
        mediaLibAvailable = mediaLib;
    }
}

