/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.domain.ip;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.io.Serializable;

public class IPv4
implements Comparable<IPv4>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final long value;

    public IPv4(String ip) {
        this(IPv4.ipToLong(ip));
    }

    public IPv4(long ip) {
        this.value = ip;
    }

    private static long ipToLong(String addr) {
        Preconditions.checkNotNull((Object)addr);
        String[] octets = addr.split("\\.", 5);
        Preconditions.checkArgument((octets.length == 4 ? 1 : 0) != 0, (String)"Invalid IPv4 representation: %s", (Object[])new Object[]{addr});
        long num = 0L;
        for (String octStr : octets) {
            try {
                int octet = Integer.parseInt(octStr);
                Preconditions.checkArgument((octet >= 0 && octet < 256 ? 1 : 0) != 0, (String)"Invalid IPv4 representation: %s", (Object[])new Object[]{addr});
                num = num << 8 | (long)(Integer.parseInt(octStr) & 0xFF);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Invalid IPv4 representation: " + addr);
            }
        }
        return num;
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public int compareTo(IPv4 o) {
        if (o == null) {
            return 1;
        }
        return Longs.compare((long)this.value, (long)o.value);
    }

    public String toString() {
        return (this.value >>> 24 & 0xFFL) + "." + (this.value >>> 16 & 0xFFL) + "." + (this.value >>> 8 & 0xFFL) + "." + (this.value & 0xFFL);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IPv4)) {
            return false;
        }
        IPv4 iPv4 = (IPv4)o;
        return this.value == iPv4.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }
}

